/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.Version;

public final class DomainVersion
implements Externalizable {
    private static final long serialVersionUID = 8660184188777148469L;
    private static final String ADDITIONS = "ADDITIONS";
    private static final String DELETIONS = "DELETIONS";
    private static final String CHANGES = "CHANGES";
    private Map deploymentsVersionMap = Collections.synchronizedMap(new HashMap());

    public DomainVersion() {
    }

    public DomainVersion(Map map) {
        this();
        this.deploymentsVersionMap.putAll(map);
    }

    public final Map getDeploymentsVersionMap() {
        return this.deploymentsVersionMap;
    }

    public final void addOrUpdateDeploymentVersion(String string, Version version2) {
        Version version3 = this.deploymentsVersionMap.put(string, version2);
        if (this.isDebugEnabled()) {
            String string2 = null;
            string2 = version3 != null ? super.toString() + ".addOrUpdateDeploymentVersion():" + " Changed version on - '" + string + "' from: '" + version3 + "' to: '" + version2 + "'" : super.toString() + ".addOrUpdateDeploymentVersion():" + " Added version for - '" + string + "' : '" + version2 + "'";
            this.debug(string2);
        }
    }

    public final void removeDeploymentVersion(String string) {
        this.deploymentsVersionMap.remove(string);
    }

    public final Version getDeploymentVersion(String string) {
        return (Version)this.deploymentsVersionMap.get(string);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DomainVersion) {
            DomainVersion domainVersion = (DomainVersion)object;
            return ((Object)this.deploymentsVersionMap).equals(domainVersion.getDeploymentsVersionMap());
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this.deploymentsVersionMap).hashCode();
    }

    public final DomainVersion getCopy() {
        return new DomainVersion(this.deploymentsVersionMap);
    }

    public final Map getDifferences(DomainVersion domainVersion) {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        if (domainVersion == null) {
            hashMap.put(ADDITIONS, this.deploymentsVersionMap);
        } else {
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            HashMap hashMap4 = new HashMap();
            Map map = domainVersion.getDeploymentsVersionMap();
            if (map.size() > this.deploymentsVersionMap.size()) {
                for (String string : map.keySet()) {
                    if (this.deploymentsVersionMap.containsKey(string)) {
                        if (map.get(string).equals(this.deploymentsVersionMap.get(string))) continue;
                        hashMap4.put(string, this.deploymentsVersionMap.get(string));
                        continue;
                    }
                    hashMap3.put(string, map.get(string));
                }
            } else {
                for (String string : this.deploymentsVersionMap.keySet()) {
                    if (map.containsKey(string)) {
                        if (this.deploymentsVersionMap.get(string).equals(map.get(string))) continue;
                        hashMap4.put(string, this.deploymentsVersionMap.get(string));
                        continue;
                    }
                    hashMap2.put(string, this.deploymentsVersionMap.get(string));
                }
            }
            hashMap.put(ADDITIONS, hashMap2);
            hashMap.put(DELETIONS, hashMap3);
            hashMap.put(CHANGES, hashMap4);
        }
        return hashMap;
    }

    public DomainVersion getFilteredVersion(Set set) {
        DomainVersion domainVersion = this;
        if (set != null && !((Object)set).equals(this.deploymentsVersionMap.keySet())) {
            domainVersion = this.getCopy();
            domainVersion.getDeploymentsVersionMap().keySet().retainAll(set);
        }
        return domainVersion;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(": [");
        for (String string : this.deploymentsVersionMap.keySet()) {
            stringBuffer.append(" { Deployment: ");
            stringBuffer.append("'");
            stringBuffer.append(string);
            stringBuffer.append("'");
            stringBuffer.append(" : v = '");
            stringBuffer.append(this.deploymentsVersionMap.get(string));
            stringBuffer.append("' }, ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.deploymentsVersionMap);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.deploymentsVersionMap.putAll((Map)objectInput.readObject());
    }

    private boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    private void debug(String string) {
        Debug.serviceDebug(string);
    }
}

