/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentFailureHandler;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public class RequestImpl
implements DeploymentRequest {
    protected List deployments = new ArrayList();
    protected long identifier;
    private long timeoutInterval = 120000L;
    private boolean callConfigurationProviderLast;
    private AuthenticatedSubject initiator;
    private transient Timer timeoutMonitor;
    private transient String timeoutIdentifier;
    private transient boolean startControl;
    private transient boolean isAControlRequest;
    private final transient HashSet failureListeners = new HashSet();

    protected RequestImpl() {
    }

    protected static final void debug(String string) {
        Debug.serviceDebug(string);
    }

    protected static final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    public final long getId() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDeployment(Deployment deployment) {
        List list = this.deployments;
        synchronized (list) {
            if (deployment != null) {
                this.deployments.add(deployment);
            } else if (RequestImpl.isDebugEnabled()) {
                Debug.serviceDebug("Attempt to add an empty deployment " + StackTraceUtils.throwable2StackTrace((Throwable)new Throwable().fillInStackTrace()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDeployments() {
        List list;
        List list2 = this.deployments;
        synchronized (list2) {
            list = (List)((ArrayList)this.deployments).clone();
        }
        return list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDeployments(String string) {
        ArrayList<Deployment> arrayList = new ArrayList<Deployment>();
        List list = this.deployments;
        synchronized (list) {
            for (Deployment deployment : this.deployments) {
                if (!string.equals(deployment.getCallbackHandlerId())) continue;
                arrayList.add(deployment);
            }
        }
        return arrayList.iterator();
    }

    public DeploymentRequestTaskRuntimeMBean getTaskRuntime() {
        return null;
    }

    public final boolean isConfigurationProviderCalledLast() {
        return this.callConfigurationProviderLast;
    }

    public final void setCallConfigurationProviderLast() {
        this.callConfigurationProviderLast = true;
    }

    public final boolean isStartControlEnabled() {
        return this.startControl;
    }

    public final void setStartControl(boolean bl) {
        this.startControl = bl;
    }

    public boolean isControlRequest() {
        return this.isAControlRequest;
    }

    public void setControlRequest(boolean bl) {
        this.isAControlRequest = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerFailureListener(DeploymentFailureHandler deploymentFailureHandler) {
        HashSet hashSet = this.failureListeners;
        synchronized (hashSet) {
            this.failureListeners.add(deploymentFailureHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getRegisteredFailureListeners() {
        HashSet hashSet = this.failureListeners;
        synchronized (hashSet) {
            return this.failureListeners;
        }
    }

    public final void setInitiator(AuthenticatedSubject authenticatedSubject) {
        if (this.initiator == null) {
            this.initiator = authenticatedSubject;
        }
    }

    public final AuthenticatedSubject getInitiator() {
        return this.initiator;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof RequestImpl && this.identifier != 0L && ((RequestImpl)object).getId() == this.identifier;
    }

    public int hashCode() {
        return (int)this.identifier;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DeploymentRequest: id: " + this.getId());
        Iterator iterator = this.getDeployments();
        int n = 1;
        while (iterator.hasNext()) {
            Deployment deployment = (Deployment)iterator.next();
            stringBuffer.append(" Deployment[");
            stringBuffer.append(n);
            ++n;
            stringBuffer.append("]: type: ");
            stringBuffer.append(deployment.getCallbackHandlerId());
            stringBuffer.append(" , proposedVersion: ");
            stringBuffer.append(deployment.getProposedVersion());
            stringBuffer.append(" , targets: ");
            String[] stringArray = deployment.getTargets();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public final void setTimeoutInterval(long l) {
        if (l <= 120000L) {
            return;
        }
        if (this.timeoutInterval > 120000L) {
            return;
        }
        this.timeoutInterval = l;
    }

    public final long getTimeoutInterval() {
        return this.timeoutInterval;
    }

    public final void startTimeoutMonitor(String string) {
        if (this.timeoutMonitor != null) {
            return;
        }
        this.timeoutIdentifier = string;
        this.timeoutMonitor = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.deploy.RequestTimeout", WorkManagerFactory.getInstance().getSystem()).schedule((TimerListener)new TimeoutMonitor(), this.timeoutInterval);
        if (RequestImpl.isDebugEnabled()) {
            RequestImpl.debug("Starting timer '" + string + "' to expire in '" + this.timeoutInterval + "' ms at '" + new Date(System.currentTimeMillis() + this.timeoutInterval) + "'");
        }
    }

    public final void cancelTimeoutMonitor() {
        block4: {
            try {
                if (this.timeoutMonitor != null) {
                    if (RequestImpl.isDebugEnabled()) {
                        RequestImpl.debug("Cancelling timeout monitor for '" + this.timeoutIdentifier + "'");
                    }
                    this.timeoutMonitor.cancel();
                    this.timeoutMonitor = null;
                }
            }
            catch (Throwable throwable) {
                if (!RequestImpl.isDebugEnabled()) break block4;
                Debug.serviceDebug(throwable.getMessage() + " " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
    }

    public void requestTimedout() {
        if (RequestImpl.isDebugEnabled()) {
            RequestImpl.debug(this.timeoutIdentifier + " timed out");
        }
    }

    private final class TimeoutMonitor
    implements TimerListener {
        private TimeoutMonitor() {
        }

        public final void timerExpired(Timer timer) {
            block2: {
                try {
                    RequestImpl.this.requestTimedout();
                }
                catch (Throwable throwable) {
                    if (!RequestImpl.isDebugEnabled()) break block2;
                    RequestImpl.debug("Time out for request id: " + RequestImpl.this.timeoutIdentifier);
                }
            }
        }
    }
}

