/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal;

import weblogic.deploy.common.Debug;
import weblogic.deploy.service.internal.ServiceRequest;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public abstract class RequestManager {
    private ServiceRequestQueue incomingRequestQueue = null;

    public RequestManager(String string) {
        this.incomingRequestQueue = new ServiceRequestQueue(string);
    }

    public final synchronized void scheduleNextRequest() {
        this.serviceNextRequest();
    }

    public final synchronized void addRequest(ServiceRequest serviceRequest) {
        this.incomingRequestQueue.add(serviceRequest);
        this.serviceNextRequest();
    }

    protected final void debug(String string) {
        Debug.serviceDebug(string);
    }

    protected final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    private void serviceNextRequest() {
        ServiceRequest serviceRequest = this.incomingRequestQueue.getNextQueuedRequest();
        if (serviceRequest != null) {
            if (WorkManagerFactory.isInitialized()) {
                WorkManager workManager = WorkManagerFactory.getInstance().getSystem();
                workManager.schedule((Runnable)serviceRequest);
            } else {
                serviceRequest.run();
            }
        }
    }

    private class ServiceRequestQueue {
        private UnsyncCircularQueue q = new UnsyncCircularQueue();
        private String queueName;

        ServiceRequestQueue(String string) {
            this.queueName = string;
        }

        void add(ServiceRequest serviceRequest) {
            this.q.put((Object)serviceRequest);
            if (RequestManager.this.isDebugEnabled()) {
                RequestManager.this.debug("Adding request '" + ((Object)serviceRequest).toString() + "' to '" + this.queueName + "' queue whose size is now '" + this.size() + "'");
            }
        }

        ServiceRequest getNextQueuedRequest() {
            if (this.q.empty()) {
                return null;
            }
            ServiceRequest serviceRequest = (ServiceRequest)this.q.get();
            if (RequestManager.this.isDebugEnabled()) {
                RequestManager.this.debug("ServiceRequest on queue '" + this.queueName + "' returning request '" + ((Object)serviceRequest).toString() + "' to be serviced - queue's size now is '" + this.size() + "'");
            }
            return serviceRequest;
        }

        String getName() {
            return this.queueName;
        }

        int size() {
            return this.q.size();
        }
    }
}

