/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.net.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.deploy.service.DeploymentException;
import weblogic.deploy.service.FailureDescription;

public class AdminDeploymentException
extends Exception
implements DeploymentException {
    private List failureDescriptions = new ArrayList();

    public FailureDescription[] getFailures() {
        FailureDescription[] failureDescriptionArray = new FailureDescription[]{};
        return this.failureDescriptions.toArray(failureDescriptionArray);
    }

    public void addFailureDescription(FailureDescription failureDescription) {
        String string = failureDescription.getServer();
        if (string != null && !this.hasFailureFor(string)) {
            this.failureDescriptions.add(failureDescription);
        }
    }

    public void addFailureDescriptions(Set set) {
        if (set == null || set.size() <= 0) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.addFailureDescription((FailureDescription)iterator.next());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AdminDeploymentException due to underlying exceptions : ");
        if (!this.failureDescriptions.isEmpty()) {
            Iterator iterator = this.failureDescriptions.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                stringBuffer.append(" Failure ");
                stringBuffer.append(n);
                ++n;
                stringBuffer.append(": reason: ");
                FailureDescription failureDescription = (FailureDescription)iterator.next();
                Exception exception = failureDescription.getReason();
                if (exception instanceof RemoteException) {
                    Throwable throwable = ((RemoteException)exception).detail;
                    if (!(throwable instanceof ConnectException) && !(throwable instanceof java.rmi.ConnectException) && !(throwable instanceof ConnectIOException) && !(throwable instanceof UnknownHostException)) continue;
                    stringBuffer.append("ConnectException : " + throwable.toString());
                    continue;
                }
                stringBuffer.append(failureDescription.toString());
            }
        }
        return stringBuffer.toString();
    }

    private boolean hasFailureFor(String string) {
        for (FailureDescription failureDescription : this.failureDescriptions) {
            String string2 = failureDescription.getServer();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

