/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.ChangeDescriptor;
import weblogic.deploy.service.ChangeDescriptorFactory;
import weblogic.deploy.service.DeploymentProvider;
import weblogic.deploy.service.DeploymentProviderManager;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.DeploymentRequestFactory;
import weblogic.deploy.service.DeploymentServiceCallbackHandler;
import weblogic.deploy.service.DeploymentServiceOperations;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.InvalidCreateChangeDescriptorException;
import weblogic.deploy.service.RegistrationExistsException;
import weblogic.deploy.service.RequiresTaskMediatedStartException;
import weblogic.deploy.service.StatusListener;
import weblogic.deploy.service.StatusListenerManager;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DeploymentRequestTaskRuntimeMBeanImpl;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.ServiceRequest;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentException;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentsManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestStatus;
import weblogic.deploy.service.internal.adminserver.ChangeDescriptorImpl;
import weblogic.deploy.service.internal.adminserver.StatusDeliverer;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class AdminDeploymentService
extends AbstractServerService
implements DeploymentRequestFactory,
DeploymentServiceOperations,
ChangeDescriptorFactory,
DeploymentProviderManager,
StatusListenerManager {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private AdminRequestManager requestManager;
    private AdminDeploymentsManager deploymentsManager;
    private final StatusDeliverer statusDeliverer;
    private static AdminDeploymentService singleton;
    private final HashSet providers = new HashSet();
    private String localServerName;

    private AdminDeploymentService() {
        this.statusDeliverer = StatusDeliverer.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdminDeploymentService getDeploymentService() {
        if (!ManagementService.getPropertyService(kernelId).isAdminServer()) return singleton;
        Class<AdminDeploymentService> clazz = AdminDeploymentService.class;
        synchronized (AdminDeploymentService.class) {
            if (singleton != null) return singleton;
            Class<AdminDeploymentService> clazz2 = AdminDeploymentService.class;
            synchronized (AdminDeploymentService.class) {
                singleton = new AdminDeploymentService();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return singleton;
            }
        }
    }

    private static final void debug(String string) {
        Debug.serviceDebug(string);
    }

    private static final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    private String getLocalServerName() {
        if (this.localServerName == null) {
            this.localServerName = ManagementService.getRuntimeAccess(kernelId).getServerName();
        }
        return this.localServerName;
    }

    private void sendCancelFailedTo(DeploymentRequest deploymentRequest, Exception exception) {
        AdminDeploymentException adminDeploymentException = new AdminDeploymentException();
        String string = DeploymentServiceLogger.indeterminate();
        FailureDescription failureDescription = new FailureDescription(this.localServerName, exception, string);
        adminDeploymentException.addFailureDescription(failureDescription);
        DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)deploymentRequest.getTaskRuntime();
        if (deploymentRequestTaskRuntimeMBeanImpl == null) {
            if (AdminDeploymentService.isDebugEnabled()) {
                AdminDeploymentService.debug("Cancel attempt failed since underlying request " + deploymentRequest + " has completed");
            }
            return;
        }
        deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(this.localServerName, exception);
        this.requestManager.deliverDeployCancelFailedCallback((AdminRequestImpl)deploymentRequest, adminDeploymentException);
        deploymentRequestTaskRuntimeMBeanImpl.setState(7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DeploymentRequest createDeploymentRequest() throws ManagementException {
        Object object = AdminDeploymentService.class;
        synchronized (AdminDeploymentService.class) {
            AdminRequestImpl adminRequestImpl = new AdminRequestImpl();
            adminRequestImpl.setId(System.currentTimeMillis());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            object = new DeploymentRequestTaskRuntimeMBeanImpl("Deploy request with id '" + adminRequestImpl.getId() + "'", adminRequestImpl);
            adminRequestImpl.setTaskRuntime((DeploymentRequestTaskRuntimeMBean)object);
            return adminRequestImpl;
        }
    }

    public final void register(Version version2, DeploymentServiceCallbackHandler deploymentServiceCallbackHandler) throws RegistrationExistsException {
        if (AdminDeploymentService.isDebugEnabled()) {
            AdminDeploymentService.debug("DeploymentServiceCallbackHandler for '" + deploymentServiceCallbackHandler.getHandlerIdentity() + "' registering with version '" + version2.toString() + "'");
        }
        this.deploymentsManager = AdminDeploymentsManager.getInstance();
        this.deploymentsManager.registerCallbackHandler(version2, deploymentServiceCallbackHandler);
    }

    public final DeploymentRequestTaskRuntimeMBean deploy(DeploymentRequest deploymentRequest) throws RequiresTaskMediatedStartException {
        if (AdminDeploymentService.isDebugEnabled()) {
            AdminDeploymentService.debug("'deploy'-ing id " + deploymentRequest.getId());
        }
        if (deploymentRequest.isStartControlEnabled()) {
            throw new RequiresTaskMediatedStartException(DeploymentServiceLogger.logStartControlLoggable().getMessage());
        }
        return this.startDeploy(deploymentRequest);
    }

    public final DeploymentRequestTaskRuntimeMBean startDeploy(DeploymentRequest deploymentRequest) {
        final DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)deploymentRequest.getTaskRuntime();
        if (deploymentRequest instanceof AdminRequestImpl) {
            if (AdminDeploymentService.isDebugEnabled()) {
                AdminDeploymentService.debug("starting 'deploy' of id '" + deploymentRequest.getId() + "'");
            }
            final DeploymentRequest deploymentRequest2 = deploymentRequest;
            this.requestManager.addRequest(new ServiceRequest(){

                public void run() {
                    deploymentRequestTaskRuntimeMBeanImpl.setState(1);
                    ((AdminRequestImpl)deploymentRequest2).run();
                }

                public String toString() {
                    return deploymentRequest2.toString();
                }
            });
        } else {
            deploymentRequestTaskRuntimeMBeanImpl.setState(3);
            String string = DeploymentServiceLogger.incompatibleModification();
            Exception exception = new Exception(string);
            deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(this.getLocalServerName(), exception);
        }
        return deploymentRequestTaskRuntimeMBeanImpl;
    }

    public final void cancel(DeploymentRequest deploymentRequest) {
        block6: {
            AdminRequestImpl adminRequestImpl;
            long l = deploymentRequest.getId();
            if (AdminDeploymentService.isDebugEnabled()) {
                AdminDeploymentService.debug("'cancel' called on id '" + l + "'");
            }
            if ((adminRequestImpl = this.requestManager.getRequest(l)) == null) {
                String string = DeploymentServiceLogger.noRequestToCancel((long)l);
                if (AdminDeploymentService.isDebugEnabled()) {
                    AdminDeploymentService.debug(string);
                }
                this.requestManager.addPendingCancel(l);
                this.sendCancelFailedTo(deploymentRequest, new Exception(string));
                return;
            }
            DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)deploymentRequest.getTaskRuntime();
            deploymentRequestTaskRuntimeMBeanImpl.setState(5);
            try {
                adminRequestImpl.cancel();
            }
            catch (InvalidStateException invalidStateException) {
                AdminRequestStatus adminRequestStatus;
                if (AdminDeploymentService.isDebugEnabled()) {
                    AdminDeploymentService.debug("attempt to 'cancel' id '" + l + "' failed due to '" + invalidStateException.getMessage() + "'");
                }
                if ((adminRequestStatus = adminRequestImpl.getStatus()) == null) break block6;
                adminRequestStatus.signalCancelFailed(false);
            }
        }
    }

    public final void unregister(String string) {
        final String string2 = "DeploymentServiceCallbackHandler for '" + string + "' unregistering ";
        if (AdminDeploymentService.isDebugEnabled()) {
            AdminDeploymentService.debug(string2);
        }
        final String string3 = string;
        this.requestManager.addRequest(new ServiceRequest(){

            public void run() {
                AdminDeploymentService.this.deploymentsManager.unregisterCallbackHandler(string3);
                AdminDeploymentService.this.requestManager.scheduleNextRequest();
            }

            public String toString() {
                return string2;
            }
        });
    }

    public final ChangeDescriptor createChangeDescriptor(String string, String string2, String string3, Serializable serializable) throws InvalidCreateChangeDescriptorException {
        return this.createChangeDescriptor(string, string2, string3, serializable, null);
    }

    public final ChangeDescriptor createChangeDescriptor(String string, String string2, String string3, Serializable serializable, String string4) throws InvalidCreateChangeDescriptorException {
        String string5 = File.separator;
        String string6 = DomainDir.getRootDir() + string5 + string3;
        File file = new File(string6);
        if (!file.exists()) {
            throw new InvalidCreateChangeDescriptorException(DeploymentServiceLogger.logNoFileLoggable((String)string6).getMessage());
        }
        if (!(string.equals("add") || string.equals("delete") || string.equals("update"))) {
            String string7 = DeploymentServiceLogger.unsupportedOperation((String)string);
            throw new InvalidCreateChangeDescriptorException(string7);
        }
        ChangeDescriptorImpl changeDescriptorImpl = new ChangeDescriptorImpl(string, string2, string3, serializable, string4);
        return changeDescriptorImpl;
    }

    public final ChangeDescriptor createChangeDescriptor(Serializable serializable, Serializable serializable2) {
        return new ChangeDescriptorImpl(serializable, serializable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerDeploymentProvider(DeploymentProvider deploymentProvider) {
        HashSet hashSet = this.providers;
        synchronized (hashSet) {
            this.providers.add(deploymentProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getRegisteredDeploymentProviders() {
        HashSet hashSet = this.providers;
        synchronized (hashSet) {
            return (Set)this.providers.clone();
        }
    }

    public void registerStatusListener(String string, StatusListener statusListener) {
        this.statusDeliverer.registerStatusListener(string, statusListener);
    }

    public void unregisterStatusListener(String string) {
        this.statusDeliverer.unregisterStatusListener(string);
    }

    public final void start() throws ServiceFailureException {
        this.requestManager = AdminRequestManager.getInstance();
    }
}

