/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.application.utils.XMLWriter;
import weblogic.deploy.internal.diagnostics.ImageProvider;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestStatus;

public class AdminDeploymentServiceImageProvider
extends ImageProvider {
    public void writeDiagnosticImage(XMLWriter xMLWriter) {
        if (!isAdminServer) {
            return;
        }
        AdminRequestManager adminRequestManager = AdminRequestManager.getInstance();
        Iterator iterator = adminRequestManager.getRequests().iterator();
        while (iterator.hasNext() && !this.timedOut) {
            AdminRequestImpl adminRequestImpl = (AdminRequestImpl)((Map.Entry)iterator.next()).getValue();
            AdminRequestStatus adminRequestStatus = adminRequestImpl.getStatus();
            xMLWriter.addElement("admin-deployment-service-request");
            xMLWriter.addElement("id", "" + adminRequestStatus.getId());
            xMLWriter.addElement("current-state", adminRequestStatus.getCurrentState().toString());
            this.writeCollection(xMLWriter, adminRequestStatus.getTargetedServers(), "targets");
            this.writePrepareDeliveryFailed(xMLWriter, adminRequestStatus);
            this.writeRespondPrepareTargets(xMLWriter, adminRequestStatus);
            this.writeRestartTargets(xMLWriter, adminRequestStatus);
            this.writeCommittedTargets(xMLWriter, adminRequestStatus);
            this.writeCommitDeliveryFailed(xMLWriter, adminRequestStatus);
            this.writeRespondCommitTargets(xMLWriter, adminRequestStatus);
            this.writeCommitFailures(xMLWriter, adminRequestStatus);
            this.writeCancelTargets(xMLWriter, adminRequestStatus);
            this.writeRespondCancelTargets(xMLWriter, adminRequestStatus);
            this.writeCancelFailures(xMLWriter, adminRequestStatus);
            this.writePrepareFailure(xMLWriter, adminRequestStatus);
            if (adminRequestStatus.timedOut()) {
                xMLWriter.addElement("timed-out", "true");
            }
            if (adminRequestStatus.isCancelledByUser()) {
                xMLWriter.addElement("cancelled-by", "user / administrator");
            }
            if (adminRequestStatus.isCancelledByClusterConstraints()) {
                xMLWriter.addElement("cancelled-by", "cluster-constraints-enabled");
            }
            xMLWriter.closeElement();
            xMLWriter.flush();
        }
    }

    private void writePrepareDeliveryFailed(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Map map = adminRequestStatus.getPrepareDeliveryFailureTargets();
        if (!map.isEmpty()) {
            this.writeCollection(xMLWriter, map.keySet().iterator(), "prepare-failed-to-be-delivered-to");
        }
    }

    private void writeRespondPrepareTargets(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Set set = adminRequestStatus.getTargetsToRespondToPrepare();
        if (!set.isEmpty()) {
            this.writeCollection(xMLWriter, set.iterator(), "targets-to-respond-to-prepare");
        }
    }

    private void writeRestartTargets(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Set set = adminRequestStatus.getTargetsToBeRestarted();
        if (!set.isEmpty()) {
            this.writeCollection(xMLWriter, set.iterator(), "targets-to-be-restarted");
        }
    }

    private void writeCommittedTargets(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Set set = adminRequestStatus.getTargetsToBeCommited();
        if (!set.isEmpty()) {
            this.writeCollection(xMLWriter, set.iterator(), "targets-that-are-to-be-commited");
        }
    }

    private void writeCommitDeliveryFailed(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Map map = adminRequestStatus.getCommitDeliveryFailureTargets();
        if (!map.isEmpty()) {
            this.writeCollection(xMLWriter, map.keySet().iterator(), "commit-failed-to-be-delivered-to");
        }
    }

    private void writeRespondCommitTargets(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Set set = adminRequestStatus.getTargetsToRespondToCommit();
        if (!set.isEmpty()) {
            this.writeCollection(xMLWriter, set.iterator(), "targets-to-respond-to-commit");
        }
    }

    private void writeCommitFailures(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Set set = adminRequestStatus.getTargetsToBeCanceled();
        if (!set.isEmpty()) {
            this.writeCollection(xMLWriter, set.iterator(), "targets-to-be-canceled");
        }
    }

    private void writeCancelTargets(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Map map = adminRequestStatus.getCancelDeliveryFailureTargets();
        if (!map.isEmpty()) {
            this.writeCollection(xMLWriter, map.keySet().iterator(), "cancel-failed-to-be-delivered-to");
        }
    }

    private void writeRespondCancelTargets(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Set set = adminRequestStatus.getTargetsToRespondToCancel();
        if (!set.isEmpty()) {
            this.writeCollection(xMLWriter, set.iterator(), "targets-to-respond-to-cancel");
        }
    }

    private void writeCancelFailures(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Set set = adminRequestStatus.getCancelFailureSet();
        if (set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            FailureDescription failureDescription = (FailureDescription)iterator.next();
            stringBuffer.append(failureDescription.getServer());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        xMLWriter.addElement("targets-cancel-failed-on", stringBuffer.toString());
    }

    private void writePrepareFailure(XMLWriter xMLWriter, AdminRequestStatus adminRequestStatus) {
        Throwable throwable = adminRequestStatus.getPrepareFailure();
        if (throwable != null) {
            xMLWriter.addElement("prepare-failure");
            xMLWriter.addElement("message", throwable.toString());
            xMLWriter.addElement("target", adminRequestStatus.getPrepareFailureSource());
        }
    }
}

