/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.DeploymentServiceCallbackHandler;
import weblogic.deploy.service.RegistrationExistsException;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.adminserver.DeploymentServiceCallbackDeliverer;

public final class AdminDeploymentsManager {
    private Map registeredCallbackHandlers = new HashMap();
    private DomainVersion currentDomainVersion = new DomainVersion();

    private AdminDeploymentsManager() {
    }

    public static AdminDeploymentsManager getInstance() {
        return Maker.SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallbackHandler(Version version2, DeploymentServiceCallbackHandler deploymentServiceCallbackHandler) throws RegistrationExistsException {
        String string = deploymentServiceCallbackHandler.getHandlerIdentity();
        Map map = this.registeredCallbackHandlers;
        synchronized (map) {
            if (this.registeredCallbackHandlers.get(string) != null) {
                throw new RegistrationExistsException(DeploymentServiceLogger.logCallbackAlreadyRegisteredLoggable((String)string).getMessage());
            }
            this.registeredCallbackHandlers.put(string, new DeploymentServiceCallbackDeliverer(deploymentServiceCallbackHandler));
            this.currentDomainVersion.addOrUpdateDeploymentVersion(string, version2);
        }
        this.dumpActiveUpdatesList();
        if (Debug.isServiceDebugEnabled()) {
            Debug.serviceDebug("Current Version updated to: " + this.currentDomainVersion.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentServiceCallbackHandler getCallbackHandler(String string) {
        Map map = this.registeredCallbackHandlers;
        synchronized (map) {
            return (DeploymentServiceCallbackHandler)this.registeredCallbackHandlers.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallbackHandler(String string) {
        if (Debug.isServiceDebugEnabled()) {
            Debug.serviceDebug("unregistering DeploymentInfo for '" + string + "'");
        }
        Map map = this.registeredCallbackHandlers;
        synchronized (map) {
            this.registeredCallbackHandlers.remove(string);
        }
        this.currentDomainVersion.removeDeploymentVersion(string);
    }

    public synchronized DomainVersion getCurrentDomainVersion() {
        return this.currentDomainVersion;
    }

    public synchronized void setCurrentDomainVersion(DomainVersion domainVersion) {
        this.currentDomainVersion = domainVersion;
        if (Debug.isServiceDebugEnabled()) {
            Debug.serviceDebug("setting current domain version on admin to '" + this.currentDomainVersion.toString() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpActiveUpdatesList() {
        Map map = this.registeredCallbackHandlers;
        synchronized (map) {
            if (this.registeredCallbackHandlers.size() > 0 && Debug.isServiceDebugEnabled()) {
                Debug.serviceDebug("registered DeploymentServiceCallbackHandlers : " + this.registeredCallbackHandlers);
            }
        }
    }

    static class Maker {
        static final AdminDeploymentsManager SINGLETON = new AdminDeploymentsManager();

        Maker() {
        }
    }
}

