/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentServiceCallbackHandler;
import weblogic.deploy.service.internal.DeploymentRequestTaskRuntimeMBeanImpl;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.RequestImpl;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentsManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestStatus;
import weblogic.deploy.service.internal.statemachines.adminserver.AdminServerState;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.internal.ConfigurationDeployment;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;

public final class AdminRequestImpl
extends RequestImpl {
    private static final AdminRequestManager requestManager = AdminRequestManager.getInstance();
    private static final AdminDeploymentsManager deploymentsManager = AdminDeploymentsManager.getInstance();
    private final Set targets;
    private DomainVersion proposedDomainVersion;
    private transient AdminRequestStatus status;
    private transient DeploymentRequestTaskRuntimeMBeanImpl taskRuntime;
    private final Object requestLock = new Object();

    AdminRequestImpl() {
        this.targets = new HashSet();
    }

    final void setId(long l) {
        this.identifier = l;
        if (AdminRequestImpl.isDebugEnabled()) {
            AdminRequestImpl.debug("Setting id for deployment request to '" + this.identifier + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskRuntime(DeploymentRequestTaskRuntimeMBean deploymentRequestTaskRuntimeMBean) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.taskRuntime == null) {
                this.taskRuntime = (DeploymentRequestTaskRuntimeMBeanImpl)deploymentRequestTaskRuntimeMBean;
            } else if (AdminRequestImpl.isDebugEnabled()) {
                AdminRequestImpl.debug("attempting to set a duplicate task runtime for '" + this.identifier + "' - ignoring this");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentRequestTaskRuntimeMBean getTaskRuntime() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.taskRuntime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdminRequestStatus getStatus() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DomainVersion getProposedDomainVersion() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.proposedDomainVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean toBeCancelled() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status != null) {
                return this.status.isCancelledByUser() || this.status.isCancelledByClusterConstraints() || this.status.timedOut() || this.status.failed();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (AdminRequestImpl.isDebugEnabled()) {
            AdminRequestImpl.debug("DeploymentService call: Starting deploy for " + this.toString());
        }
        this.startTimeoutMonitor("admin request for id '" + this.getId() + "'");
        this.status = AdminRequestStatus.createAdminRequestStatus(this);
        if (this.toBeCancelled() || requestManager.isCancelPending(this.getId())) {
            if (AdminRequestImpl.isDebugEnabled()) {
                AdminRequestImpl.debug("request '" + this.getId() + "' has been cancelled" + " - will not proceed with the deploy");
            }
            requestManager.removePendingCancel(this.getId());
            Object object = this.requestLock;
            synchronized (object) {
                if (this.status != null) {
                    this.status.signalCancelSucceeded();
                }
            }
            return;
        }
        this.processRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest() {
        requestManager.addToRequestTable(this);
        this.proposedDomainVersion = deploymentsManager.getCurrentDomainVersion().getCopy();
        Object object = this.requestLock;
        synchronized (object) {
            block6: {
                this.processDeployments();
                try {
                    AdminServerState adminServerState = this.getCurrentState();
                    if (adminServerState != null) {
                        adminServerState.start();
                    }
                }
                catch (InvalidStateException invalidStateException) {
                    if (!AdminRequestImpl.isDebugEnabled()) break block6;
                    AdminRequestImpl.debug("could not start deployment of id '" + this.identifier + "' due to '" + invalidStateException.toString());
                }
            }
        }
    }

    private void processDeployments() {
        for (int i = 0; i < this.deployments.size(); ++i) {
            Deployment deployment = (Deployment)this.deployments.get(i);
            if (deployment == null) continue;
            String string = deployment.getCallbackHandlerId();
            this.proposedDomainVersion.addOrUpdateDeploymentVersion(string, deployment.getProposedVersion());
            DeploymentServiceCallbackHandler deploymentServiceCallbackHandler = deploymentsManager.getCallbackHandler(string);
            if (deploymentServiceCallbackHandler == null && AdminRequestImpl.isDebugEnabled()) {
                AdminRequestImpl.debug("no DeploymentServiceCallbackHandler associated with '" + string + "'");
            }
            this.updateTargetList(deployment);
        }
    }

    private void updateTargetList(Deployment deployment) {
        boolean bl = deployment instanceof ConfigurationDeployment;
        String[] stringArray = deployment.getTargets();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addToTargetList(stringArray[i], bl);
        }
    }

    private void addToTargetList(String string, boolean bl) {
        this.targets.add(string);
        ClusterMBean clusterMBean = TargetHelper.getTargetCluster(string);
        if (clusterMBean == null) {
            this.status.addTargetedServer(string, false);
            if (AdminRequestImpl.isDebugEnabled()) {
                AdminRequestImpl.debug("Added '" + string + "' to target server list");
            }
        } else {
            ServerMBean[] serverMBeanArray = clusterMBean.getServers();
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                String string2 = serverMBeanArray[i].getName();
                this.status.addTargetedServer(string2, !bl);
                if (!AdminRequestImpl.isDebugEnabled()) continue;
                AdminRequestImpl.debug("Added clustered server '" + string2 + "' to target server list");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator getTargets() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return null;
            }
            return this.targets.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator getTargetServers() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return null;
            }
            return this.status.getTargetedServers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() throws InvalidStateException {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.setCancelledByUser();
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelDueToClusterConstraints() throws InvalidStateException {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.setCancelledByClusterConstraints();
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestTimedout() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            if (AdminRequestImpl.isDebugEnabled()) {
                AdminRequestImpl.debug(this.identifier + " timed out on admin server");
            }
            this.status.setTimedOut();
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.requestTimedOut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdminServerState getCurrentState() {
        AdminServerState adminServerState = null;
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status != null) {
                adminServerState = this.status.getCurrentState();
            }
        }
        return adminServerState;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AdminRequestImpl) {
            return super.equals(object);
        }
        return false;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AdminDeploymentRequest id '" + this.getId() + "'");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedPrepareSucceeded(long l, String string, boolean bl) {
        Object object = this.requestLock;
        synchronized (object) {
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.receivedPrepareSucceeded(string, bl);
            }
        }
    }

    public void receivedPrepareFailed(String string, Throwable throwable) {
        this.receivedPrepareFailed(string, throwable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedPrepareFailed(String string, Throwable throwable, boolean bl) {
        Object object = this.requestLock;
        synchronized (object) {
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.receivedPrepareFailed(string, throwable, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedCommitSucceeded(String string) {
        Object object = this.requestLock;
        synchronized (object) {
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.receivedCommitSucceeded(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedCommitFailed(String string, Throwable throwable) {
        Object object = this.requestLock;
        synchronized (object) {
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.receivedCommitFailed(string, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedCancelSucceeded(String string) {
        Object object = this.requestLock;
        synchronized (object) {
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.receivedCancelSucceeded(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedCancelFailed(String string, Throwable throwable) {
        Object object = this.requestLock;
        synchronized (object) {
            AdminServerState adminServerState = this.getCurrentState();
            if (adminServerState != null) {
                adminServerState.receivedCancelFailed(string, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDeliveredTo(String string) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.prepareDeliveredTo(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDeliveryFailureWhenContacting(String string, Exception exception) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.prepareDeliveryFailureWhenContacting(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitDeliveredTo(String string) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.commitDeliveredTo(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitDeliveryFailureWhenContacting(String string, Exception exception) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.commitDeliveryFailureWhenContacting(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDeliveredTo(String string) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.cancelDeliveredTo(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDeliveryFailureWhenContacting(String string, Exception exception) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status == null) {
                return;
            }
            this.status.cancelDeliveryFailureWhenContacting(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.status != null) {
                this.targets.clear();
                this.proposedDomainVersion = null;
                this.status.reset();
                this.status = null;
            }
            if (this.taskRuntime != null) {
                this.taskRuntime.unregisterIfNoSubTasks();
                this.taskRuntime = null;
            }
        }
    }
}

