/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentServiceCallbackHandler;
import weblogic.deploy.service.DeploymentServiceCallbackHandlerV2;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.RequestManager;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentException;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentsManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.deploy.service.internal.adminserver.AdminRequestStatus;
import weblogic.deploy.service.internal.transport.CommonMessageSender;
import weblogic.deploy.service.internal.transport.ServerDisconnectListener;
import weblogic.deploy.service.internal.transport.ServerDisconnectManager;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.utils.StackTraceUtils;

public final class AdminRequestManager
extends RequestManager {
    private final HashSet pendingCancels = new HashSet();
    private final HashMap requestsMap = new HashMap();
    private final AdminDeploymentsManager adminDeploymentsManager = AdminDeploymentsManager.getInstance();
    private static final int DEPLOYMENT_SUCCEEDED = 1;
    private static final int COMMIT_FAILURE = 2;
    private static final int CANCEL_SUCCESS = 3;
    private static final int COMMIT_SUCCESS = 4;

    private AdminRequestManager() {
        super("AdminRequestManager");
        ServerDisconnectManager.getInstance().initialize();
    }

    public static AdminRequestManager getInstance() {
        return Maker.SINGLETON;
    }

    public ArrayList getDeployments(DomainVersion domainVersion, String string, long l, boolean bl, String string2, Set set) {
        Object object;
        boolean bl2 = this.isDebugEnabled();
        ArrayList<Deployment> arrayList = new ArrayList<Deployment>();
        Map map = domainVersion.getDeploymentsVersionMap();
        DomainVersion domainVersion2 = this.adminDeploymentsManager.getCurrentDomainVersion();
        if (string2 != null && string2.length() != 0) {
            arrayList.addAll(this.getDeploymentsFor(string2, domainVersion, string, l));
        } else if (!domainVersion2.equals(domainVersion)) {
            if (bl2) {
                this.debug("AdminRequestManager: getDeployments: fromVersion '" + domainVersion + "' is not equal to currentVersion '" + domainVersion2 + "' - need to generate deployments to get " + " them in sync");
            }
            object = domainVersion2.getDeploymentsVersionMap();
            for (String string3 : object.keySet()) {
                DeploymentServiceCallbackHandler deploymentServiceCallbackHandler;
                Deployment[] deploymentArray;
                Version version2;
                if (set == null || !set.contains(string3)) {
                    if (!bl2) continue;
                    this.debug("Skipping " + string3 + " passed in collection does NOT contain it for server - " + string);
                    continue;
                }
                Version version3 = version2 = (Version)map.get(string3);
                Version version4 = (Version)object.get(string3);
                if (version4 == null || ((Object)version4).equals(version3) || version3 == null || (deploymentArray = (deploymentServiceCallbackHandler = this.adminDeploymentsManager.getCallbackHandler(string3)).getDeployments(version3, version4, string)) == null) continue;
                for (int i = 0; i < deploymentArray.length; ++i) {
                    if (bl2) {
                        this.debug("adding deployment '" + deploymentArray[i] + "' to getDeploymentsResponse");
                    }
                    arrayList.add(deploymentArray[i]);
                }
            }
        }
        if (!bl) {
            object = CommonMessageSender.getInstance();
            ((CommonMessageSender)object).sendGetDeploymentsResponse(arrayList, string, domainVersion2, l);
        }
        return arrayList;
    }

    public synchronized void addToRequestTable(AdminRequestImpl adminRequestImpl) {
        if (this.isDebugEnabled()) {
            this.debug("adding request  '" + adminRequestImpl.getId() + "' to admin request table");
        }
        this.requestsMap.put(new Long(adminRequestImpl.getId()), adminRequestImpl);
    }

    public final synchronized Set getRequests() {
        return this.requestsMap.entrySet();
    }

    public final synchronized AdminRequestImpl getRequest(long l) {
        return (AdminRequestImpl)this.requestsMap.get(new Long(l));
    }

    public final synchronized void removeRequest(long l) {
        if (this.isDebugEnabled()) {
            this.debug("removing request '" + l + "' from admin request table");
        }
        this.requestsMap.remove(new Long(l));
    }

    public final synchronized void addPendingCancel(long l) {
        Long l2 = new Long(l);
        if (!this.pendingCancels.contains(l2)) {
            this.pendingCancels.add(l2);
        }
        if (this.isDebugEnabled()) {
            this.debug("adding '" + l + "' to list of pending cancels on admin");
        }
    }

    public final synchronized boolean isCancelPending(long l) {
        Long l2 = new Long(l);
        return this.pendingCancels.contains(l2);
    }

    public final synchronized void removePendingCancel(long l) {
        this.pendingCancels.remove(new Long(l));
    }

    public final void deliverDeploySucceededCallback(AdminRequestImpl adminRequestImpl, Map map, List list) {
        long l = adminRequestImpl.getId();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.setUpCallbacksToFailuresTable(adminRequestImpl, linkedHashMap, map);
        this.deliverCallbacks(linkedHashMap, l, 1, list);
    }

    private boolean isDeferredDeploymentTargetInDeploymentTargetCluster(Set set, String string) {
        ClusterMBean clusterMBean = TargetHelper.getTargetCluster(string);
        if (clusterMBean == null) {
            return false;
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        if (serverMBeanArray == null) {
            return false;
        }
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!set.contains(serverMBeanArray[i])) continue;
            return true;
        }
        return false;
    }

    public ArrayList getDeploymentsFor(String string, DomainVersion domainVersion, String string2, long l) {
        Version version2;
        boolean bl = this.isDebugEnabled();
        ArrayList<Deployment> arrayList = new ArrayList<Deployment>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        Map map = domainVersion.getDeploymentsVersionMap();
        DomainVersion domainVersion2 = this.adminDeploymentsManager.getCurrentDomainVersion();
        if (bl) {
            this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : current DomainVersion : " + domainVersion2);
        }
        if (domainVersion2.equals(domainVersion)) {
            if (bl) {
                this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : managed " + "server is at the same version as admin server.");
            }
            return arrayList;
        }
        if (bl) {
            this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "' : managed " + "server is *NOT* at the same version as admin server.");
        }
        Map map2 = domainVersion2.getDeploymentsVersionMap();
        Version version3 = version2 = (Version)map.get(string);
        Version version4 = (Version)map2.get(string);
        if (bl) {
            this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : " + " fromVersion : '" + version3);
            this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : " + " toVersion : '" + version4);
        }
        if (version4 != null && !((Object)version4).equals(version3)) {
            DeploymentServiceCallbackHandler deploymentServiceCallbackHandler;
            Deployment[] deploymentArray;
            if (bl) {
                this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : " + " From-Version is *NOT* equal to To-Version");
            }
            if ((deploymentArray = (deploymentServiceCallbackHandler = this.adminDeploymentsManager.getCallbackHandler(string)).getDeployments(version3, version4, string2)) != null) {
                List<Deployment> list = Arrays.asList(deploymentArray);
                if (bl) {
                    this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : " + " foundDeployments : " + list);
                }
                arrayList.addAll(list);
            } else if (bl) {
                this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : " + " did *NOT* find Deployments");
            }
        } else if (bl) {
            this.debug(" AdminRequestManager: getDeploymentsFor('" + string + "', '" + string2 + "') : " + " From-Version is equal to To-Version");
        }
        if (bl) {
            this.debug("AdminRequestManager.getDeploymentsFor() : returning deployments : " + arrayList);
        }
        return arrayList;
    }

    private void updateDeferredDeploymentsSubset(Map map, Set set, Deployment deployment) {
        if (map != null && map.size() > 0) {
            String[] stringArray = deployment.getTargets();
            for (int i = 0; i < stringArray.length; ++i) {
                if (map.keySet().contains(stringArray[i])) {
                    this.addServerToDeferredSet(set, stringArray[i], deployment, map);
                    continue;
                }
                if (!this.isDeferredDeploymentTargetInDeploymentTargetCluster(map.keySet(), stringArray[i])) continue;
                ClusterMBean clusterMBean = TargetHelper.getTargetCluster(stringArray[i]);
                ServerMBean[] serverMBeanArray = clusterMBean.getServers();
                for (int j = 0; j < serverMBeanArray.length; ++j) {
                    String string = serverMBeanArray[j].getName();
                    if (!map.keySet().contains(string)) continue;
                    this.addServerToDeferredSet(set, string, deployment, map);
                }
            }
        }
    }

    private void addServerToDeferredSet(Set set, String string, Deployment deployment, Map map) {
        if (!set.contains(string)) {
            if (this.isDebugEnabled()) {
                this.debug("AdminRequestManager: updateDeferredDeploymentsSubset adding " + string + " to deferred set of " + deployment.getCallbackHandlerId());
            }
            set.add(map.get(string));
        }
    }

    public final void deliverDeployFailedCallback(AdminRequestImpl adminRequestImpl, AdminDeploymentException adminDeploymentException) {
        long l = adminRequestImpl.getId();
        Iterator iterator = adminRequestImpl.getDeployments();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = this.isDebugEnabled();
        while (iterator.hasNext()) {
            Deployment deployment = (Deployment)iterator.next();
            String string = deployment.getCallbackHandlerId();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            DeploymentServiceCallbackHandler deploymentServiceCallbackHandler = this.adminDeploymentsManager.getCallbackHandler(string);
            if (deploymentServiceCallbackHandler == null) {
                if (!bl) continue;
                this.debug("No DeploymentServiceCallbackHandler to dispatch prepare delivery failure for deployment id '" + l + "' for '" + string + "'");
                continue;
            }
            try {
                deploymentServiceCallbackHandler.deployFailed(l, adminDeploymentException);
            }
            catch (Throwable throwable) {
                if (!bl) continue;
                this.debug("DeploymentServiceCallbackHandler deployFailed callback failed for deployment id '" + l + "' and deployment type '" + string + "' due to '" + throwable.getMessage() + "'");
            }
        }
    }

    public final void deliverCommitFailureCallback(AdminRequestImpl adminRequestImpl, Map map) {
        long l = adminRequestImpl.getId();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.setUpCallbacksToFailuresTable(adminRequestImpl, linkedHashMap, map);
        this.deliverCallbacks(linkedHashMap, l, 2, new ArrayList());
    }

    public final void deliverCommitSucceededCallback(AdminRequestImpl adminRequestImpl) {
        long l = adminRequestImpl.getId();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.setUpCallbacksToFailuresTable(adminRequestImpl, linkedHashMap, null);
        this.deliverCallbacks(linkedHashMap, l, 4, new ArrayList());
    }

    public final void deliverDeployCancelSucceededCallback(AdminRequestImpl adminRequestImpl, Map map) {
        long l = adminRequestImpl.getId();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.setUpCallbacksToFailuresTable(adminRequestImpl, linkedHashMap, map);
        this.deliverCallbacks(linkedHashMap, l, 3, new ArrayList());
    }

    private void deliverCallbacks(HashMap hashMap, long l, int n, List list) {
        if (hashMap.size() > 0) {
            Iterator iterator = hashMap.keySet().iterator();
            FailureDescription[] failureDescriptionArray = new FailureDescription[]{};
            boolean bl = this.isDebugEnabled();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)hashMap.get(string);
                DeploymentServiceCallbackHandler deploymentServiceCallbackHandler = this.adminDeploymentsManager.getCallbackHandler(string);
                if (deploymentServiceCallbackHandler == null) {
                    if (!bl) continue;
                    this.debug("No DeploymentServiceCallbackHandler to deliver '" + n + "' for deployment id '" + l + "' for '" + string + "'");
                    continue;
                }
                try {
                    switch (n) {
                        case 1: {
                            ArrayList arrayList = new ArrayList();
                            if (list != null) {
                                arrayList.addAll(list);
                            }
                            if (set != null) {
                                arrayList.addAll(set);
                            }
                            deploymentServiceCallbackHandler.deploySucceeded(l, arrayList.toArray(failureDescriptionArray));
                            break;
                        }
                        case 2: {
                            deploymentServiceCallbackHandler.commitFailed(l, set.toArray(failureDescriptionArray));
                            break;
                        }
                        case 3: {
                            deploymentServiceCallbackHandler.cancelSucceeded(l, set.toArray(failureDescriptionArray));
                            break;
                        }
                        case 4: {
                            deploymentServiceCallbackHandler.commitSucceeded(l);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!bl) continue;
                    this.debug("DeploymentServiceCallbackHandler '" + this.getOperationString(n) + "' callback failed for request '" + l + "' and deployment type '" + string + "' due to '" + StackTraceUtils.throwable2StackTrace((Throwable)throwable) + "'");
                }
            }
        }
    }

    private void setUpCallbacksToFailuresTable(AdminRequestImpl adminRequestImpl, HashMap hashMap, Map map) {
        Iterator iterator = adminRequestImpl.getDeployments();
        while (iterator.hasNext()) {
            Deployment deployment = (Deployment)iterator.next();
            String string = deployment.getCallbackHandlerId();
            HashSet hashSet = (HashSet)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet();
                hashMap.put(string, hashSet);
            }
            if (map == null) continue;
            this.updateDeferredDeploymentsSubset(map, hashSet, deployment);
        }
    }

    public final void deliverDeployCancelFailedCallback(AdminRequestImpl adminRequestImpl, AdminDeploymentException adminDeploymentException) {
        long l = adminRequestImpl.getId();
        Iterator iterator = adminRequestImpl.getDeployments();
        boolean bl = this.isDebugEnabled();
        while (iterator.hasNext()) {
            Deployment deployment = (Deployment)iterator.next();
            String string = deployment.getCallbackHandlerId();
            DeploymentServiceCallbackHandler deploymentServiceCallbackHandler = this.adminDeploymentsManager.getCallbackHandler(string);
            if (deploymentServiceCallbackHandler == null) {
                if (!bl) continue;
                this.debug("No DeploymentServiceCallbackHandler to deliver failure of deployment id '" + l + "' for '" + string + "'");
                continue;
            }
            try {
                deploymentServiceCallbackHandler.cancelFailed(l, adminDeploymentException);
            }
            catch (Throwable throwable) {
                if (!bl) continue;
                this.debug("DeploymentServiceCallbackHandler cancelFailed callback failed for deployment id " + l + "' and deployment type '" + string + "' due to '" + throwable.getMessage() + "'");
            }
        }
    }

    public void addPrepareDisconnectListener(String string, AdminRequestImpl adminRequestImpl) throws RemoteException {
        if (adminRequestImpl == null) {
            return;
        }
        AdminRequestStatus adminRequestStatus = adminRequestImpl.getStatus();
        DisconnectListener disconnectListener = adminRequestStatus.getPrepareDisconnectListener(string);
        this.addDisconnectListener(string, disconnectListener);
    }

    public void addCommitDisconnectListener(String string, AdminRequestImpl adminRequestImpl) throws RemoteException {
        if (adminRequestImpl == null) {
            return;
        }
        AdminRequestStatus adminRequestStatus = adminRequestImpl.getStatus();
        DisconnectListener disconnectListener = adminRequestStatus.getCommitDisconnectListener(string);
        this.addDisconnectListener(string, disconnectListener);
    }

    public void addCancelDisconnectListener(String string, AdminRequestImpl adminRequestImpl) throws RemoteException {
        if (adminRequestImpl == null) {
            return;
        }
        AdminRequestStatus adminRequestStatus = adminRequestImpl.getStatus();
        DisconnectListener disconnectListener = adminRequestStatus.getCancelDisconnectListener(string);
        this.addDisconnectListener(string, disconnectListener);
    }

    public void removeDisconnectListener(String string, DisconnectListener disconnectListener) {
        ServerDisconnectManager serverDisconnectManager = ServerDisconnectManager.getInstance();
        ServerDisconnectListener serverDisconnectListener = serverDisconnectManager.findDisconnectListener(string);
        if (serverDisconnectListener == null) {
            return;
        }
        serverDisconnectListener.unregisterListener(disconnectListener);
        if (this.isDebugEnabled()) {
            this.debug(" +++ Removed listener='" + disconnectListener + "' : from : " + serverDisconnectListener);
        }
    }

    public final void deliverRequestStatusUpdateCallback(AdminRequestImpl adminRequestImpl, String string, String string2) {
        long l = adminRequestImpl.getId();
        Iterator iterator = adminRequestImpl.getDeployments();
        while (iterator.hasNext()) {
            Deployment deployment = (Deployment)iterator.next();
            String string3 = deployment.getCallbackHandlerId();
            DeploymentServiceCallbackHandler deploymentServiceCallbackHandler = this.adminDeploymentsManager.getCallbackHandler(string3);
            if (deploymentServiceCallbackHandler == null) {
                if (!this.isDebugEnabled()) continue;
                this.debug("No DeploymentServiceCallbackHandler to deliver '" + string + "' for deployment id '" + l + "' for '" + string3 + "'");
                continue;
            }
            if (!(deploymentServiceCallbackHandler instanceof DeploymentServiceCallbackHandlerV2)) {
                if (!this.isDebugEnabled()) continue;
                this.debug("Callback handler is not V2 to deliver '" + string + "' for deployment id '" + l + "' for '" + string3 + "'");
                continue;
            }
            DeploymentServiceCallbackHandlerV2 deploymentServiceCallbackHandlerV2 = (DeploymentServiceCallbackHandlerV2)deploymentServiceCallbackHandler;
            try {
                deploymentServiceCallbackHandlerV2.requestStatusUpdated(l, string, string2);
            }
            catch (Throwable throwable) {
                if (!this.isDebugEnabled()) continue;
                this.debug("DeploymentServiceCallbackHandlerV2 requestStatusUpdated callback failed for deployment id " + l + "' and deployment type '" + string3 + "' due to '" + throwable.getMessage() + "'");
            }
        }
    }

    private void addDisconnectListener(String string, DisconnectListener disconnectListener) throws RemoteException {
        ServerDisconnectManager serverDisconnectManager = ServerDisconnectManager.getInstance();
        ServerDisconnectListener serverDisconnectListener = serverDisconnectManager.findOrCreateDisconnectListener(string);
        if (serverDisconnectListener == null) {
            String string2 = DeployerRuntimeLogger.serverUnreachable((String)string);
            throw new RemoteException(string2);
        }
        serverDisconnectListener.registerListener(disconnectListener);
        if (this.isDebugEnabled()) {
            this.debug(" +++ Added listener='" + disconnectListener + "' : to : " + serverDisconnectListener);
        }
    }

    private String getOperationString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "DEPLOYMENT_SUCCEEDED";
                break;
            }
            case 2: {
                string = "COMMIT_FAILURE";
                break;
            }
            case 3: {
                string = "CANCEL_SUCCESS";
                break;
            }
            case 4: {
                string = "COMMIT_SUCCESS";
            }
        }
        return string;
    }

    static class Maker {
        static final AdminRequestManager SINGLETON = new AdminRequestManager();

        Maker() {
        }
    }
}

