/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.RequiresRestartFailureDescription;
import weblogic.deploy.service.internal.DeploymentRequestTaskRuntimeMBeanImpl;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentException;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentsManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.TimeAuditorManager;
import weblogic.deploy.service.internal.statemachines.StateMachinesManager;
import weblogic.deploy.service.internal.statemachines.adminserver.AdminServerState;
import weblogic.logging.Loggable;
import weblogic.logging.NonCatalogLogger;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.ServerDisconnectEvent;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public final class AdminRequestStatus {
    private static final NonCatalogLogger timeoutLogger = new NonCatalogLogger("DeploymentRequestTimeoutLogger");
    private static final AdminDeploymentsManager adminDeploymentsManager = AdminDeploymentsManager.getInstance();
    private static final AdminRequestManager adminRequestManager = AdminRequestManager.getInstance();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String localServer = ManagementService.getRuntimeAccess(kernelId).getServerName();
    private AdminRequestImpl request;
    private final long requestId;
    private AdminServerState currentState;
    private ArrayList adminServerStateList;
    private boolean timedOut;
    private static boolean clusterConstraintsInitialized = false;
    private static boolean clusterConstraintsEnabled = false;
    private HashMap prepareDisconnectListeners = new HashMap();
    private HashMap commitDisconnectListeners = new HashMap();
    private HashMap cancelDisconnectListeners = new HashMap();
    private HashSet targetedServers = new HashSet();
    private HashSet targetsToBeCommited = new HashSet();
    private Set targetsToRespondToPrepare = Collections.synchronizedSet(new HashSet());
    private Map prepareDeliveryFailureTargets = new HashMap();
    private int prepareTargetsCount;
    private Throwable prepareFailure = null;
    private String prepareFailureSource = null;
    private Map prepareFailuresMap = Collections.synchronizedMap(new HashMap());
    private Set targetsToBeRestarted = new HashSet();
    private Set clusterConstraintTargets = new HashSet();
    private Set targetsToRespondToCommit = Collections.synchronizedSet(new HashSet());
    private Map commitDeliveryFailureTargets = new HashMap();
    private Map commitFailureSet = new HashMap();
    private int commitTargetsCount;
    private int commitDeliveryCount = 0;
    private HashSet targetsToBeCanceled = new HashSet();
    private Set targetsToRespondToCancel = Collections.synchronizedSet(new HashSet());
    private Map cancelDeliveryFailureTargets = new HashMap();
    private Set cancelFailureSet = new HashSet();
    private int cancelTargetsCount;
    private int cancelDeliveryCount = 0;
    private boolean isCancelledByUser;
    private boolean isCancelledByClusterConstraints;

    private AdminRequestStatus(AdminRequestImpl adminRequestImpl) {
        this.request = adminRequestImpl;
        this.requestId = adminRequestImpl.getId();
    }

    public static AdminRequestStatus createAdminRequestStatus(AdminRequestImpl adminRequestImpl) {
        AdminRequestStatus adminRequestStatus = new AdminRequestStatus(adminRequestImpl);
        try {
            StateMachinesManager.getStateMachinesManager();
            adminRequestStatus.setAdminServerStates(StateMachinesManager.createAdminServerStates(adminRequestImpl));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        adminRequestStatus.setCurrentState(adminRequestStatus.getAdminServerState(0));
        return adminRequestStatus;
    }

    public final AdminRequestImpl getRequest() {
        return this.request;
    }

    public final long getId() {
        return this.requestId;
    }

    protected Map getPrepareDeliveryFailureTargets() {
        return this.prepareDeliveryFailureTargets;
    }

    protected Set getTargetsToRespondToPrepare() {
        return this.targetsToRespondToPrepare;
    }

    protected Set getTargetsToBeRestarted() {
        return this.targetsToBeRestarted;
    }

    protected Set getTargetsToBeCommited() {
        return this.targetsToBeCommited;
    }

    protected Map getCommitDeliveryFailureTargets() {
        return this.commitDeliveryFailureTargets;
    }

    protected Set getTargetsToRespondToCommit() {
        return this.targetsToRespondToCommit;
    }

    protected Map getCommitFailureSet() {
        return this.commitFailureSet;
    }

    protected Set getTargetsToBeCanceled() {
        return this.targetsToBeCanceled;
    }

    protected Map getCancelDeliveryFailureTargets() {
        return this.cancelDeliveryFailureTargets;
    }

    protected Set getTargetsToRespondToCancel() {
        return this.targetsToRespondToCancel;
    }

    protected Set getCancelFailureSet() {
        return this.cancelFailureSet;
    }

    protected String getPrepareFailureSource() {
        return this.prepareFailureSource;
    }

    private static final void debug(String string) {
        Debug.serviceDebug(string);
    }

    private static final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    private void setAdminServerStates(ArrayList arrayList) {
        this.adminServerStateList = arrayList;
    }

    public final void setCurrentState(AdminServerState adminServerState) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("admin state set to '" + adminServerState.toString() + "' for " + "id '" + this.requestId);
        }
        this.currentState = adminServerState;
    }

    public final AdminServerState getCurrentState() {
        return this.currentState;
    }

    public final AdminServerState getAdminServerState(int n) {
        return (AdminServerState)this.adminServerStateList.get(n);
    }

    public final void addTargetedServer(String string, boolean bl) {
        if (bl && AdminRequestStatus.isClusterConstraintsEnabled()) {
            this.clusterConstraintTargets.add(string);
        }
        if (this.targetedServers.contains(string)) {
            return;
        }
        this.targetedServers.add(string);
        ++this.prepareTargetsCount;
        this.targetsToRespondToPrepare.add(string);
        this.targetsToBeCanceled.add(string);
    }

    public final Iterator getTargetedServers() {
        return this.targetedServers.iterator();
    }

    public final void prepareDeliveredTo(String string) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("prepare delivered to '" + string + "' for request '" + this.requestId + "'");
        }
        this.targetsToBeCommited.add(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        if (this.allPreparesDelivered()) {
            this.getCurrentState().allPreparesDelivered();
        }
        TimeAuditorManager.getInstance().startTargetTransition(this.requestId, string, 1);
    }

    public final void prepareDeliveryFailureWhenContacting(String string, Exception exception) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("prepare delivery to '" + string + "' failed for request '" + this.requestId + "'");
        }
        String string2 = DeploymentServiceLogger.operationDelivery((String)DeploymentServiceLogger.prepareOperation());
        FailureDescription failureDescription = new FailureDescription(string, exception, string2);
        this.targetsToRespondToPrepare.remove(string);
        this.targetsToBeCanceled.remove(string);
        this.prepareDeliveryFailureTargets.put(string, failureDescription);
        this.removePrepareDisconnectListener(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        if (AdminRequestStatus.isClusterConstraintsEnabled() && this.clusterConstraintTargets.contains(string)) {
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("ClusterConstraints is enabled and not all targets are reachable, so cancelling request '" + this.requestId + "'");
            }
            try {
                this.request.cancelDueToClusterConstraints();
                if (this.allPreparesDelivered()) {
                    this.getCurrentState().allPreparesDelivered();
                }
                return;
            }
            catch (InvalidStateException invalidStateException) {
                if (AdminRequestStatus.isDebugEnabled()) {
                    AdminRequestStatus.debug("attempt to 'cancel' id '" + this.requestId + "' failed due to '" + invalidStateException.getMessage() + "'");
                }
                this.signalCancelFailed(false);
            }
        }
        if (this.allTargetsUnreachableForPrepareDelivery()) {
            this.signalDeployDeferredDueToUnreachableTargets();
            return;
        }
        if (this.allPreparesDelivered()) {
            this.getCurrentState().allPreparesDelivered();
        }
    }

    private final int currentTargetCount() {
        return this.targetsToBeCommited.size() + this.prepareDeliveryFailureTargets.size();
    }

    private final boolean allPreparesDelivered() {
        return this.prepareTargetsCount > 0 && this.currentTargetCount() == this.prepareTargetsCount;
    }

    public final void receivedPrepareSucceededFrom(String string, boolean bl) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("prepare succeeded on '" + string + "' for request '" + this.requestId + "'");
        }
        this.targetsToRespondToPrepare.remove(string);
        if (bl) {
            this.targetsToBeRestarted.add(string);
        }
        this.removePrepareDisconnectListener(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        adminRequestManager.deliverRequestStatusUpdateCallback(this.request, "PrepareSuccessReceived", string);
        TimeAuditorManager.getInstance().endTargetTransition(this.requestId, string, 1);
    }

    public final void receivedPrepareFailedFrom(String string, Throwable throwable, boolean bl) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("prepare failed on '" + string + "' for request '" + this.requestId + "' due to '" + throwable.toString() + "'");
        }
        this.targetsToRespondToPrepare.remove(string);
        if (this.prepareFailure == null) {
            this.prepareFailure = throwable;
            this.prepareFailureSource = string;
        } else {
            this.prepareFailuresMap.put(string, throwable);
        }
        DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(string, exception);
        if (bl) {
            this.targetsToBeCanceled.remove(string);
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("Removed server '" + string + "' from toBeCancelled list since" + " prepare failed on this server while sending...");
            }
        }
        this.removePrepareDisconnectListener(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        adminRequestManager.deliverRequestStatusUpdateCallback(this.request, "PrepareFailedReceived", string);
        TimeAuditorManager.getInstance().endTargetTransition(this.requestId, string, 1);
    }

    public final Throwable getPrepareFailure() {
        return this.prepareFailure;
    }

    public final boolean failed() {
        return this.prepareFailure != null;
    }

    public final boolean receivedAllPrepareResponses() {
        return this.targetsToRespondToPrepare.isEmpty() || this.targetsToRespondToPrepare.size() == 0;
    }

    private boolean allTargetsUnreachableForPrepareDelivery() {
        return this.prepareDeliveryFailureTargets.size() == this.prepareTargetsCount;
    }

    public final Iterator getTargetsToBeCommitted() {
        this.commitTargetsCount = this.targetsToBeCommited.size();
        Iterator iterator = this.targetsToBeCommited.iterator();
        while (iterator.hasNext()) {
            this.targetsToRespondToCommit.add(iterator.next());
        }
        return ((HashSet)this.targetsToBeCommited.clone()).iterator();
    }

    public final void commitDeliveredTo(String string) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("'commit' delivered to target '" + string + "' for id '" + this.requestId + "'");
        }
        ++this.commitDeliveryCount;
        if (this.allCommitsDelivered()) {
            this.getCurrentState().allCommitsDelivered();
        }
        TimeAuditorManager.getInstance().startTargetTransition(this.requestId, string, 2);
    }

    public final void receivedCommitSucceededFrom(String string) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("commit succeeded on '" + string + "' for request '" + this.requestId + "'");
        }
        this.targetsToRespondToCommit.remove(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        this.removeCommitDisconnectListener(string);
        adminRequestManager.deliverRequestStatusUpdateCallback(this.request, "CommitSuccessReceived", string);
        TimeAuditorManager.getInstance().endTargetTransition(this.requestId, string, 2);
    }

    public final void receivedCommitFailedFrom(String string, Throwable throwable) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("commit failed on '" + string + "' for request '" + this.requestId + "' due to '" + throwable.toString() + "'");
        }
        String string2 = DeploymentServiceLogger.commitOperation();
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        FailureDescription failureDescription = new FailureDescription(string, exception, string2);
        this.targetsToRespondToCommit.remove(string);
        this.commitFailureSet.put(string, failureDescription);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        this.removeCommitDisconnectListener(string);
        adminRequestManager.deliverRequestStatusUpdateCallback(this.request, "CommitFailedReceived", string);
        TimeAuditorManager.getInstance().endTargetTransition(this.requestId, string, 2);
    }

    public final boolean commitFailed() {
        return !this.commitFailureSet.isEmpty();
    }

    public final void commitDeliveryFailureWhenContacting(String string, Exception exception) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("commit delivery to '" + string + "' failed for request '" + this.requestId + "'");
        }
        String string2 = DeploymentServiceLogger.operationDelivery((String)DeploymentServiceLogger.commitOperation());
        FailureDescription failureDescription = new FailureDescription(string, exception, string2);
        this.commitDeliveryFailureTargets.put(string, failureDescription);
        this.targetsToRespondToCommit.remove(string);
        this.removeCommitDisconnectListener(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        if (AdminRequestStatus.isClusterConstraintsEnabled() && this.clusterConstraintTargets.contains(string)) {
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("ClusterConstraints is enabled and not all targets are reachable, so cancelling request '" + this.requestId + "'");
            }
            try {
                this.request.cancelDueToClusterConstraints();
                if (this.allCommitsDelivered()) {
                    this.getCurrentState().allCommitsDelivered();
                }
                return;
            }
            catch (InvalidStateException invalidStateException) {
                if (AdminRequestStatus.isDebugEnabled()) {
                    AdminRequestStatus.debug("attempt to 'cancel' id '" + this.requestId + "' failed due to '" + invalidStateException.getMessage() + "'");
                }
                this.signalCancelFailed(false);
            }
        }
        if (this.allTargetsUnreachableForCommitDelivery()) {
            this.signalCommitFailed();
            return;
        }
        if (this.allCommitsDelivered()) {
            this.getCurrentState().allCommitsDelivered();
        }
    }

    private boolean allTargetsUnreachableForCommitDelivery() {
        return this.commitDeliveryFailureTargets.size() == this.commitTargetsCount;
    }

    public final boolean receivedAllCommitResponses() {
        boolean bl;
        boolean bl2 = bl = this.targetsToRespondToCommit.isEmpty() || this.targetsToRespondToCommit.size() == 0;
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(" **** Request '" + this.getRequest().getId() + "' receivedAllCommitResponses() : " + bl);
        }
        return bl;
    }

    private final boolean allCommitsDelivered() {
        return this.commitTargetsCount > 0 && this.commitDeliveryFailureTargets != null && this.commitDeliveryCount + this.commitDeliveryFailureTargets.size() == this.commitTargetsCount;
    }

    public final boolean isCancelledByUser() {
        return this.isCancelledByUser;
    }

    final void setCancelledByUser() {
        this.isCancelledByUser = true;
    }

    public final boolean isCancelledByClusterConstraints() {
        return this.isCancelledByClusterConstraints;
    }

    final void setCancelledByClusterConstraints() {
        this.isCancelledByClusterConstraints = true;
    }

    public final Iterator getTargetsToBeCancelled() {
        this.cancelTargetsCount = this.targetsToBeCanceled.size();
        Iterator iterator = this.targetsToBeCanceled.iterator();
        while (iterator.hasNext()) {
            this.targetsToRespondToCancel.add(iterator.next());
        }
        return ((HashSet)this.targetsToBeCanceled.clone()).iterator();
    }

    public final boolean hasTargetsToBeCancelled() {
        return !this.targetsToBeCanceled.isEmpty();
    }

    public final void cancelDeliveredTo(String string) {
        ++this.cancelDeliveryCount;
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("'cancel' delivered to target '" + string + "' for id '" + this.requestId + "'");
        }
        if (this.allCancelsDelivered()) {
            this.getCurrentState().allCancelsDelivered();
        }
        TimeAuditorManager.getInstance().startTargetTransition(this.requestId, string, 3);
    }

    public final void receivedCancelSucceededFrom(String string) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("cancel succeeded on '" + string + "' for request '" + this.requestId + "'");
        }
        this.targetsToRespondToCancel.remove(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        this.removeCancelDisconnectListener(string);
        adminRequestManager.deliverRequestStatusUpdateCallback(this.request, "CancelSuccessReceived", string);
        TimeAuditorManager.getInstance().endTargetTransition(this.requestId, string, 3);
    }

    public final void receivedCancelFailedFrom(String string, Throwable throwable) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("cancel failed on '" + string + "' for request '" + this.requestId + "' due to '" + throwable.toString() + "'");
        }
        String string2 = DeploymentServiceLogger.cancelOperation();
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        FailureDescription failureDescription = new FailureDescription(string, exception, string2);
        this.targetsToRespondToCancel.remove(string);
        this.cancelFailureSet.add(failureDescription);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        this.removeCancelDisconnectListener(string);
        adminRequestManager.deliverRequestStatusUpdateCallback(this.request, "CancelFailedReceived", string);
        TimeAuditorManager.getInstance().endTargetTransition(this.requestId, string, 3);
    }

    public final boolean cancelFailed() {
        return !this.cancelFailureSet.isEmpty();
    }

    public final void cancelDeliveryFailureWhenContacting(String string, Exception exception) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("cancel delivery to '" + string + "' failed for request '" + this.requestId + "'");
        }
        String string2 = DeploymentServiceLogger.operationDelivery((String)DeploymentServiceLogger.cancelOperation());
        FailureDescription failureDescription = new FailureDescription(string, exception, string2);
        this.cancelDeliveryFailureTargets.put(string, failureDescription);
        this.targetsToRespondToCancel.remove(string);
        this.removeCancelDisconnectListener(string);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        if (this.allTargetsUnreachableForCancelDelivery()) {
            this.signalCancelFailed(true);
            return;
        }
        if (this.allCancelsDelivered()) {
            this.getCurrentState().allCancelsDelivered();
        }
    }

    private boolean allTargetsUnreachableForCancelDelivery() {
        return this.cancelDeliveryFailureTargets.size() == this.cancelTargetsCount;
    }

    public final boolean receivedAllCancelResponses() {
        return this.targetsToRespondToCancel.isEmpty() || this.targetsToRespondToCancel.size() == 0;
    }

    private final boolean allCancelsDelivered() {
        return this.cancelTargetsCount > 0 && this.cancelDeliveryCount + this.cancelDeliveryFailureTargets.size() == this.cancelTargetsCount;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final void setTimedOut() {
        this.timedOut = true;
        DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
        String string = DeploymentServiceLogger.timedOut((long)this.request.getId());
        Exception exception = new Exception(string);
        deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(localServer, exception);
    }

    public final void signalDeploySucceeded() {
        boolean bl;
        this.updateTargetsToRestartInTaskRuntime();
        ArrayList<RequiresRestartFailureDescription> arrayList = new ArrayList<RequiresRestartFailureDescription>();
        if (this.targetsToBeRestarted != null && !this.targetsToBeRestarted.isEmpty()) {
            Iterator iterator = this.targetsToBeRestarted.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new RequiresRestartFailureDescription((String)iterator.next()));
            }
        }
        adminRequestManager.deliverDeploySucceededCallback(this.request, this.prepareDeliveryFailureTargets, arrayList);
        boolean bl2 = bl = !this.request.isControlRequest();
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("AdminRequestStatus.signalDeploySucceeded(): Needs Version Update for request '" + this.request.getId() + "' is : " + bl);
        }
        if (bl) {
            adminDeploymentsManager.setCurrentDomainVersion(this.request.getProposedDomainVersion());
        }
        DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
        deploymentRequestTaskRuntimeMBeanImpl.setState(2);
    }

    private void updateTargetsToRestartInTaskRuntime() {
        if (!this.targetsToBeRestarted.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("*** The following servers need to be restarted for deployment request '" + this.requestId + "' to complete: ");
            DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
            for (String string : this.targetsToBeRestarted) {
                deploymentRequestTaskRuntimeMBeanImpl.addServerToRestartSet(string);
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug(stringBuffer.toString());
            }
        }
    }

    private final void signalDeployDeferredDueToUnreachableTargets() {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("'deploy deferred' for id '" + this.requestId + "' since no targets are reachable");
        }
        this.signalDeploySucceeded();
        this.scheduleNextRequest();
        this.request.reset();
    }

    public final void signalCommitSucceeded() {
        long l = this.request.getId();
        DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
        if (this.commitDeliveryFailureTargets.size() <= 0) {
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("'commit succeeded' for id '" + l + "'");
            }
            adminRequestManager.deliverCommitSucceededCallback(this.request);
            deploymentRequestTaskRuntimeMBeanImpl.setState(8);
        } else {
            Iterator iterator = this.commitDeliveryFailureTargets.keySet().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                stringBuffer.append(" ");
            }
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("'commit' succeeded but could not be delivered to the following targets '" + stringBuffer.toString() + "' for id '" + l + "'");
            }
            String string = DeploymentServiceLogger.commitDeliveryFailure((String)stringBuffer.toString());
            deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(localServer, new Exception(string));
            adminRequestManager.deliverCommitFailureCallback(this.request, this.commitDeliveryFailureTargets);
            deploymentRequestTaskRuntimeMBeanImpl.setState(8);
        }
        this.request.reset();
    }

    public final void signalCommitFailed() {
        Exception exception;
        Object object;
        String string3;
        Iterator iterator;
        Object object2;
        long l = this.request.getId();
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("'commit failed' for id '" + l + "'");
        }
        DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.timedOut()) {
            object2 = DeploymentServiceLogger.commitTimedOut((long)l);
            iterator = this.targetsToRespondToCommit;
            string3 = (String)object2 + " : Targets to respond : " + iterator;
            timeoutLogger.notice(string3);
            object = AdminRequestStatus.getThreadDumpsOnServers(iterator);
            timeoutLogger.notice((String)object);
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug((String)object2);
            }
            exception = new Exception((String)object2);
            String string2 = DeploymentServiceLogger.operationTimeout((String)DeploymentServiceLogger.commitOperation());
            FailureDescription failureDescription = new FailureDescription(localServer, exception, string2);
            this.commitDeliveryFailureTargets.put(localServer, failureDescription);
            stringBuffer.append((String)object2);
        }
        if (this.commitDeliveryFailureTargets.size() > 0) {
            object2 = this.commitDeliveryFailureTargets.keySet().iterator();
            iterator = new StringBuffer();
            while (object2.hasNext()) {
                ((StringBuffer)((Object)iterator)).append((String)object2.next());
                ((StringBuffer)((Object)iterator)).append(" ");
            }
            string3 = DeploymentServiceLogger.commitDeliveryFailure((String)((StringBuffer)((Object)iterator)).toString());
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug(string3);
            }
            stringBuffer.append(((StringBuffer)((Object)iterator)).toString());
            object = new Exception(string3);
            if (!this.timedOut()) {
                deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(localServer, (Exception)object);
            }
        }
        if (this.commitFailureSet.size() > 0) {
            object2 = new StringBuffer();
            for (String string3 : this.commitFailureSet.keySet()) {
                ((StringBuffer)object2).append(string3);
                ((StringBuffer)object2).append(" ");
                object = (FailureDescription)this.commitFailureSet.get(string3);
                exception = ((FailureDescription)object).getReason();
                this.commitDeliveryFailureTargets.put(string3, object);
                if (this.timedOut()) continue;
                deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(string3, exception);
            }
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("'commit' failed on these targets '" + ((StringBuffer)object2).toString() + "'");
            }
            stringBuffer.append(((StringBuffer)object2).toString());
        }
        adminRequestManager.deliverCommitFailureCallback(this.request, this.commitDeliveryFailureTargets);
        deploymentRequestTaskRuntimeMBeanImpl.setState(8);
        this.request.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void signalCancelSucceeded() {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("'cancel success' for id '" + this.requestId + "'");
        }
        try {
            DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
            if (this.isCancelledByUser()) {
                adminRequestManager.deliverDeployCancelSucceededCallback(this.request, this.cancelDeliveryFailureTargets);
                deploymentRequestTaskRuntimeMBeanImpl.setState(6);
            } else if (this.isCancelledByClusterConstraints()) {
                Map.Entry entry;
                Object object;
                deploymentRequestTaskRuntimeMBeanImpl.setState(6);
                AdminDeploymentException adminDeploymentException = new AdminDeploymentException();
                boolean bl = true;
                Map map = this.getPrepareDeliveryFailureTargets();
                if (map.isEmpty()) {
                    bl = false;
                    map = this.getCommitDeliveryFailureTargets();
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (!map.isEmpty()) {
                    object = map.entrySet().iterator();
                    while (object.hasNext()) {
                        entry = object.next();
                        String string = (String)entry.getKey();
                        if (!this.clusterConstraintTargets.contains(string)) continue;
                        stringBuffer.append(string);
                        if (object.hasNext()) {
                            stringBuffer.append(", ");
                        }
                        adminDeploymentException.addFailureDescription((FailureDescription)entry.getValue());
                    }
                }
                object = new Exception(DeploymentServiceLogger.cancelledDueToClusterConstraints((long)this.requestId, (String)stringBuffer.toString()));
                entry = new FailureDescription(localServer, (Exception)object, bl ? "prepare" : "commit");
                adminDeploymentException.addFailureDescription((FailureDescription)((Object)entry));
                adminRequestManager.deliverDeployFailedCallback(this.request, adminDeploymentException);
                deploymentRequestTaskRuntimeMBeanImpl.setState(3);
            } else {
                AdminDeploymentException adminDeploymentException = new AdminDeploymentException();
                this.includePrepareDeliveryFailure(adminDeploymentException);
                this.includeCancelDeliveryFailures(adminDeploymentException);
                this.includeDeploymentFailure(adminDeploymentException);
                adminRequestManager.deliverDeployFailedCallback(this.request, adminDeploymentException);
                deploymentRequestTaskRuntimeMBeanImpl.setState(3);
            }
            Object var10_10 = null;
            this.scheduleNextRequest();
            this.request.reset();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.scheduleNextRequest();
            this.request.reset();
            throw throwable;
        }
    }

    private void includePrepareDeliveryFailure(AdminDeploymentException adminDeploymentException) {
        if (this.prepareDeliveryFailureTargets.size() > 0) {
            Iterator iterator = this.prepareDeliveryFailureTargets.values().iterator();
            while (iterator.hasNext()) {
                adminDeploymentException.addFailureDescription((FailureDescription)iterator.next());
            }
        }
    }

    private void includeDeploymentFailure(AdminDeploymentException adminDeploymentException) {
        Throwable throwable;
        String string = localServer;
        if (this.timedOut()) {
            throwable = new Exception(DeploymentServiceLogger.timedOutAdmin((long)this.request.getId()));
        } else {
            throwable = this.prepareFailure;
            string = this.prepareFailureSource;
        }
        String string2 = DeploymentServiceLogger.prepareOperation();
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        FailureDescription failureDescription = new FailureDescription(string, exception, string2);
        adminDeploymentException.addFailureDescription(failureDescription);
        for (Map.Entry entry : this.prepareFailuresMap.entrySet()) {
            Exception exception2 = entry.getValue() instanceof Exception ? (Exception)entry.getValue() : new Exception((Throwable)entry.getValue());
            FailureDescription failureDescription2 = new FailureDescription((String)entry.getKey(), exception2, string2);
            adminDeploymentException.addFailureDescription(failureDescription2);
        }
    }

    public final void signalCancelFailed(boolean bl) {
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("'cancel failed' for id '" + this.requestId + "'");
        }
        AdminDeploymentException adminDeploymentException = new AdminDeploymentException();
        String string = localServer;
        DeploymentRequestTaskRuntimeMBeanImpl deploymentRequestTaskRuntimeMBeanImpl = (DeploymentRequestTaskRuntimeMBeanImpl)this.request.getTaskRuntime();
        if (this.isCancelledByUser() || this.isCancelledByClusterConstraints()) {
            String string2 = DeploymentServiceLogger.prepareOperation();
            Exception exception = new Exception(DeploymentServiceLogger.deploymentCancelled((long)this.requestId));
            FailureDescription failureDescription = new FailureDescription(string, exception, string2);
            adminDeploymentException.addFailureDescription(failureDescription);
            deploymentRequestTaskRuntimeMBeanImpl.addFailedTarget(localServer, deploymentRequestTaskRuntimeMBeanImpl.getError());
            adminRequestManager.deliverDeployCancelFailedCallback(this.request, adminDeploymentException);
            deploymentRequestTaskRuntimeMBeanImpl.setState(7);
        } else {
            this.includePrepareFailure(adminDeploymentException);
            this.includeTimeoutFailure(adminDeploymentException);
            this.includeCancelDeliveryFailures(adminDeploymentException);
            this.includeCancelFailures(adminDeploymentException);
            adminRequestManager.deliverDeployFailedCallback(this.request, adminDeploymentException);
            deploymentRequestTaskRuntimeMBeanImpl.setState(3);
        }
        if (bl) {
            this.scheduleNextRequest();
            this.request.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisconnectListener getPrepareDisconnectListener(String string) {
        Object object = this.prepareDisconnectListeners.get(string);
        if (object == null) {
            HashMap hashMap = this.prepareDisconnectListeners;
            synchronized (hashMap) {
                object = this.prepareDisconnectListeners.get(string);
                if (object == null) {
                    object = new PrepareDisconnectListenerImpl(string);
                    this.prepareDisconnectListeners.put(string, object);
                }
            }
        }
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(" +++ Returning Prepare DisconnectListener : " + object);
        }
        return (DisconnectListener)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisconnectListener getCommitDisconnectListener(String string) {
        Object object = this.commitDisconnectListeners.get(string);
        if (object == null) {
            HashMap hashMap = this.commitDisconnectListeners;
            synchronized (hashMap) {
                object = this.commitDisconnectListeners.get(string);
                if (object == null) {
                    object = new CommitDisconnectListenerImpl(string);
                    this.commitDisconnectListeners.put(string, object);
                }
            }
        }
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(" +++ Returning Commit DisconnectListener : " + object);
        }
        return (DisconnectListener)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisconnectListener getCancelDisconnectListener(String string) {
        Object object = this.cancelDisconnectListeners.get(string);
        if (object == null) {
            HashMap hashMap = this.cancelDisconnectListeners;
            synchronized (hashMap) {
                object = this.cancelDisconnectListeners.get(string);
                if (object == null) {
                    object = new CancelDisconnectListenerImpl(string);
                    this.cancelDisconnectListeners.put(string, object);
                }
            }
        }
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(" +++ Returning Cancel DisconnectListener : " + object);
        }
        return (DisconnectListener)object;
    }

    private void includeCancelFailures(AdminDeploymentException adminDeploymentException) {
        if (this.cancelFailureSet.size() > 0) {
            Iterator iterator = this.cancelFailureSet.iterator();
            while (iterator.hasNext()) {
                adminDeploymentException.addFailureDescription((FailureDescription)iterator.next());
            }
        }
    }

    private void includeCancelDeliveryFailures(AdminDeploymentException adminDeploymentException) {
        if (this.cancelDeliveryFailureTargets.size() > 0) {
            Iterator iterator = this.cancelDeliveryFailureTargets.values().iterator();
            while (iterator.hasNext()) {
                adminDeploymentException.addFailureDescription((FailureDescription)iterator.next());
            }
        }
    }

    private void includeTimeoutFailure(AdminDeploymentException adminDeploymentException) {
        if (this.timedOut()) {
            String string = this.prepareFailure == null ? DeploymentServiceLogger.timedOutDuring((long)this.request.getId(), (String)DeploymentServiceLogger.prepareOperation()) : DeploymentServiceLogger.timedOutDuring((long)this.request.getId(), (String)DeploymentServiceLogger.cancelOperation());
            Exception exception = new Exception(string);
            String string2 = localServer;
            String string3 = DeploymentServiceLogger.prepareOperation();
            FailureDescription failureDescription = new FailureDescription(string2, exception, string3);
            adminDeploymentException.addFailureDescription(failureDescription);
        }
    }

    private void includePrepareFailure(AdminDeploymentException adminDeploymentException) {
        if (this.prepareFailure != null) {
            Throwable throwable = this.prepareFailure;
            String string = this.prepareFailureSource;
            String string2 = DeploymentServiceLogger.prepareOperation();
            Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            FailureDescription failureDescription = new FailureDescription(string, exception, string2);
            adminDeploymentException.addFailureDescription(failureDescription);
        }
    }

    public final void scheduleNextRequest() {
        if (this.request != null && AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug("scheduling next admin request after id '" + this.request.getId() + "'");
        }
        adminRequestManager.scheduleNextRequest();
    }

    final void reset() {
        if (this.request != null) {
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("resetting admin request of id '" + this.request.getId() + "'");
            }
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    TimeAuditorManager.getInstance().printAuditor(AdminRequestStatus.this.requestId, System.out);
                    TimeAuditorManager.getInstance().endAuditor(AdminRequestStatus.this.requestId);
                }
            });
            this.request.cancelTimeoutMonitor();
            this.targetedServers.clear();
            this.targetedServers = null;
            this.targetsToRespondToPrepare.clear();
            this.targetsToRespondToPrepare = null;
            this.targetsToBeRestarted.clear();
            this.targetsToBeRestarted = null;
            this.prepareDeliveryFailureTargets.clear();
            this.prepareDeliveryFailureTargets = null;
            this.targetsToBeCommited.clear();
            this.targetsToBeCommited = null;
            this.targetsToRespondToCommit.clear();
            this.targetsToRespondToCommit = null;
            this.commitDeliveryFailureTargets.clear();
            this.commitDeliveryFailureTargets = null;
            this.commitFailureSet.clear();
            this.commitFailureSet = null;
            this.targetsToBeCanceled.clear();
            this.targetsToBeCanceled = null;
            this.targetsToRespondToCancel.clear();
            this.targetsToRespondToCancel = null;
            this.cancelDeliveryFailureTargets.clear();
            this.cancelDeliveryFailureTargets = null;
            this.cancelFailureSet.clear();
            this.cancelFailureSet = null;
            for (AdminServerState adminServerState : this.adminServerStateList) {
                adminServerState.reset();
            }
            this.adminServerStateList.clear();
            this.adminServerStateList = null;
            this.currentState = null;
            this.prepareFailure = null;
            this.prepareFailureSource = null;
            this.prepareFailuresMap.clear();
            adminRequestManager.removeRequest(this.request.getId());
            this.request = null;
        }
    }

    private String dumpStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("admin request status [ ");
        stringBuffer.append("\n\tid: ");
        stringBuffer.append(this.requestId);
        stringBuffer.append(", ");
        if (this.request == null) {
            stringBuffer.append(" is reset");
            stringBuffer.append("\n]");
            return stringBuffer.toString();
        }
        stringBuffer.append("\n \tcurrent state: ");
        stringBuffer.append(this.currentState.toString());
        Iterator iterator = this.targetedServers.iterator();
        stringBuffer.append("\n \ttargets: ");
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append(" ");
        }
        if (!this.prepareDeliveryFailureTargets.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.prepareDeliveryFailureTargets.keySet().iterator(), "prepare failed to be delivered to: ");
        }
        if (!this.targetsToRespondToPrepare.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.targetsToRespondToPrepare.iterator(), "targets to respond to prepare: ");
        }
        if (!this.targetsToBeRestarted.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.targetsToBeRestarted.iterator(), "targets to be restarted: ");
        }
        if (!this.targetsToBeCommited.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.targetsToBeCommited.iterator(), "targets that are to be commited: ");
        }
        if (!this.commitDeliveryFailureTargets.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.commitDeliveryFailureTargets.keySet().iterator(), "commit failed to be delivered to: ");
        }
        if (!this.targetsToRespondToCommit.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.targetsToRespondToCommit.iterator(), "targets to respond to commit: ");
        }
        if (!this.commitFailureSet.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.commitFailureSet.keySet().iterator(), "targets commit failed on : ");
        }
        if (!this.targetsToBeCanceled.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.targetsToBeCanceled.iterator(), "targets that are to be canceled: ");
        }
        if (!this.cancelDeliveryFailureTargets.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.cancelDeliveryFailureTargets.keySet().iterator(), "cancel failed to be delivered to: ");
        }
        if (!this.targetsToRespondToCancel.isEmpty()) {
            AdminRequestStatus.dumpCollection(stringBuffer, this.targetsToRespondToCancel.iterator(), "targets to respond to cancel: ");
        }
        if (!this.cancelFailureSet.isEmpty()) {
            stringBuffer.append("\n \t");
            stringBuffer.append("targets cancel failed on : ");
            for (FailureDescription failureDescription : this.cancelFailureSet) {
                stringBuffer.append(failureDescription.getServer());
                stringBuffer.append(" ");
            }
        }
        if (this.prepareFailure != null) {
            stringBuffer.append("\n \t prepare failure: " + this.prepareFailure.toString() + " on " + this.prepareFailureSource);
        }
        if (this.timedOut()) {
            stringBuffer.append("\n \t has timed out");
        }
        if (this.isCancelledByUser()) {
            stringBuffer.append("\n \t was cancelled by the user / administrator");
        }
        if (this.isCancelledByClusterConstraints()) {
            stringBuffer.append("\n \t was cancelled due to all targets not available and cluster-constraints-enabled being set to true");
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    private static void dumpCollection(StringBuffer stringBuffer, Iterator iterator, String string) {
        stringBuffer.append("\n \t");
        stringBuffer.append(string);
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append(" ");
        }
    }

    private void prepareFailedDueToServerDisconnect(String string) {
        this.targetsToBeCommited.remove(string);
        Loggable loggable = DeploymentServiceLogger.logDeferredDueToDisconnectLoggable((String)Long.toString(this.requestId), (String)string);
        String string2 = DeploymentServiceLogger.operationDelivery((String)DeploymentServiceLogger.prepareOperation());
        FailureDescription failureDescription = new FailureDescription(string, new Exception(loggable.getMessage()), string2);
        this.targetsToRespondToPrepare.remove(string);
        this.targetsToBeCanceled.remove(string);
        this.prepareDeliveryFailureTargets.put(string, failureDescription);
        if (AdminRequestStatus.isClusterConstraintsEnabled() && this.clusterConstraintTargets.contains(string)) {
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("ClusterConstraints is enabled and not all targets are reachable, so cancelling request '" + this.requestId + "'");
            }
            try {
                this.request.cancelDueToClusterConstraints();
                if (this.allPreparesDelivered()) {
                    this.getCurrentState().allPreparesDelivered();
                }
                return;
            }
            catch (InvalidStateException invalidStateException) {
                if (AdminRequestStatus.isDebugEnabled()) {
                    AdminRequestStatus.debug("attempt to 'cancel' id '" + this.requestId + "' failed due to '" + invalidStateException.getMessage() + "'");
                }
                this.signalCancelFailed(false);
            }
        }
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        this.request.receivedPrepareSucceeded(this.requestId, string, false);
    }

    private void commitFailedDueToServerDisconnect(String string) {
        Loggable loggable = DeploymentServiceLogger.logDeferredDueToDisconnectLoggable((String)Long.toString(this.requestId), (String)string);
        String string2 = DeploymentServiceLogger.operationDelivery((String)DeploymentServiceLogger.commitOperation());
        FailureDescription failureDescription = new FailureDescription(string, new Exception(loggable.getMessage()), string2);
        this.targetsToRespondToCommit.remove(string);
        this.targetsToBeCanceled.remove(string);
        this.commitDeliveryFailureTargets.put(string, failureDescription);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        if (AdminRequestStatus.isClusterConstraintsEnabled() && this.clusterConstraintTargets.contains(string)) {
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug("ClusterConstraints is enabled and not all targets are reachable, so cancelling request '" + this.requestId + "'");
            }
            try {
                this.request.cancelDueToClusterConstraints();
                if (this.allCommitsDelivered()) {
                    this.getCurrentState().allCommitsDelivered();
                }
                return;
            }
            catch (InvalidStateException invalidStateException) {
                if (AdminRequestStatus.isDebugEnabled()) {
                    AdminRequestStatus.debug("attempt to 'cancel' id '" + this.requestId + "' failed due to '" + invalidStateException.getMessage() + "'");
                }
                this.signalCancelFailed(false);
            }
        }
        this.request.receivedCommitSucceeded(string);
    }

    private void cancelFailedDueToServerDisconnect(String string) {
        Loggable loggable = DeploymentServiceLogger.logDeferredDueToDisconnectLoggable((String)Long.toString(this.requestId), (String)string);
        String string2 = DeploymentServiceLogger.operationDelivery((String)DeploymentServiceLogger.cancelOperation());
        FailureDescription failureDescription = new FailureDescription(string, new Exception(loggable.getMessage()), string2);
        this.targetsToRespondToCancel.remove(string);
        this.cancelDeliveryFailureTargets.put(string, failureDescription);
        if (AdminRequestStatus.isDebugEnabled()) {
            AdminRequestStatus.debug(this.dumpStatus());
        }
        if (this.allTargetsUnreachableForCancelDelivery()) {
            this.signalCancelFailed(true);
            return;
        }
        this.request.receivedCancelSucceeded(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePrepareDisconnectListener(String string) {
        DisconnectListener disconnectListener = null;
        HashMap hashMap = this.prepareDisconnectListeners;
        synchronized (hashMap) {
            disconnectListener = (DisconnectListener)((HashMap)this.prepareDisconnectListeners.clone()).get(string);
        }
        if (disconnectListener != null) {
            adminRequestManager.removeDisconnectListener(string, disconnectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCommitDisconnectListener(String string) {
        DisconnectListener disconnectListener = null;
        HashMap hashMap = this.commitDisconnectListeners;
        synchronized (hashMap) {
            disconnectListener = (DisconnectListener)((HashMap)this.commitDisconnectListeners.clone()).get(string);
        }
        if (disconnectListener != null) {
            adminRequestManager.removeDisconnectListener(string, disconnectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCancelDisconnectListener(String string) {
        DisconnectListener disconnectListener = null;
        HashMap hashMap = this.cancelDisconnectListeners;
        synchronized (hashMap) {
            disconnectListener = (DisconnectListener)((HashMap)this.cancelDisconnectListeners.clone()).get(string);
        }
        if (disconnectListener != null) {
            adminRequestManager.removeDisconnectListener(string, disconnectListener);
        }
    }

    private static boolean isClusterConstraintsEnabled() {
        if (!clusterConstraintsInitialized) {
            clusterConstraintsEnabled = ManagementService.getRuntimeAccess(kernelId).getDomain().isClusterConstraintsEnabled();
            clusterConstraintsInitialized = true;
        }
        return clusterConstraintsEnabled;
    }

    private static String getThreadDumpsOnServers(Set set) {
        if (set == null) {
            return null;
        }
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ThreadDumps on servers ").append(set).append("{\n");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                DomainRuntimeServiceMBean domainRuntimeServiceMBean = ManagementService.getDomainAccess(kernelId).getDomainRuntimeService();
                ServerRuntimeMBean serverRuntimeMBean = domainRuntimeServiceMBean.lookupServerRuntime(string);
                String string2 = serverRuntimeMBean.getJVMRuntime().getThreadStackDump();
                stringBuffer.append(" ThreadDump for ").append(string).append("<\n");
                stringBuffer.append(string2);
                stringBuffer.append("\n>\n\n");
            }
            catch (Throwable throwable) {
                stringBuffer.append(" Exception while getting ThreadDump for ");
                stringBuffer.append(string).append(" :: ");
                stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                stringBuffer.append("\n\n");
            }
        }
        stringBuffer.append("\n}\n");
        return stringBuffer.toString();
    }

    private class CancelDisconnectListenerImpl
    extends DisconnectListenerImpl {
        CancelDisconnectListenerImpl(String string) {
            super(string);
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            boolean bl;
            String string = this.serverName;
            if (disconnectEvent instanceof ServerDisconnectEvent) {
                string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
            }
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug(" +++ Got Disconnect event... : " + disconnectEvent + " on : " + this.toString());
            }
            boolean bl2 = bl = AdminRequestStatus.this.targetsToRespondToCancel != null && AdminRequestStatus.this.targetsToRespondToCancel.contains(string);
            if (bl) {
                AdminRequestStatus.this.cancelFailedDueToServerDisconnect(string);
            }
        }
    }

    private class CommitDisconnectListenerImpl
    extends DisconnectListenerImpl {
        CommitDisconnectListenerImpl(String string) {
            super(string);
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            boolean bl;
            String string = this.serverName;
            if (disconnectEvent instanceof ServerDisconnectEvent) {
                string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
            }
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug(" +++ Got Disconnect event... : " + disconnectEvent + " on : " + this.toString());
            }
            boolean bl2 = bl = AdminRequestStatus.this.targetsToRespondToCommit != null && AdminRequestStatus.this.targetsToRespondToCommit.contains(string);
            if (bl) {
                AdminRequestStatus.this.commitFailedDueToServerDisconnect(string);
            }
        }
    }

    private class PrepareDisconnectListenerImpl
    extends DisconnectListenerImpl {
        PrepareDisconnectListenerImpl(String string) {
            super(string);
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            boolean bl;
            String string = this.serverName;
            if (disconnectEvent instanceof ServerDisconnectEvent) {
                string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
            }
            if (AdminRequestStatus.isDebugEnabled()) {
                AdminRequestStatus.debug(" +++ Got Disconnect event... : " + disconnectEvent + " on : " + this.toString());
            }
            boolean bl2 = bl = AdminRequestStatus.this.targetsToRespondToPrepare != null && AdminRequestStatus.this.targetsToRespondToPrepare.contains(string);
            if (bl) {
                AdminRequestStatus.this.prepareFailedDueToServerDisconnect(string);
            }
        }
    }

    private abstract class DisconnectListenerImpl
    implements DisconnectListener {
        protected String serverName = null;

        DisconnectListenerImpl(String string) {
            this.serverName = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append("(");
            stringBuffer.append("Server=").append(this.serverName).append(", ");
            stringBuffer.append("requestId=").append(AdminRequestStatus.this.requestId);
            return stringBuffer.toString();
        }
    }
}

