/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.io.Serializable;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentException;
import weblogic.deploy.service.DeploymentServiceCallbackHandler;
import weblogic.deploy.service.DeploymentServiceCallbackHandlerV2;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.StatusListener;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.adminserver.StatusDeliverer;

final class DeploymentServiceCallbackDeliverer
implements DeploymentServiceCallbackHandlerV2,
StatusListener {
    private final DeploymentServiceCallbackHandler delegate;

    DeploymentServiceCallbackDeliverer(DeploymentServiceCallbackHandler deploymentServiceCallbackHandler) {
        this.delegate = deploymentServiceCallbackHandler;
        StatusDeliverer.getInstance().registerStatusListener(deploymentServiceCallbackHandler.getHandlerIdentity(), this);
    }

    private final void debug(String string) {
        Debug.serviceDebug(string);
    }

    private final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    public final String getHandlerIdentity() {
        return this.delegate.getHandlerIdentity();
    }

    public final Deployment[] getDeployments(Version version2, Version version3, String string) {
        if (this.isDebugEnabled()) {
            this.debug("Calling 'getDeployments' on DeploymentServiceCallbackHandler for '" + this.getHandlerIdentity() + "'  to sync from '" + version2 + "' to '" + version3 + "' for server '" + string + "'");
        }
        return this.delegate.getDeployments(version2, version3, string);
    }

    public final void deploySucceeded(long l, FailureDescription[] failureDescriptionArray) {
        if (this.isDebugEnabled()) {
            this.debug("Calling 'deploySucceeded' on DeploymentServiceCallbackHandler for '" + this.getHandlerIdentity() + "'  for id '" + l + "'");
        }
        this.delegate.deploySucceeded(l, failureDescriptionArray);
    }

    public final void deployFailed(long l, DeploymentException deploymentException) {
        if (this.isDebugEnabled()) {
            this.debug("Calling 'deployFailed' on DeploymentServiceCallbackHandler for '" + this.getHandlerIdentity() + "'  for id '" + l + "' due to '" + deploymentException + "'");
        }
        this.delegate.deployFailed(l, deploymentException);
    }

    public void commitFailed(long l, FailureDescription[] failureDescriptionArray) {
        if (this.isDebugEnabled()) {
            this.debug("Calling 'commitDeliverFailed' on DeploymentServiceCallbackHandler for '" + this.getHandlerIdentity() + "'  for id '" + l + "'");
        }
        this.delegate.commitFailed(l, failureDescriptionArray);
    }

    public void commitSucceeded(long l) {
        if (this.isDebugEnabled()) {
            this.debug("Calling 'commitSucceeded' on DeploymentServiceCallbackHandlerfor '" + this.getHandlerIdentity() + "' for id '" + l + "'");
        }
        this.delegate.commitSucceeded(l);
    }

    public final void cancelSucceeded(long l, FailureDescription[] failureDescriptionArray) {
        if (this.isDebugEnabled()) {
            this.debug("Calling 'cancelSucceeded' on DeploymentServiceCallbackHandler for '" + this.getHandlerIdentity() + "'  for id '" + l + "'");
        }
        this.delegate.cancelSucceeded(l, failureDescriptionArray);
    }

    public final void cancelFailed(long l, DeploymentException deploymentException) {
        if (this.isDebugEnabled()) {
            this.debug("Calling 'cancelFailed' on DeploymentServiceCallbackHandler for '" + this.getHandlerIdentity() + "'  for id '" + l + "' due to '" + deploymentException + "'");
        }
        this.delegate.cancelFailed(l, deploymentException);
    }

    public final void statusReceived(Serializable serializable, String string) {
    }

    public final void statusReceived(long l, Serializable serializable, String string) {
        if (Debug.serviceStatusLogger.isDebugEnabled()) {
            Debug.serviceStatusLogger.debug("Calling 'received status' on DeploymentServiceCallbackHandler for '" + this.getHandlerIdentity() + "'  for id '" + l + "' from server '" + string + "'");
        }
        this.delegate.receivedStatusFrom(l, serializable, string);
    }

    public final void receivedStatusFrom(long l, Serializable serializable, String string) {
    }

    public final void requestStatusUpdated(long l, String string, String string2) {
        if (this.delegate instanceof DeploymentServiceCallbackHandlerV2) {
            DeploymentServiceCallbackHandlerV2 deploymentServiceCallbackHandlerV2 = (DeploymentServiceCallbackHandlerV2)this.delegate;
            deploymentServiceCallbackHandlerV2.requestStatusUpdated(l, string, string2);
        }
    }
}

