/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.internal.transport.CommonMessageReceiver;
import weblogic.deploy.service.internal.transport.CommonMessageSender;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.rmi.extensions.ConnectMonitor;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.ServerDisconnectEvent;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;

public final class HeartbeatService
extends AbstractServerService
implements TimerListener {
    private static final long HEARTBEAT_PERIOD_MILLIS = Integer.getInteger("weblogic.deployment.HeartbeatPeriodSeconds", 60) * 1000;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private TimerManager timerManager;
    private CommonMessageSender messageSender = null;
    private CommonMessageReceiver messageReceiver = null;
    private final List connectedServers = new ArrayList();

    private CommonMessageSender getMessageSender() {
        if (this.messageSender == null) {
            this.messageSender = CommonMessageSender.getInstance();
        }
        return this.messageSender;
    }

    private CommonMessageReceiver getMessageReceiver() {
        if (this.messageReceiver == null) {
            this.messageReceiver = CommonMessageReceiver.getInstance();
        }
        return this.messageReceiver;
    }

    public void start() throws ServiceFailureException {
        if (ManagementService.getPropertyService(kernelId).isAdminServer()) {
            this.monitorServerConnections();
            if (this.timerManager == null) {
                if (HeartbeatService.isDebugEnabled()) {
                    HeartbeatService.debug("Starting DeploymentService hearbeats");
                }
                this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.deploy.service.internal.adminserver.HeartbeatService", WorkManagerFactory.getInstance().getSystem());
                this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, HEARTBEAT_PERIOD_MILLIS);
            }
        }
        this.getMessageReceiver().setHeartbeatServiceInitialized();
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public synchronized void halt() throws ServiceFailureException {
        if (this.timerManager != null) {
            if (HeartbeatService.isDebugEnabled()) {
                HeartbeatService.debug("Halting DeploymentService hearbeats");
            }
            this.timerManager.suspend();
        }
    }

    public void timerExpired(Timer timer) {
        this.createAndSendHeartbeatMessage();
    }

    private void createAndSendHeartbeatMessage() {
        this.createAndSendHeartbeatMessage(this.getConnectedServers());
    }

    private void createAndSendHeartbeatMessage(List list) {
        if (HeartbeatService.isDebugEnabled()) {
            HeartbeatService.debug("Creating and sending out heartbeat to : " + list);
        }
        this.getMessageSender().sendHeartbeatMsg(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConnectedServers() {
        List list = this.connectedServers;
        synchronized (list) {
            return new ArrayList(this.connectedServers);
        }
    }

    private void monitorServerConnections() {
        ConnectMonitor connectMonitor = ConnectMonitorFactory.getConnectMonitor();
        connectMonitor.addConnectDisconnectListener(this.createConnectListener(), this.createDisconnectListener());
    }

    private DisconnectListener createDisconnectListener() {
        return new DisconnectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDisconnect(DisconnectEvent disconnectEvent) {
                String string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
                List list = HeartbeatService.this.connectedServers;
                synchronized (list) {
                    HeartbeatService.this.connectedServers.remove(string);
                }
                if (HeartbeatService.isDebugEnabled()) {
                    HeartbeatService.debug("[HeartbeatService] disconnected to server '" + string + "'");
                }
            }
        };
    }

    private ConnectListener createConnectListener() {
        return new ConnectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConnect(ConnectEvent connectEvent) {
                String string = connectEvent.getServerName();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                HeartbeatService.this.createAndSendHeartbeatMessage(arrayList);
                List list = HeartbeatService.this.connectedServers;
                synchronized (list) {
                    HeartbeatService.this.connectedServers.add(string);
                }
                if (HeartbeatService.isDebugEnabled()) {
                    HeartbeatService.debug("[HeartbeatService] connected to server '" + string + "'");
                }
            }
        };
    }

    private static final void debug(String string) {
        Debug.serviceTransportDebug(string);
    }

    private static final boolean isDebugEnabled() {
        return Debug.isServiceTransportDebugEnabled();
    }
}

