/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.adminserver;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TimeAuditorManager {
    private static final boolean AUDITOR_ENABLED = Boolean.getBoolean("weblogic.deployment.TimeAuditorEnabled");
    public static final int PREPARE = 1;
    public static final int COMMIT = 2;
    public static final int CANCEL = 3;
    private Map auditors = Collections.synchronizedMap(new HashMap());

    public static TimeAuditorManager getInstance() {
        return Maker.SINGLETON;
    }

    public void startAuditor(long l) {
        if (AUDITOR_ENABLED) {
            this.auditors.put(l, new RequestAuditor(l));
        }
    }

    public void printAuditor(long l, OutputStream outputStream) {
        this.printAuditor(l, new PrintWriter(outputStream, true));
    }

    public void printAuditor(long l, PrintStream printStream) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            printStream.println("<" + new Date() + "> " + requestAuditor);
        }
    }

    public void printAuditor(long l, PrintWriter printWriter) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            printWriter.println("<" + new Date() + "> " + requestAuditor);
            printWriter.flush();
        }
    }

    public String getAuditorAsString(long l) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            return requestAuditor.toString();
        }
        return null;
    }

    public Object endAuditor(long l) {
        return this.auditors.remove(l);
    }

    public void startTransition(long l, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.startTransition(n);
        }
    }

    public void endTransition(long l, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.endTransition(n);
        }
    }

    public void startTargetTransition(long l, String string, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.startTargetTransition(string, n);
        }
    }

    public void endTargetTransition(long l, String string, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.endTargetTransition(string, n);
        }
    }

    private static String transitionToString(int n) {
        switch (n) {
            case 1: {
                return "PREPARE";
            }
            case 2: {
                return "COMMIT";
            }
            case 3: {
                return "CANCEL";
            }
        }
        throw new IllegalArgumentException("Transition type '" + n + "' is invalid");
    }

    private class RequestAuditor {
        private final List inspectors;
        private final long requestId;

        RequestAuditor(long l) {
            this.inspectors = Arrays.asList(new AdminTransitionInspector(1), new AdminTransitionInspector(2), new AdminTransitionInspector(3));
            this.requestId = l;
        }

        void startTransition(int n) {
            AdminTransitionInspector adminTransitionInspector = this.getInspector(n);
            adminTransitionInspector.setBeginTime(System.currentTimeMillis());
        }

        void endTransition(int n) {
            AdminTransitionInspector adminTransitionInspector = this.getInspector(n);
            adminTransitionInspector.setEndTime(System.currentTimeMillis());
        }

        void startTargetTransition(String string, int n) {
            AdminTransitionInspector adminTransitionInspector = this.getInspector(n);
            adminTransitionInspector.startTargetTransition(string);
        }

        void endTargetTransition(String string, int n) {
            AdminTransitionInspector adminTransitionInspector = this.getInspector(n);
            adminTransitionInspector.endTargetTransition(string);
        }

        private AdminTransitionInspector getInspector(int n) {
            for (AdminTransitionInspector adminTransitionInspector : this.inspectors) {
                if (adminTransitionInspector.getTransitionType() != n) continue;
                return adminTransitionInspector;
            }
            throw new IllegalArgumentException("Transition type '" + n + "' is invalid");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Admin - Time calculations for requestId '").append(this.requestId);
            stringBuffer.append("' are [").append("\n");
            Iterator iterator = this.inspectors.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t").append(iterator.next()).append("\n");
            }
            stringBuffer.append("]").append("\n");
            return stringBuffer.toString();
        }
    }

    private class AdminTransitionInspector
    extends TransitionInspector {
        private Map targetTransitions;

        AdminTransitionInspector(int n) {
            super(n);
            this.targetTransitions = new HashMap();
        }

        void startTargetTransition(String string) {
            TransitionInspector transitionInspector = (TransitionInspector)this.targetTransitions.get(string);
            if (transitionInspector == null) {
                transitionInspector = new TargetTransitionInspector(string, this.getTransitionType());
                this.targetTransitions.put(string, transitionInspector);
            }
            transitionInspector.setBeginTime(System.currentTimeMillis());
        }

        void endTargetTransition(String string) {
            TransitionInspector transitionInspector = (TransitionInspector)this.targetTransitions.get(string);
            if (transitionInspector != null) {
                transitionInspector.setEndTime(System.currentTimeMillis());
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append(" - {").append("\n");
            Iterator iterator = this.targetTransitions.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
            stringBuffer.append("\t").append("}");
            return stringBuffer.toString();
        }
    }

    private class TargetTransitionInspector
    extends TransitionInspector {
        private final String target;

        TargetTransitionInspector(String string, int n) {
            super(n);
            this.target = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\t\t").append(this.target).append("=");
            stringBuffer.append(this.timeSpent()).append("\n");
            return stringBuffer.toString();
        }
    }

    private class TransitionInspector {
        private final int transition;
        private long beginTime = 0L;
        private long endTime = 0L;

        TransitionInspector(int n) {
            this.transition = n;
        }

        int getTransitionType() {
            return this.transition;
        }

        long getBeginTime() {
            return this.beginTime;
        }

        long getEndTime() {
            return this.endTime;
        }

        void setBeginTime(long l) {
            this.beginTime = l;
        }

        void setEndTime(long l) {
            this.endTime = l;
        }

        long timeSpent() {
            return this.endTime - this.beginTime;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Transition '").append(TimeAuditorManager.transitionToString(this.transition));
            stringBuffer.append("'").append(" took : ").append(this.timeSpent());
            return stringBuffer.toString();
        }
    }

    private static class Maker {
        private static TimeAuditorManager SINGLETON = new TimeAuditorManager();

        private Maker() {
        }
    }
}

