/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.adminserver;

import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.deploy.service.internal.statemachines.State;

public abstract class AdminServerState
extends State {
    protected long requestId;
    protected AdminRequestImpl request = null;

    public AdminServerState start() throws InvalidStateException {
        throw new InvalidStateException(DeploymentServiceLogger.logInvalidStateLoggable().getMessage());
    }

    public AdminServerState cancel() throws InvalidStateException {
        this.fireStateTransitionEvent(this, "requestCancelled", this.requestId);
        return this.getCurrentState();
    }

    public AdminServerState requestTimedOut() {
        this.fireStateTransitionEvent(this, "requestTimedout", this.requestId);
        return this.getCurrentState();
    }

    public AdminServerState receivedPrepareSucceeded(String string, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareSuceeded", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - receivedPrepareSucceeded is an invalid +" + "transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState receivedPrepareFailed(String string, Throwable throwable, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareFailed", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - receivedPrepareFailed is an invalid " + "transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState receivedCommitSucceeded(String string) {
        this.fireStateTransitionEvent(this, "receivedCommitSucceeded", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - receivedCommitSucceeded is an invalid +" + "transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState receivedCommitFailed(String string, Throwable throwable) {
        this.fireStateTransitionEvent(this, "receivedCommitFailed", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - receivedCommitFailed is an invalid +" + "transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState receivedCancelSucceeded(String string) {
        this.fireStateTransitionEvent(this, "receivedCancelSucceeded", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - receivedCancelSucceeded is an invalid +" + "transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState receivedCancelFailed(String string, Throwable throwable) {
        this.fireStateTransitionEvent(this, "receivedCancelFailed", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - receivedCancelfailed is an invalid +" + "transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState allPreparesDelivered() {
        this.fireStateTransitionEvent(this, "preparesDelivered", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - allPreparesDelivered is an invalid transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState allCommitsDelivered() {
        this.fireStateTransitionEvent(this, "commitsDelivered", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - allCommitsDelivered is an invalid transition event");
        }
        return this.getCurrentState();
    }

    public AdminServerState allCancelsDelivered() {
        this.fireStateTransitionEvent(this, "cancelsDelivered", this.requestId);
        if (this.isDebugEnabled()) {
            this.debug("deployment '" + this.requestId + "' is in ' " + this.getCurrentState() + "' - allCancelsDelivered is an invalid transition event");
        }
        return this.getCurrentState();
    }

    public final void initialize(AdminRequestImpl adminRequestImpl) {
        this.request = adminRequestImpl;
        this.requestId = adminRequestImpl.getId();
    }

    protected void doPrepareCompletionCheck() {
    }

    protected boolean doCommitCompletionCheck() {
        return false;
    }

    protected boolean doCancelCompletionCheck() {
        return false;
    }

    protected final AdminServerState getCurrentState() {
        if (this.request == null) {
            return null;
        }
        return this.request.getCurrentState();
    }

    protected final AdminRequestImpl getDeploymentRequest() {
        return this.request;
    }

    protected final void setExpectedNextState(int n) {
        AdminServerState adminServerState = this.request.getStatus().getAdminServerState(n);
        if (this.isDebugEnabled()) {
            this.debug("Setting admin state of deployment '" + this.requestId + "' to : " + this.getAdminStateString(n));
        }
        this.request.getStatus().setCurrentState(adminServerState);
    }

    public void reset() {
        this.request = null;
    }

    protected final void fireStateTransitionEvent(State state, String string, long l) {
        if (this.isDebugEnabled()) {
            this.debug("Admin DeploymentService event : '" + state.toString() + "." + string + "()' for deployment id '" + l + "'");
        }
    }

    protected final String getAdminStateString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "SendingPrepare";
                break;
            }
            case 1: {
                string = "AwaitingPrepareResponses";
                break;
            }
            case 2: {
                string = "SendingCommit";
                break;
            }
            case 3: {
                string = "AwaitingCommitResponses";
                break;
            }
            case 4: {
                string = "SendingCancel";
                break;
            }
            case 5: {
                string = "AwaitingCancelResponses";
            }
        }
        return string;
    }
}

