/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.adminserver;

import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.TimeAuditorManager;
import weblogic.deploy.service.internal.statemachines.adminserver.AdminServerState;

public final class AwaitingCancelResponses
extends AdminServerState {
    public final AdminServerState cancel() throws InvalidStateException {
        throw new InvalidStateException(DeploymentServiceLogger.logAlreadyCancelledLoggable((long)this.requestId, (String)this.toString()).getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdminServerState requestTimedOut() {
        this.fireStateTransitionEvent(this, "requestTimedout", this.requestId);
        AdminRequestManager adminRequestManager = AdminRequestManager.getInstance();
        synchronized (adminRequestManager) {
            this.request.getStatus().signalCancelFailed(true);
        }
        return null;
    }

    public final AdminServerState receivedPrepareSucceeded(String string, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareSucceeded", this.requestId);
        return this.getCurrentState();
    }

    public AdminServerState receivedPrepareFailed(String string, Throwable throwable, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareFailed", this.requestId);
        return this.getCurrentState();
    }

    public final AdminServerState receivedCancelSucceeded(String string) {
        this.fireStateTransitionEvent(this, "receivedCancelSucceeded", this.requestId);
        this.request.getStatus().receivedCancelSucceededFrom(string);
        if (this.doCancelCompletionCheck()) {
            return null;
        }
        return this.getCurrentState();
    }

    public final AdminServerState receivedCancelFailed(String string, Throwable throwable) {
        this.fireStateTransitionEvent(this, "receivedCancelFailed", this.requestId);
        this.request.getStatus().receivedCancelFailedFrom(string, throwable);
        if (this.doCancelCompletionCheck()) {
            return null;
        }
        return this.getCurrentState();
    }

    protected final boolean doCancelCompletionCheck() {
        if (this.request.getStatus().receivedAllCancelResponses()) {
            TimeAuditorManager.getInstance().endTransition(this.requestId, 3);
            this.signalCancelCompletion();
            return true;
        }
        return false;
    }

    private final void signalCancelCompletion() {
        if (this.request.getStatus().cancelFailed()) {
            this.request.getStatus().signalCancelFailed(true);
        } else {
            this.request.getStatus().signalCancelSucceeded();
        }
    }

    public final String toString() {
        return "AwaitingCancelResponses";
    }
}

