/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.adminserver;

import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.TimeAuditorManager;
import weblogic.deploy.service.internal.statemachines.adminserver.AdminServerState;

public final class AwaitingCommitResponses
extends AdminServerState {
    public final AdminServerState cancel() throws InvalidStateException {
        throw new InvalidStateException(DeploymentServiceLogger.logTooLateToCancelLoggable((long)this.requestId, (String)this.toString()).getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdminServerState requestTimedOut() {
        this.fireStateTransitionEvent(this, "requestTimedout", this.requestId);
        AdminRequestManager adminRequestManager = AdminRequestManager.getInstance();
        synchronized (adminRequestManager) {
            this.request.getStatus().signalCommitFailed();
        }
        return null;
    }

    public AdminServerState receivedCommitSucceeded(String string) {
        this.fireStateTransitionEvent(this, "receivedCommitSucceeded", this.requestId);
        this.request.getStatus().receivedCommitSucceededFrom(string);
        if (this.doCommitCompletionCheck()) {
            return null;
        }
        return this.getCurrentState();
    }

    public AdminServerState receivedCommitFailed(String string, Throwable throwable) {
        this.fireStateTransitionEvent(this, "receivedCommitFailed", this.requestId);
        this.request.getStatus().receivedCommitFailedFrom(string, throwable);
        if (this.doCommitCompletionCheck()) {
            return null;
        }
        return this.getCurrentState();
    }

    protected final boolean doCommitCompletionCheck() {
        if (this.request.getStatus().receivedAllCommitResponses()) {
            TimeAuditorManager.getInstance().endTransition(this.requestId, 2);
            this.signalCommitCompletion();
            return true;
        }
        return false;
    }

    private final void signalCommitCompletion() {
        if (this.request.getStatus().commitFailed()) {
            this.request.getStatus().signalCommitFailed();
        } else {
            this.request.getStatus().signalCommitSucceeded();
        }
    }

    public final String toString() {
        return "AwaitingCommitResponses";
    }
}

