/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.adminserver;

import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.adminserver.TimeAuditorManager;
import weblogic.deploy.service.internal.statemachines.adminserver.AdminServerState;

public final class AwaitingPrepareResponses
extends AdminServerState {
    public AdminServerState cancel() throws InvalidStateException {
        this.fireStateTransitionEvent(this, "requestCancelled", this.requestId);
        return this.getCurrentState();
    }

    public AdminServerState requestTimedOut() {
        this.fireStateTransitionEvent(this, "requestTimedout", this.requestId);
        this.doCancelCheck();
        return this.getCurrentState();
    }

    public final AdminServerState receivedPrepareSucceeded(String string, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareSucceeded", this.requestId);
        this.request.getStatus().receivedPrepareSucceededFrom(string, bl);
        this.doPrepareCompletionCheck();
        return this.getCurrentState();
    }

    public final AdminServerState receivedPrepareFailed(String string, Throwable throwable, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareFailed", this.requestId);
        this.request.getStatus().receivedPrepareFailedFrom(string, throwable, bl);
        this.doPrepareCompletionCheck();
        return this.getCurrentState();
    }

    private final boolean doCancelCheck() {
        if (this.request.toBeCancelled()) {
            this.sendCancel();
            return true;
        }
        return false;
    }

    protected final void doPrepareCompletionCheck() {
        if (this.request.getStatus().receivedAllPrepareResponses()) {
            if (this.doCancelCheck()) {
                return;
            }
            TimeAuditorManager.getInstance().endTransition(this.requestId, 1);
            this.sendCommit();
        }
    }

    private final void sendCommit() {
        this.request.getStatus().signalDeploySucceeded();
        this.setExpectedNextState(2);
        TimeAuditorManager.getInstance().startTransition(this.requestId, 2);
        this.sender.sendRequestCommitMsg(this.request);
        this.request.getStatus().scheduleNextRequest();
    }

    private final void sendCancel() {
        this.setExpectedNextState(4);
        Throwable throwable = this.request.getStatus().isCancelledByUser() ? new Exception(DeploymentServiceLogger.logCancelledLoggable((long)this.requestId).getMessage()) : (this.request.getStatus().isCancelledByClusterConstraints() ? new Exception(DeploymentServiceLogger.cancelledDueToClusterConstraints((long)this.requestId, (String)"")) : (this.request.getStatus().timedOut() ? new Exception(DeploymentServiceLogger.logRequestTimedOutLoggable((long)this.requestId).getMessage()) : this.request.getStatus().getPrepareFailure()));
        TimeAuditorManager.getInstance().startTransition(this.requestId, 3);
        if (this.request.getStatus().hasTargetsToBeCancelled()) {
            this.sender.sendRequestCancelMsg(this.getDeploymentRequest(), throwable);
        } else {
            this.getCurrentState().allCancelsDelivered();
        }
    }

    public final String toString() {
        return "AwaitingPrepareResponses";
    }
}

