/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.adminserver;

import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.statemachines.adminserver.AdminServerState;

public final class SendingCommit
extends AdminServerState {
    public final AdminServerState cancel() throws InvalidStateException {
        throw new InvalidStateException(DeploymentServiceLogger.logTooLateToCancelLoggable((long)this.requestId, (String)this.toString()).getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdminServerState requestTimedOut() {
        this.fireStateTransitionEvent(this, "requestTimedout", this.requestId);
        AdminRequestManager adminRequestManager = AdminRequestManager.getInstance();
        synchronized (adminRequestManager) {
            this.request.getStatus().signalCommitFailed();
        }
        return null;
    }

    public final AdminServerState receivedCommitSucceeded(String string) {
        this.fireStateTransitionEvent(this, "receivedCommitSucceeded", this.requestId);
        this.request.getStatus().receivedCommitSucceededFrom(string);
        return this.getCurrentState();
    }

    public final AdminServerState receivedCommitFailed(String string, Throwable throwable) {
        this.fireStateTransitionEvent(this, "receivedCommitFailed", this.requestId);
        this.request.getStatus().receivedCommitFailedFrom(string, throwable);
        return this.getCurrentState();
    }

    public final AdminServerState allCommitsDelivered() {
        this.fireStateTransitionEvent(this, "commitsDelivered", this.requestId);
        this.setExpectedNextState(3);
        AdminServerState adminServerState = this.getCurrentState();
        if (adminServerState != null) {
            adminServerState.doCommitCompletionCheck();
        }
        return this.getCurrentState();
    }

    public final String toString() {
        return "SendingCommit";
    }
}

