/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.adminserver;

import weblogic.deploy.service.internal.InvalidStateException;
import weblogic.deploy.service.internal.adminserver.TimeAuditorManager;
import weblogic.deploy.service.internal.statemachines.adminserver.AdminServerState;

public final class SendingPrepare
extends AdminServerState {
    public final AdminServerState start() throws InvalidStateException {
        this.fireStateTransitionEvent(this, "start", this.requestId);
        TimeAuditorManager.getInstance().startAuditor(this.requestId);
        TimeAuditorManager.getInstance().startTransition(this.requestId, 1);
        return this.sendDeploymentRequest();
    }

    public AdminServerState requestTimedOut() {
        this.fireStateTransitionEvent(this, "requestTimedout", this.requestId);
        return this.getCurrentState();
    }

    public final AdminServerState receivedPrepareSucceeded(String string, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareSucceeded", this.requestId);
        this.request.getStatus().receivedPrepareSucceededFrom(string, bl);
        return this.getCurrentState();
    }

    public AdminServerState receivedPrepareFailed(String string, Throwable throwable, boolean bl) {
        this.fireStateTransitionEvent(this, "receivedPrepareFailed", this.requestId);
        this.request.getStatus().receivedPrepareFailedFrom(string, throwable, bl);
        return this.getCurrentState();
    }

    public final AdminServerState allPreparesDelivered() {
        this.fireStateTransitionEvent(this, "preparesDelivered", this.requestId);
        this.setExpectedNextState(1);
        this.getCurrentState().doPrepareCompletionCheck();
        return this.getCurrentState();
    }

    private AdminServerState sendDeploymentRequest() {
        this.sender.sendRequestPrepareMsg(this.getDeploymentRequest());
        return this.getCurrentState();
    }

    public final String toString() {
        return "SendingPrepare";
    }
}

