/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;

public class AwaitingCancelCompletion
extends TargetServerState {
    public final TargetServerState cancelSucceeded() {
        this.fireStateTransitionEvent(this, "cancelSucceeded", this.getId());
        if (this.deploymentStatus != null) {
            if (this.deploymentStatus.isCanceled()) {
                this.sendCancelSucceeded();
            } else if (this.deploymentStatus.isTimedOut() || this.deploymentStatus.isAborted()) {
                this.deploymentStatus.reset();
            } else {
                DomainVersion domainVersion = this.deploymentsManager.getCurrentDomainVersion();
                this.syncWithAdminServer(domainVersion);
                return this.getCurrentState();
            }
        }
        return null;
    }

    public final TargetServerState cancelFailed() {
        this.fireStateTransitionEvent(this, "cancelFailed", this.getId());
        if (this.deploymentStatus != null) {
            if (this.deploymentStatus.isCanceled()) {
                this.sendCancelFailed(this.deploymentStatus.getCancelFailureError());
            } else if (this.deploymentStatus.isTimedOut()) {
                this.deploymentStatus.reset();
            } else {
                String string = DeploymentServiceLogger.optimisticConcurrencyErr((long)this.getId());
                Exception exception = new Exception(string, this.deploymentStatus.getCancelFailureError());
                this.sendCancelFailed(exception);
            }
        }
        return null;
    }

    public final String toString() {
        return "AwaitingCancelCompletion";
    }
}

