/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import java.util.Map;
import weblogic.deploy.service.CallbackHandler;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;
import weblogic.deploy.service.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TimeAuditorManager;

public final class AwaitingCommit
extends TargetServerState {
    public final synchronized TargetServerState receivedCancel() {
        this.fireStateTransitionEvent(this, "receivedCancel", this.getId());
        this.cancelIfNecessary();
        return this.getCurrentState();
    }

    public final synchronized TargetServerState receivedCommit() {
        this.fireStateTransitionEvent(this, "receivedCommit", this.getId());
        try {
            this.handleCommit();
        }
        catch (Throwable throwable) {
            try {
                this.sendCommitFailed(new Exception(throwable.getMessage()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getCurrentState();
    }

    private final void handleRestartIsPending() {
        boolean bl;
        DeploymentServiceLogger.logCommitPendingRestart((long)this.getId());
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        boolean bl2 = bl = !targetRequestImpl.isControlRequest();
        if (this.isDebugEnabled()) {
            this.debug("Needs VersionUpdate : " + bl);
        }
        if (bl) {
            this.deploymentsManager.setCurrentDomainVersion(targetRequestImpl.getProposedDomainVersion());
        }
        if (this.isDebugEnabled()) {
            this.debug("Treating request id " + targetRequestImpl.getId() + " on this target as 'Commit Success'");
        }
        this.deploymentStatus.commitSkipped();
        this.sendCommitSucceeded();
        if (this.deploymentStatus != null) {
            this.deploymentStatus.reset();
        }
    }

    private final void handleCommit() throws Exception {
        if (this.deploymentStatus != null && this.deploymentStatus.isRestartPending()) {
            this.handleRestartIsPending();
            return;
        }
        if (this.deploymentStatus != null && this.deploymentStatus.isCanceledOrAborted()) {
            return;
        }
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        this.doPreCommitValidation(targetRequestImpl);
        if (this.handleOptimisticConcurrencyViolationIfNecessary(targetRequestImpl)) {
            return;
        }
        DomainVersion domainVersion = targetRequestImpl.getSyncToAdminVersion();
        if (domainVersion != null) {
            this.deploymentsManager.setCurrentDomainVersion(domainVersion);
        } else {
            boolean bl;
            boolean bl2 = bl = !targetRequestImpl.isControlRequest();
            if (this.isDebugEnabled()) {
                this.debug("Needs VersionUpdate : " + bl);
            }
            if (bl) {
                this.deploymentsManager.setCurrentDomainVersion(targetRequestImpl.getProposedDomainVersion());
            }
        }
        this.setExpectedNextState(4);
        if (this.isDebugEnabled()) {
            this.debug("'commit' for id '" + targetRequestImpl + "' from version '" + targetRequestImpl.getPreparingFromVersion() + "' to version '" + targetRequestImpl.getProposedDomainVersion());
        }
        this.callDeploymentReceivers();
        this.deploymentStatus.scheduleNextRequest();
    }

    private boolean handleOptimisticConcurrencyViolationIfNecessary(TargetRequestImpl targetRequestImpl) {
        boolean bl = false;
        if (targetRequestImpl.getSyncToAdminDeployments() != null) {
            return bl;
        }
        DomainVersion domainVersion = this.deploymentsManager.getCurrentDomainVersion();
        if (!domainVersion.equals(targetRequestImpl.getPreparingFromVersion())) {
            if (this.isDebugEnabled()) {
                this.debug("request '" + targetRequestImpl.getId() + "' was 'prepare'-d " + "against version '" + targetRequestImpl.getPreparingFromVersion() + "' but is being 'commit'-ted against version '" + domainVersion + "' - request will be aborted locally and an " + "attempt will be made to resynchronize with the admin after which " + "the request will be retried");
            }
            bl = true;
            this.deploymentStatus.setAborted();
            this.cancelIfNecessary();
        }
        return bl;
    }

    private final void doPreCommitValidation(TargetRequestImpl targetRequestImpl) throws Exception {
        if (targetRequestImpl == null) {
            String string = DeploymentServiceLogger.commitNoRequest();
            if (this.isDebugEnabled()) {
                this.debug(string);
            }
            throw new Exception(string);
        }
    }

    protected final void callDeploymentReceivers() throws Exception {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        TimeAuditorManager.getInstance().startTransition(targetRequestImpl.getId(), 2);
        Map map = targetRequestImpl.getDeploymentsMap();
        CallbackHandler callbackHandler = null;
        DeploymentContextImpl deploymentContextImpl = targetRequestImpl.getDeploymentContext();
        for (String string : map.keySet()) {
            DeploymentReceiver deploymentReceiver = this.deploymentsManager.getDeploymentReceiver(string);
            if (deploymentReceiver == null) continue;
            if (targetRequestImpl.isConfigurationProviderCalledLast() && callbackHandler == null && string.equals("Configuration")) {
                callbackHandler = deploymentReceiver;
                continue;
            }
            if (this.isDebugEnabled()) {
                this.debug("calling DeploymentReceiver '" + string + "' to 'commit' for id '" + this.getId());
            }
            TimeAuditorManager.getInstance().startDeploymentTransition(targetRequestImpl.getId(), string, 2);
            deploymentReceiver.commit(deploymentContextImpl);
        }
        if (callbackHandler != null) {
            if (this.isDebugEnabled()) {
                this.debug("calling DeploymentReceiver 'Configuration' to 'commit' for id '" + this.getId());
            }
            TimeAuditorManager.getInstance().startDeploymentTransition(targetRequestImpl.getId(), callbackHandler.getHandlerIdentity(), 2);
            callbackHandler.commit(deploymentContextImpl);
        }
    }

    public final String toString() {
        return "AwaitingCommit";
    }
}

