/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import java.rmi.RemoteException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;

public final class AwaitingCommitCompletion
extends TargetServerState {
    public final TargetServerState receivedCancel() {
        this.fireStateTransitionEvent(this, "receivedCancel", this.getId());
        String string = DeploymentServiceLogger.cancelRejected((long)this.getId());
        this.sendCancelFailed(new Exception(string));
        return this.getCurrentState();
    }

    public TargetServerState abort() {
        this.fireStateTransitionEvent(this, "abort", this.getId());
        if (this.isDebugEnabled()) {
            this.debug("already waiting for commit completion for id: " + this.getId() + " nothing to be done");
        }
        return this.getCurrentState();
    }

    private final TargetRequestImpl getDeploymentRequest(long l) {
        return this.requestsManager.getRequest(l);
    }

    public final TargetServerState commitSucceeded() {
        long l = this.getId();
        this.fireStateTransitionEvent(this, "commitSucceeded", l);
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest(l);
        if (targetRequestImpl == null) {
            if (this.isDebugEnabled()) {
                this.debug("'commit succeeded' received on target for id: " + l + " that has no request - it may be completed " + "or cancelled");
            }
            return null;
        }
        DomainVersion domainVersion = targetRequestImpl.getSyncToAdminVersion();
        if (domainVersion != null) {
            if (this.isDebugEnabled()) {
                this.debug("'commit success' of sync to admin version " + domainVersion);
            }
            this.deploymentsManager.setCurrentDomainVersion(domainVersion);
            this.deploymentStatus.reset();
        } else {
            boolean bl;
            if (this.isDebugEnabled()) {
                this.debug("'commit success' on target of id " + l);
            }
            boolean bl2 = bl = !targetRequestImpl.isControlRequest();
            if (this.isDebugEnabled()) {
                this.debug("Needs VersionUpdate : " + bl);
            }
            if (bl) {
                this.deploymentsManager.setCurrentDomainVersion(targetRequestImpl.getProposedDomainVersion());
            }
            boolean bl3 = this.deploymentStatus.isCanceled();
            this.sendCommitSucceeded();
            if (bl3) {
                String string = DeploymentServiceLogger.cancelRejected((long)this.getId());
                this.sender.sendCancelFailedMsg(l, new Exception(string));
            }
        }
        return null;
    }

    public final TargetServerState commitFailed() {
        long l = this.getId();
        this.fireStateTransitionEvent(this, "commitFailed", l);
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl == null) {
            String string = DeploymentServiceLogger.commitFailed((long)l);
            if (this.isDebugEnabled()) {
                this.debug(string);
            }
            try {
                this.sender.sendCommitFailedMsg(this.getId(), new Exception(string));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return null;
        }
        DomainVersion domainVersion = targetRequestImpl.getSyncToAdminVersion();
        if (domainVersion != null) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug("'commit failed' in sync to admin version " + domainVersion + " - transition server to admin state");
            }
            this.transitionServerToAdminState();
        } else {
            boolean bl = this.deploymentStatus.isCanceled();
            try {
                this.sendCommitFailed(this.deploymentStatus.getCommitFailureError());
            }
            catch (RemoteException remoteException) {
                String string = DeploymentServiceLogger.sendCommitFailMsgFailed((long)l);
                try {
                    this.sender.sendCommitFailedMsg(this.getId(), new Exception(string));
                }
                catch (RemoteException remoteException2) {
                    // empty catch block
                }
            }
            if (bl) {
                this.sender.sendCancelFailedMsg(l, new Exception("'commit' already called on deployment request with id '" + l + "'"));
            }
        }
        return null;
    }

    public final String toString() {
        return "AwaitingCommitCompletion";
    }
}

