/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.CallbackHandler;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TimeAuditorManager;
import weblogic.utils.StackTraceUtils;

public class AwaitingContextUpdateCompletion
extends TargetServerState {
    public final synchronized TargetServerState contextUpdated() {
        this.fireStateTransitionEvent(this, "contextUpdated", this.getId());
        this.handleContextUpdateSuccess();
        return this.getCurrentState();
    }

    public final synchronized TargetServerState contextUpdateFailed(Throwable throwable) {
        this.fireStateTransitionEvent(this, "contextUpdated", this.getId());
        this.handleContextUpdateFailure(throwable);
        return this.getCurrentState();
    }

    private void handleContextUpdateSuccess() {
        if (this.cancelIfNecessary()) {
            return;
        }
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl.getDeploymentContext().isRestartRequired()) {
            this.deploymentStatus.setRestartPending();
        }
        this.setExpectedNextState(2);
        try {
            this.callDeploymentReceivers(targetRequestImpl);
        }
        catch (Exception exception) {
            if (this.isDebugEnabled()) {
                this.debug("AwaitingContextUpdateCompletion:handleContextUpdateSuccess: encountered an error " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            if (targetRequestImpl.getSyncToAdminDeployments() != null) {
                if (Debug.serviceLogger.isDebugEnabled()) {
                    Debug.serviceLogger.debug("'context update' sync to admin version " + targetRequestImpl.getSyncToAdminVersion() + " - handling failed - transitioning server to admin state");
                }
                this.transitionServerToAdminState();
                return;
            }
            if (this.cancelIfNecessary()) {
                return;
            }
            this.setExpectedNextState(6);
            this.sendPrepareNak(new Exception(exception.getMessage()));
        }
    }

    private void handleContextUpdateFailure(Throwable throwable) {
        if (this.cancelIfNecessary()) {
            return;
        }
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl.getSyncToAdminVersion() != null) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug("'context update' failed in sync to admin version " + targetRequestImpl.getSyncToAdminVersion() + " - transitioning server to admin state");
            }
            this.transitionServerToAdminState();
            return;
        }
        this.setExpectedNextState(6);
        this.sendPrepareNak(throwable);
    }

    protected final void callDeploymentReceivers(TargetRequestImpl targetRequestImpl) throws Exception {
        TimeAuditorManager.getInstance().startTransition(targetRequestImpl.getId(), 1);
        CallbackHandler callbackHandler = null;
        Map map = targetRequestImpl.getDeploymentsMap();
        for (String string : map.keySet()) {
            DeploymentReceiver deploymentReceiver = this.deploymentsManager.getDeploymentReceiver(string);
            if (targetRequestImpl.isConfigurationProviderCalledLast() && callbackHandler == null && string.equals("Configuration")) {
                callbackHandler = deploymentReceiver;
                if (!this.isDebugEnabled()) continue;
                this.debug("'call config last' set for id: " + targetRequestImpl.getId());
                continue;
            }
            TimeAuditorManager.getInstance().startDeploymentTransition(targetRequestImpl.getId(), string, 1);
            deploymentReceiver.prepare(targetRequestImpl.getDeploymentContext());
        }
        if (callbackHandler != null) {
            TimeAuditorManager.getInstance().startDeploymentTransition(targetRequestImpl.getId(), callbackHandler.getHandlerIdentity(), 1);
            callbackHandler.prepare(targetRequestImpl.getDeploymentContext());
        }
    }

    public final String toString() {
        return "AwaitingContextUpdateCompletion";
    }
}

