/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;
import weblogic.deploy.service.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.utils.StackTraceUtils;

public final class AwaitingGetDeploymentsResponse
extends TargetServerState {
    public synchronized TargetServerState receivedCancel() {
        this.fireStateTransitionEvent(this, "receivedCancel", this.getId());
        return this.getCurrentState();
    }

    public final synchronized TargetServerState receivedGetDeploymentsResponse(DeploymentServiceMessage deploymentServiceMessage) {
        this.fireStateTransitionEvent(this, "receivedGetDeltasResponse", 0L);
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        try {
            this.handleGetDeploymentsResponse(targetRequestImpl, deploymentServiceMessage);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug("'" + StackTraceUtils.throwable2StackTrace((Throwable)throwable) + "' failure when handling a 'get deployments response' - this is an " + "unexpected failure & probably requires a server reboot to recover");
            }
            this.transitionServerToAdminState();
            return null;
        }
        return this.getCurrentState();
    }

    private final void handleGetDeploymentsResponse(TargetRequestImpl targetRequestImpl, DeploymentServiceMessage deploymentServiceMessage) throws Exception {
        this.doPreHandleResponseValidation(targetRequestImpl, deploymentServiceMessage);
        DomainVersion domainVersion = this.deploymentsManager.getCurrentDomainVersion();
        targetRequestImpl.setSyncToAdminMessage(deploymentServiceMessage);
        DomainVersion domainVersion2 = targetRequestImpl.getSyncToAdminVersion();
        this.setExpectedNextState(1);
        this.setupDeploymentRequest(domainVersion, domainVersion2, targetRequestImpl, targetRequestImpl.getSyncToAdminDeployments().iterator());
        this.setupDeploymentContext();
        Map map = targetRequestImpl.getSyncToAdminDeploymentsMap();
        if (map == null || map.size() == 0) {
            this.doCommit(targetRequestImpl);
            return;
        }
        this.callDeploymentReceivers();
    }

    private final void doPreHandleResponseValidation(TargetRequestImpl targetRequestImpl, DeploymentServiceMessage deploymentServiceMessage) throws Exception {
        if (targetRequestImpl == null) {
            String string = DeployerRuntimeLogger.invalidHandleResponse((long)this.getId());
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(string);
            }
            throw new Exception(string);
        }
        if (targetRequestImpl.getSyncToAdminDeployments() != null) {
            String string = DeployerRuntimeLogger.duplicateHandleResponse((String)deploymentServiceMessage.toString());
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(string);
            }
            throw new Exception(string);
        }
    }

    protected final void setupDeploymentRequest(DomainVersion domainVersion, DomainVersion domainVersion2, TargetRequestImpl targetRequestImpl, Iterator iterator) throws Exception {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.getDeploymentReceiversInfo(iterator, domainVersion, domainVersion2, linkedHashMap);
        targetRequestImpl.setSyncToAdminDeploymentsMap(linkedHashMap);
    }

    protected final void callDeploymentReceivers() throws Exception {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        Map map = targetRequestImpl.getDeploymentsMap();
        DeploymentContextImpl deploymentContextImpl = targetRequestImpl.getDeploymentContext();
        boolean bl = true;
        for (String string : map.keySet()) {
            DeploymentReceiver deploymentReceiver = this.deploymentsManager.getDeploymentReceiver(string);
            if (deploymentReceiver != null) {
                bl = false;
                deploymentReceiver.updateDeploymentContext(deploymentContextImpl);
            }
            if (!bl) continue;
            this.deploymentStatus.reset();
        }
    }

    private final void doCommit(TargetRequestImpl targetRequestImpl) {
        DomainVersion domainVersion = targetRequestImpl.getSyncToAdminVersion();
        if (domainVersion != null) {
            this.deploymentsManager.setCurrentDomainVersion(domainVersion);
        }
        this.setExpectedNextState(4);
        this.deploymentStatus.getCurrentState().commitSucceeded();
    }

    public final String toString() {
        return "AwaitingGetDeploymentsResponse";
    }
}

