/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import java.rmi.RemoteException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;

public final class AwaitingPrepareCompletion
extends TargetServerState {
    public final synchronized TargetServerState prepareSucceeded() {
        this.fireStateTransitionEvent(this, "prepareSucceeded", this.getId());
        if (this.cancelIfNecessary()) {
            return null;
        }
        this.setExpectedNextState(3);
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl == null) {
            if (this.isDebugEnabled()) {
                this.debug("'prepare succeeded' received for id: " + this.getId() + " that has no request - it may " + "completed or been cancelled ");
            }
            if (this.getId() != -1L) {
                try {
                    this.sender.sendPrepareAckMsg(this.getId(), false);
                }
                catch (RemoteException remoteException) {
                    try {
                        this.sender.sendPrepareNakMsg(this.getId(), remoteException);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
        if (targetRequestImpl.getSyncToAdminDeployments() != null) {
            this.deploymentStatus.getCurrentState().receivedCommit();
        } else {
            try {
                this.sender.sendPrepareAckMsg(this.getId(), this.deploymentStatus.isRestartPending());
            }
            catch (RemoteException remoteException) {
                try {
                    this.sender.sendPrepareNakMsg(this.getId(), remoteException);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.deploymentStatus.setAborted();
                this.cancelIfNecessary();
            }
        }
        return this.getCurrentState();
    }

    public final synchronized TargetServerState prepareFailed() {
        this.fireStateTransitionEvent(this, "prepareFailed", this.getId());
        if (this.cancelIfNecessary()) {
            return null;
        }
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl.getSyncToAdminVersion() != null) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug("'prepare' failed in sync to admin version " + targetRequestImpl.getSyncToAdminVersion() + " - transitioning server to admin state");
            }
            this.transitionServerToAdminState();
            return null;
        }
        this.setExpectedNextState(6);
        this.sendPrepareNak(this.deploymentStatus.getSavedError());
        return this.getCurrentState();
    }

    public final String toString() {
        return "AwaitingPrepareCompletion";
    }
}

