/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import java.security.AccessController;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;
import weblogic.deploy.service.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TimeAuditorManager;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;

public final class ReceivedPrepare
extends TargetServerState {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public final TargetServerState receivedPrepare() {
        this.fireStateTransitionEvent(this, "receivedPrepare", this.getId());
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        try {
            this.handlePrepare(targetRequestImpl);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            this.setExpectedNextState(6);
            this.sendPrepareNak(new Exception(throwable.getMessage()));
        }
        return this.getCurrentState();
    }

    protected final void handlePrepare(TargetRequestImpl targetRequestImpl) throws Exception {
        TimeAuditorManager.getInstance().startAuditor(targetRequestImpl.getId());
        TimeAuditorManager.getInstance().startTransition(targetRequestImpl.getId(), 0);
        if (this.handlePendingCancel(targetRequestImpl)) {
            return;
        }
        DomainVersion domainVersion = this.deploymentsManager.getCurrentDomainVersion();
        if (this.syncWithAdminIfNecessary(domainVersion, targetRequestImpl)) {
            return;
        }
        this.setExpectedNextState(1);
        DomainVersion domainVersion2 = domainVersion.getCopy();
        this.setupDeploymentRequest(domainVersion, domainVersion2, targetRequestImpl, targetRequestImpl.getDeployments());
        this.setupDeploymentContext();
        if (this.isDebugEnabled()) {
            this.debug("'Receivedprepare' for id '" + targetRequestImpl + "' from version '" + targetRequestImpl.getPreparingFromVersion() + "' to version '" + targetRequestImpl.getProposedDomainVersion());
        }
        this.callDeploymentReceivers();
    }

    private final boolean handlePendingCancel(TargetRequestImpl targetRequestImpl) {
        long l = targetRequestImpl.getId();
        if (this.requestsManager.hasAPendingCancelFor(l)) {
            if (this.isDebugEnabled()) {
                this.debug("ReceivedPrepare: handling pending cancel for request with id '" + l + "'");
            }
            this.requestsManager.removePendingCancelFor(l);
            this.sendCancelSucceeded();
            return true;
        }
        return false;
    }

    private final boolean syncWithAdminIfNecessary(DomainVersion domainVersion, TargetRequestImpl targetRequestImpl) {
        if (ManagementService.getPropertyService(kernelId).isAdminServer()) {
            return false;
        }
        boolean bl = false;
        if (!domainVersion.equals(targetRequestImpl.getDomainVersion())) {
            bl = true;
            this.syncWithAdminServer(domainVersion);
        }
        return bl;
    }

    protected final void doPrePrepareValidation(TargetRequestImpl targetRequestImpl) throws Exception {
        if (targetRequestImpl == null) {
            String string = DeployerRuntimeLogger.invalidPrepare((long)this.getId());
            if (this.isDebugEnabled()) {
                this.debug(string);
            }
            throw new Exception(string);
        }
    }

    protected final void callDeploymentReceivers() throws Exception {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        Map map = targetRequestImpl.getDeploymentsMap();
        DeploymentContextImpl deploymentContextImpl = targetRequestImpl.getDeploymentContext();
        for (String string : map.keySet()) {
            DeploymentReceiver deploymentReceiver = this.deploymentsManager.getDeploymentReceiver(string);
            TimeAuditorManager.getInstance().startDeploymentTransition(targetRequestImpl.getId(), string, 0);
            deploymentReceiver.updateDeploymentContext(deploymentContextImpl);
        }
    }

    public final String toString() {
        return "ReceivedPrepare";
    }
}

