/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.statemachines.targetserver;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.statemachines.State;
import weblogic.deploy.service.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.service.internal.targetserver.TargetDeploymentsManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestStatus;
import weblogic.deploy.service.internal.targetserver.TimeAuditorManager;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;

public class TargetServerState
extends State {
    protected TargetRequestStatus deploymentStatus = null;
    protected TargetRequestManager requestsManager = null;
    protected TargetDeploymentsManager deploymentsManager = TargetDeploymentsManager.getInstance();
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public TargetServerState() {
        this.requestsManager = TargetRequestManager.getInstance();
    }

    public synchronized TargetServerState contextUpdated() {
        this.fireStateTransitionEvent(this, "contextUpdated", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState contextUpdateFailed(Throwable throwable) {
        this.fireStateTransitionEvent(this, "contextUpdateFailed", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState prepareSucceeded() {
        this.fireStateTransitionEvent(this, "prepareSucceeded", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState prepareFailed() {
        this.fireStateTransitionEvent(this, "prepareFailed", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState commitSucceeded() {
        this.fireStateTransitionEvent(this, "commitSucceeded", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState commitFailed() {
        this.fireStateTransitionEvent(this, "commitFailed", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState cancelSucceeded() {
        this.fireStateTransitionEvent(this, "cancelSucceeded", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState cancelFailed() {
        this.fireStateTransitionEvent(this, "cancelFailed", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState receivedPrepare() {
        this.fireStateTransitionEvent(this, "receivedPrepare", 0L);
        return this.getCurrentState();
    }

    public synchronized TargetServerState receivedCommit() {
        this.fireStateTransitionEvent(this, "receivedCommit", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState receivedCancel() {
        this.fireStateTransitionEvent(this, "receivedCancel", this.getId());
        return this.getCurrentState();
    }

    public synchronized TargetServerState receivedGetDeploymentsResponse(DeploymentServiceMessage deploymentServiceMessage) {
        this.fireStateTransitionEvent(this, "receivedGetDeltasResponse", 0L);
        return this.getCurrentState();
    }

    public synchronized TargetServerState abort() {
        this.fireStateTransitionEvent(this, "abort", this.getId());
        if (this.deploymentStatus != null) {
            this.deploymentStatus.setAborted();
        }
        if (this.deploymentStatus != null && !this.deploymentStatus.isCanceled()) {
            if (this.getId() != -1L) {
                this.requestsManager.addToPendingCancels(this.getId());
                if (this.isDebugEnabled()) {
                    this.debug("'abort' with id '" + this.getId() + "' added as pending cancel for future cancel request");
                }
            }
            this.cancelIfNecessary();
        }
        return this.getCurrentState();
    }

    public final void setDeploymentStatus(TargetRequestStatus targetRequestStatus) {
        this.deploymentStatus = targetRequestStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void transitionServerToAdminState() {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        try {
            try {
                DeploymentServiceLogger.transitioningServerToAdminState();
                serverRuntimeMBean.setRestartRequired(true);
                serverRuntimeMBean.suspend();
            }
            catch (ServerLifecycleException serverLifecycleException) {
                block11: {
                    if (this.isDebugEnabled()) {
                        this.debug("Attempt to 'suspend' server failed due to '" + serverLifecycleException + "' will attempt to 'force suspend' the server");
                    }
                    try {
                        serverRuntimeMBean.forceSuspend();
                    }
                    catch (Exception exception) {
                        if (!this.isDebugEnabled()) break block11;
                        this.debug("Attempt to 'force suspend' server failed due to '" + exception + "' ignoring the event");
                    }
                }
                Object var5_3 = null;
                if (this.deploymentStatus != null) {
                    TargetRequestImpl targetRequestImpl = this.deploymentStatus.getDeploymentRequest();
                    targetRequestImpl.resetSyncToAdminDeployments();
                    this.deploymentStatus.reset();
                }
            }
            Object var5_2 = null;
            if (this.deploymentStatus != null) {
                TargetRequestImpl targetRequestImpl = this.deploymentStatus.getDeploymentRequest();
                targetRequestImpl.resetSyncToAdminDeployments();
                this.deploymentStatus.reset();
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.deploymentStatus != null) {
                TargetRequestImpl targetRequestImpl = this.deploymentStatus.getDeploymentRequest();
                targetRequestImpl.resetSyncToAdminDeployments();
                this.deploymentStatus.reset();
            }
            throw throwable;
        }
    }

    protected final TargetServerState getCurrentState() {
        TargetServerState targetServerState = null;
        if (this.deploymentStatus != null) {
            targetServerState = this.deploymentStatus.getCurrentState();
        }
        return targetServerState;
    }

    protected final TargetRequestImpl getDeploymentRequest() {
        return this.requestsManager.getRequest(this.getId());
    }

    protected final DeploymentContextImpl getDeploymentContext() {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl == null) {
            return null;
        }
        return targetRequestImpl.getDeploymentContext();
    }

    protected final long getId() {
        long l = -1L;
        if (this.deploymentStatus != null) {
            l = this.deploymentStatus.getId();
        }
        return l;
    }

    protected final String getTargetStateString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "ReceivedPrepare";
                break;
            }
            case 1: {
                string = "AwaitingContextUpdateCompletion";
                break;
            }
            case 2: {
                string = "AwaitingPrepareCompletion";
                break;
            }
            case 3: {
                string = "AwaitingCommit";
                break;
            }
            case 4: {
                string = "AwaitingCommitCompletion";
                break;
            }
            case 5: {
                string = "AwaitingGetDeploymentsResponse";
                break;
            }
            case 6: {
                string = "AwaitingCancel";
                break;
            }
            case 7: {
                string = "AwaitingCancelCompletion";
            }
        }
        return string;
    }

    protected final void setExpectedNextState(int n) {
        TargetServerState targetServerState = this.deploymentStatus.getTargetServerState(n);
        if (this.isDebugEnabled()) {
            this.debug("Setting target state of deployment '" + this.getId() + "' to : " + this.getTargetStateString(n));
        }
        this.deploymentStatus.setCurrentState(targetServerState);
    }

    private final void dispatchCancelToDeploymentReceivers() {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        TimeAuditorManager.getInstance().startTransition(targetRequestImpl.getId(), 3);
        if (targetRequestImpl == null || this.deploymentStatus == null || this.deploymentStatus.isCancelDispatched()) {
            return;
        }
        Iterator iterator = this.deploymentStatus.getDeploymentsToBeCancelled();
        this.deploymentStatus.setCancelDispatched();
        if (iterator == null) {
            if (this.deploymentStatus.isCanceled()) {
                if (this.isDebugEnabled()) {
                    this.debug("No deployments to cancel for request '" + targetRequestImpl.getId() + "'");
                }
                this.sendCancelSucceeded();
            }
        } else {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                DeploymentReceiver deploymentReceiver = this.deploymentsManager.getDeploymentReceiver(string);
                DeploymentContextImpl deploymentContextImpl = targetRequestImpl.getDeploymentContext();
                TimeAuditorManager.getInstance().startDeploymentTransition(targetRequestImpl.getId(), string, 3);
                deploymentReceiver.cancel(deploymentContextImpl);
            }
        }
    }

    protected final void sendPrepareNak(Throwable throwable) {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl == null) {
            return;
        }
        try {
            this.sender.sendPrepareNakMsg(targetRequestImpl.getId(), throwable);
        }
        catch (RemoteException remoteException) {
            this.deploymentStatus.setAborted();
            this.cancelIfNecessary();
        }
    }

    protected final void sendCommitSucceeded() {
        long l = this.getId();
        TargetRequestImpl targetRequestImpl = this.requestsManager.getRequest(l);
        if (targetRequestImpl == null) {
            if (this.isDebugEnabled()) {
                this.debug("no request corresponding to id '" + l + "' - aborting " + "'commit success' send attempt");
            }
            return;
        }
        this.sender.sendCommitSucceededMsg(targetRequestImpl.getId());
        this.deploymentStatus.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void sendCommitFailed(Throwable throwable) throws RemoteException {
        long l = this.getId();
        TargetRequestImpl targetRequestImpl = this.requestsManager.getRequest(l);
        if (targetRequestImpl == null) {
            if (this.isDebugEnabled()) {
                this.debug("no request corresponding to id '" + l + "' - aborting " + "'commit failure' send attempt");
            }
            return;
        }
        try {
            this.sender.sendCommitFailedMsg(targetRequestImpl.getId(), throwable);
            Object var6_4 = null;
            this.deploymentStatus.reset();
        }
        catch (Throwable throwable2) {
            Object var6_5 = null;
            this.deploymentStatus.reset();
            throw throwable2;
        }
    }

    protected final void sendCancelSucceeded() {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl == null) {
            return;
        }
        this.sender.sendCancelSucceededMsg(targetRequestImpl.getId());
        this.deploymentStatus.reset();
    }

    protected final void sendCancelFailed(Throwable throwable) {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl == null) {
            return;
        }
        this.sender.sendCancelFailedMsg(targetRequestImpl.getId(), throwable);
        this.deploymentStatus.reset();
    }

    protected void setupDeploymentRequest(DomainVersion domainVersion, DomainVersion domainVersion2, TargetRequestImpl targetRequestImpl, Iterator iterator) throws Exception {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.getDeploymentReceiversInfo(iterator, domainVersion, domainVersion2, linkedHashMap);
        targetRequestImpl.setProposedDomainVersion(domainVersion2);
        targetRequestImpl.setPreparingFromVersion(domainVersion);
        targetRequestImpl.setDeploymentsMap(linkedHashMap);
    }

    protected void callDeploymentReceivers() throws Exception {
    }

    protected final void getDeploymentReceiversInfo(Iterator iterator, DomainVersion domainVersion, DomainVersion domainVersion2, Map map) throws Exception {
        while (iterator.hasNext()) {
            ArrayList<Deployment> arrayList;
            Deployment deployment = (Deployment)iterator.next();
            if (deployment == null) continue;
            String string = deployment.getCallbackHandlerId();
            if (this.deploymentsManager.getDeploymentReceiver(string) == null) {
                arrayList = DeployerRuntimeLogger.receiverNotFound((String)string);
                throw new Exception((String)((Object)arrayList));
            }
            this.deploymentStatus.addToDeploymentsAckList(string);
            arrayList = (List)map.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Deployment>();
                map.put(string, arrayList);
            }
            arrayList.add(deployment);
            domainVersion2.addOrUpdateDeploymentVersion(string, deployment.getProposedVersion());
        }
    }

    protected final void setupDeploymentContext() throws Exception {
        TargetRequestImpl targetRequestImpl = this.getDeploymentRequest();
        if (targetRequestImpl == null) {
            String string = DeployerRuntimeLogger.noDeploymentRequest();
            throw new Exception(string);
        }
        DeploymentContextImpl deploymentContextImpl = targetRequestImpl.getDeploymentContext();
        if (deploymentContextImpl == null) {
            deploymentContextImpl = new DeploymentContextImpl(targetRequestImpl);
            targetRequestImpl.setDeploymentContext(deploymentContextImpl);
        }
    }

    protected final void syncWithAdminServer(DomainVersion domainVersion) {
        if (this.isDebugEnabled()) {
            this.debug("Deployment '" + this.getId() + "' in '" + this.getCurrentState() + "' state needs to sync with admin to catch up from '" + domainVersion.toString());
        }
        TargetServerState targetServerState = this.deploymentStatus.getTargetServerState(5);
        this.deploymentStatus.setCurrentState(targetServerState);
        this.sender.sendGetDeploymentsMsg(domainVersion, this.getId());
    }

    protected boolean cancelIfNecessary() {
        boolean bl = false;
        if (this.deploymentStatus != null && this.deploymentStatus.isCanceledOrAborted()) {
            bl = true;
            this.doCancel();
        }
        return bl;
    }

    private void doCancel() {
        this.setExpectedNextState(7);
        this.dispatchCancelToDeploymentReceivers();
    }

    protected final void fireStateTransitionEvent(State state, String string, long l) {
        if (this.isDebugEnabled()) {
            this.debug("Target DeploymentService event : '" + state.toString() + "." + string + "()' for deployment id '" + l + "'");
        }
    }
}

