/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import weblogic.deploy.common.Debug;
import weblogic.deploy.service.DeploymentContext;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.DeploymentReceiverV2;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

final class DeploymentReceiverCallbackDeliverer
implements DeploymentReceiverV2 {
    private final DeploymentReceiver delegate;

    DeploymentReceiverCallbackDeliverer(DeploymentReceiver deploymentReceiver) {
        this.delegate = deploymentReceiver;
    }

    public final String getHandlerIdentity() {
        return this.delegate.getHandlerIdentity();
    }

    public final void updateDeploymentContext(DeploymentContext deploymentContext) {
        this.doUpdateDeploymentContextCallback(deploymentContext);
    }

    public final void prepare(DeploymentContext deploymentContext) {
        final DeploymentContext deploymentContext2 = deploymentContext;
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        if (this.delegate != null) {
            if (deploymentRequest.isConfigurationProviderCalledLast() && !this.delegate.getHandlerIdentity().equals("Configuration") || !deploymentRequest.isConfigurationProviderCalledLast() && this.delegate.getHandlerIdentity().equals("Configuration")) {
                this.doPrepareCallback(deploymentContext);
            } else {
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        DeploymentReceiverCallbackDeliverer.this.doPrepareCallback(deploymentContext2);
                    }
                });
            }
        }
    }

    public final void commit(DeploymentContext deploymentContext) {
        final DeploymentContext deploymentContext2 = deploymentContext;
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        if (this.delegate != null) {
            if (deploymentRequest.isConfigurationProviderCalledLast() && !this.delegate.getHandlerIdentity().equals("Configuration") || !deploymentRequest.isConfigurationProviderCalledLast() && this.delegate.getHandlerIdentity().equals("Configuration")) {
                this.doCommitCallback(deploymentContext);
            } else {
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        DeploymentReceiverCallbackDeliverer.this.doCommitCallback(deploymentContext2);
                    }
                });
            }
        }
    }

    public final void cancel(DeploymentContext deploymentContext) {
        final DeploymentContext deploymentContext2 = deploymentContext;
        if (this.delegate != null) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    DeploymentReceiverCallbackDeliverer.this.doCancelCallback(deploymentContext2);
                }
            });
        }
    }

    public final void prepareCompleted(DeploymentContext deploymentContext, String string) {
        final DeploymentContext deploymentContext2 = deploymentContext;
        final String string2 = string;
        if (this.delegate != null) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    DeploymentReceiverCallbackDeliverer.this.doPrepareCompletedCallback(deploymentContext2, string2);
                }
            });
        }
    }

    public final void commitCompleted(DeploymentContext deploymentContext, String string) {
        final DeploymentContext deploymentContext2 = deploymentContext;
        final String string2 = string;
        if (this.delegate != null) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    DeploymentReceiverCallbackDeliverer.this.doCommitCompletedCallback(deploymentContext2, string2);
                }
            });
        }
    }

    public final void commitSkipped(DeploymentContext deploymentContext) {
        final DeploymentContext deploymentContext2 = deploymentContext;
        if (this.delegate != null && this.delegate instanceof DeploymentReceiverV2) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    DeploymentReceiverCallbackDeliverer.this.doCommitSkippedCallback(deploymentContext2);
                }
            });
        }
    }

    private final void debug(String string) {
        Debug.serviceDebug(string);
    }

    private final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    private final void doUpdateDeploymentContextCallback(DeploymentContext deploymentContext) {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling 'updateDeploymentContext' on DeploymentReceiver for '" + this.getHandlerIdentity() + "' for id '" + deploymentContext.getDeploymentRequest().getId() + "'");
            }
            this.delegate.updateDeploymentContext(deploymentContext);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            DeploymentService.getDeploymentService().notifyContextUpdateFailed(deploymentContext.getDeploymentRequest().getId(), this.getHandlerIdentity(), new Exception(throwable));
        }
    }

    private final void doPrepareCallback(DeploymentContext deploymentContext) {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling 'prepare' on DeploymentReceiver for '" + this.getHandlerIdentity() + "' for id '" + deploymentContext.getDeploymentRequest().getId() + "'");
            }
            this.delegate.prepare(deploymentContext);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            DeploymentService.getDeploymentService().notifyPrepareFailure(deploymentContext.getDeploymentRequest().getId(), this.getHandlerIdentity(), new Exception(throwable));
        }
    }

    private final void doCommitCallback(DeploymentContext deploymentContext) {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling 'commit' on DeploymentReceiver for '" + this.getHandlerIdentity() + "' for id '" + deploymentContext.getDeploymentRequest().getId() + "'");
            }
            this.delegate.commit(deploymentContext);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            DeploymentService.getDeploymentService().notifyCommitFailure(deploymentContext.getDeploymentRequest().getId(), this.getHandlerIdentity(), new Exception(throwable));
        }
    }

    private final void doCancelCallback(DeploymentContext deploymentContext) {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling 'cancel' on DeploymentReceiver for '" + this.getHandlerIdentity() + "' for id '" + deploymentContext.getDeploymentRequest().getId() + "'");
            }
            this.delegate.cancel(deploymentContext);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            DeploymentService.getDeploymentService().notifyCancelFailure(deploymentContext.getDeploymentRequest().getId(), this.getHandlerIdentity(), new Exception(throwable));
        }
    }

    private final void doPrepareCompletedCallback(DeploymentContext deploymentContext, String string) {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling 'prepareCompleted' on DeploymentReceiver for '" + this.getHandlerIdentity() + "' for id '" + deploymentContext.getDeploymentRequest().getId() + "'");
            }
            this.delegate.prepareCompleted(deploymentContext, string);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            DeploymentService.getDeploymentService().notifyPrepareFailure(deploymentContext.getDeploymentRequest().getId(), this.getHandlerIdentity(), new Exception(throwable));
        }
    }

    private final void doCommitCompletedCallback(DeploymentContext deploymentContext, String string) {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling 'commitCompleted' on DeploymentReceiver for '" + this.getHandlerIdentity() + "' for id '" + deploymentContext.getDeploymentRequest().getId() + "'");
            }
            this.delegate.commitCompleted(deploymentContext, string);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            DeploymentService.getDeploymentService().notifyCommitFailure(deploymentContext.getDeploymentRequest().getId(), this.getHandlerIdentity(), new Exception(throwable));
        }
    }

    private final void doCommitSkippedCallback(DeploymentContext deploymentContext) {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling 'commitSkipped' on DeploymentReceiver for id '" + deploymentContext.getDeploymentRequest().getId() + "'");
            }
            DeploymentReceiverV2 deploymentReceiverV2 = (DeploymentReceiverV2)this.delegate;
            deploymentReceiverV2.commitSkipped(deploymentContext);
        }
        catch (Throwable throwable) {
            if (Debug.serviceLogger.isDebugEnabled()) {
                Debug.serviceLogger.debug(throwable.getMessage());
            }
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            DeploymentService.getDeploymentService().notifyCommitFailure(deploymentContext.getDeploymentRequest().getId(), this.getHandlerIdentity(), new Exception(throwable));
        }
    }
}

