/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentContext;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.DeploymentReceiversCoordinator;
import weblogic.deploy.service.RegistrationException;
import weblogic.deploy.service.StatusRelayer;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.ServiceRequest;
import weblogic.deploy.service.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.service.internal.targetserver.TargetDeploymentsManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestStatus;
import weblogic.deploy.service.internal.transport.CommonMessageSender;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.StackTraceUtils;

public final class TargetDeploymentService
extends AbstractServerService
implements DeploymentReceiversCoordinator,
StatusRelayer {
    private TargetRequestManager requestManager;
    private final TargetDeploymentsManager deploymentsManager = TargetDeploymentsManager.getInstance();

    private TargetDeploymentService() {
    }

    public static TargetDeploymentService getDeploymentService() {
        return Maker.SINGLETON;
    }

    private void debug(String string) {
        Debug.serviceDebug(string);
    }

    private boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    public DeploymentContext registerHandler(Version version2, DeploymentReceiver deploymentReceiver) throws RegistrationException {
        String string = deploymentReceiver.getHandlerIdentity();
        final String string2 = "registerHandler called from DeploymentReceiver for '" + string + "'  with version '" + version2.toString() + "'";
        if (this.isDebugEnabled()) {
            this.debug(string2);
        }
        this.deploymentsManager.registerCallbackHandler(version2, deploymentReceiver);
        TargetRequestImpl targetRequestImpl = new TargetRequestImpl();
        targetRequestImpl.setId(System.currentTimeMillis());
        final TargetRequestImpl targetRequestImpl2 = targetRequestImpl;
        final TargetRequestManager targetRequestManager = this.requestManager;
        final RegistrationResponse registrationResponse = new RegistrationResponse();
        final String string3 = string;
        this.requestManager.addRequest(new ServiceRequest(){

            public void run() {
                targetRequestManager.addToRequestTable(targetRequestImpl2);
                targetRequestImpl2.setDeploymentStatus(TargetRequestStatus.createTargetRequestStatus(targetRequestImpl2));
                targetRequestImpl2.getDeploymentStatus().setServerStarting();
                CommonMessageSender commonMessageSender = targetRequestImpl2.getMessageSender();
                DomainVersion domainVersion = TargetDeploymentService.this.deploymentsManager.getCurrentDomainVersion();
                try {
                    Object object;
                    DeploymentServiceMessage deploymentServiceMessage = commonMessageSender.sendBlockingGetDeploymentsMsg(domainVersion, string3);
                    DomainVersion domainVersion2 = deploymentServiceMessage.getToVersion();
                    Version version2 = domainVersion2.getDeploymentVersion(string3);
                    Iterator iterator = deploymentServiceMessage.getItems().iterator();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (iterator.hasNext()) {
                        object = (Deployment)iterator.next();
                        String string = object.getCallbackHandlerId();
                        if (TargetDeploymentService.this.isDebugEnabled()) {
                            TargetDeploymentService.this.debug(" TargetDeploymentService: deployment identity = " + string + " : callback handler id from request = " + string3);
                        }
                        if (!string.equals(string3)) continue;
                        if (TargetDeploymentService.this.isDebugEnabled()) {
                            TargetDeploymentService.this.debug(" TargetDeploymentService: adding deployment : " + object);
                        }
                        arrayList.add(object);
                    }
                    targetRequestImpl2.setDeployments(arrayList);
                    object = new DeploymentContextImpl(targetRequestImpl2);
                    targetRequestImpl2.setDeploymentContext((DeploymentContextImpl)object);
                    if (version2 != null) {
                        domainVersion.addOrUpdateDeploymentVersion(string3, version2);
                    }
                    registrationResponse.setResponseReceived((DeploymentContext)object);
                }
                catch (Throwable throwable) {
                    if (TargetDeploymentService.this.isDebugEnabled()) {
                        TargetDeploymentService.this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                    }
                    registrationResponse.setErrorEncountered(throwable);
                    TargetDeploymentService.this.resetRegistration(targetRequestImpl2.getDeploymentStatus());
                    return;
                }
            }

            public String toString() {
                return string2;
            }
        });
        registrationResponse.waitForResponse();
        if (registrationResponse.errorEncountered()) {
            this.resetRegistration(targetRequestImpl2.getDeploymentStatus());
            throw new RegistrationException(registrationResponse.getError().toString());
        }
        this.resetRegistration(targetRequestImpl2.getDeploymentStatus());
        return registrationResponse.getContext();
    }

    public void unregisterHandler(String string) {
        final String string2 = "registerHandler called from DeploymentReceiver for '" + string + "' ";
        final String string3 = string;
        if (this.isDebugEnabled()) {
            this.debug(string2);
        }
        this.requestManager.addRequest(new ServiceRequest(){

            public void run() {
                TargetDeploymentService.this.deploymentsManager.unregisterCallbackHandler(string3);
                TargetDeploymentService.this.requestManager.scheduleNextRequest();
            }

            public String toString() {
                return string2;
            }
        });
    }

    public synchronized void notifyContextUpdated(long l, String string) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'context updated' received from DeploymentReceiver for '" + string + "'  for id '" + l + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'context updated' received from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.receivedContextUpdateCompletedFrom(string);
            if (targetRequestStatus.receivedAllContextUpdates()) {
                Throwable throwable = targetRequestStatus.getSavedError();
                if (throwable == null) {
                    targetRequestStatus.getCurrentState().contextUpdated();
                } else {
                    targetRequestStatus.getCurrentState().contextUpdateFailed(throwable);
                }
            }
        }
    }

    public synchronized void notifyContextUpdateFailed(long l, String string, Throwable throwable) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'context update failed' received from DeploymentReceiver for '" + string + "'  for id '" + l + "' due to '" + throwable.toString() + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'context update failure' from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.receivedContextUpdateCompletedFrom(string, throwable);
            if (targetRequestStatus.receivedAllContextUpdates()) {
                targetRequestStatus.getCurrentState().contextUpdateFailed(throwable);
            }
        }
    }

    public synchronized void notifyPrepareSuccess(long l, String string) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'prepare ack' received from DeploymentReceiver for '" + string + "'  for id '" + l + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'prepare ack' from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.receivedPrepareAckFrom(string);
            if (targetRequestStatus.receivedAllPrepareCompletions()) {
                Throwable throwable = targetRequestStatus.getSavedError();
                if (throwable == null) {
                    targetRequestStatus.getCurrentState().prepareSucceeded();
                } else {
                    targetRequestStatus.getCurrentState().prepareFailed();
                }
            }
        }
    }

    public synchronized void notifyPrepareFailure(long l, String string, Throwable throwable) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'prepare nak' received from DeploymentReceiver for '" + string + "'  for id '" + l + "' due to '" + throwable.toString() + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'prepare nak' from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.receivedPrepareNakFrom(string, throwable);
            if (targetRequestStatus.receivedAllPrepareCompletions()) {
                targetRequestStatus.getCurrentState().prepareFailed();
            }
        }
    }

    public synchronized void notifyCommitSuccess(long l, String string) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'commit success' received from DeploymentReceiver for '" + string + "'  for id '" + l + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'commit success' from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.receivedCommitAckFrom(string);
            if (targetRequestStatus.receivedAllCommitResponses()) {
                Throwable throwable = targetRequestStatus.getCommitFailureError();
                if (throwable == null) {
                    targetRequestStatus.getCurrentState().commitSucceeded();
                } else {
                    targetRequestStatus.getCurrentState().commitFailed();
                }
            }
        }
    }

    public synchronized void notifyCommitFailure(long l, String string, Throwable throwable) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'commit failure' received from DeploymentReceiver for '" + string + "'  for id '" + l + "' due to '" + throwable.toString() + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'commit failure' from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.receivedCommitFailureFrom(string, throwable);
            if (targetRequestStatus.receivedAllCommitResponses()) {
                targetRequestStatus.getCurrentState().commitFailed();
            }
        }
    }

    public synchronized void notifyCancelSuccess(long l, String string) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'cancel success' received from DeploymentReceiver for '" + string + "'  for id '" + l + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'cancel success' from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.cancelSuccessFrom(string);
            if (targetRequestStatus.receivedAllCancelResponses()) {
                Throwable throwable = targetRequestStatus.getCancelFailureError();
                if (throwable == null) {
                    targetRequestStatus.getCurrentState().cancelSucceeded();
                } else {
                    targetRequestStatus.getCurrentState().cancelFailed();
                }
            }
        }
    }

    public synchronized void notifyCancelFailure(long l, String string, Throwable throwable) {
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("'cancel failure' received from DeploymentReceiver for '" + string + "'  for id '" + l + "' due to '" + throwable.toString() + "'");
        }
        if ((targetRequestImpl = this.requestManager.getRequest(l)) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'cancel failure' from DeploymentReceiver for '" + string + "'  for id '" + l + "' does not have a corresponding request - ignoring notification");
            }
        } else {
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            targetRequestStatus.cancelFailureFrom(string, throwable);
            if (targetRequestStatus.receivedAllCancelResponses()) {
                targetRequestStatus.getCurrentState().cancelFailed();
            }
        }
    }

    public void notifyStatusUpdate(long l, String string, Serializable serializable) {
        if (Debug.isServiceStatusDebugEnabled()) {
            Debug.serviceStatusDebug("'status update' received from DeploymentReceiver for '" + string + "'  for id '" + l + "'");
        }
        this.relayStatus(l, string, serializable);
    }

    public void relayStatus(String string, Serializable serializable) {
        if (Debug.isServiceStatusDebugEnabled()) {
            Debug.serviceStatusDebug("'relaying status ' '" + serializable + "' on '" + string + "'");
        }
        CommonMessageSender commonMessageSender = CommonMessageSender.getInstance();
        commonMessageSender.sendStatusMsg(string, serializable);
    }

    public void relayStatus(long l, String string, Serializable serializable) {
        if (Debug.isServiceStatusDebugEnabled()) {
            Debug.serviceStatusDebug("'relaying status ' '" + serializable + "' with id '" + l + "' on '" + string + "'");
        }
        CommonMessageSender commonMessageSender = CommonMessageSender.getInstance();
        commonMessageSender.sendStatusMsg(l, string, serializable);
    }

    public void start() throws ServiceFailureException {
        this.requestManager = TargetRequestManager.getInstance();
    }

    private void resetRegistration(TargetRequestStatus targetRequestStatus) {
        targetRequestStatus.reset();
        this.requestManager.scheduleNextRequest();
    }

    private final class RegistrationResponse {
        boolean responseReceived;
        DeploymentContext context;
        Throwable error;

        RegistrationResponse() {
        }

        synchronized void waitForResponse() {
            block3: {
                if (this.responseReceived) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!Debug.isServiceStatusDebugEnabled()) break block3;
                    Debug.serviceDebug("DeploymentService: registerHandler: Interrupted while waiting for response");
                }
            }
        }

        DeploymentContext getContext() {
            return this.context;
        }

        synchronized void setResponseReceived(DeploymentContext deploymentContext) {
            this.context = deploymentContext;
            this.responseReceived = true;
            this.notify();
        }

        synchronized void setErrorEncountered(Throwable throwable) {
            this.error = throwable;
            this.responseReceived = true;
            this.notify();
        }

        boolean errorEncountered() {
            return this.error != null;
        }

        Throwable getError() {
            return this.error;
        }
    }

    static class Maker {
        static final TargetDeploymentService SINGLETON = new TargetDeploymentService();

        Maker() {
        }
    }
}

