/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import java.util.Iterator;
import java.util.Map;
import weblogic.application.utils.XMLWriter;
import weblogic.deploy.internal.diagnostics.ImageProvider;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestStatus;

public class TargetDeploymentServiceImageProvider
extends ImageProvider {
    public void writeDiagnosticImage(XMLWriter xMLWriter) {
        TargetRequestManager targetRequestManager = TargetRequestManager.getInstance();
        Iterator iterator = targetRequestManager.getRequests().iterator();
        while (iterator.hasNext() && !this.timedOut) {
            TargetRequestImpl targetRequestImpl = (TargetRequestImpl)((Map.Entry)iterator.next()).getValue();
            TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
            xMLWriter.addElement("target-deployment-service-request");
            xMLWriter.addElement("id", "" + targetRequestStatus.getId());
            xMLWriter.addElement("state", targetRequestStatus.getCurrentState().toString());
            if (targetRequestStatus.isTimedOut()) {
                xMLWriter.addElement("timed-out", "true");
            }
            xMLWriter.closeElement();
            xMLWriter.flush();
        }
    }
}

