/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.RegistrationExistsException;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.targetserver.DeploymentReceiverCallbackDeliverer;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;

public final class TargetDeploymentsManager {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final Map registeredCallbackHandlers = new HashMap();
    private DomainVersion currentDomainVersion = new DomainVersion();
    private String localServerName;
    private ServerRuntimeMBean serverBean;

    private TargetDeploymentsManager() {
    }

    public static TargetDeploymentsManager getInstance() {
        return Maker.SINGLETON;
    }

    public final synchronized void registerCallbackHandler(Version version2, DeploymentReceiver deploymentReceiver) throws RegistrationExistsException {
        String string = deploymentReceiver.getHandlerIdentity();
        if (this.registeredCallbackHandlers.get(string) != null) {
            throw new RegistrationExistsException(DeploymentServiceLogger.logCallbackAlreadyRegisteredLoggable((String)string).getMessage());
        }
        this.registeredCallbackHandlers.put(string, new DeploymentReceiverCallbackDeliverer(deploymentReceiver));
        this.currentDomainVersion.addOrUpdateDeploymentVersion(string, version2);
        this.dumpActiveUpdatesList();
    }

    public final synchronized DeploymentReceiver getDeploymentReceiver(String string) {
        return (DeploymentReceiver)this.registeredCallbackHandlers.get(string);
    }

    public final synchronized void unregisterCallbackHandler(String string) {
        if (Debug.isServiceDebugEnabled()) {
            Debug.serviceDebug("Unregistering DeploymentReceiver callback  handler for " + string + " from the target " + "DeploymentService");
        }
        this.registeredCallbackHandlers.remove(string);
        this.currentDomainVersion.removeDeploymentVersion(string);
    }

    public final synchronized DomainVersion getCurrentDomainVersion() {
        return this.currentDomainVersion;
    }

    public final synchronized void setCurrentDomainVersion(DomainVersion domainVersion) {
        if (domainVersion == null) {
            if (Debug.isServiceDebugEnabled()) {
                String string = "Attempt to set the current domain version to 'null' ";
                Debug.serviceDebug(string + StackTraceUtils.throwable2StackTrace((Throwable)new Exception(string)));
            }
            return;
        }
        if (Debug.isServiceDebugEnabled()) {
            Debug.serviceDebug("Current domain version being set to: " + domainVersion.toString());
        }
        this.currentDomainVersion = domainVersion;
    }

    public final String getLocalServerName() {
        if (this.localServerName == null) {
            this.localServerName = ManagementService.getRuntimeAccess(kernelId).getServerName();
        }
        return this.localServerName;
    }

    private final ServerRuntimeMBean getServerBean() {
        if (this.serverBean == null) {
            this.serverBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        }
        return this.serverBean;
    }

    public final synchronized boolean restartPending() {
        return this.getServerBean().isRestartRequired();
    }

    private synchronized void dumpActiveUpdatesList() {
        if (this.registeredCallbackHandlers.size() > 0 && Debug.isServiceDebugEnabled()) {
            Debug.serviceDebug("Active DeploymentInfos on target : " + this.registeredCallbackHandlers);
        }
    }

    static class Maker {
        static final TargetDeploymentsManager SINGLETON = new TargetDeploymentsManager();

        Maker() {
        }
    }
}

