/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.RequestImpl;
import weblogic.deploy.service.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestStatus;
import weblogic.deploy.service.internal.transport.CommonMessageSender;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.utils.StackTraceUtils;

public final class TargetRequestImpl
extends RequestImpl {
    private static final TargetRequestManager requestManager = TargetRequestManager.getInstance();
    private static final CommonMessageSender messageSender = CommonMessageSender.getInstance();
    private TargetRequestStatus deploymentStatus;
    private DomainVersion domainVersion;
    private DomainVersion proposedDomainVersion;
    private DomainVersion preparingFromVersion;
    private DeploymentContextImpl context;
    private Map deploymentsMap;
    private DomainVersion syncToAdminVersion;
    private ArrayList syncToAdminDeployments;
    private Map syncToAdminDeploymentsMap;
    private boolean heartbeatRequest;
    private boolean isAborted = false;

    public void setId(long l) {
        this.identifier = l;
        if (TargetRequestImpl.isDebugEnabled()) {
            TargetRequestImpl.debug("setting id for request to '" + this.identifier + "' on target");
        }
    }

    public final void setDeployments(List list) {
        this.deployments = list;
    }

    public final Iterator getDeployments() {
        if (this.syncToAdminVersion != null) {
            return ((List)this.syncToAdminDeployments.clone()).iterator();
        }
        return super.getDeployments();
    }

    public final void setDeploymentsMap(Map map) {
        this.deploymentsMap = map;
    }

    public final Map getDeploymentsMap() {
        if (this.syncToAdminVersion != null) {
            return this.syncToAdminDeploymentsMap;
        }
        return this.deploymentsMap;
    }

    public final Iterator getDeployments(String string) {
        if (this.syncToAdminVersion != null) {
            ArrayList<Deployment> arrayList = new ArrayList<Deployment>();
            for (Deployment deployment : this.syncToAdminDeployments) {
                if (!string.equals(deployment.getCallbackHandlerId())) continue;
                arrayList.add(deployment);
            }
            return arrayList.iterator();
        }
        return super.getDeployments(string);
    }

    public final void setHeartbeatRequest() {
        this.heartbeatRequest = true;
    }

    public final boolean isHeartbeatRequest() {
        return this.heartbeatRequest;
    }

    public final void setDomainVersion(DomainVersion domainVersion) {
        this.domainVersion = domainVersion;
    }

    public final DomainVersion getDomainVersion() {
        return this.domainVersion;
    }

    public final void setProposedDomainVersion(DomainVersion domainVersion) {
        this.proposedDomainVersion = domainVersion;
    }

    public final DomainVersion getProposedDomainVersion() {
        return this.proposedDomainVersion;
    }

    public final void setPreparingFromVersion(DomainVersion domainVersion) {
        this.preparingFromVersion = domainVersion;
    }

    public final DomainVersion getPreparingFromVersion() {
        return this.preparingFromVersion;
    }

    public final DomainVersion getSyncToAdminVersion() {
        return this.syncToAdminVersion;
    }

    public final void setSyncToAdminMessage(DeploymentServiceMessage deploymentServiceMessage) {
        this.syncToAdminVersion = deploymentServiceMessage.getToVersion();
        this.syncToAdminDeployments = deploymentServiceMessage.getItems();
    }

    public final List getSyncToAdminDeployments() {
        return this.syncToAdminDeployments;
    }

    public final void setSyncToAdminDeploymentsMap(Map map) {
        this.syncToAdminDeploymentsMap = map;
    }

    public final Map getSyncToAdminDeploymentsMap() {
        return this.syncToAdminDeploymentsMap;
    }

    public final void resetSyncToAdminDeployments() {
        this.syncToAdminVersion = null;
        this.syncToAdminDeployments = null;
        this.syncToAdminDeploymentsMap = null;
    }

    public final void setDeploymentStatus(TargetRequestStatus targetRequestStatus) {
        this.deploymentStatus = targetRequestStatus;
    }

    public final TargetRequestStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public final CommonMessageSender getMessageSender() {
        return messageSender;
    }

    public final void setDeploymentContext(DeploymentContextImpl deploymentContextImpl) {
        this.context = deploymentContextImpl;
    }

    public final DeploymentContextImpl getDeploymentContext() {
        return this.context;
    }

    public void run() {
        block6: {
            requestManager.addToRequestTable(this);
            if (TargetRequestImpl.isDebugEnabled()) {
                TargetRequestImpl.debug("DeploymentService call: Starting target side deploy for '" + this.getId() + "'");
            }
            this.deploymentStatus = TargetRequestStatus.createTargetRequestStatus(this);
            this.startTimeoutMonitor("TargetRequest for id '" + this.identifier + "'");
            try {
                this.deploymentStatus.getCurrentState().receivedPrepare();
            }
            catch (Throwable throwable) {
                if (TargetRequestImpl.isDebugEnabled()) {
                    Debug.serviceDebug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                }
                try {
                    messageSender.sendPrepareNakMsg(this.getId(), throwable);
                }
                catch (RemoteException remoteException) {
                    this.abort();
                }
                if (this.isAborted()) break block6;
                this.deploymentStatus.reset();
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TargetRequestImpl) {
            return super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TargetDeploymentRequest id '" + this.getId() + "'");
        return stringBuffer.toString();
    }

    public void requestTimedout() {
        if (this.deploymentStatus == null) {
            return;
        }
        if (TargetRequestImpl.isDebugEnabled()) {
            TargetRequestImpl.debug(this.identifier + " timed out on target server");
        }
        this.deploymentStatus.setTimedOut();
        this.abort();
    }

    public void abort() {
        this.isAborted = true;
        this.deploymentStatus.getCurrentState().abort();
    }

    public boolean isAborted() {
        return this.isAborted;
    }
}

