/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.service.internal.RequestManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;

public class TargetRequestManager
extends RequestManager {
    private final Map requestsMap = new HashMap();
    private final Set pendingCancels = new HashSet();

    private TargetRequestManager() {
        super("TargetRequestManager");
    }

    public static TargetRequestManager getInstance() {
        return Maker.SINGLETON;
    }

    public final synchronized void addToRequestTable(TargetRequestImpl targetRequestImpl) {
        if (this.isDebugEnabled()) {
            this.debug("adding request '" + targetRequestImpl.getId() + "' to target request table");
        }
        this.requestsMap.put(new Long(targetRequestImpl.getId()), targetRequestImpl);
    }

    public final synchronized Set getRequests() {
        return this.requestsMap.entrySet();
    }

    public final synchronized TargetRequestImpl getRequest(long l) {
        return (TargetRequestImpl)this.requestsMap.get(new Long(l));
    }

    public final synchronized void removeRequest(long l) {
        if (this.isDebugEnabled()) {
            this.debug("removing request '" + l + "' from target request table");
        }
        this.requestsMap.remove(new Long(l));
    }

    public final synchronized void addToPendingCancels(long l) {
        if (this.isDebugEnabled()) {
            this.debug("adding request '" + l + "' to target pending cancel set");
        }
        this.pendingCancels.add(new Long(l));
    }

    public final synchronized void removePendingCancelFor(long l) {
        if (this.isDebugEnabled()) {
            this.debug("removing request '" + l + "' from target " + "pending cancel set");
        }
        this.pendingCancels.remove(new Long(l));
    }

    public final synchronized boolean hasAPendingCancelFor(long l) {
        return this.pendingCancels.contains(new Long(l));
    }

    public final synchronized boolean handlingRequests() {
        return this.requestsMap.size() > 0;
    }

    static class Maker {
        static final TargetRequestManager SINGLETON = new TargetRequestManager();

        Maker() {
        }
    }
}

