/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.DeploymentReceiverV2;
import weblogic.deploy.service.internal.statemachines.StateMachinesManager;
import weblogic.deploy.service.internal.statemachines.targetserver.TargetServerState;
import weblogic.deploy.service.internal.targetserver.TargetDeploymentsManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestManager;
import weblogic.deploy.service.internal.targetserver.TimeAuditorManager;

public final class TargetRequestStatus {
    private static final TargetDeploymentsManager deploymentsManager = TargetDeploymentsManager.getInstance();
    private static final TargetRequestManager requestManager = TargetRequestManager.getInstance();
    private TargetRequestImpl request;
    private long id = 0L;
    private TargetServerState currentState;
    private ArrayList targetServerStateList;
    private HashSet deploymentsToUpdateContext = new HashSet();
    private HashSet deploymentsToAckPrepare = new HashSet();
    private HashSet deploymentsToAckCommit = new HashSet();
    private HashSet deploymentsToAckCancel = new HashSet();
    private HashSet deploymentsToNotifySkip = new HashSet();
    private boolean isCanceled;
    private boolean isAborted;
    private boolean isTimedOut;
    private boolean cancelDispatched;
    private boolean serverStarting;
    private boolean restartPending;
    private Throwable savedException = null;
    Throwable commitFailureError = null;
    private Throwable cancelFailureError = null;

    private TargetRequestStatus(TargetRequestImpl targetRequestImpl) {
        this.request = targetRequestImpl;
        this.id = targetRequestImpl.getId();
    }

    private final void debug(String string) {
        Debug.serviceDebug(string);
    }

    private final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    public static TargetRequestStatus createTargetRequestStatus(TargetRequestImpl targetRequestImpl) {
        TargetRequestStatus targetRequestStatus = new TargetRequestStatus(targetRequestImpl);
        try {
            targetRequestStatus.setTargetServerStates(StateMachinesManager.createTargetServerStates(targetRequestStatus));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        targetRequestStatus.setCurrentState(targetRequestStatus.getTargetServerState(0));
        return targetRequestStatus;
    }

    private void setTargetServerStates(ArrayList arrayList) {
        this.targetServerStateList = arrayList;
    }

    public final long getId() {
        return this.id;
    }

    public final void setServerStarting() {
        this.serverStarting = true;
    }

    public final boolean isServerStarting() {
        return this.serverStarting;
    }

    public final synchronized void setCurrentState(TargetServerState targetServerState) {
        this.currentState = targetServerState;
    }

    public final synchronized TargetServerState getCurrentState() {
        return this.currentState;
    }

    public final synchronized TargetRequestImpl getDeploymentRequest() {
        return this.request;
    }

    public final TargetServerState getTargetServerState(int n) {
        TargetServerState targetServerState = (TargetServerState)this.targetServerStateList.get(n);
        return targetServerState;
    }

    public final boolean isTimedOut() {
        return this.isTimedOut;
    }

    public final void setTimedOut() {
        this.isTimedOut = true;
    }

    public final synchronized void addToDeploymentsAckList(String string) {
        if (deploymentsManager.getDeploymentReceiver(string) == null) {
            if (this.isDebugEnabled()) {
                this.debug("TargetRequestStatus: '" + string + "' not added to ack list - no DeploymentReceiver registered");
            }
            return;
        }
        this.deploymentsToUpdateContext.add(string);
        this.deploymentsToAckPrepare.add(string);
        this.deploymentsToAckCancel.add(string);
        this.deploymentsToAckCommit.add(string);
        this.deploymentsToNotifySkip.add(string);
        if (this.isDebugEnabled()) {
            this.debug("'" + string + "' added to DeploymentReceiver " + "ack for '" + this.id + "'");
        }
    }

    public final synchronized void receivedContextUpdateCompletedFrom(String string) {
        this.receivedContextUpdateCompletedFrom(string, null);
    }

    public final synchronized void receivedContextUpdateCompletedFrom(String string, Throwable throwable) {
        this.deploymentsToUpdateContext.remove(string);
        if (throwable != null) {
            this.savedException = throwable;
        }
        TimeAuditorManager.getInstance().endDeploymentTransition(this.request.getId(), string, 0);
    }

    public final synchronized boolean receivedAllContextUpdates() {
        boolean bl;
        boolean bl2 = bl = this.deploymentsToUpdateContext == null || this.deploymentsToUpdateContext.size() == 0;
        if (bl) {
            TimeAuditorManager.getInstance().endTransition(this.request.getId(), 0);
        }
        return bl;
    }

    public final synchronized void receivedPrepareAckFrom(String string) {
        this.deploymentsToAckPrepare.remove(string);
        Iterator iterator = this.deploymentsToAckPrepare.iterator();
        while (iterator.hasNext()) {
            DeploymentReceiver deploymentReceiver = deploymentsManager.getDeploymentReceiver((String)iterator.next());
            deploymentReceiver.prepareCompleted(this.request.getDeploymentContext(), string);
        }
        TimeAuditorManager.getInstance().endDeploymentTransition(this.request.getId(), string, 1);
    }

    public final synchronized void receivedPrepareNakFrom(String string, Throwable throwable) {
        this.deploymentsToAckPrepare.remove(string);
        this.deploymentsToAckCommit.remove(string);
        if (this.savedException == null) {
            this.savedException = throwable;
        }
        TimeAuditorManager.getInstance().endDeploymentTransition(this.request.getId(), string, 1);
    }

    public final synchronized Throwable getSavedError() {
        return this.savedException;
    }

    public final synchronized boolean receivedAllPrepareCompletions() {
        boolean bl;
        boolean bl2 = bl = this.deploymentsToAckPrepare == null || this.deploymentsToAckPrepare.size() == 0;
        if (bl) {
            TimeAuditorManager.getInstance().endTransition(this.request.getId(), 1);
        }
        return bl;
    }

    public final synchronized void receivedCommitAckFrom(String string) {
        if (this.isCanceled()) {
            return;
        }
        this.deploymentsToAckCommit.remove(string);
        Iterator iterator = this.deploymentsToAckCommit.iterator();
        while (iterator.hasNext()) {
            DeploymentReceiver deploymentReceiver = deploymentsManager.getDeploymentReceiver((String)iterator.next());
            deploymentReceiver.commitCompleted(this.request.getDeploymentContext(), string);
        }
        TimeAuditorManager.getInstance().endDeploymentTransition(this.request.getId(), string, 2);
    }

    public final synchronized void receivedCommitFailureFrom(String string, Throwable throwable) {
        this.deploymentsToAckCommit.remove(string);
        if (this.commitFailureError == null) {
            this.commitFailureError = throwable;
        }
        TimeAuditorManager.getInstance().endDeploymentTransition(this.request.getId(), string, 2);
    }

    public final synchronized Throwable getCommitFailureError() {
        return this.commitFailureError;
    }

    public final synchronized boolean receivedAllCommitResponses() {
        boolean bl;
        boolean bl2 = bl = this.deploymentsToAckCommit == null || this.deploymentsToAckCommit.size() == 0;
        if (bl) {
            TimeAuditorManager.getInstance().endTransition(this.request.getId(), 2);
        }
        return bl;
    }

    public final synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public final synchronized void setCanceled() {
        if (this.isCanceled || this.request == null) {
            return;
        }
        this.isCanceled = true;
        if (this.isDebugEnabled()) {
            this.debug("request '" + this.request.getId() + "' set to 'canceled' on target");
        }
    }

    public final synchronized boolean isAborted() {
        return this.isAborted;
    }

    public final synchronized void setAborted() {
        if (this.isAborted || this.request == null) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("request '" + this.request.getId() + "' set to 'aborted' on target");
        }
        this.isAborted = true;
    }

    public final synchronized boolean isCanceledOrAborted() {
        return this.isCanceled || this.isAborted;
    }

    public final synchronized boolean isCancelDispatched() {
        return this.cancelDispatched;
    }

    public final synchronized void setCancelDispatched() {
        this.cancelDispatched = true;
    }

    public final synchronized void cancelSuccessFrom(String string) {
        this.deploymentsToAckCancel.remove(string);
        TimeAuditorManager.getInstance().endDeploymentTransition(this.request.getId(), string, 3);
    }

    public final synchronized void cancelFailureFrom(String string, Throwable throwable) {
        this.deploymentsToAckCancel.remove(string);
        if (this.cancelFailureError == null) {
            this.cancelFailureError = throwable;
        }
        TimeAuditorManager.getInstance().endDeploymentTransition(this.request.getId(), string, 3);
    }

    public final Throwable getCancelFailureError() {
        return this.cancelFailureError;
    }

    public final synchronized Iterator getDeploymentsToBeCancelled() {
        if (this.deploymentsToAckCancel != null) {
            HashSet hashSet = (HashSet)this.deploymentsToAckCancel.clone();
            return hashSet.iterator();
        }
        return null;
    }

    public final synchronized boolean receivedAllCancelResponses() {
        boolean bl = this.deploymentsToAckCancel.isEmpty();
        if (bl) {
            TimeAuditorManager.getInstance().endTransition(this.request.getId(), 2);
        }
        return bl;
    }

    public final synchronized void scheduleNextRequest() {
        if (this.request != null && this.request.getSyncToAdminDeployments() == null) {
            requestManager.scheduleNextRequest();
        }
    }

    public final void setRestartPending() {
        this.restartPending = true;
    }

    public final boolean isRestartPending() {
        return this.restartPending;
    }

    public final synchronized void commitSkipped() {
        Iterator iterator = this.deploymentsToNotifySkip.iterator();
        while (iterator.hasNext()) {
            DeploymentReceiver deploymentReceiver = deploymentsManager.getDeploymentReceiver((String)iterator.next());
            if (!(deploymentReceiver instanceof DeploymentReceiverV2)) continue;
            ((DeploymentReceiverV2)deploymentReceiver).commitSkipped(this.request.getDeploymentContext());
        }
    }

    public final synchronized void reset() {
        if (this.request == null) {
            return;
        }
        long l = this.request.getId();
        if (this.isDebugEnabled()) {
            this.debug("resetting id '" + l + "' heartbeat?:" + this.request.isHeartbeatRequest() + " on target");
        }
        TimeAuditorManager.getInstance().printAuditor(l, System.out);
        TimeAuditorManager.getInstance().endAuditor(l);
        if (this.request.getSyncToAdminDeployments() != null) {
            this.request.resetSyncToAdminDeployments();
            if (!this.request.isHeartbeatRequest()) {
                if (this.isDebugEnabled()) {
                    this.debug("handling pending request '" + this.request.getId() + " on target");
                }
                TargetServerState targetServerState = this.getTargetServerState(0);
                this.setCurrentState(targetServerState);
                this.getCurrentState().receivedPrepare();
                return;
            }
        }
        this.request.cancelTimeoutMonitor();
        this.deploymentsToUpdateContext.clear();
        this.deploymentsToUpdateContext = null;
        this.deploymentsToAckPrepare.clear();
        this.deploymentsToAckPrepare = null;
        this.deploymentsToAckCommit.clear();
        this.deploymentsToAckCommit = null;
        this.deploymentsToAckCancel.clear();
        this.deploymentsToAckCancel = null;
        this.deploymentsToNotifySkip.clear();
        this.deploymentsToNotifySkip = null;
        this.savedException = null;
        this.cancelFailureError = null;
        this.targetServerStateList.clear();
        this.targetServerStateList = null;
        requestManager.removeRequest(this.id);
        this.request = null;
        requestManager.scheduleNextRequest();
    }
}

