/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.targetserver;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TimeAuditorManager {
    private static final boolean AUDITOR_ENABLED = Boolean.getBoolean("weblogic.deployment.TimeAuditorEnabled");
    public static final int DEPLOYMENT_CONTEXT = 0;
    public static final int PREPARE = 1;
    public static final int COMMIT = 2;
    public static final int CANCEL = 3;
    private Map auditors = Collections.synchronizedMap(new HashMap());

    public static TimeAuditorManager getInstance() {
        return Maker.SINGLETON;
    }

    public void startAuditor(long l) {
        if (AUDITOR_ENABLED) {
            this.auditors.put(l, new RequestAuditor(l));
        }
    }

    public void printAuditor(long l, OutputStream outputStream) {
        this.printAuditor(l, new PrintWriter(outputStream, true));
    }

    public void printAuditor(long l, PrintStream printStream) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            printStream.println("<" + new Date() + "> " + requestAuditor);
        }
    }

    public void printAuditor(long l, PrintWriter printWriter) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            printWriter.println("<" + new Date() + "> " + requestAuditor);
            printWriter.flush();
        }
    }

    public String getAuditorAsString(long l) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            return requestAuditor.toString();
        }
        return null;
    }

    public Object endAuditor(long l) {
        return this.auditors.remove(l);
    }

    public void startTransition(long l, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.startTransition(n);
        }
    }

    public void endTransition(long l, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.endTransition(n);
        }
    }

    public void startDeploymentTransition(long l, String string, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.startDeploymentTransition(string, n);
        }
    }

    public void endDeploymentTransition(long l, String string, int n) {
        RequestAuditor requestAuditor = (RequestAuditor)this.auditors.get(l);
        if (requestAuditor != null) {
            requestAuditor.endDeploymentTransition(string, n);
        }
    }

    private static String transitionToString(int n) {
        switch (n) {
            case 0: {
                return "DEPLOYMENT_CONTEXT";
            }
            case 1: {
                return "PREPARE";
            }
            case 2: {
                return "COMMIT";
            }
            case 3: {
                return "CANCEL";
            }
        }
        throw new IllegalArgumentException("Transition type '" + n + "' is invalid");
    }

    private class RequestAuditor {
        private final List inspectors;
        private final long requestId;

        RequestAuditor(long l) {
            this.inspectors = Arrays.asList(new TargetTransitionInspector(0), new TargetTransitionInspector(1), new TargetTransitionInspector(2), new TargetTransitionInspector(3));
            this.requestId = l;
        }

        void startTransition(int n) {
            TargetTransitionInspector targetTransitionInspector = this.getInspector(n);
            targetTransitionInspector.setBeginTime(System.currentTimeMillis());
        }

        void endTransition(int n) {
            TargetTransitionInspector targetTransitionInspector = this.getInspector(n);
            targetTransitionInspector.setEndTime(System.currentTimeMillis());
        }

        void startDeploymentTransition(String string, int n) {
            TargetTransitionInspector targetTransitionInspector = this.getInspector(n);
            targetTransitionInspector.startDeploymentTransition(string);
        }

        void endDeploymentTransition(String string, int n) {
            TargetTransitionInspector targetTransitionInspector = this.getInspector(n);
            targetTransitionInspector.endDeploymentTransition(string);
        }

        private TargetTransitionInspector getInspector(int n) {
            for (TargetTransitionInspector targetTransitionInspector : this.inspectors) {
                if (targetTransitionInspector.getTransitionType() != n) continue;
                return targetTransitionInspector;
            }
            throw new IllegalArgumentException("Transition type '" + n + "' is invalid");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Target - Time calculations for requestId '").append(this.requestId);
            stringBuffer.append("' are [").append("\n");
            Iterator iterator = this.inspectors.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t").append(iterator.next()).append("\n");
            }
            stringBuffer.append("]").append("\n");
            return stringBuffer.toString();
        }
    }

    private class TargetTransitionInspector
    extends TransitionInspector {
        private Map deploymentTransitions;

        TargetTransitionInspector(int n) {
            super(n);
            this.deploymentTransitions = new HashMap();
        }

        void startDeploymentTransition(String string) {
            TransitionInspector transitionInspector = (TransitionInspector)this.deploymentTransitions.get(string);
            if (transitionInspector == null) {
                transitionInspector = new DeploymentTransitionInspector(string, this.getTransitionType());
                this.deploymentTransitions.put(string, transitionInspector);
            }
            transitionInspector.setBeginTime(System.currentTimeMillis());
        }

        void endDeploymentTransition(String string) {
            TransitionInspector transitionInspector = (TransitionInspector)this.deploymentTransitions.get(string);
            if (transitionInspector != null) {
                transitionInspector.setEndTime(System.currentTimeMillis());
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append(" - {").append("\n");
            Iterator iterator = this.deploymentTransitions.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
            stringBuffer.append("\t").append("}");
            return stringBuffer.toString();
        }
    }

    private class DeploymentTransitionInspector
    extends TransitionInspector {
        private final String deploymentType;

        DeploymentTransitionInspector(String string, int n) {
            super(n);
            this.deploymentType = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\t\t").append(this.deploymentType).append("=");
            stringBuffer.append(this.timeSpent()).append("\n");
            return stringBuffer.toString();
        }
    }

    private class TransitionInspector {
        private final int transition;
        private long beginTime = 0L;
        private long endTime = 0L;

        TransitionInspector(int n) {
            this.transition = n;
        }

        int getTransitionType() {
            return this.transition;
        }

        long getBeginTime() {
            return this.beginTime;
        }

        long getEndTime() {
            return this.endTime;
        }

        void setBeginTime(long l) {
            this.beginTime = l;
        }

        void setEndTime(long l) {
            this.endTime = l;
        }

        long timeSpent() {
            return this.endTime - this.beginTime;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Transition '").append(TimeAuditorManager.transitionToString(this.transition));
            stringBuffer.append("'").append(" took : ").append(this.timeSpent());
            return stringBuffer.toString();
        }
    }

    private static class Maker {
        private static TimeAuditorManager SINGLETON = new TimeAuditorManager();

        private Maker() {
        }
    }
}

