/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.transport;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.ServiceRequest;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentsManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.StatusDeliverer;
import weblogic.deploy.service.internal.targetserver.TargetDeploymentsManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestImpl;
import weblogic.deploy.service.internal.targetserver.TargetRequestManager;
import weblogic.deploy.service.internal.targetserver.TargetRequestStatus;
import weblogic.deploy.service.internal.transport.AdminServerMessageReceiver;
import weblogic.deploy.service.internal.transport.CommonMessageSender;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.deploy.service.internal.transport.MessageDispatcher;
import weblogic.deploy.service.internal.transport.MessageReceiver;
import weblogic.deploy.service.internal.transport.TargetServerMessageReceiver;
import weblogic.deploy.service.internal.transport.http.HTTPMessageReceiver;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public final class CommonMessageReceiver
implements AdminServerMessageReceiver,
TargetServerMessageReceiver,
MessageDispatcher {
    private final byte deploymentServiceVersion;
    private final MessageReceiver delegate;
    private final AdminRequestManager adminRequestManager;
    private final AdminDeploymentsManager adminDeploymentsManager;
    private final TargetRequestManager targetRequestManager;
    private final TargetDeploymentsManager targetDeploymentsManager;
    private final StatusDeliverer statusDeliverer;
    private CommonMessageSender messageSender;
    private boolean heartbeatServiceInitialized = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private CommonMessageReceiver() {
        DeploymentService deploymentService = DeploymentService.getDeploymentService();
        this.deploymentServiceVersion = deploymentService.getVersionByte();
        this.delegate = HTTPMessageReceiver.getMessageReceiver();
        if (ManagementService.getPropertyService(kernelId).isAdminServer()) {
            this.adminRequestManager = AdminRequestManager.getInstance();
            this.adminDeploymentsManager = AdminDeploymentsManager.getInstance();
            this.statusDeliverer = StatusDeliverer.getInstance();
        } else {
            this.adminRequestManager = null;
            this.adminDeploymentsManager = null;
            this.statusDeliverer = null;
        }
        this.targetRequestManager = TargetRequestManager.getInstance();
        this.targetDeploymentsManager = TargetDeploymentsManager.getInstance();
        this.delegate.setDispatcher(this);
    }

    public static CommonMessageReceiver getInstance() {
        return Maker.SINGLETON;
    }

    private synchronized CommonMessageSender getMessageSender() {
        if (this.messageSender == null) {
            this.messageSender = CommonMessageSender.getInstance();
        }
        return this.messageSender;
    }

    private final void debug(String string) {
        Debug.serviceTransportDebug(string);
    }

    private final boolean isDebugEnabled() {
        return Debug.isServiceTransportDebugEnabled();
    }

    private final void handlePendingCancel(long l) {
        if (this.isDebugEnabled()) {
            this.debug("handling pending cancel for request with id '" + l + "'");
        }
        this.targetRequestManager.removePendingCancelFor(l);
        this.getMessageSender().sendCancelSucceededMsg(l);
    }

    public void setHeartbeatServiceInitialized() {
        this.heartbeatServiceInitialized = true;
    }

    public final void receivePrepareAckMsg(DeploymentServiceMessage deploymentServiceMessage) {
        AdminRequestImpl adminRequestImpl;
        long l = deploymentServiceMessage.getDeploymentId();
        String string = deploymentServiceMessage.getMessageSrc();
        boolean bl = (Boolean)deploymentServiceMessage.getItems().get(0);
        if (this.isDebugEnabled()) {
            this.debug("received 'prepare succeeded' from '" + string + "' for id '" + l + "'");
        }
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        if ((adminRequestImpl = this.adminRequestManager.getRequest(l)) != null) {
            adminRequestImpl.receivedPrepareSucceeded(l, string, bl);
        } else if (this.isDebugEnabled()) {
            this.debug("'prepare succeeded' received for id '" + l + "' from '" + string + "' that has no corresponding request");
        }
    }

    public final void receivePrepareNakMsg(DeploymentServiceMessage deploymentServiceMessage) {
        AdminRequestImpl adminRequestImpl;
        long l = deploymentServiceMessage.getDeploymentId();
        String string = deploymentServiceMessage.getMessageSrc();
        Throwable throwable = (Throwable)deploymentServiceMessage.getItems().get(0);
        if (this.isDebugEnabled()) {
            this.debug("received 'prepare failed' from '" + string + "' for id '" + l + "' with reason '" + throwable.getMessage() + "'");
        }
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        if ((adminRequestImpl = this.adminRequestManager.getRequest(l)) != null) {
            adminRequestImpl.receivedPrepareFailed(string, throwable);
        } else if (this.isDebugEnabled()) {
            this.debug("'prepare failed' received for id " + l + "' from '" + string + "' that has no corresponding request - it may have been cancelled");
        }
    }

    public final void receiveCommitSucceededMsg(DeploymentServiceMessage deploymentServiceMessage) {
        AdminRequestImpl adminRequestImpl;
        long l = deploymentServiceMessage.getDeploymentId();
        String string = deploymentServiceMessage.getMessageSrc();
        if (this.isDebugEnabled()) {
            this.debug("received 'commit succeeded' from '" + string + "' for id '" + l + "'");
        }
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        if ((adminRequestImpl = this.adminRequestManager.getRequest(l)) != null) {
            adminRequestImpl.receivedCommitSucceeded(string);
        } else if (this.isDebugEnabled()) {
            this.debug("'commit success' from '" + string + "' for id '" + l + "' has no corresponding request - it may have been " + "cancelled");
        }
    }

    public final void receiveCommitFailedMsg(DeploymentServiceMessage deploymentServiceMessage) {
        AdminRequestImpl adminRequestImpl;
        long l = deploymentServiceMessage.getDeploymentId();
        String string = deploymentServiceMessage.getMessageSrc();
        Throwable throwable = (Throwable)deploymentServiceMessage.getItems().get(0);
        if (this.isDebugEnabled()) {
            this.debug("received 'commit failed' from '" + string + "' for id '" + l + "' with reason '" + throwable.getMessage() + "'");
        }
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        if ((adminRequestImpl = this.adminRequestManager.getRequest(l)) != null) {
            adminRequestImpl.receivedCommitFailed(string, throwable);
        } else if (this.isDebugEnabled()) {
            this.debug("'commit failed' from '" + string + "' for id '" + l + "' has no corresponding request - it may have been " + "cancelled");
        }
    }

    public final void receiveCancelSucceededMsg(DeploymentServiceMessage deploymentServiceMessage) {
        AdminRequestImpl adminRequestImpl;
        long l = deploymentServiceMessage.getDeploymentId();
        String string = deploymentServiceMessage.getMessageSrc();
        if (this.isDebugEnabled()) {
            this.debug("received 'cancel succeeded' from '" + string + "' for id '" + l + "'");
        }
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        if ((adminRequestImpl = this.adminRequestManager.getRequest(l)) != null) {
            adminRequestImpl.receivedCancelSucceeded(string);
        } else if (this.isDebugEnabled()) {
            this.debug("'cancel succeeded' from '" + string + "' for id '" + l + "' has no corresponding request - it may have been cancelled ");
        }
    }

    public final void receiveCancelFailedMsg(DeploymentServiceMessage deploymentServiceMessage) {
        AdminRequestImpl adminRequestImpl;
        long l = deploymentServiceMessage.getDeploymentId();
        String string = deploymentServiceMessage.getMessageSrc();
        Throwable throwable = (Throwable)deploymentServiceMessage.getItems().get(0);
        if (this.isDebugEnabled()) {
            this.debug("received 'cancel failed' from '" + string + "' for id '" + l + "' with reason '" + throwable.getMessage() + "'");
        }
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        if ((adminRequestImpl = this.adminRequestManager.getRequest(l)) != null) {
            adminRequestImpl.receivedCancelFailed(string, throwable);
        } else if (this.isDebugEnabled()) {
            this.debug("'cancel failed' from '" + string + "' for id '" + l + "' has no corresponding request - it may be " + "already complete or have been cancelled");
        }
    }

    public final void receiveGetDeploymentsMsg(DeploymentServiceMessage deploymentServiceMessage) {
        if (this.isDebugEnabled()) {
            this.debug("received 'get deployments' from '" + deploymentServiceMessage.getMessageSrc() + "' to sync from version '" + deploymentServiceMessage.getFromVersion() + "' for id '" + deploymentServiceMessage.getDeploymentId() + "'");
        }
        String string = deploymentServiceMessage.getMessageSrc();
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        String string2 = deploymentServiceMessage.getMessageSrc();
        this.adminRequestManager.getDeployments(deploymentServiceMessage.getFromVersion(), string2, deploymentServiceMessage.getDeploymentId(), false, null, this.getMessageSender().getHandlers(string2));
    }

    public final DeploymentServiceMessage receiveBlockingGetDeploymentsMsg(DeploymentServiceMessage deploymentServiceMessage) {
        if (this.isDebugEnabled()) {
            this.debug("received 'blocking get deployments' from '" + deploymentServiceMessage.getMessageSrc() + "'");
        }
        String string = deploymentServiceMessage.getMessageSrc();
        if (this.adminRequestManager == null) {
            this.rejectAdminServerOperation(string);
        }
        DomainVersion domainVersion = deploymentServiceMessage.getFromVersion();
        Set set = domainVersion.getDeploymentsVersionMap().keySet();
        this.getMessageSender().putHandlers(string, set);
        ArrayList arrayList = this.adminRequestManager.getDeployments(domainVersion, string, deploymentServiceMessage.getDeploymentId(), true, deploymentServiceMessage.getDeploymentType(), set);
        DeploymentServiceMessage deploymentServiceMessage2 = new DeploymentServiceMessage(this.deploymentServiceVersion, 5, deploymentServiceMessage.getDeploymentId(), arrayList);
        deploymentServiceMessage2.setFromVersion(deploymentServiceMessage.getFromVersion());
        deploymentServiceMessage2.setToVersion(this.adminDeploymentsManager.getCurrentDomainVersion().getFilteredVersion(set));
        if (this.isDebugEnabled()) {
            this.debug("'get deployments response' being returned to '" + deploymentServiceMessage.getMessageSrc() + "' message --> " + deploymentServiceMessage2);
        }
        return deploymentServiceMessage2;
    }

    public final void receiveStatusMsg(DeploymentServiceMessage deploymentServiceMessage) {
        ArrayList arrayList = deploymentServiceMessage.getItems();
        String string = (String)arrayList.get(0);
        Serializable serializable = (Serializable)arrayList.get(1);
        boolean bl = false;
        long l = 0L;
        if (arrayList.size() > 2) {
            bl = true;
            l = (Long)arrayList.get(2);
        }
        if (this.isDebugEnabled()) {
            Debug.serviceStatusLogger.debug("received 'status update' from '" + deploymentServiceMessage.getMessageSrc() + "' on channel id '" + string + "'");
        }
        String string2 = deploymentServiceMessage.getMessageSrc();
        if (this.statusDeliverer == null) {
            this.rejectAdminServerOperation(string2);
        }
        if (bl) {
            this.statusDeliverer.deliverStatus(l, string, serializable, deploymentServiceMessage.getMessageSrc());
        } else {
            this.statusDeliverer.deliverStatus(string, serializable, deploymentServiceMessage.getMessageSrc());
        }
    }

    public final void receiveRequestPrepareMsg(DeploymentServiceMessage deploymentServiceMessage) {
        block7: {
            long l = deploymentServiceMessage.getDeploymentId();
            if (this.isDebugEnabled()) {
                this.debug("received 'prepare' with id '" + l + "'");
            }
            if (this.targetRequestManager.hasAPendingCancelFor(l)) {
                this.handlePendingCancel(l);
                return;
            }
            TargetRequestImpl targetRequestImpl = null;
            try {
                targetRequestImpl = CommonMessageReceiver.createTargetRequestImpl(deploymentServiceMessage);
                targetRequestImpl.setControlRequest(!deploymentServiceMessage.needsVersionUpdate());
                targetRequestImpl.setDomainVersion(deploymentServiceMessage.getFromVersion());
                final TargetRequestImpl targetRequestImpl2 = targetRequestImpl;
                this.targetRequestManager.addRequest(new ServiceRequest(){

                    public void run() {
                        targetRequestImpl2.run();
                    }

                    public String toString() {
                        return targetRequestImpl2.toString();
                    }
                });
            }
            catch (Throwable throwable) {
                if (this.isDebugEnabled()) {
                    Debug.serviceDebug(throwable.getMessage() + " " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                }
                try {
                    this.getMessageSender().sendPrepareNakMsg(deploymentServiceMessage.getDeploymentId(), throwable);
                }
                catch (RemoteException remoteException) {
                    targetRequestImpl.abort();
                }
                if (targetRequestImpl == null || targetRequestImpl.getDeploymentStatus() == null || targetRequestImpl.isAborted()) break block7;
                targetRequestImpl.getDeploymentStatus().reset();
            }
        }
    }

    public final void receiveRequestCommitMsg(DeploymentServiceMessage deploymentServiceMessage) {
        block10: {
            TargetRequestImpl targetRequestImpl;
            long l = deploymentServiceMessage.getDeploymentId();
            if (this.isDebugEnabled()) {
                this.debug("received 'commit' with id '" + l + "'");
            }
            if ((targetRequestImpl = this.targetRequestManager.getRequest(l)) == null) {
                if (this.isDebugEnabled()) {
                    this.debug("'commit' with id '" + l + "' does not have a " + "corresponding request - ignoring message");
                }
                return;
            }
            TargetRequestStatus targetRequestStatus = null;
            try {
                targetRequestStatus = targetRequestImpl.getDeploymentStatus();
                targetRequestStatus.getCurrentState().receivedCommit();
            }
            catch (Throwable throwable) {
                try {
                    this.getMessageSender().sendCommitFailedMsg(l, throwable);
                }
                catch (RemoteException remoteException) {
                    String string = DeploymentServiceLogger.sendCommitFailMsgFailed((long)l);
                    try {
                        this.getMessageSender().sendCommitFailedMsg(l, new Exception(string));
                    }
                    catch (RemoteException remoteException2) {
                        // empty catch block
                    }
                }
                if (targetRequestStatus != null) {
                    targetRequestStatus.reset();
                }
                if (!this.isDebugEnabled()) break block10;
                this.debug(throwable.getMessage() + " " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
    }

    public final void receiveRequestCancelMsg(DeploymentServiceMessage deploymentServiceMessage) {
        block12: {
            long l = deploymentServiceMessage.getDeploymentId();
            Throwable throwable = (Throwable)deploymentServiceMessage.getItems().get(0);
            if (this.isDebugEnabled()) {
                this.debug("Received 'cancel' for id '" + l + "' due to '" + throwable + "'");
            }
            if (this.targetRequestManager.hasAPendingCancelFor(l)) {
                if (this.isDebugEnabled()) {
                    this.debug("request with id '" + l + "' is a pending cancel so send back success message");
                }
                this.handlePendingCancel(l);
                return;
            }
            TargetRequestImpl targetRequestImpl = this.targetRequestManager.getRequest(l);
            if (targetRequestImpl == null) {
                if (this.isDebugEnabled()) {
                    this.debug("'cancel' with id '" + l + "' does not have a corresponding request - saving to " + "'pending cancel' list");
                }
                this.targetRequestManager.addToPendingCancels(l);
                return;
            }
            TargetRequestStatus targetRequestStatus = null;
            try {
                targetRequestStatus = targetRequestImpl.getDeploymentStatus();
                if (targetRequestStatus != null) {
                    targetRequestStatus.setCanceled();
                    if (targetRequestStatus.isAborted()) {
                        if (this.isDebugEnabled()) {
                            this.debug("Request '" + l + "' aborted so cancel already performed. Just send back success");
                        }
                        this.getMessageSender().sendCancelSucceededMsg(l);
                    } else {
                        targetRequestStatus.getCurrentState().receivedCancel();
                    }
                }
            }
            catch (Throwable throwable2) {
                this.getMessageSender().sendCancelFailedMsg(l, throwable2);
                if (targetRequestStatus != null) {
                    targetRequestStatus.reset();
                }
                if (!this.isDebugEnabled()) break block12;
                this.debug(throwable2.getMessage() + " " + StackTraceUtils.throwable2StackTrace((Throwable)throwable2));
            }
        }
    }

    public final void receiveHeartbeatMsg(final DeploymentServiceMessage deploymentServiceMessage) {
        if (!this.heartbeatServiceInitialized) {
            if (this.isDebugEnabled()) {
                this.debug("ignoring 'heartbeat' - heartbeat service not initialized");
            }
            return;
        }
        if (this.targetRequestManager.handlingRequests()) {
            if (this.isDebugEnabled()) {
                this.debug("ignoring 'heartbeat' - requests still in progress");
            }
            return;
        }
        this.targetRequestManager.addRequest(new ServiceRequest(){

            public void run() {
                try {
                    CommonMessageReceiver.this.handleHeartbeatMessage(deploymentServiceMessage);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public String toString() {
                return "Heartbeat request";
            }
        });
    }

    private boolean serverInAdminState() {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        return serverRuntimeMBean.getState() == "ADMIN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHeartbeatMessage(DeploymentServiceMessage deploymentServiceMessage) {
        if (this.targetRequestManager.handlingRequests() || this.serverInAdminState()) {
            if (this.isDebugEnabled()) {
                this.debug("skipping 'heartbeat' handling");
            }
            return;
        }
        DomainVersion domainVersion = deploymentServiceMessage.getFromVersion();
        DomainVersion domainVersion2 = this.targetDeploymentsManager.getCurrentDomainVersion();
        if (domainVersion2.equals(domainVersion)) {
            if (this.isDebugEnabled()) {
                this.debug("domain version in 'heartbeat' '" + domainVersion + "' is equal " + "to current domain version");
            }
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("domain version in 'heartbeat' '" + domainVersion + "' not equal " + "to current domain version - needs to sync with admin server");
        }
        TargetRequestImpl targetRequestImpl = new TargetRequestImpl();
        long l = System.currentTimeMillis();
        targetRequestImpl.setId(l);
        targetRequestImpl.setHeartbeatRequest();
        Object object = this.targetRequestManager;
        synchronized (object) {
            if (this.targetRequestManager.handlingRequests() || this.serverInAdminState()) {
                if (this.isDebugEnabled()) {
                    this.debug(" 1 skipping 'heartbeat' handling");
                }
                return;
            }
            this.targetRequestManager.addToRequestTable(targetRequestImpl);
        }
        object = TargetRequestStatus.createTargetRequestStatus(targetRequestImpl);
        ((TargetRequestStatus)object).setCurrentState(((TargetRequestStatus)object).getTargetServerState(5));
        targetRequestImpl.setDeploymentStatus((TargetRequestStatus)object);
        this.getMessageSender().sendGetDeploymentsMsg(domainVersion2, l);
    }

    public final void receiveGetDeploymentsResponse(DeploymentServiceMessage deploymentServiceMessage) {
        long l;
        TargetRequestImpl targetRequestImpl;
        if (this.isDebugEnabled()) {
            this.debug("received 'get deployments response' from '" + deploymentServiceMessage.getMessageSrc());
        }
        if ((targetRequestImpl = this.targetRequestManager.getRequest(l = deploymentServiceMessage.getDeploymentId())) == null) {
            if (this.isDebugEnabled()) {
                this.debug("'get deployments response' does not have  corresponding request - ignoring message");
            }
            return;
        }
        TargetRequestStatus targetRequestStatus = targetRequestImpl.getDeploymentStatus();
        targetRequestStatus.getCurrentState().receivedGetDeploymentsResponse(deploymentServiceMessage);
    }

    public final void dispatch(DeploymentServiceMessage deploymentServiceMessage) {
        byte by = deploymentServiceMessage.getMessageType();
        switch (by) {
            case 0: {
                this.receiveHeartbeatMsg(deploymentServiceMessage);
                break;
            }
            default: {
                if (!Debug.isServiceDebugEnabled()) break;
                Debug.serviceDebug("received illegal message '" + deploymentServiceMessage.toString() + "'");
            }
        }
    }

    public final DeploymentServiceMessage blockingDispatch(DeploymentServiceMessage deploymentServiceMessage) {
        final DeploymentServiceMessage deploymentServiceMessage2 = deploymentServiceMessage;
        final byte by = deploymentServiceMessage2.getMessageType();
        if (by == 13) {
            return this.receiveBlockingGetDeploymentsMsg(deploymentServiceMessage2);
        }
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                switch (by) {
                    case 0: {
                        CommonMessageReceiver.this.receiveHeartbeatMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 1: {
                        CommonMessageReceiver.this.receiveRequestPrepareMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 2: {
                        CommonMessageReceiver.this.receiveRequestCommitMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 3: {
                        CommonMessageReceiver.this.receiveRequestCancelMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 5: {
                        CommonMessageReceiver.this.receiveGetDeploymentsResponse(deploymentServiceMessage2);
                        break;
                    }
                    case 4: {
                        CommonMessageReceiver.this.receiveGetDeploymentsMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 6: {
                        CommonMessageReceiver.this.receivePrepareAckMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 7: {
                        CommonMessageReceiver.this.receivePrepareNakMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 8: {
                        CommonMessageReceiver.this.receiveCommitSucceededMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 9: {
                        CommonMessageReceiver.this.receiveCommitFailedMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 10: {
                        CommonMessageReceiver.this.receiveCancelSucceededMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 11: {
                        CommonMessageReceiver.this.receiveCancelFailedMsg(deploymentServiceMessage2);
                        break;
                    }
                    case 12: {
                        CommonMessageReceiver.this.receiveStatusMsg(deploymentServiceMessage2);
                        break;
                    }
                    default: {
                        if (!Debug.isServiceDebugEnabled()) break;
                        Debug.serviceDebug("blocking dispatch received illegal message '" + deploymentServiceMessage2.toString() + "'");
                    }
                }
            }
        });
        return null;
    }

    public final MessageReceiver getDelegate() {
        return this.delegate;
    }

    private static TargetRequestImpl createTargetRequestImpl(DeploymentServiceMessage deploymentServiceMessage) {
        AuthenticatedSubject authenticatedSubject;
        TargetRequestImpl targetRequestImpl = new TargetRequestImpl();
        ArrayList arrayList = deploymentServiceMessage.getItems();
        long l = deploymentServiceMessage.getDeploymentId();
        targetRequestImpl.setDeployments(arrayList);
        targetRequestImpl.setId(l);
        targetRequestImpl.setTimeoutInterval(deploymentServiceMessage.getTimeoutInterval());
        if (deploymentServiceMessage.isConfigurationProviderCalledLast()) {
            targetRequestImpl.setCallConfigurationProviderLast();
        }
        if ((authenticatedSubject = deploymentServiceMessage.getInitiator()) != null) {
            targetRequestImpl.setInitiator(authenticatedSubject);
        }
        return targetRequestImpl;
    }

    protected void rejectAdminServerOperation(String string) {
        throw new UnsupportedOperationException(DeploymentServiceLogger.logExceptionInServletRequestIntendedForAdminServerLoggable((String)string).getMessage());
    }

    static final class Maker {
        static final CommonMessageReceiver SINGLETON = new CommonMessageReceiver();

        Maker() {
        }
    }
}

