/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.transport;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentsManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.deploy.service.internal.adminserver.AdminRequestManager;
import weblogic.deploy.service.internal.adminserver.AdminRequestStatus;
import weblogic.deploy.service.internal.transport.AdminServerMessageSender;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.deploy.service.internal.transport.MessageSender;
import weblogic.deploy.service.internal.transport.TargetServerMessageSender;
import weblogic.deploy.service.internal.transport.UnreachableHostException;
import weblogic.deploy.service.internal.transport.http.HTTPMessageSender;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public final class CommonMessageSender
implements AdminServerMessageSender,
TargetServerMessageSender {
    private MessageSender delegate;
    private final byte deploymentServiceVersion;
    private final AdminDeploymentsManager adminDeploymentsManager;
    private final AdminRequestManager adminRequestManager;
    private final Map serverToHandlers = Collections.synchronizedMap(new HashMap());
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String localServerName;

    private CommonMessageSender() {
        DeploymentService deploymentService = DeploymentService.getDeploymentService();
        this.deploymentServiceVersion = deploymentService.getVersionByte();
        this.adminDeploymentsManager = AdminDeploymentsManager.getInstance();
        this.adminRequestManager = AdminRequestManager.getInstance();
        this.setDelegate(HTTPMessageSender.getMessageSender());
    }

    public static CommonMessageSender getInstance() {
        return Maker.SINGLETON;
    }

    private static final void debug(String string) {
        Debug.serviceTransportDebug(string);
    }

    private static final boolean isDebugEnabled() {
        return Debug.isServiceTransportDebugEnabled();
    }

    private void setDelegate(MessageSender messageSender) {
        if (this.delegate == null) {
            this.delegate = messageSender;
        }
    }

    public final MessageSender getDelegate() {
        return this.delegate;
    }

    private String getLocalServerName() {
        if (this.localServerName == null) {
            this.localServerName = ManagementService.getRuntimeAccess(kernelId).getServerName();
        }
        return this.localServerName;
    }

    public void sendHeartbeatMsg(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        DeploymentServiceMessage deploymentServiceMessage = this.createHeartbeatMessage();
        DomainVersion domainVersion = this.adminDeploymentsManager.getCurrentDomainVersion();
        for (String string : list) {
            if (this.getLocalServerName().equals(string)) continue;
            Set set = this.getHandlers(string);
            deploymentServiceMessage.setFromVersion(domainVersion.getFilteredVersion(set));
            this.sendOutHeartbeatMsg(deploymentServiceMessage, string);
        }
    }

    private DeploymentServiceMessage createHeartbeatMessage() {
        ArrayList arrayList = new ArrayList();
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 0, -1L, arrayList);
        return deploymentServiceMessage;
    }

    public final void sendRequestPrepareMsg(AdminRequestImpl adminRequestImpl) {
        Iterator iterator;
        if (CommonMessageSender.isDebugEnabled()) {
            CommonMessageSender.debug("start send 'prepare' for id '" + adminRequestImpl.getId() + "'");
        }
        if ((iterator = adminRequestImpl.getTargetServers()) == null) {
            return;
        }
        DomainVersion domainVersion = this.adminDeploymentsManager.getCurrentDomainVersion();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 1, adminRequestImpl, string);
            DomainVersion domainVersion2 = domainVersion;
            if (!this.getLocalServerName().equals(string)) {
                Set set = this.getHandlers(string);
                domainVersion2 = domainVersion.getFilteredVersion(set);
            }
            deploymentServiceMessage.setFromVersion(domainVersion2);
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("sending 'prepare' for id '" + adminRequestImpl.getId() + "' to '" + string + "' message -->" + deploymentServiceMessage);
            }
            this.sendOutPrepareMsg(deploymentServiceMessage, string, adminRequestImpl);
        }
    }

    public final void sendRequestCommitMsg(AdminRequestImpl adminRequestImpl) {
        if (CommonMessageSender.isDebugEnabled()) {
            CommonMessageSender.debug("start send 'commit' for id '" + adminRequestImpl.getId() + "'");
        }
        AdminRequestStatus adminRequestStatus = adminRequestImpl.getStatus();
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 2, adminRequestImpl.getId(), new ArrayList());
        Iterator iterator = adminRequestStatus.getTargetsToBeCommitted();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("sending 'commit' for id '" + adminRequestImpl.getId() + "' to '" + string + "'");
            }
            this.sendOutCommitMsg(deploymentServiceMessage, string, adminRequestImpl);
        }
    }

    public final void sendRequestCancelMsg(AdminRequestImpl adminRequestImpl, Throwable throwable) {
        if (CommonMessageSender.isDebugEnabled()) {
            CommonMessageSender.debug("start send 'cancel' for id '" + adminRequestImpl.getId() + "'");
        }
        AdminRequestStatus adminRequestStatus = adminRequestImpl.getStatus();
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        arrayList.add(throwable);
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 3, adminRequestImpl.getId(), arrayList);
        Iterator iterator = adminRequestStatus.getTargetsToBeCancelled();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("sending 'cancel' for id '" + adminRequestImpl.getId() + "' to '" + string + "'");
            }
            this.sendOutCancelMsg(deploymentServiceMessage, string, adminRequestImpl);
        }
    }

    public final void sendGetDeploymentsResponse(ArrayList arrayList, String string, DomainVersion domainVersion, long l) {
        block5: {
            DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 5, l, arrayList);
            deploymentServiceMessage.setToVersion(domainVersion);
            try {
                if (this.getLocalServerName().equals(string)) {
                    this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
                } else {
                    Set set = this.getHandlers(string);
                    DomainVersion domainVersion2 = domainVersion.getFilteredVersion(set);
                    deploymentServiceMessage.setToVersion(domainVersion2);
                    this.delegate.sendMessageToTargetServer(deploymentServiceMessage, string);
                }
                if (CommonMessageSender.isDebugEnabled()) {
                    CommonMessageSender.debug("start send 'get deployments response' '" + arrayList + "' to '" + string + " to version '" + deploymentServiceMessage.getToVersion() + "'");
                }
            }
            catch (Exception exception) {
                if (!Debug.isServiceTransportDebugEnabled()) break block5;
                Debug.serviceTransportDebug("send 'get deployments response' to '" + string + "' failed due to '" + exception.getMessage() + "'");
            }
        }
    }

    private final void sendOutPrepareMsg(final DeploymentServiceMessage deploymentServiceMessage, final String string, final AdminRequestImpl adminRequestImpl) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                long l = adminRequestImpl.getId();
                AdminRequestImpl adminRequestImpl2 = CommonMessageSender.this.adminRequestManager.getRequest(l);
                try {
                    if (CommonMessageSender.this.getLocalServerName().equals(string)) {
                        adminRequestImpl.prepareDeliveredTo(string);
                        CommonMessageSender.this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
                    } else {
                        if (adminRequestImpl2 != null) {
                            CommonMessageSender.this.adminRequestManager.addPrepareDisconnectListener(string, adminRequestImpl2);
                        }
                        CommonMessageSender.this.delegate.sendMessageToTargetServer(deploymentServiceMessage, string);
                        adminRequestImpl.prepareDeliveredTo(string);
                    }
                }
                catch (Throwable throwable) {
                    Exception exception;
                    if (CommonMessageSender.isDebugEnabled()) {
                        CommonMessageSender.debug("send 'prepare' of id '" + l + "' to '" + string + "' failed due to '" + StackTraceUtils.throwable2StackTrace((Throwable)throwable) + "'");
                    }
                    if (adminRequestImpl2 == null) {
                        if (CommonMessageSender.isDebugEnabled()) {
                            CommonMessageSender.debug("prepare delivery failure to '" + string + "' for request '" + l + "' could not be " + "dispatched since request is no longer available");
                        }
                        return;
                    }
                    Exception exception2 = exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
                    if (exception instanceof UnreachableHostException) {
                        adminRequestImpl2.prepareDeliveryFailureWhenContacting(string, exception);
                    }
                    adminRequestImpl2.prepareDeliveredTo(string);
                    adminRequestImpl2.receivedPrepareFailed(string, exception, true);
                }
            }
        });
    }

    private final void sendOutCommitMsg(final DeploymentServiceMessage deploymentServiceMessage, final String string, final AdminRequestImpl adminRequestImpl) {
        final long l = adminRequestImpl.getId();
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                AdminRequestImpl adminRequestImpl2 = CommonMessageSender.this.adminRequestManager.getRequest(l);
                try {
                    if (CommonMessageSender.this.getLocalServerName().equals(string)) {
                        adminRequestImpl.commitDeliveredTo(string);
                        CommonMessageSender.this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
                    } else {
                        if (adminRequestImpl2 != null) {
                            CommonMessageSender.this.adminRequestManager.addCommitDisconnectListener(string, adminRequestImpl2);
                        }
                        CommonMessageSender.this.delegate.sendMessageToTargetServer(deploymentServiceMessage, string);
                        adminRequestImpl.commitDeliveredTo(string);
                    }
                }
                catch (Throwable throwable) {
                    Exception exception;
                    if (CommonMessageSender.isDebugEnabled()) {
                        CommonMessageSender.debug("send 'commit' of id '" + adminRequestImpl.getId() + "' to '" + string + "' failed due to '" + StackTraceUtils.throwable2StackTrace((Throwable)throwable) + "'");
                    }
                    if (adminRequestImpl2 == null) {
                        if (CommonMessageSender.isDebugEnabled()) {
                            CommonMessageSender.debug("commit delivery failure to '" + string + "' for request '" + l + "' could not be " + "dispatched since request is no longer available");
                        }
                        return;
                    }
                    Exception exception2 = exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
                    if (exception instanceof UnreachableHostException) {
                        adminRequestImpl2.commitDeliveryFailureWhenContacting(string, exception);
                    }
                    adminRequestImpl2.commitDeliveredTo(string);
                    adminRequestImpl2.receivedCommitFailed(string, exception);
                }
            }
        });
    }

    private void sendOutCancelMsg(final DeploymentServiceMessage deploymentServiceMessage, final String string, final AdminRequestImpl adminRequestImpl) {
        final long l = adminRequestImpl.getId();
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                AdminRequestImpl adminRequestImpl2 = CommonMessageSender.this.adminRequestManager.getRequest(l);
                try {
                    if (CommonMessageSender.this.getLocalServerName().equals(string)) {
                        adminRequestImpl.cancelDeliveredTo(string);
                        CommonMessageSender.this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
                    } else {
                        if (adminRequestImpl2 != null) {
                            CommonMessageSender.this.adminRequestManager.addCancelDisconnectListener(string, adminRequestImpl2);
                        }
                        CommonMessageSender.this.delegate.sendMessageToTargetServer(deploymentServiceMessage, string);
                        adminRequestImpl.cancelDeliveredTo(string);
                    }
                }
                catch (Throwable throwable) {
                    Exception exception;
                    if (CommonMessageSender.isDebugEnabled()) {
                        CommonMessageSender.debug("send 'cancel' of id '" + deploymentServiceMessage.getDeploymentId() + "' to '" + string + "' failed due to '" + throwable.getMessage() + "'");
                    }
                    if (adminRequestImpl2 == null) {
                        if (CommonMessageSender.isDebugEnabled()) {
                            CommonMessageSender.debug("cancel delivery failure to '" + string + "' for request '" + l + "' could not be " + "dispatched since request is no longer available");
                        }
                        return;
                    }
                    Exception exception2 = exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
                    if (exception instanceof UnreachableHostException) {
                        adminRequestImpl2.cancelDeliveryFailureWhenContacting(string, exception);
                    }
                    adminRequestImpl2.cancelDeliveredTo(string);
                    adminRequestImpl2.receivedCancelFailed(string, exception);
                }
            }
        });
    }

    private void sendOutHeartbeatMsg(final DeploymentServiceMessage deploymentServiceMessage, final String string) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                block3: {
                    try {
                        if (CommonMessageSender.isDebugEnabled()) {
                            CommonMessageSender.debug("sending heartbeat to server '" + string + "', message -->" + deploymentServiceMessage);
                        }
                        CommonMessageSender.this.delegate.sendHeartbeatMessage(deploymentServiceMessage, string);
                    }
                    catch (Throwable throwable) {
                        if (!CommonMessageSender.isDebugEnabled()) break block3;
                        CommonMessageSender.debug("Failed to send heartbeat message to server '" + string + "' due to: " + throwable);
                    }
                }
            }
        });
    }

    public final void sendPrepareAckMsg(long l, boolean bl) throws RemoteException {
        if (CommonMessageSender.isDebugEnabled()) {
            CommonMessageSender.debug("sending 'prepare ack' for id '" + l + "'");
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        arrayList.add(bl);
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 6, l, arrayList);
        try {
            this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
        }
        catch (UnreachableHostException unreachableHostException) {
            throw unreachableHostException;
        }
        catch (Exception exception) {
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("send 'prepare ack' of id '" + l + "' failed due to " + exception.getMessage() + "'");
            }
            throw new RemoteException("Error sending prepare ack", exception);
        }
    }

    public final void sendPrepareNakMsg(long l, Throwable throwable) throws RemoteException {
        block4: {
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("sending 'prepare nak' for id '" + l + "' with reason '" + throwable.getMessage() + "'");
            }
            ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
            arrayList.add(throwable);
            DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 7, l, arrayList);
            try {
                this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
            }
            catch (UnreachableHostException unreachableHostException) {
                throw unreachableHostException;
            }
            catch (Exception exception) {
                if (!CommonMessageSender.isDebugEnabled()) break block4;
                CommonMessageSender.debug("send 'prepare nak' of id '" + l + "' failed due to '" + exception.getMessage() + "'");
            }
        }
    }

    public final DeploymentServiceMessage sendBlockingGetDeploymentsMsg(DomainVersion domainVersion, String string) throws Exception {
        ArrayList arrayList = new ArrayList();
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 13, -1L, arrayList);
        deploymentServiceMessage.setFromVersion(domainVersion);
        deploymentServiceMessage.setDeploymentType(string);
        if (CommonMessageSender.isDebugEnabled()) {
            CommonMessageSender.debug("sending 'blocking get deployments' request to catch up from version '" + domainVersion + "' for deployment type '" + string + "'");
        }
        DeploymentServiceMessage deploymentServiceMessage2 = this.delegate.sendBlockingMessageToAdminServer(deploymentServiceMessage);
        if (CommonMessageSender.isDebugEnabled()) {
            CommonMessageSender.debug("received 'blocking get deployments' response to catch up from version '" + domainVersion + "' for deployment type '" + string + "'");
        }
        return deploymentServiceMessage2;
    }

    public final void sendGetDeploymentsMsg(DomainVersion domainVersion, final long l) {
        final DomainVersion domainVersion2 = domainVersion;
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                block3: {
                    if (CommonMessageSender.isDebugEnabled()) {
                        CommonMessageSender.debug("sending 'get deployments' request to catch up from version '" + domainVersion2 + "'");
                    }
                    ArrayList arrayList = new ArrayList();
                    DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(CommonMessageSender.this.deploymentServiceVersion, 4, l, arrayList);
                    deploymentServiceMessage.setFromVersion(domainVersion2);
                    try {
                        CommonMessageSender.this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
                    }
                    catch (Exception exception) {
                        if (!CommonMessageSender.isDebugEnabled()) break block3;
                        CommonMessageSender.debug("send 'get deployments' request to catch up from version '" + domainVersion2 + "' failed due to '" + exception.getMessage() + "'");
                    }
                }
            }
        });
    }

    public final void sendCommitSucceededMsg(long l) {
        block3: {
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("sending 'commit success' for id '" + l + "'");
            }
            ArrayList arrayList = new ArrayList();
            DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 8, l, arrayList);
            try {
                this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
            }
            catch (Exception exception) {
                if (!CommonMessageSender.isDebugEnabled()) break block3;
                CommonMessageSender.debug("send 'commit success' of id '" + l + "' failed due to " + exception.getMessage() + "'");
            }
        }
    }

    public final void sendCommitFailedMsg(long l, Throwable throwable) throws RemoteException {
        if (CommonMessageSender.isDebugEnabled()) {
            CommonMessageSender.debug("sending 'commit failed' for id '" + l + "' with reason '" + throwable.getMessage() + "'");
        }
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        arrayList.add(throwable);
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 9, l, arrayList);
        try {
            this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
        }
        catch (Exception exception) {
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("send 'commit failed' of id '" + l + "' failed due to '" + exception.getMessage() + "'");
            }
            throw new RemoteException("Error sending commit failed", exception);
        }
    }

    public final void sendCancelSucceededMsg(long l) {
        block3: {
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("sending 'cancel success' for id '" + l + "'");
            }
            ArrayList arrayList = new ArrayList();
            DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 10, l, arrayList);
            try {
                this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
            }
            catch (Exception exception) {
                if (!CommonMessageSender.isDebugEnabled()) break block3;
                CommonMessageSender.debug("send 'cancel success' of id '" + l + "' failed due to '" + exception.getMessage() + "'");
            }
        }
    }

    public final void sendCancelFailedMsg(long l, Throwable throwable) {
        block3: {
            if (CommonMessageSender.isDebugEnabled()) {
                CommonMessageSender.debug("sending 'cancel failed' for id '" + l + "' with reason '" + throwable.getMessage() + "'");
            }
            ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
            arrayList.add(throwable);
            DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 11, l, arrayList);
            try {
                this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
            }
            catch (Exception exception) {
                if (!Debug.isServiceDebugEnabled()) break block3;
                Debug.serviceDebug("send 'cancel failed' of id '" + l + "' failed due to '" + exception.getMessage() + "'");
            }
        }
    }

    public final void sendStatusMsg(String string, Serializable serializable) {
        block3: {
            if (Debug.isServiceStatusDebugEnabled()) {
                Debug.serviceStatusDebug("send 'status' '" + serializable + "' for channel '" + string + "'");
            }
            try {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(string);
                arrayList.add(serializable);
                this.createAndSendStatusMessage(arrayList);
            }
            catch (Exception exception) {
                if (!Debug.isServiceDebugEnabled()) break block3;
                Debug.serviceDebug("send 'status' for channel '" + string + "' failed due to '" + exception.getMessage() + "'");
            }
        }
    }

    public final void sendStatusMsg(long l, String string, Serializable serializable) {
        block3: {
            if (Debug.isServiceStatusDebugEnabled()) {
                Debug.serviceStatusDebug("send 'status' '" + serializable + "' for channel '" + l + "' and handler id '" + string + "'");
            }
            try {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(string);
                arrayList.add(serializable);
                arrayList.add(new Long(l));
                this.createAndSendStatusMessage(arrayList);
            }
            catch (Exception exception) {
                if (!Debug.isServiceDebugEnabled()) break block3;
                Debug.serviceDebug("send 'status' for channel '" + l + "' failed due to '" + exception.getMessage() + "'");
            }
        }
    }

    private void createAndSendStatusMessage(ArrayList arrayList) throws Exception {
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, 12, -1L, arrayList);
        this.delegate.sendMessageToAdminServer(deploymentServiceMessage);
    }

    Set putHandlers(String string, Set set) {
        return this.serverToHandlers.put(string, Collections.unmodifiableSet(set));
    }

    Set getHandlers(String string) {
        return (Set)this.serverToHandlers.get(string);
    }

    static final class Maker {
        static final CommonMessageSender SINGLETON = new CommonMessageSender();

        Maker() {
        }
    }
}

