/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.transport;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.DomainVersion;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.ArrayUtils;

public final class DeploymentServiceMessage
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = -566288665135473593L;
    public static final byte HEARTBEAT = 0;
    public static final byte REQUEST_PREPARE = 1;
    public static final byte REQUEST_COMMIT = 2;
    public static final byte REQUEST_CANCEL = 3;
    public static final byte GET_DEPLOYMENTS = 4;
    public static final byte GET_DEPLOYMENTS_RESPONSE = 5;
    public static final byte PREPARE_ACK = 6;
    public static final byte PREPARE_NAK = 7;
    public static final byte COMMIT_SUCCEEDED = 8;
    public static final byte COMMIT_FAILED = 9;
    public static final byte CANCEL_SUCCEEDED = 10;
    public static final byte CANCEL_FAILED = 11;
    public static final byte REQUEST_STATUS = 12;
    public static final byte BLOCKING_GET_DEPLOYMENTS = 13;
    private byte deploymentServiceVersion;
    private final byte currentDeploymentServiceVersion;
    private byte messageType;
    private long deploymentId;
    private long timeoutValue = -1L;
    private boolean callConfigurationProviderLast;
    private String messageSrc;
    private transient Set targets = null;
    private ArrayList items = null;
    private DomainVersion fromVersion = null;
    private DomainVersion toVersion = null;
    private AuthenticatedSubject initiator = null;
    private String deploymentType = null;
    private boolean needsVersionUpdate = true;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public DeploymentServiceMessage() {
        DeploymentService.getDeploymentService();
        this.currentDeploymentServiceVersion = DeploymentService.getVersionByte();
    }

    public DeploymentServiceMessage(byte by, byte by2, AdminRequestImpl adminRequestImpl, String string) {
        DeploymentService.getDeploymentService();
        this.currentDeploymentServiceVersion = DeploymentService.getVersionByte();
        this.deploymentServiceVersion = by;
        this.messageType = by2;
        this.messageSrc = ManagementService.getRuntimeAccess(kernelId).getServerName();
        if (adminRequestImpl != null) {
            this.deploymentId = adminRequestImpl.getId();
            this.timeoutValue = adminRequestImpl.getTimeoutInterval();
            this.callConfigurationProviderLast = adminRequestImpl.isConfigurationProviderCalledLast();
            this.initiator = adminRequestImpl.getInitiator();
            this.targets = new HashSet();
            Iterator iterator = adminRequestImpl.getTargets();
            if (this.targets != null) {
                while (iterator.hasNext()) {
                    this.targets.add((String)iterator.next());
                }
            }
            if (this.items == null) {
                this.items = new ArrayList();
            }
            Iterator iterator2 = adminRequestImpl.getDeployments();
            while (iterator2.hasNext()) {
                Deployment deployment = (Deployment)iterator2.next();
                Object[] objectArray = deployment.getTargets();
                boolean bl = false;
                if ("Configuration".equals(deployment.getCallbackHandlerId()) || "Application".equals(deployment.getCallbackHandlerId())) {
                    bl = true;
                } else if (string == null || objectArray == null || objectArray.length == 0 || ArrayUtils.contains((Object[])objectArray, (Object)string)) {
                    bl = true;
                }
                if (!bl) continue;
                this.items.add(deployment);
            }
            this.needsVersionUpdate = !adminRequestImpl.isControlRequest();
        }
    }

    public DeploymentServiceMessage(byte by, byte by2, long l, ArrayList arrayList) {
        DeploymentService.getDeploymentService();
        this.currentDeploymentServiceVersion = DeploymentService.getVersionByte();
        this.deploymentServiceVersion = by;
        this.messageType = by2;
        this.deploymentId = l;
        this.items = arrayList;
        this.messageSrc = ManagementService.getPropertyService(kernelId).serverNameIsSet() ? ManagementService.getPropertyService(kernelId).getServerName() : null;
    }

    public final long getDeploymentId() {
        return this.deploymentId;
    }

    public final long getTimeoutInterval() {
        return this.timeoutValue;
    }

    public final boolean isConfigurationProviderCalledLast() {
        return this.callConfigurationProviderLast;
    }

    private void setTargets(Set set) {
        this.targets = set;
    }

    public final Set getTargets() {
        return this.targets;
    }

    public final byte getVersion() {
        return this.deploymentServiceVersion;
    }

    public final byte getMessageType() {
        return this.messageType;
    }

    public final ArrayList getItems() {
        return this.items;
    }

    public final String getMessageSrc() {
        return this.messageSrc;
    }

    public final AuthenticatedSubject getInitiator() {
        return this.initiator;
    }

    private static String getMessageTypeString(byte by) {
        switch (by) {
            case 0: {
                return "HEARTBEAT";
            }
            case 1: {
                return "REQUEST_PREPARE";
            }
            case 2: {
                return "REQUEST_COMMIT";
            }
            case 3: {
                return "REQUEST_CANCEL";
            }
            case 4: {
                return "GET_DEPLOYMENTS";
            }
            case 5: {
                return "GET_DEPLOYMENTS_RESPONSE";
            }
            case 6: {
                return "PREPARE_ACK";
            }
            case 7: {
                return "PREPARE_NAK";
            }
            case 8: {
                return "COMMIT_SUCCEEDED";
            }
            case 9: {
                return "COMMIT_FAILED";
            }
            case 10: {
                return "CANCEL_SUCCEEDED";
            }
            case 11: {
                return "CANCEL_FAILED";
            }
            case 12: {
                return "REQUEST_STATUS";
            }
            case 13: {
                return "BLOCKING_GET_DEPLOYMENTS";
            }
        }
        return "ILLEGAL";
    }

    public final Object clone() {
        DeploymentServiceMessage deploymentServiceMessage = new DeploymentServiceMessage(this.deploymentServiceVersion, this.messageType, this.deploymentId, (ArrayList)this.items.clone());
        deploymentServiceMessage.setTargets(this.targets);
        return deploymentServiceMessage;
    }

    public final void setFromVersion(DomainVersion domainVersion) {
        this.fromVersion = domainVersion;
    }

    public final DomainVersion getFromVersion() {
        return this.fromVersion;
    }

    public final void setToVersion(DomainVersion domainVersion) {
        this.toVersion = domainVersion;
    }

    public final DomainVersion getToVersion() {
        return this.toVersion;
    }

    public final boolean needsVersionUpdate() {
        return this.needsVersionUpdate;
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.deploymentServiceVersion);
        this.writeMessage(this.deploymentServiceVersion, objectOutput);
    }

    private void writeMessage(byte by, ObjectOutput objectOutput) throws IOException {
        if (by == this.currentDeploymentServiceVersion) {
            objectOutput.writeByte(this.messageType);
            objectOutput.writeLong(this.deploymentId);
            objectOutput.writeLong(this.timeoutValue);
            objectOutput.writeBoolean(this.callConfigurationProviderLast);
            ((WLObjectOutput)objectOutput).writeString(this.messageSrc);
            boolean bl = this.items != null;
            objectOutput.writeBoolean(bl);
            if (bl) {
                ((WLObjectOutput)objectOutput).writeArrayList(this.items);
            }
            boolean bl2 = this.fromVersion != null;
            objectOutput.writeBoolean(bl2);
            if (bl2) {
                objectOutput.writeObject(this.fromVersion);
            }
            boolean bl3 = this.toVersion != null;
            objectOutput.writeBoolean(bl3);
            if (bl3) {
                objectOutput.writeObject(this.toVersion);
            }
            boolean bl4 = this.initiator != null;
            objectOutput.writeBoolean(bl4);
            if (bl4) {
                objectOutput.writeObject(SecurityServiceManager.sendASToWire((AuthenticatedSubject)this.initiator));
            }
            boolean bl5 = this.deploymentType != null;
            objectOutput.writeBoolean(bl5);
            if (bl5) {
                objectOutput.writeObject(this.deploymentType);
            }
            objectOutput.writeBoolean(this.needsVersionUpdate);
        }
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.deploymentServiceVersion = objectInput.readByte();
        this.readMessage(this.deploymentServiceVersion, objectInput);
    }

    private void readMessage(byte by, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (by == this.currentDeploymentServiceVersion) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            this.messageType = objectInput.readByte();
            this.deploymentId = objectInput.readLong();
            this.timeoutValue = objectInput.readLong();
            this.callConfigurationProviderLast = objectInput.readBoolean();
            this.messageSrc = ((WLObjectInput)objectInput).readString();
            boolean bl5 = objectInput.readBoolean();
            if (bl5) {
                this.items = ((WLObjectInput)objectInput).readArrayList();
            }
            if (bl4 = objectInput.readBoolean()) {
                this.fromVersion = (DomainVersion)objectInput.readObject();
            }
            if (bl3 = objectInput.readBoolean()) {
                this.toVersion = (DomainVersion)objectInput.readObject();
            }
            if (bl2 = objectInput.readBoolean()) {
                this.initiator = SecurityServiceManager.getASFromWire((AuthenticatedSubject)((AuthenticatedSubject)objectInput.readObject()));
            }
            if (bl = objectInput.readBoolean()) {
                this.setDeploymentType((String)objectInput.readObject());
            }
            this.needsVersionUpdate = objectInput.readBoolean();
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DeploymentService message ");
        stringBuffer.append(DeploymentServiceMessage.getMessageTypeString(this.messageType));
        stringBuffer.append(" and deployment id: ");
        stringBuffer.append(this.deploymentId);
        stringBuffer.append(" from : ");
        stringBuffer.append(this.messageSrc);
        stringBuffer.append(" with : ");
        if (this.items != null && !this.items.isEmpty()) {
            Iterator iterator = this.items.iterator();
            stringBuffer.append(this.items.size());
            stringBuffer.append(" item(s) : ");
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                stringBuffer.append("[");
                stringBuffer.append(e.toString());
                stringBuffer.append("] ");
            }
        } else {
            stringBuffer.append(0);
            stringBuffer.append(" items ");
        }
        if (this.fromVersion != null) {
            stringBuffer.append(" fromVersion: ");
            stringBuffer.append(this.fromVersion.toString());
        }
        if (this.toVersion != null) {
            stringBuffer.append(" toVersion: ");
            stringBuffer.append(this.toVersion.toString());
        }
        return stringBuffer.toString();
    }

    public final String getDeploymentType() {
        return this.deploymentType;
    }

    public final void setDeploymentType(String string) {
        if (this.messageType != 13) {
            throw new IllegalArgumentException("setDeploymentType is invalid for this message type");
        }
        this.deploymentType = string;
    }
}

