/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.service.internal.transport.ServerDisconnectListener;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.rmi.extensions.ConnectMonitor;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.ServerDisconnectEvent;
import weblogic.work.WorkManagerFactory;

public class ServerDisconnectManager {
    private static final long DISCONNECT_TIMEOUT = (long)Integer.getInteger("weblogic.deployment.serverDisconnectTimeout", 0).intValue() * 1000L;
    private ServerConnectDisconnectListenerImpl connectDisconnectListener = null;

    public static ServerDisconnectManager getInstance() {
        return Maker.SINGLETON;
    }

    private ServerDisconnectManager() {
    }

    public void initialize() {
        this.connectDisconnectListener = new ServerConnectDisconnectListenerImpl();
        ConnectMonitor connectMonitor = ConnectMonitorFactory.getConnectMonitor();
        connectMonitor.addConnectDisconnectListener((ConnectListener)this.connectDisconnectListener, (DisconnectListener)this.connectDisconnectListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDisconnectListener findOrCreateDisconnectListener(String string) {
        ServerDisconnectListener serverDisconnectListener = this.findDisconnectListener(string);
        if (serverDisconnectListener == null) {
            ServerDisconnectManager serverDisconnectManager = this;
            synchronized (serverDisconnectManager) {
                serverDisconnectListener = this.findDisconnectListener(string);
                if (serverDisconnectListener == null) {
                    serverDisconnectListener = this.createListener(string);
                    this.connectDisconnectListener.registerListener(string, serverDisconnectListener);
                    return serverDisconnectListener;
                }
            }
        }
        return serverDisconnectListener;
    }

    public ServerDisconnectListener findDisconnectListener(String string) {
        return this.connectDisconnectListener.getRegisteredListener(string);
    }

    public void removeDisconnectListener(String string) {
        this.connectDisconnectListener.unregisterListener(string);
    }

    public void removeAll() {
        this.connectDisconnectListener.unregisterAll();
    }

    private ServerDisconnectListener createListener(String string) {
        return new ServerDisconnectListenerImpl(string);
    }

    private class ServerConnectDisconnectListenerImpl
    implements DisconnectListener,
    ConnectListener {
        private Map disconnectListeners = new HashMap();

        private ServerConnectDisconnectListenerImpl() {
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            if (!(disconnectEvent instanceof ServerDisconnectEvent)) {
                return;
            }
            String string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
            this.handleOnDisconnectEvent(string, disconnectEvent);
        }

        public void onConnect(ConnectEvent connectEvent) {
            String string = connectEvent.getServerName();
            this.handleOnConnectEvent(string, connectEvent);
        }

        private void handleOnConnectEvent(final String string, ConnectEvent connectEvent) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    ServerDisconnectListener serverDisconnectListener = ServerConnectDisconnectListenerImpl.this.getRegisteredListener(string);
                    if (serverDisconnectListener != null) {
                        ((ServerDisconnectListenerImpl)serverDisconnectListener).setConnected(true);
                    } else {
                        serverDisconnectListener = ServerDisconnectManager.this.createListener(string);
                        ServerConnectDisconnectListenerImpl.this.registerListener(string, serverDisconnectListener);
                    }
                }
            });
        }

        private void handleOnDisconnectEvent(final String string, final DisconnectEvent disconnectEvent) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    ServerDisconnectListener serverDisconnectListener = ServerConnectDisconnectListenerImpl.this.getRegisteredListener(string);
                    if (serverDisconnectListener != null) {
                        ((ServerDisconnectListenerImpl)serverDisconnectListener).setConnected(false);
                        serverDisconnectListener.onDisconnect(disconnectEvent);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterAll() {
            ServerConnectDisconnectListenerImpl serverConnectDisconnectListenerImpl = this;
            synchronized (serverConnectDisconnectListenerImpl) {
                this.disconnectListeners.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerListener(String string, ServerDisconnectListener serverDisconnectListener) {
            ServerConnectDisconnectListenerImpl serverConnectDisconnectListenerImpl = this;
            synchronized (serverConnectDisconnectListenerImpl) {
                this.disconnectListeners.put(string, serverDisconnectListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerDisconnectListener getRegisteredListener(String string) {
            ServerConnectDisconnectListenerImpl serverConnectDisconnectListenerImpl = this;
            synchronized (serverConnectDisconnectListenerImpl) {
                return (ServerDisconnectListener)this.disconnectListeners.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterListener(String string) {
            ServerConnectDisconnectListenerImpl serverConnectDisconnectListenerImpl = this;
            synchronized (serverConnectDisconnectListenerImpl) {
                this.disconnectListeners.remove(string);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append("(");
            stringBuffer.append("disconnectListeners=").append(this.disconnectListeners);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    private class ServerDisconnectListenerImpl
    implements ServerDisconnectListener {
        private String serverName = null;
        private boolean connected = true;
        private ArrayList allListeners = new ArrayList();

        private ServerDisconnectListenerImpl(String string) {
            this.serverName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerListener(DisconnectListener disconnectListener) {
            ArrayList arrayList = this.allListeners;
            synchronized (arrayList) {
                this.allListeners.add(disconnectListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterListener(DisconnectListener disconnectListener) {
            ArrayList arrayList = this.allListeners;
            synchronized (arrayList) {
                this.allListeners.remove(disconnectListener);
            }
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            if (this.allListeners.isEmpty()) {
                return;
            }
            if (this.isReconnected()) {
                return;
            }
            for (DisconnectListener disconnectListener : (ArrayList)this.allListeners.clone()) {
                try {
                    disconnectListener.onDisconnect(disconnectEvent);
                }
                catch (Throwable throwable) {
                    DeploymentManagerLogger.logDisconnectListenerError(disconnectListener.toString(), throwable);
                }
            }
            this.allListeners.clear();
        }

        protected synchronized void setConnected(boolean bl) {
            this.connected = bl;
            this.notify();
        }

        protected synchronized boolean isConnected() {
            return this.connected;
        }

        protected synchronized boolean isReconnected() {
            long l = DISCONNECT_TIMEOUT;
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (true) {
                l3 = l2 - System.currentTimeMillis();
                if (l == 0L || this.connected || l3 <= 0L) {
                    return this.connected;
                }
                long l4 = l3 <= 5000L ? l3 : 5000L;
                try {
                    this.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append("(");
            stringBuffer.append("Server = ").append(this.serverName).append(", ");
            stringBuffer.append("listeners = ").append(this.allListeners).append(")");
            return stringBuffer.toString();
        }
    }

    static class Maker {
        private static final ServerDisconnectManager SINGLETON = new ServerDisconnectManager();

        Maker() {
        }
    }
}

