/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.mail.internet.MimeUtility;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.deploy.common.Debug;
import weblogic.deploy.common.DeploymentObjectInputStream;
import weblogic.deploy.service.DataTransferRequest;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.DataHandlerManager;
import weblogic.deploy.service.datatransferhandlers.MultipartResponse;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.deploy.service.internal.transport.MessageReceiver;
import weblogic.deploy.service.internal.transport.http.DeploymentServiceConstants;
import weblogic.deploy.utils.DeploymentServletConstants;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AdminResource;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.ServerResource;
import weblogic.security.spi.Resource;
import weblogic.utils.FileUtils;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.jars.JarFileUtils;

public final class DeploymentServiceServlet
extends HttpServlet
implements PrivilegedExceptionAction,
DeploymentServiceConstants,
DeploymentServletConstants {
    private static final int MAXIMUM_UPLOAD_SIZE = Integer.MAX_VALUE;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static AdminResource FILEUPLOAD_RESOURCE = new AdminResource("FileUpload", null, null);
    private AuthorizationManager authorizer;
    private PrincipalAuthenticator authenticator;
    private ServletConfig config = null;
    private String serverName = null;
    private RuntimeAccess serverConfig = null;
    private MessageReceiver loopbackReceiver = null;

    private final boolean isDebugEnabled() {
        return Debug.isServiceHttpDebugEnabled();
    }

    private final void debug(String string) {
        Debug.serviceHttpDebug("DeploymentServiceServlet:" + string);
    }

    public String getServletInfo() {
        return "DeploymentService transport servlet";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.config = servletConfig;
        if (kernelId == null) {
            Loggable loggable = DeploymentServiceLogger.logServletFailedToInitLoggable();
            loggable.log();
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: init: Security Services unavailable");
            }
            throw new ServletException(loggable.getMessage());
        }
        this.authenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        this.authorizer = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        if (this.authenticator == null || this.authorizer == null) {
            Loggable loggable = DeploymentServiceLogger.logServletFailedToInitLoggable();
            loggable.log();
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: init: Security Services unavailable " + (this.authenticator == null ? "null authenticator" : "null authorizer"));
            }
            throw new ServletException(loggable.getMessage());
        }
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Loggable loggable = DeploymentServiceLogger.logServletInitFailedDueToPrivilegedActionViolationLoggable((String)privilegedActionException.getException().getMessage());
            loggable.log();
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: init: Privileged action violation: " + loggable.getMessage());
            }
            throw (ServletException)((Object)privilegedActionException.getException());
        }
        this.serverConfig = ManagementService.getRuntimeAccess(kernelId);
        this.serverName = this.serverConfig.getServerName();
        DeploymentService deploymentService = DeploymentService.getDeploymentService();
        this.loopbackReceiver = deploymentService.getMessageReceiver().getDelegate();
        if (this.isDebugEnabled()) {
            this.debug("DeploymentServiceServlet initialized");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public void doPost(final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) throws ServletException, IOException {
        final AuthenticatedSubject authenticatedSubject = this.authenticateRequest(httpServletRequest, httpServletResponse);
        if (authenticatedSubject == null) {
            return;
        }
        String string = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("wl_request_type"));
        if (this.isDebugEnabled()) {
            this.debug("DeploymentServiceServlet: doPost: requestType: " + string);
        }
        try {
            Object object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DeploymentServiceServlet.this.internalDoPost(httpServletRequest, httpServletResponse, authenticatedSubject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Loggable loggable = DeploymentServiceLogger.logUnautherizedRequestLoggable((String)string, (String)authenticatedSubject.getName());
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: doPost: privileged action error - " + loggable.getMessage());
            }
            DeploymentServiceServlet.logAndSendError(httpServletResponse, 401, loggable);
        }
    }

    private final void internalDoPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticatedSubject authenticatedSubject) throws IOException {
        String string = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("wl_request_type"));
        try {
            if (string.equals("deployment_svc_msg")) {
                this.handleDeploymentServiceMessage(httpServletRequest, httpServletResponse, authenticatedSubject);
                return;
            }
            if (string.equals("data_transfer_request")) {
                this.handleDataTransferRequest(httpServletRequest, httpServletResponse, authenticatedSubject);
                return;
            }
            if (string.equals("plan_upload") || string.equals("app_upload")) {
                this.handlePlanOrApplicationUpload(httpServletRequest, httpServletResponse, authenticatedSubject);
                return;
            }
        }
        catch (IOException iOException) {
            Loggable loggable = DeploymentServiceLogger.logExceptionInServletRequestLoggable((String)string, (String)iOException.getMessage());
            DeploymentServiceServlet.logAndSendError(httpServletResponse, 500, loggable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handlePlanOrApplicationUpload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticatedSubject authenticatedSubject) throws IOException {
        String string;
        boolean bl;
        block18: {
            block17: {
                String string2 = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("wl_upload_application_name"));
                String string3 = ApplicationVersionUtils.getApplicationName(string2);
                String string4 = ApplicationVersionUtils.getVersionId(string2);
                String string5 = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("wl_request_type"));
                if (string3 == null) {
                    Loggable loggable = DeploymentServiceLogger.logRequestWithNoAppNameLoggable((String)string5);
                    DeploymentServiceServlet.logAndSendError(httpServletResponse, 403, loggable);
                    return;
                }
                String string6 = httpServletRequest.getContentType();
                if (string6 == null || !string6.startsWith("multipart")) {
                    Loggable loggable = DeploymentServiceLogger.logBadContentTypeServletRequestLoggable((String)string5, (String)string6);
                    DeploymentServiceServlet.logAndSendError(httpServletResponse, 400, loggable);
                    return;
                }
                boolean bl2 = false;
                String string7 = httpServletRequest.getHeader("wl_upload_delta");
                if (string7 != null && string7.equalsIgnoreCase("true")) {
                    bl2 = true;
                }
                boolean bl3 = string5.equals("plan_upload");
                boolean bl4 = "false".equals(httpServletRequest.getHeader("archive"));
                if (this.isDebugEnabled()) {
                    this.debug(string5 + " request for application " + string3 + " with archive: " + bl4);
                }
                String string8 = null;
                if (string4 == null || string4.length() == 0) {
                    string8 = this.getUploadDirName(string3, string4, bl2, bl3, bl4);
                }
                if (string8 == null) {
                    string8 = this.getDefaultUploadDirName();
                    if (string8 == null) {
                        Loggable loggable = DeploymentServiceLogger.logNoUploadDirectoryLoggable((String)string5, (String)string3);
                        DeploymentServiceServlet.logAndSendError(httpServletResponse, 500, loggable);
                        return;
                    }
                    string8 = string8 + string3 + File.separator;
                    if (string4 != null) {
                        string8 = string8 + string4 + File.separator;
                    }
                }
                if (this.isDebugEnabled()) {
                    this.debug(" +++ Final uploadingDirName : " + string8);
                }
                bl = true;
                string = null;
                try {
                    httpServletResponse.setContentType("text/plain");
                    File file = null;
                    if (httpServletRequest.getHeader("jspRefresh") != null && httpServletRequest.getHeader("jspRefresh").equals("true")) {
                        string = httpServletRequest.getHeader("adminAppPath");
                        if (string == null) {
                            Loggable loggable = DeploymentServiceLogger.logNoUploadFileRequestLoggable();
                            DeploymentServiceServlet.logAndSendError(httpServletResponse, 400, loggable);
                            Object var19_22 = null;
                            if (bl) return;
                            PrintStream printStream = new PrintStream((OutputStream)httpServletResponse.getOutputStream());
                            File file2 = new File(string);
                            printStream.println(DeploymentServiceServlet.mimeEncode(file2.getAbsolutePath()));
                            printStream.close();
                            return;
                        }
                        string = httpServletRequest.getHeader("adminAppPath");
                        file = this.doUploadFile(httpServletRequest, string);
                    } else {
                        file = this.doUploadFile(httpServletRequest, string8);
                    }
                    if (file == null) {
                        Loggable loggable = DeploymentServiceLogger.logFailedOnUploadingFileLoggable();
                        DeploymentServiceServlet.logAndSendError(httpServletResponse, 400, loggable);
                        break block17;
                    }
                    string = file.getPath();
                    bl = false;
                    if (bl4) {
                        if (this.isDebugEnabled()) {
                            this.debug("extracting " + string + " to " + string8);
                        }
                        bl = !this.extractArchive(string, string8);
                        string = string8;
                    }
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var19_25 = null;
                    if (bl) throw throwable;
                    PrintStream printStream = new PrintStream((OutputStream)httpServletResponse.getOutputStream());
                    File file = new File(string);
                    printStream.println(DeploymentServiceServlet.mimeEncode(file.getAbsolutePath()));
                    printStream.close();
                    throw throwable;
                }
            }
            Object var19_23 = null;
            if (bl) return;
            PrintStream printStream = new PrintStream((OutputStream)httpServletResponse.getOutputStream());
            File file = new File(string);
            printStream.println(DeploymentServiceServlet.mimeEncode(file.getAbsolutePath()));
            printStream.close();
            return;
        }
        Object var19_24 = null;
        if (bl) return;
        PrintStream printStream = new PrintStream((OutputStream)httpServletResponse.getOutputStream());
        File file = new File(string);
        printStream.println(DeploymentServiceServlet.mimeEncode(file.getAbsolutePath()));
        printStream.close();
    }

    private File doUploadFile(HttpServletRequest httpServletRequest, String string) {
        File file;
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        if (!this.authorizer.isAccessAllowed(authenticatedSubject, (Resource)FILEUPLOAD_RESOURCE, null)) {
            throw new RuntimeException("User has no access to upload files");
        }
        if (string != null) {
            file = new File(string);
            if (!file.exists()) {
                boolean bl = file.mkdirs();
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + string);
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("Not writable: " + string);
            }
        }
        try {
            file = File.createTempFile("wls_upload", "");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + file);
        }
        File file2 = null;
        try {
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            diskFileItemFactory.setSizeThreshold(0x100000);
            diskFileItemFactory.setRepository(file);
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            servletFileUpload.setSizeMax(Integer.MAX_VALUE);
            List list = servletFileUpload.parseRequest(httpServletRequest);
            FileItem fileItem = (FileItem)list.iterator().next();
            if (!fileItem.isFormField()) {
                String string2 = DeploymentServiceServlet.mimeDecode(fileItem.getName());
                file2 = new File(string + string2);
                fileItem.write(file2);
            }
        }
        catch (FileUploadException fileUploadException) {
            String string3 = httpServletRequest.getMethod();
            String string4 = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("wl_upload_application_name"));
            String string5 = ApplicationVersionUtils.getApplicationName(string4);
            String string6 = ApplicationVersionUtils.getVersionId(string4);
            String string7 = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("wl_request_type"));
            String string8 = httpServletRequest.getContentType();
            String string9 = "\n" + string3 + ",\n" + "wl_request_type" + ":" + string7 + ",\n" + "wl_upload_application_name" + ": " + string5 + ",\n" + "Content-Type: " + string8 + ",\n";
            if (this.isDebugEnabled()) {
                this.debug(" Exception while parsing multipart/form-data request " + string9 + "reason: " + StackTraceUtils.throwable2StackTrace((Throwable)fileUploadException));
            }
            DeploymentServiceLogger.logExceptionOnUpload((String)string9, (String)fileUploadException.getMessage());
            return null;
        }
        catch (Exception exception) {
            if (this.isDebugEnabled()) {
                this.debug(" Exception while uploading file to directory : " + string + "reason: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            DeploymentServiceLogger.logExceptionOnUpload((String)string.toString(), (String)exception.getMessage());
            return null;
        }
        return file2;
    }

    private final String getUploadDirName(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        AppDeploymentMBean appDeploymentMBean = null;
        String string3 = null;
        if (string != null && (appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(ManagementService.getRuntimeAccess(kernelId).getDomain(), string, string2)) != null) {
            if (bl) {
                string3 = appDeploymentMBean.getAbsoluteSourcePath();
            } else if (!bl2) {
                File file = new File(appDeploymentMBean.getAbsoluteSourcePath());
                string3 = file.getParentFile().getParent();
            } else {
                string3 = bl3 ? this.getUploadDirForPlanDir(appDeploymentMBean) : this.getUploadDirForPlan(appDeploymentMBean);
            }
            if (string3 != null) {
                string3 = string3 + File.separator;
            }
        }
        return string3;
    }

    private String getUploadDirForPlan(AppDeploymentMBean appDeploymentMBean) {
        String string = appDeploymentMBean.getAbsolutePlanPath();
        string = string == null ? this.getOrCreatePlanDir(appDeploymentMBean) : new File(string).getParent();
        return string;
    }

    private String getOrCreatePlanDir(AppDeploymentMBean appDeploymentMBean) {
        if (appDeploymentMBean.getPlanDir() != null) {
            return appDeploymentMBean.getAbsolutePlanDir();
        }
        File file = null;
        String string = null;
        if (appDeploymentMBean.getAbsoluteInstallDir() != null) {
            file = new File(appDeploymentMBean.getAbsoluteInstallDir());
            file = new File(file, "plan");
            file.mkdirs();
            string = file.getPath();
        }
        return string;
    }

    private String getUploadDirForPlanDir(AppDeploymentMBean appDeploymentMBean) {
        return this.getOrCreatePlanDir(appDeploymentMBean);
    }

    private final String getDefaultUploadDirName() {
        String string = null;
        string = ManagementService.getRuntimeAccess(kernelId).getServer().getUploadDirectoryName() + File.separator;
        if (this.isDebugEnabled()) {
            this.debug("uploadingDirName is " + string);
        }
        return string;
    }

    private final boolean extractArchive(String string, String string2) {
        File file = new File(string2);
        File file2 = new File(string);
        if (this.isDebugEnabled()) {
            this.debug(" +++ toDir : " + file.getAbsolutePath());
            this.debug(" +++ jar : " + file2.getAbsolutePath());
        }
        try {
            JarFileUtils.extract((File)file2, (File)file);
        }
        catch (IOException iOException) {
            if (this.isDebugEnabled()) {
                this.debug(" Exception while extracting jar file to directory : " + file + "reason: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
            DeploymentServiceLogger.logExceptionOnExtract((String)file.toString(), (String)iOException.getMessage());
            return false;
        }
        file2.delete();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticatedSubject authenticateRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        AuthenticatedSubject authenticatedSubject;
        String string;
        String string2;
        long l;
        block23: {
            block21: {
                Loggable loggable;
                block22: {
                    AuthenticatedSubject authenticatedSubject2;
                    l = System.currentTimeMillis();
                    try {
                        String string3 = httpServletRequest.getHeader("wls_salt");
                        if (string3 == null) break block21;
                        String string4 = httpServletRequest.getHeader("wls_signature");
                        if (string4 == null) {
                            loggable = DeploymentServiceLogger.logUnautherizedRequestLoggable((String)DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("wl_request_type")), (String)"No Signature");
                            loggable.log();
                            if (this.isDebugEnabled()) {
                                this.debug("DeploymentServiceServlet: authenticateRequest: " + loggable.getMessage());
                            }
                        }
                        if (ConnectionSigner.authenticate(string3, string4)) break block22;
                        loggable = DeploymentServiceLogger.logDomainWideSecretMismatchLoggable();
                        if (this.isDebugEnabled()) {
                            this.debug("DeploymentServiceServlet: authenticateRequest: Domain wide secret mismatch between salt: " + string3 + " and signature: " + string4);
                        }
                        DeploymentServiceServlet.logAndSendError(httpServletResponse, 401, loggable);
                        authenticatedSubject2 = null;
                        Object var13_13 = null;
                    }
                    catch (Throwable throwable) {
                        block24: {
                            Object var13_18 = null;
                            long l2 = System.currentTimeMillis() - l;
                            if (!this.isDebugEnabled()) break block24;
                            this.debug("DeploymentServiceServlet: authenticateRequest: TIME TOOK: " + l2);
                        }
                        throw throwable;
                    }
                    long l3 = System.currentTimeMillis() - l;
                    if (this.isDebugEnabled()) {
                        this.debug("DeploymentServiceServlet: authenticateRequest: TIME TOOK: " + l3);
                    }
                    return authenticatedSubject2;
                }
                loggable = kernelId;
                Object var13_14 = null;
                long l4 = System.currentTimeMillis() - l;
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentServiceServlet: authenticateRequest: TIME TOOK: " + l4);
                }
                return loggable;
            }
            string2 = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("username"));
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: authenticateRequest: Received req.header username: " + string2);
            }
            string = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("password"));
            if (string2 != null && string != null) break block23;
            if (this.isDebugEnabled()) {
                if (string2 == null) {
                    this.debug("DeploymentServiceServlet: authenticateRequest: error - User name not provided");
                } else {
                    this.debug("DeploymentServiceServlet: authenticateRequest: error - User password not provided");
                }
            }
            Loggable loggable = DeploymentServiceLogger.logNoUserNameOrPasswordLoggable();
            DeploymentServiceServlet.logAndSendError(httpServletResponse, 401, loggable);
            AuthenticatedSubject authenticatedSubject3 = null;
            Object var13_15 = null;
            long l5 = System.currentTimeMillis() - l;
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: authenticateRequest: TIME TOOK: " + l5);
            }
            return authenticatedSubject3;
        }
        try {
            authenticatedSubject = this.authenticator.authenticate((CallbackHandler)new MyCallbackHandler(string2, string));
        }
        catch (LoginException loginException) {
            Loggable loggable = DeploymentServiceLogger.logInvalidUserNameOrPasswordLoggable();
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: authenticateRequest: error - User name not authorized");
            }
            DeploymentServiceServlet.logAndSendError(httpServletResponse, 401, loggable);
            AuthenticatedSubject authenticatedSubject4 = null;
            Object var13_16 = null;
            long l6 = System.currentTimeMillis() - l;
            if (this.isDebugEnabled()) {
                this.debug("DeploymentServiceServlet: authenticateRequest: TIME TOOK: " + l6);
            }
            return authenticatedSubject4;
        }
        AuthenticatedSubject authenticatedSubject5 = authenticatedSubject;
        Object var13_17 = null;
        long l7 = System.currentTimeMillis() - l;
        if (this.isDebugEnabled()) {
            this.debug("DeploymentServiceServlet: authenticateRequest: TIME TOOK: " + l7);
        }
        return authenticatedSubject5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDeploymentServiceMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticatedSubject authenticatedSubject) throws IOException {
        OutputStream outputStream;
        ObjectOutputStream objectOutputStream;
        DeploymentObjectInputStream deploymentObjectInputStream;
        block26: {
            block24: {
                block25: {
                    String string;
                    String string2 = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("serverName"));
                    if (this.isDebugEnabled()) {
                        this.debug("Received req.header serverName: " + string2);
                    }
                    long l = (string = httpServletRequest.getHeader("deployment_request_id")) != null ? Long.parseLong(string) : -1L;
                    String string3 = this.readOrConstructPeerVersion(httpServletRequest);
                    if (this.isDebugEnabled()) {
                        this.debug("Peer Version : " + string3);
                    }
                    boolean bl = Boolean.valueOf(DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("isSynchronous")));
                    if (this.isDebugEnabled()) {
                        this.debug("Received req.header isSynch: " + bl);
                    }
                    httpServletResponse.addHeader("serverName", DeploymentServiceServlet.mimeEncode(this.serverName));
                    deploymentObjectInputStream = null;
                    objectOutputStream = null;
                    outputStream = null;
                    try {
                        try {
                            deploymentObjectInputStream = new DeploymentObjectInputStream((InputStream)httpServletRequest.getInputStream(), string3);
                            DeploymentServiceMessage deploymentServiceMessage = (DeploymentServiceMessage)deploymentObjectInputStream.readObject();
                            ServerResource serverResource = new ServerResource(null, string2, "boot");
                            if (!this.authorizer.isAccessAllowed(authenticatedSubject, (Resource)serverResource, null)) {
                                Loggable loggable = DeploymentServiceLogger.logAccessNotAllowedLoggable((String)string2);
                                if (this.isDebugEnabled()) {
                                    this.debug(loggable.getMessage());
                                    this.debug("DeploymentServiceServlet error - access not allowed");
                                }
                                DeploymentServiceServlet.logAndSendError(httpServletResponse, 401, loggable);
                                Object var18_19 = null;
                                if (deploymentObjectInputStream == null) break block24;
                                break block25;
                            }
                            if (this.isDebugEnabled()) {
                                this.debug("Received DeploymentService message '" + deploymentServiceMessage);
                            }
                            httpServletResponse.setStatus(200);
                            if (bl) {
                                DeploymentServiceMessage deploymentServiceMessage2;
                                if (this.isDebugEnabled()) {
                                    this.debug("Handling synchronous deployment service message");
                                }
                                if ((deploymentServiceMessage2 = this.loopbackReceiver.receiveSynchronousMessage(deploymentServiceMessage)) != null && this.isDebugEnabled()) {
                                    this.debug("Sending out synchronous response " + deploymentServiceMessage2);
                                }
                                httpServletResponse.addHeader("server_version", PeerInfo.getPeerInfo().getVersionAsString());
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                objectOutputStream = new WLObjectOutputStream(byteArrayOutputStream);
                                ((WLObjectOutputStream)objectOutputStream).setReplacer(RemoteObjectReplacer.getReplacer());
                                objectOutputStream.writeObject(deploymentServiceMessage2);
                                objectOutputStream.flush();
                                httpServletResponse.setContentLength(byteArrayOutputStream.size());
                                outputStream = httpServletResponse.getOutputStream();
                                byteArrayOutputStream.writeTo(outputStream);
                                outputStream.flush();
                                break block26;
                            } else {
                                if (this.isDebugEnabled()) {
                                    this.debug("Handling asynchronous deployment service message");
                                }
                                this.loopbackReceiver.receiveMessage(deploymentServiceMessage);
                            }
                            break block26;
                        }
                        catch (Throwable throwable) {
                            httpServletResponse.addHeader("serverName", DeploymentServiceServlet.mimeEncode(this.serverName));
                            String string4 = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
                            if (this.isDebugEnabled()) {
                                this.debug("DeploymentServiceServlet error - " + throwable.getMessage() + " " + string4);
                            }
                            Loggable loggable = DeploymentServiceLogger.logExceptionInServletRequestForDeploymentMsgLoggable((long)l, (String)string2, (String)string4);
                            loggable.log();
                            loggable = DeploymentServiceLogger.logExceptionInServletRequestForDeploymentMsgLoggable((long)l, (String)string2, (String)throwable.getMessage());
                            DeploymentServiceServlet.sendError(httpServletResponse, 500, loggable.getMessage());
                            Object var18_21 = null;
                            if (deploymentObjectInputStream != null) {
                                ((ObjectInputStream)deploymentObjectInputStream).close();
                            }
                            if (objectOutputStream != null) {
                                objectOutputStream.close();
                            }
                            if (outputStream == null) return;
                            outputStream.close();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        if (deploymentObjectInputStream != null) {
                            ((ObjectInputStream)deploymentObjectInputStream).close();
                        }
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (outputStream == null) throw throwable;
                        outputStream.close();
                        throw throwable;
                    }
                }
                ((ObjectInputStream)deploymentObjectInputStream).close();
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (outputStream == null) return;
            outputStream.close();
            return;
        }
        Object var18_20 = null;
        if (deploymentObjectInputStream != null) {
            ((ObjectInputStream)deploymentObjectInputStream).close();
        }
        if (objectOutputStream != null) {
            objectOutputStream.close();
        }
        if (outputStream == null) return;
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDataTransferRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticatedSubject authenticatedSubject) throws IOException {
        String string;
        if (this.isDebugEnabled()) {
            this.debug("Received DataTransferRequest : ");
        }
        String string2 = this.readOrConstructPeerVersion(httpServletRequest);
        if (this.isDebugEnabled()) {
            this.debug("Peer Version : " + string2);
        }
        long l = (string = httpServletRequest.getHeader("deployment_request_id")) != null ? Long.parseLong(string) : -1L;
        String string3 = DeploymentServiceServlet.mimeDecode(httpServletRequest.getHeader("serverName"));
        DeploymentObjectInputStream deploymentObjectInputStream = null;
        try {
            try {
                deploymentObjectInputStream = new DeploymentObjectInputStream((InputStream)httpServletRequest.getInputStream(), string2);
                DataTransferRequest dataTransferRequest = (DataTransferRequest)deploymentObjectInputStream.readObject();
                MultiDataStream multiDataStream = DataHandlerManager.getInstance().getHttpDataTransferHandler().getDataAsStream(dataTransferRequest);
                String string4 = dataTransferRequest.getLockPath();
                FileLock fileLock = null;
                try {
                    if (string4 != null && string4.length() > 0) {
                        fileLock = this.lockFile(string4);
                    }
                    MultipartResponse multipartResponse = new MultipartResponse(httpServletResponse, multiDataStream);
                    multipartResponse.write();
                    Object var16_17 = null;
                    this.unlockFile(fileLock);
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    this.unlockFile(fileLock);
                    throw throwable;
                }
                Object var18_20 = null;
                if (deploymentObjectInputStream == null) return;
            }
            catch (Throwable throwable) {
                String string5 = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentServiceServlet error - " + throwable.getMessage() + " " + string5);
                }
                Loggable loggable = DeploymentServiceLogger.logExceptionInServletRequestForDatatransferMsgLoggable((long)l, (String)string3, (String)string5);
                loggable.log();
                loggable = DeploymentServiceLogger.logExceptionInServletRequestForDatatransferMsgLoggable((long)l, (String)string3, (String)throwable.getMessage());
                DeploymentServiceServlet.sendError(httpServletResponse, 500, loggable.getMessage());
                Object var18_21 = null;
                if (deploymentObjectInputStream == null) return;
                ((ObjectInputStream)deploymentObjectInputStream).close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            if (deploymentObjectInputStream == null) throw throwable;
            ((ObjectInputStream)deploymentObjectInputStream).close();
            throw throwable;
        }
        ((ObjectInputStream)deploymentObjectInputStream).close();
    }

    public Object run() throws ServletException {
        super.init(this.config);
        return null;
    }

    public static URL getURL() throws MalformedURLException {
        ManagementService.getPropertyService(kernelId);
        String string = PropertyService.getAdminHttpUrl();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return new URL(string + "bea_wls_deployment_internal/DeploymentService");
    }

    private static void sendError(HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        if (!httpServletResponse.isCommitted()) {
            httpServletResponse.sendError(n, string);
            httpServletResponse.addHeader("ErrorMsg", string);
        }
    }

    private static void logAndSendError(HttpServletResponse httpServletResponse, int n, Loggable loggable) throws IOException {
        loggable.log();
        DeploymentServiceServlet.sendError(httpServletResponse, n, loggable.getMessage());
    }

    private FileLock lockFile(String string) {
        if (string == null) {
            return null;
        }
        FileLock fileLock = null;
        try {
            String string2 = DomainDir.getRootDir() + File.separator;
            String string3 = string2 + string;
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileLock = FileUtils.getFileLock((FileChannel)fileOutputStream.getChannel(), (long)30000L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileLock;
    }

    private void unlockFile(FileLock fileLock) {
        if (fileLock != null) {
            try {
                fileLock.release();
                fileLock.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String mimeDecode(String string) {
        String string2 = null;
        try {
            if (string != null) {
                string2 = MimeUtility.decodeText((String)string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    private static String mimeEncode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.encodeText((String)string, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    private String readOrConstructPeerVersion(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = httpServletRequest.getHeader("server_version");
        if (this.isDebugEnabled()) {
            this.debug("Received req.header server_version: " + string2);
        }
        String string3 = string = string2 == null || string2.length() == 0 ? PeerInfo.getPeerInfo().getVersionAsString() : string2;
        if (this.isDebugEnabled()) {
            this.debug("decided peerVersion: " + string);
        }
        return string;
    }

    static final class MyCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public MyCallbackHandler(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Object object;
                if (callbackArray[i] instanceof NameCallback) {
                    object = (NameCallback)callbackArray[i];
                    ((NameCallback)object).setName(this.username);
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    object = (PasswordCallback)callbackArray[i];
                    ((PasswordCallback)object).setPassword(this.password.toCharArray());
                    continue;
                }
                object = DeploymentServiceLogger.unrecognizedCallback();
                throw new UnsupportedCallbackException(callbackArray[i], (String)object);
            }
        }
    }
}

