/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.transport.http;

import java.rmi.RemoteException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.deploy.service.internal.transport.MessageDispatcher;
import weblogic.deploy.service.internal.transport.MessageReceiver;

public class HTTPMessageReceiver
implements MessageReceiver {
    private static final HTTPMessageReceiver SINGLETON = new HTTPMessageReceiver();
    private MessageDispatcher dispatcher = null;

    public HTTPMessageReceiver() {
        Debug.serviceHttpDebug("Created HTTPMessageReceiver");
    }

    public static MessageReceiver getMessageReceiver() {
        return SINGLETON;
    }

    public void setDispatcher(MessageDispatcher messageDispatcher) {
        if (this.dispatcher == null) {
            this.dispatcher = messageDispatcher;
        }
    }

    public void receiveMessage(DeploymentServiceMessage deploymentServiceMessage) throws Exception {
        this.dispatcher.dispatch(deploymentServiceMessage);
    }

    public DeploymentServiceMessage receiveSynchronousMessage(DeploymentServiceMessage deploymentServiceMessage) throws RemoteException {
        DeploymentServiceMessage deploymentServiceMessage2 = this.dispatcher.blockingDispatch(deploymentServiceMessage);
        return deploymentServiceMessage2;
    }
}

