/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import javax.mail.internet.MimeUtility;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.deploy.common.Debug;
import weblogic.deploy.common.DeploymentObjectInputStream;
import weblogic.deploy.service.internal.transport.DeploymentServiceMessage;
import weblogic.deploy.service.internal.transport.MessageReceiver;
import weblogic.deploy.service.internal.transport.MessageSender;
import weblogic.deploy.service.internal.transport.UnreachableHostException;
import weblogic.deploy.service.internal.transport.http.DeploymentServiceConstants;
import weblogic.deploy.utils.DeploymentServletConstants;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.protocol.URLManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;

public final class HTTPMessageSender
implements MessageSender,
DeploymentServletConstants,
DeploymentServiceConstants {
    private static final String DEPLOYMENT_APPNAME = "bea_wls_deployment_internal";
    private static final HTTPMessageSender SINGLETON = new HTTPMessageSender();
    private String userName;
    private String password;
    private MessageReceiver loopbackReceiver;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private HTTPMessageSender() {
        if (HTTPMessageSender.isDebugEnabled()) {
            HTTPMessageSender.debug("Created HTTPMessageSender");
        }
    }

    private static final boolean isDebugEnabled() {
        return Debug.isServiceHttpDebugEnabled();
    }

    private static final void debug(String string) {
        Debug.serviceHttpDebug(string);
    }

    private String getUserName() {
        if (this.userName == null) {
            this.userName = ManagementService.getPropertyService(kernelId).getTimestamp1();
        }
        return this.userName;
    }

    private String getUserCredential() {
        if (this.password == null) {
            this.password = ManagementService.getPropertyService(kernelId).getTimestamp2();
        }
        return this.password;
    }

    private static String getAdminUrl() {
        ManagementService.getPropertyService(kernelId);
        return PropertyService.getAdminHttpUrl();
    }

    private static String[] getAllAdminUrls() {
        return PropertyService.getAllAdminHttpUrls();
    }

    public static HTTPMessageSender getMessageSender() {
        return SINGLETON;
    }

    public void sendHeartbeatMessage(DeploymentServiceMessage deploymentServiceMessage, String string) throws Exception {
        block2: {
            try {
                String string2 = HTTPMessageSender.getURL(string);
                this.sendMessageToServerURL(deploymentServiceMessage, string2, string, false, 60000);
            }
            catch (UnreachableHostException unreachableHostException) {
                if (!HTTPMessageSender.isDebugEnabled()) break block2;
                HTTPMessageSender.debug(" UnreachableHost : " + StackTraceUtils.throwable2StackTrace((Throwable)unreachableHostException));
            }
        }
    }

    public void sendMessageToTargetServer(DeploymentServiceMessage deploymentServiceMessage, String string) throws RemoteException {
        String string2 = HTTPMessageSender.getURL(string);
        this.sendMessageToServerURL(deploymentServiceMessage, string2, string, true, 0);
    }

    public void sendMessageToAdminServer(DeploymentServiceMessage deploymentServiceMessage) throws RemoteException {
        String string = null;
        String string2 = null;
        if (!HTTPMessageSender.isAdminServer()) {
            string2 = HTTPMessageSender.getAdminUrl();
        }
        try {
            this.sendMessageToServerURL(deploymentServiceMessage, string2, string, true, 0);
        }
        catch (UnreachableHostException unreachableHostException) {
            this.sendMessageToAdminServerViaAlternateUrls(string2, deploymentServiceMessage, true);
        }
    }

    private DeploymentServiceMessage sendMessageToAdminServerViaAlternateUrls(String string, DeploymentServiceMessage deploymentServiceMessage, boolean bl) throws RemoteException {
        String string2;
        String[] stringArray = HTTPMessageSender.getAllAdminUrls();
        String string3 = null;
        UnreachableHostException unreachableHostException = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            if (string != null && string.equals(string2)) continue;
            try {
                if (HTTPMessageSender.isDebugEnabled()) {
                    HTTPMessageSender.debug("Retrying attempt to send to admin server via alternate url '" + string2);
                }
                return this.sendMessageToServerURL(deploymentServiceMessage, string2, string3, bl, 0);
            }
            catch (UnreachableHostException unreachableHostException2) {
                if (unreachableHostException == null) continue;
                unreachableHostException = unreachableHostException2;
                continue;
            }
            catch (RemoteException remoteException) {
                String string4 = DeployerRuntimeLogger.altURLFailed((String)string2);
                throw new RemoteException(string4);
            }
        }
        if (unreachableHostException != null) {
            throw unreachableHostException;
        }
        string2 = DeployerRuntimeLogger.adminUnreachable((String)StringUtils.join((String[])stringArray, (String)","));
        throw new RemoteException(string2);
    }

    public DeploymentServiceMessage sendBlockingMessageToAdminServer(DeploymentServiceMessage deploymentServiceMessage) throws RemoteException {
        String string = null;
        String string2 = null;
        if (!HTTPMessageSender.isAdminServer()) {
            string2 = HTTPMessageSender.getAdminUrl();
        }
        try {
            return this.sendMessageToServerURL(deploymentServiceMessage, string2, string, true, 0);
        }
        catch (UnreachableHostException unreachableHostException) {
            return this.sendMessageToAdminServerViaAlternateUrls(string2, deploymentServiceMessage, true);
        }
    }

    public void setLoopbackReceiver(MessageReceiver messageReceiver) {
        if (this.loopbackReceiver == null) {
            this.loopbackReceiver = messageReceiver;
        }
        if (HTTPMessageSender.isDebugEnabled()) {
            HTTPMessageSender.debug("setting loopback messageReceiver to '" + messageReceiver + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeploymentServiceMessage sendMessageToServerURL(DeploymentServiceMessage deploymentServiceMessage, String string, String string2, boolean bl, int n) throws RemoteException {
        URL uRL;
        boolean bl2 = false;
        if (HTTPMessageSender.isAdminServer() && (string2 == null || string2.equals(ManagementService.getRuntimeAccess(kernelId).getServerName()))) {
            bl2 = true;
            string2 = "loopback admin";
        }
        if (HTTPMessageSender.isDebugEnabled()) {
            HTTPMessageSender.debug("sending message for id '" + deploymentServiceMessage.getDeploymentId() + "' to '" + string2 + "' using URL '" + string + "' via http");
        }
        if (bl2) {
            try {
                if (bl) {
                    return this.loopbackReceiver.receiveSynchronousMessage(deploymentServiceMessage);
                }
                this.loopbackReceiver.receiveMessage(deploymentServiceMessage);
                return null;
            }
            catch (Exception exception) {
                String string4 = DeployerRuntimeLogger.errorReceivingMessage();
                throw new RemoteException(string4, exception);
            }
        }
        try {
            uRL = new URL(string + "/" + DEPLOYMENT_APPNAME + "/DeploymentService");
        }
        catch (MalformedURLException malformedURLException) {
            String string5 = DeployerRuntimeLogger.malformedURL((String)string);
            throw new RemoteException(string5, malformedURLException);
        }
        int n2 = -1;
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                httpURLConnection = URLManager.createAdminHttpConnection(uRL);
                httpURLConnection.setRequestProperty("wl_request_type", HTTPMessageSender.mimeEncode("deployment_svc_msg"));
                if (ManagementService.isRuntimeAccessInitialized()) {
                    ConnectionSigner.signConnection(httpURLConnection, kernelId);
                } else {
                    httpURLConnection.setRequestProperty("username", HTTPMessageSender.mimeEncode(this.getUserName()));
                    httpURLConnection.setRequestProperty("password", HTTPMessageSender.mimeEncode(this.getUserCredential()));
                }
                httpURLConnection.setRequestProperty("serverName", HTTPMessageSender.mimeEncode(ManagementService.getPropertyService(kernelId).getServerName()));
                httpURLConnection.setRequestProperty("server_version", PeerInfo.getPeerInfo().getVersionAsString());
                httpURLConnection.setRequestProperty("isSynchronous", HTTPMessageSender.mimeEncode(Boolean.valueOf(bl).toString()));
                httpURLConnection.setRequestProperty("deployment_request_id", Long.toString(deploymentServiceMessage.getDeploymentId()));
                httpURLConnection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                if (n > 0) {
                    httpURLConnection.setConnectTimeout(n);
                    httpURLConnection.setReadTimeout(n);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                WLObjectOutputStream wLObjectOutputStream = new WLObjectOutputStream(byteArrayOutputStream);
                wLObjectOutputStream.setReplacer(RemoteObjectReplacer.getReplacer());
                wLObjectOutputStream.writeObject(deploymentServiceMessage);
                wLObjectOutputStream.flush();
                httpURLConnection.setRequestProperty("Content-Length", "" + byteArrayOutputStream.size());
                OutputStream outputStream = httpURLConnection.getOutputStream();
                byteArrayOutputStream.writeTo(outputStream);
                outputStream.flush();
                outputStream.close();
                if (bl) {
                    String string3;
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 != 200) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(DeployerRuntimeLogger.errorReadingInput());
                        stringBuffer.append(" : with response code '").append(n2).append("'");
                        stringBuffer.append(" : with response message '");
                        stringBuffer.append(httpURLConnection.getResponseMessage()).append("'");
                        if (!HTTPMessageSender.isServerStandby(string2)) throw new RemoteException(stringBuffer.toString());
                        throw new ConnectException(stringBuffer.toString());
                    }
                    String string6 = httpURLConnection.getHeaderField("server_version");
                    String string4 = string3 = string6 == null || string6.length() == 0 ? PeerInfo.getPeerInfo().getVersionAsString() : string6;
                    if (HTTPMessageSender.isDebugEnabled()) {
                        HTTPMessageSender.debug("Response Peer Version: " + string3);
                    }
                    DeploymentObjectInputStream deploymentObjectInputStream = new DeploymentObjectInputStream(httpURLConnection.getInputStream(), string3);
                    DeploymentServiceMessage deploymentServiceMessage2 = (DeploymentServiceMessage)deploymentObjectInputStream.readObject();
                    Object var18_28 = null;
                    if (httpURLConnection == null) return deploymentServiceMessage2;
                    httpURLConnection.disconnect();
                    return deploymentServiceMessage2;
                }
                Object var18_29 = null;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (ConnectException connectException) {
                throw new UnreachableHostException(string2, connectException);
            }
            catch (UnknownHostException unknownHostException) {
                throw new UnreachableHostException(string2, unknownHostException);
            }
            catch (IOException iOException) {
                if (iOException instanceof RemoteException) {
                    throw (RemoteException)iOException;
                }
                n2 = 404;
                if (HTTPMessageSender.isDebugEnabled()) {
                    HTTPMessageSender.debug("HTTPMessageSender: IOException: " + iOException.toString() + " when making a DeploymentServiceMsg request to " + "URL: " + uRL.toString());
                    HTTPMessageSender.debug("Exception StackTrace: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
                }
                String string8 = DeployerRuntimeLogger.errorReadingInput();
                throw new RemoteException(string8, iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!HTTPMessageSender.isDebugEnabled()) throw new RemoteException(classNotFoundException.toString(), classNotFoundException);
                HTTPMessageSender.debug("HTTPMessageSender: ClassNotFoundException: " + classNotFoundException.toString() + " when making a DeploymentServiceMsg request to " + "URL: " + uRL.toString());
                throw new RemoteException(classNotFoundException.toString(), classNotFoundException);
            }
            catch (Throwable throwable) {
                if (!HTTPMessageSender.isDebugEnabled()) throw new RemoteException(throwable.toString(), throwable);
                HTTPMessageSender.debug("HTTPMessageSender: Throwable: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable) + " when making a DeploymentServiceMsg request to " + "URL: " + uRL.toString());
                throw new RemoteException(throwable.toString(), throwable);
            }
        }
        catch (Throwable throwable) {
            Object var18_30 = null;
            if (httpURLConnection == null) throw throwable;
            httpURLConnection.disconnect();
            throw throwable;
        }
        if (n2 == 404) {
            Debug.serviceHttpDebug("HTTPMessageSender: HTTP_NOT_FOUND error when making a DeploymentServiceMsg request to URL: " + uRL.toString());
            return null;
        }
        if (n2 == 401) {
            Debug.serviceHttpDebug("HTTPMessageSender: HTTP_UNAUTHORIZED error when making a DeploymentServiceMsg request to URL: " + uRL.toString());
            return null;
        }
        if (n2 != 500 && n2 != 409) {
            if (n2 != 503) return null;
            Debug.serviceHttpDebug("HTTPMessageSender: HTTP_UNAVAILABLE error when making a DeploymentServiceMsg request to URL: " + uRL.toString());
            return null;
        }
        Debug.serviceHttpDebug("HTTPMessageSender: " + (n2 == 500 ? "HTTP_INTERNAL_ERROR" : "HTTP_CONFLICT") + "error when making a DeploymentServiceMsg request to " + "URL: " + uRL.toString());
        return null;
    }

    private static boolean isAdminServer() {
        return ManagementService.getPropertyService(kernelId).isAdminServer();
    }

    private static String getURL(String string) throws UnreachableHostException {
        try {
            String string2 = URLManager.findAdministrationURL(string);
            string2 = URLManager.normalizeToHttpProtocol(string2);
            if (string2 == null) {
                throw new UnreachableHostException(string, null);
            }
            return string2;
        }
        catch (UnknownHostException unknownHostException) {
            throw new UnreachableHostException(string, unknownHostException);
        }
    }

    private static boolean isServerStandby(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ServerMBean serverMBean = domainMBean.lookupServer(string);
        return serverMBean != null && "STANDBY".equals(serverMBean.getStartupMode());
    }

    private static String mimeDecode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.decodeText((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    private static String mimeEncode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.encodeText((String)string, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }
}

