/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.MimeUtility;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.utils.JMXDeployerHelper;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.deploy.utils.DeployerHelperException;
import weblogic.deploy.utils.DeployerHelperFilter;
import weblogic.deploy.utils.DeployerHelperListener;
import weblogic.deploy.utils.RemoteDeployerHelperListener;
import weblogic.deploy.utils.TaskCompletionNotificationFilter;
import weblogic.deploy.utils.TaskCompletionNotificationListener;
import weblogic.management.DeploymentNotification;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.utils.DeployerHelperTextFormatter;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.utils.Debug;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class DeployerHelper {
    public static final String HTTP_STRING = "http";
    public static final String HTTPS_STRING = "https";
    public static final String T3_STRING = "t3";
    public static final String T3S_STRING = "t3s";
    public static final String IIOP_STRING = "iiop";
    public static final String IIOPS_STRING = "iiops";
    private static final String DEPLOYER_MBEAN_TYPE = "DeployerRuntime";
    private static final String APPLICATION_MBEAN_TYPE = "Application";
    private static final String MIME_BOUNDARY = "---------------------------7d01b33320494";
    private static final String TEMP_FILE_PREFIX = "wl_comp";
    private static final String TEMP_FILE_EXT = ".jar";
    private MBeanHome mBeanHome;
    private MBeanServerConnection mbeanServerConnection;
    private JMXDeployerHelper jmxHelper;
    private DeployerRuntimeMBean deployer;
    private static final DeployerHelperTextFormatter textFormatter = new DeployerHelperTextFormatter();
    private static DeployerTextFormatter messageFormatter = new DeployerTextFormatter();
    private boolean isUsingMBeanServerConnection = false;
    private boolean formatted = false;
    private TaskCompletionNotificationListener taskCompletion = null;

    private DeployerHelper() {
    }

    public DeployerHelper(MBeanHome mBeanHome) {
        this();
        this.mBeanHome = mBeanHome;
        this.isUsingMBeanServerConnection = false;
    }

    public DeployerHelper(MBeanServerConnection mBeanServerConnection) {
        this();
        this.mbeanServerConnection = mBeanServerConnection;
        try {
            this.jmxHelper = new JMXDeployerHelper(this.mbeanServerConnection);
        }
        catch (weblogic.deploy.api.internal.utils.DeployerHelperException deployerHelperException) {
            throw new ServerConnectionException(deployerHelperException.getMessage(), deployerHelperException);
        }
        this.isUsingMBeanServerConnection = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createJarFromDirectory(File file, File file2, File file3, Set set) throws IOException {
        if (file2 == null) {
            file2 = file;
        }
        File file4 = null;
        ZipOutputStream zipOutputStream = null;
        try {
            file4 = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_EXT, file3);
            file4.deleteOnExit();
            zipOutputStream = new JarOutputStream(new FileOutputStream(file4));
            String string = file.toString().replace(File.separatorChar, '/');
            DeployerHelper.addFileOrDirectoryToJar(string.length(), file2, (JarOutputStream)zipOutputStream, set);
            File file5 = file4;
            return file5;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addFileOrDirectoryToJar(int n, File file, JarOutputStream jarOutputStream, Set set) throws IOException {
        String string = file.toString().replace(File.separatorChar, '/');
        string = string.length() > n ? string.substring(n + 1) : (string.length() == n && file.isFile() ? file.getName() : "");
        if (file.isDirectory()) {
            if (set != null && set.contains(string)) {
                set.remove(string);
                set = null;
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                DeployerHelper.addFileOrDirectoryToJar(n, file2, jarOutputStream, set);
            }
            return;
        } else {
            InputStream inputStream = null;
            try {
                File file3 = file;
                if (set != null && !set.contains(string)) return;
                if (set != null) {
                    set.remove(string);
                }
                JarEntry jarEntry = new JarEntry(string);
                jarEntry.setTime(file3.lastModified());
                jarOutputStream.putNextEntry(jarEntry);
                byte[] byArray = new byte[4096];
                int n2 = 0;
                inputStream = new BufferedInputStream(new FileInputStream(file3));
                while ((n2 = inputStream.read(byArray)) != -1) {
                    jarOutputStream.write(byArray, 0, n2);
                }
                return;
            }
            catch (Exception exception) {
                String string2 = DeployerHelperTextFormatter.getInstance().exceptionArchivingFile(file.toString(), exception.toString());
                if (!(exception instanceof IOException)) throw new IOException(string2);
                throw (IOException)exception;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    public MBeanHome getBeanHome() {
        return this.mBeanHome;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbeanServerConnection;
    }

    public DeployerRuntimeMBean getDeployer() {
        if (this.deployer != null) {
            return this.deployer;
        }
        if (!this.isUsingMBeanServerConnection) {
            Set set = this.mBeanHome.getMBeansByType(DEPLOYER_MBEAN_TYPE);
            if (set.size() != 1) {
                return null;
            }
            this.deployer = (DeployerRuntimeMBean)set.iterator().next();
            return this.deployer;
        }
        try {
            this.deployer = this.jmxHelper.getDeployer();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.deployer;
    }

    public DeploymentTaskRuntimeMBean getTaskByID(String string) {
        return this.getDeployer().query(string);
    }

    public DeploymentTaskRuntimeMBean[] getAllTasks() {
        return this.getDeployer().list();
    }

    public ApplicationMBean getApplication(String string) throws InstanceNotFoundException {
        if (!this.isUsingMBeanServerConnection) {
            return (ApplicationMBean)this.mBeanHome.getMBean(APPLICATION_MBEAN_TYPE, string);
        }
        DomainMBean domainMBean = this.jmxHelper.getDomain();
        return domainMBean.lookupApplication(string);
    }

    public List getAppDeployments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isUsingMBeanServerConnection) {
            DomainMBean domainMBean = this.jmxHelper.getDomain();
            AppDeploymentMBean[] appDeploymentMBeanArray = domainMBean.getAppDeployments();
            for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
                if (appDeploymentMBeanArray[i].isInternalApp()) continue;
                String string = ApplicationVersionUtils.getDisplayName(appDeploymentMBeanArray[i]);
                arrayList.add(string);
            }
            return arrayList;
        }
        Set set = this.mBeanHome.getMBeansByType(APPLICATION_MBEAN_TYPE);
        for (ApplicationMBean applicationMBean : set) {
            if (applicationMBean.isInternalApp()) continue;
            arrayList.add(applicationMBean.getName());
        }
        return arrayList;
    }

    public String getAdminServerName() {
        if (!this.isUsingMBeanServerConnection) {
            DomainMBean domainMBean = this.mBeanHome.getActiveDomain();
            return domainMBean.getAdminServerName();
        }
        return this.jmxHelper.getDomain().getAdminServerName();
    }

    public boolean isSourceArchive(String string) {
        File file = new File(string);
        return file.isFile();
    }

    public void initiateListening(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) throws InstanceNotFoundException {
        ApplicationMBean applicationMBean = deploymentTaskRuntimeMBean.getDeploymentObject();
        if (applicationMBean == null) {
            return;
        }
        if (!this.isUsingMBeanServerConnection) {
            RemoteMBeanServer remoteMBeanServer = this.mBeanHome.getMBeanServer();
            try {
                remoteMBeanServer.addNotificationListener((ObjectName)applicationMBean.getObjectName(), new RemoteDeployerHelperListener(deploymentTaskRuntimeMBean.getId(), this), (NotificationFilter)new DeployerHelperFilter(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            this.mbeanServerConnection.addNotificationListener((ObjectName)applicationMBean.getObjectName(), new DeployerHelperListener(deploymentTaskRuntimeMBean.getId(), this), (NotificationFilter)new DeployerHelperFilter(), null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String uploadSource(String string, String string2, String string3, String string4, String[] stringArray, String string5) throws DeployerHelperException {
        String string6 = null;
        String string7 = null;
        try {
            String string8;
            string7 = this.getDSSUrl(string);
            HttpURLConnection httpURLConnection = this.getDSSConnection(string7);
            this.initConnection(string2, string3, string5, httpURLConnection, "app_upload");
            File file = new File(string4);
            String string9 = file.getName();
            if (this.isSourceArchive(string4)) {
                string8 = "true";
            } else {
                string8 = "false";
                string9 = string9.concat(TEMP_FILE_EXT);
            }
            httpURLConnection.setRequestProperty("archive", string8);
            httpURLConnection.setRequestProperty("wl_upload_delta", Boolean.toString(stringArray != null));
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            BufferedInputStream bufferedInputStream = this.getInputStreamForSource(string4, stringArray);
            this.transferData(bufferedInputStream, (OutputStream)unsyncByteArrayOutputStream, string9);
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(unsyncByteArrayOutputStream.size()));
            OutputStream outputStream = httpURLConnection.getOutputStream();
            unsyncByteArrayOutputStream.writeTo(outputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            string6 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DeployerHelperException(uRISyntaxException.toString(), uRISyntaxException);
        }
        catch (IOException iOException) {
            throw new DeployerHelperException(textFormatter.exceptionUploadingSource(string7, string5, string4), iOException);
        }
        return string6;
    }

    public String uploadPlan(String string, String string2, String string3, String string4, String string5) throws DeployerHelperException {
        String string6 = null;
        String string7 = null;
        try {
            string7 = this.getDSSUrl(string);
            HttpURLConnection httpURLConnection = this.getDSSConnection(string7);
            this.initConnection(string2, string3, string5, httpURLConnection, "plan_upload");
            File file = new File(string4);
            String string8 = file.getName();
            if (file.isDirectory()) {
                httpURLConnection.setRequestProperty("archive", "false");
                string8 = string8.concat(TEMP_FILE_EXT);
            }
            OutputStream outputStream = httpURLConnection.getOutputStream();
            BufferedInputStream bufferedInputStream = this.getInputStreamForSource(string4, null);
            this.transferData(bufferedInputStream, outputStream, string8);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            string6 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DeployerHelperException(uRISyntaxException.toString(), uRISyntaxException);
        }
        catch (IOException iOException) {
            throw new DeployerHelperException(textFormatter.exceptionUploadingSource(string7, string5, string4), iOException);
        }
        return string6;
    }

    public void setFormatted(boolean bl) {
        this.formatted = bl;
    }

    private void transferData(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        int n;
        PrintStream printStream = new PrintStream(outputStream);
        String string2 = "-----------------------------7d01b33320494\r\n";
        string2 = string2 + "Content-Disposition: form-data; name=\"file\"; filename=\"" + string + "\"\r\n";
        string2 = string2 + "Content-Type: application/x-zip-compressed\r\n";
        string2 = string2 + "\r\n";
        printStream.print(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            dataOutputStream.write(byArray, 0, n);
        }
        printStream.print("\r\n-----------------------------7d01b33320494--");
        printStream.flush();
        printStream.close();
        dataOutputStream.close();
        inputStream.close();
    }

    private void initConnection(String string, String string2, String string3, HttpURLConnection httpURLConnection, String string4) {
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setAllowUserInteraction(true);
        httpURLConnection.setRequestProperty("wl_request_type", DeployerHelper.mimeEncode(string4));
        httpURLConnection.setRequestProperty("username", DeployerHelper.mimeEncode(string));
        httpURLConnection.setRequestProperty("password", DeployerHelper.mimeEncode(string2));
        if (string3 != null) {
            httpURLConnection.setRequestProperty("wl_upload_application_name", string3);
        }
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=---------------------------7d01b33320494");
    }

    private String getDSSUrl(String string) throws URISyntaxException {
        if (!string.startsWith(HTTP_STRING)) {
            URI uRI = new URI(string);
            URI uRI2 = new URI(this.getHTTPProtocol(uRI.getScheme()), null, uRI.getHost(), uRI.getPort(), null, null, null);
            string = uRI2.toString();
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string + "bea_wls_deployment_internal/DeploymentService";
    }

    private HttpURLConnection getDSSConnection(String string) throws IOException {
        URL uRL = new URL(string);
        return (HttpURLConnection)uRL.openConnection();
    }

    private String getHTTPProtocol(String string) {
        if (string.equals(HTTPS_STRING) || string.equals(T3S_STRING) || string.equals(IIOPS_STRING)) {
            return HTTPS_STRING;
        }
        return HTTP_STRING;
    }

    BufferedInputStream getInputStreamForSource(String string, String[] stringArray) throws IOException, DeployerHelperException {
        String string2 = string;
        try {
            URL uRL = new URL(string);
            return new BufferedInputStream(uRL.openStream());
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists()) {
                throw new DeployerHelperException(textFormatter.exceptionNoSuchSource(string));
            }
            TreeSet<String> treeSet = null;
            if (stringArray != null) {
                treeSet = new TreeSet<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].replace(File.separatorChar, '/');
                    treeSet.add(string3);
                }
            }
            if (file.isDirectory()) {
                file = DeployerHelper.createJarFromDirectory(file, null, null, treeSet);
            }
            if (stringArray != null && treeSet != null && treeSet.size() > 0) {
                throw new DeployerHelperException(textFormatter.exceptionUploadingFiles(((Object)treeSet).toString(), string2));
            }
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    public void registerTaskCompletionNotificationListener(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        try {
            if (this.isUsingMBeanServerConnection) {
                Debug.assertion((deploymentTaskRuntimeMBean != null ? 1 : 0) != 0);
                this.taskCompletion = new TaskCompletionNotificationListener(deploymentTaskRuntimeMBean);
                this.mbeanServerConnection.addNotificationListener((ObjectName)deploymentTaskRuntimeMBean.getObjectName(), this.taskCompletion, (NotificationFilter)new TaskCompletionNotificationFilter(), null);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void waitForTaskCompletion(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean, long l) {
        if (this.isUsingMBeanServerConnection && this.taskCompletion != null) {
            long l2 = l - System.currentTimeMillis();
            if (l2 > 0L) {
                this.taskCompletion.waitForTaskCompletion(l2);
            }
            return;
        }
        deploymentTaskRuntimeMBean.waitForTaskCompletion(l);
    }

    protected final void showDeploymentNotificationInformation(String string, DeploymentNotification deploymentNotification) {
        if (this.formatted) {
            String string2 = this.translateNotificationType(deploymentNotification.getPhase());
            if (deploymentNotification.isAppNotification()) {
                DeployerHelper.println(messageFormatter.showDeploymentNotification(string, string2, deploymentNotification.getAppName(), deploymentNotification.getServerName()));
            }
        } else {
            String string3 = deploymentNotification.getAppName();
            String string4 = deploymentNotification.getServerName();
            String string5 = null;
            String string6 = null;
            if (deploymentNotification.isModuleNotification()) {
                string6 = deploymentNotification.getModuleName();
                String string7 = deploymentNotification.getCurrentState();
                String string8 = deploymentNotification.getTargetState();
                String string9 = deploymentNotification.getTransition();
                if (string9.equals("end")) {
                    string5 = messageFormatter.successfulTransition(string6, string7, string8, string4);
                } else if (string9.equals("failed")) {
                    string5 = messageFormatter.failedTransition(string6, string7, string8, string4);
                }
                if (string5 != null) {
                    DeployerHelper.println(string5);
                }
            } else {
                String string10 = deploymentNotification.getPhase();
                DeployerHelper.println(messageFormatter.appNotification(string3, string4, string10));
            }
        }
    }

    private String translateNotificationType(String string) {
        if ("activated".equals(string)) {
            return messageFormatter.messageNotificationActivated();
        }
        if ("activating".equals(string)) {
            return messageFormatter.messageNotificationActivating();
        }
        if ("deactivated".equals(string)) {
            return messageFormatter.messageNotificationDeactivated();
        }
        if ("deactivating".equals(string)) {
            return messageFormatter.messageNotificationDeactivating();
        }
        if ("prepared".equals(string)) {
            return messageFormatter.messageNotificationPrepared();
        }
        if ("preparing".equals(string)) {
            return messageFormatter.messageNotificationPreparing();
        }
        if ("unprepared".equals(string)) {
            return messageFormatter.messageNotificationUnprepared();
        }
        if ("unpreparing".equals(string)) {
            return messageFormatter.messageNotificationUnpreparing();
        }
        if ("distributing".equals(string)) {
            return messageFormatter.messageNotificationDistributing();
        }
        if ("distributed".equals(string)) {
            return messageFormatter.messageNotificationDistributed();
        }
        if ("failed".equals(string)) {
            return messageFormatter.messageNotificationFailed();
        }
        return string;
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static String mimeEncode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.encodeText((String)string, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }
}

