/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.deploy.utils.MBeanHomeToolException;
import weblogic.jndi.Environment;
import weblogic.kernel.Kernel;
import weblogic.management.MBeanHome;
import weblogic.management.deploy.utils.MBeanHomeToolTextFormatter;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.utils.Getopt2;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.compiler.Tool;
import weblogic.utils.io.TerminalIO;

public abstract class MBeanHomeTool
extends Tool {
    public static final String DEFAULT_ADMIN_URL = "t3://localhost:7001";
    public static final String DEFAULT_PROTOCOL = "t3://";
    public static final String DEFAULT_USER = null;
    public static final String DEFAULT_USER_VALUE = "installadministrator";
    public static final String OPTION_ADMIN_URL = "adminurl";
    public static final String OPTION_USER = "user";
    public static final String OPTION_PASSWORD = "password";
    public static final String HTTP_STRING = "http";
    public static final String HTTPS_STRING = "https";
    public static final String T3_STRING = "t3";
    public static final String T3S_STRING = "t3s";
    public static final String OPTION_USERNAME = "username";
    public static final String OPTION_URL = "url";
    public static final String IIOP_STRING = "iiop";
    public static final String OPTION_USERCONFIG = "userconfigfile";
    public static final String DEFAULT_USERCONFIG = null;
    public static final String OPTION_USERKEY = "userkeyfile";
    public static final String DEFAULT_USERKEY = null;
    private MBeanHomeToolTextFormatter textFormatter;
    private String password;
    private String user;
    private UsernameAndPassword UandP = null;
    private String userConfigFile = null;
    private String userKeyFile = null;
    private MBeanHome mbh = null;
    private Context ctx = null;
    private JMXConnector jmx = null;
    private MBeanServerConnection mbs = null;

    public MBeanHomeTool(MBeanHome mBeanHome, String[] stringArray) {
        super(stringArray);
        this.mbh = mBeanHome;
        this.textFormatter = new MBeanHomeToolTextFormatter();
    }

    public MBeanHomeTool(String[] stringArray) {
        super(stringArray);
        this.textFormatter = new MBeanHomeToolTextFormatter();
    }

    public Getopt2 getOpts() {
        return this.opts;
    }

    private InitialContext getInitialContext() throws NamingException {
        String string = "weblogic.jndi.WLInitialContextFactory";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", string);
        return new InitialContext(hashtable);
    }

    public MBeanHome getMBeanHome() throws MBeanHomeToolException {
        if (this.mbh != null) {
            return this.mbh;
        }
        String string = this.opts.getOption(OPTION_ADMIN_URL, DEFAULT_ADMIN_URL);
        String string2 = null;
        try {
            if (Kernel.isServer()) {
                this.ctx = this.getInitialContext();
                this.mbh = (MBeanHome)this.ctx.lookup("weblogic.management.adminhome");
                return this.mbh;
            }
            this.processUsernameAndPassword();
            string2 = string.startsWith(HTTP_STRING) ? T3_STRING + string.substring(HTTP_STRING.length()) : string;
            if (string2.startsWith(IIOP_STRING)) {
                if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
                    System.setProperty("weblogic.system.iiop.enableClient", "false");
                }
                this.ctx = this.getIIOPContext(string2);
            } else {
                this.ctx = this.getContext(string2);
            }
            this.mbh = (MBeanHome)PortableRemoteObject.narrow((Object)this.ctx.lookup("weblogic.management.home.localhome"), MBeanHome.class);
        }
        catch (Exception exception) {
            throw new MBeanHomeToolException(this.textFormatter.errorOnConnect(string2, this.user, StackTraceUtils.throwable2StackTrace((Throwable)exception)));
        }
        return this.mbh;
    }

    public MBeanServerConnection getMBeanServer() throws MBeanHomeToolException {
        if (this.mbs != null) {
            return this.mbs;
        }
        String string = this.opts.getOption(OPTION_ADMIN_URL, DEFAULT_ADMIN_URL);
        if (string.indexOf("://") == -1) {
            string = DEFAULT_PROTOCOL + string;
        }
        try {
            if (!Kernel.isServer()) {
                this.processUsernameAndPassword();
            } else if (string.startsWith(IIOP_STRING) && System.getProperty("weblogic.system.iiop.enableClient") == null) {
                System.setProperty("weblogic.system.iiop.enableClient", "false");
            }
            URI uRI = new URI(string);
            string = string + "/jndi/" + "weblogic.management.mbeanservers.domainruntime";
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (!Kernel.isServer()) {
                hashtable.put("java.naming.security.principal", this.getUser());
                hashtable.put("java.naming.security.credentials", this.getPassword());
            }
            Environment environment = new Environment();
            environment.setProviderUrl(string);
            environment.setSecurityPrincipal(this.getUser());
            environment.setSecurityCredentials(this.getPassword());
            if (string.startsWith(IIOP_STRING)) {
                environment.setInitialContextFactory("weblogic.jndi.WLInitialContextFactory");
            }
            this.ctx = environment.getInitialContext();
            hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            JMXConnector jMXConnector = JMXConnectorFactory.connect(new JMXServiceURL(uRI.getScheme(), uRI.getHost(), uRI.getPort(), "/jndi/weblogic.management.mbeanservers.domainruntime"), hashtable);
            this.mbs = jMXConnector.getMBeanServerConnection();
            return this.mbs;
        }
        catch (Exception exception) {
            throw new MBeanHomeToolException(this.textFormatter.errorOnConnect(string, this.getUser(), StackTraceUtils.throwable2StackTrace((Throwable)exception)));
        }
    }

    public String getUser() {
        return this.user;
    }

    private String getUserFromHuman() {
        if (this.user != null) {
            return this.user;
        }
        this.user = this.opts.getOption(OPTION_USERNAME);
        if (this.user == null || this.user.length() == 0) {
            System.out.print(this.textFormatter.promptUsername());
            System.out.flush();
            try {
                this.user = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException iOException) {
                this.user = DEFAULT_USER_VALUE;
            }
        }
        if (this.user == null || this.user.length() == 0) {
            this.user = DEFAULT_USER_VALUE;
        }
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private String getPasswordFromHuman() throws MBeanHomeToolException {
        if (this.password != null) {
            return this.password;
        }
        this.password = this.opts.getOption(OPTION_PASSWORD);
        if (this.password == null) {
            String string = this.textFormatter.promptPassword(this.getUser());
            int n = 0;
            while (this.password == null || this.password.length() == 0) {
                try {
                    System.out.print(string);
                    System.out.flush();
                    if (TerminalIO.isNoEchoAvailable()) {
                        this.password = TerminalIO.readTerminalNoEcho();
                        System.out.println("");
                    } else {
                        this.password = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    }
                }
                catch (IOException iOException) {
                    throw new MBeanHomeToolException(this.textFormatter.exceptionNoPassword());
                }
                if (n++ <= 3) continue;
                throw new MBeanHomeToolException(this.textFormatter.exceptionNoPassword());
            }
        }
        return this.password;
    }

    public void prepare() {
        this.opts.addOption(OPTION_ADMIN_URL, this.textFormatter.exampleAdminUrl(), this.textFormatter.usageAdminUrl(DEFAULT_ADMIN_URL));
        this.opts.addOption(OPTION_USERNAME, this.textFormatter.exampleUser(), this.textFormatter.usageUser());
        this.opts.addOption(OPTION_PASSWORD, this.textFormatter.examplePassword(), this.textFormatter.usagePassword());
        this.opts.addOption(OPTION_USERCONFIG, this.textFormatter.exampleUserConfig(), this.textFormatter.usageUserConfig());
        this.opts.addOption(OPTION_USERKEY, this.textFormatter.exampleUserKey(), this.textFormatter.usageUserkey());
        this.opts.addAlias(OPTION_USERNAME, OPTION_USER);
        this.opts.addAlias(OPTION_USER, OPTION_USERNAME);
        this.opts.addAlias(OPTION_URL, OPTION_ADMIN_URL);
    }

    public void processUsernameAndPassword() throws MBeanHomeToolException {
        this.user = this.opts.getOption(OPTION_USER, DEFAULT_USER);
        this.password = this.opts.getOption(OPTION_PASSWORD);
        if (this.user != null && this.password != null) {
            return;
        }
        if (this.user != null && this.password == null) {
            this.password = this.getPasswordFromHuman();
        } else if (this.user == null && this.password == null) {
            this.userConfigFile = this.opts.getOption(OPTION_USERCONFIG, DEFAULT_USERCONFIG);
            this.userKeyFile = this.opts.getOption(OPTION_USERKEY, DEFAULT_USERKEY);
            UsernameAndPassword usernameAndPassword = null;
            usernameAndPassword = this.userConfigFile != null || this.userKeyFile != null ? UserConfigFileManager.getUsernameAndPassword(this.userConfigFile, this.userKeyFile, "weblogic.management") : UserConfigFileManager.getUsernameAndPassword("weblogic.management");
            if (usernameAndPassword != null) {
                this.user = usernameAndPassword.getUsername();
                this.password = new String(usernameAndPassword.getPassword());
            }
            if (this.user == null && this.password == null) {
                this.user = this.getUserFromHuman();
                this.password = this.getPasswordFromHuman();
            }
        }
    }

    private Context getIIOPContext(String string) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.security.principal", this.getUser());
        hashtable.put("java.naming.security.credentials", this.getPassword());
        return new InitialContext(hashtable);
    }

    private Context getContext(String string) throws NamingException {
        Environment environment = new Environment();
        Hashtable hashtable = new Hashtable();
        environment.setProviderUrl(string);
        environment.setSecurityPrincipal(this.getUser());
        environment.setSecurityCredentials(this.getPassword());
        return environment.getInitialContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        try {
            block8: {
                try {
                    if (this.ctx == null) break block8;
                    this.ctx.close();
                }
                catch (NamingException namingException) {
                    Object var3_2 = null;
                    this.ctx = null;
                }
            }
            Object var3_1 = null;
            this.ctx = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.ctx = null;
            throw throwable;
        }
        try {
            block10: {
                try {
                    if (this.jmx == null) break block10;
                    this.jmx.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var5_8 = null;
                    this.jmx = null;
                }
            }
            Object var5_7 = null;
            this.jmx = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.jmx = null;
            throw throwable;
        }
    }
}

