/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.utils;

import javax.management.Notification;
import javax.management.NotificationListener;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.utils.Debug;

public class TaskCompletionNotificationListener
implements NotificationListener {
    private static final long WAIT_PERIOD = 60000L;
    private final DeploymentTaskRuntimeMBean task;
    private boolean isCompleted = false;

    public TaskCompletionNotificationListener(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        this.task = deploymentTaskRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        TaskCompletionNotificationListener taskCompletionNotificationListener = this;
        synchronized (taskCompletionNotificationListener) {
            this.isCompleted = true;
            this.notify();
        }
    }

    public void waitForTaskCompletion(long l) {
        long l2 = l == 0L ? 60000L : l;
        long l3 = System.currentTimeMillis() + l2;
        long l4 = l2;
        while (!this.isCompleted && !this.isTaskCompleted()) {
            if (l != 0L) {
                l4 = l3 - System.currentTimeMillis();
            }
            if (l4 <= 0L) {
                return;
            }
            long l5 = l4 <= 60000L ? l4 : 60000L;
            this.waitForTaskCompletionInternal(l5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTaskCompletionInternal(long l) {
        TaskCompletionNotificationListener taskCompletionNotificationListener = this;
        synchronized (taskCompletionNotificationListener) {
            if (!this.isCompleted) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isTaskCompleted() {
        Debug.assertion((this.task != null ? 1 : 0) != 0);
        return !this.task.isRunning();
    }
}

