/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.persistence.PersistenceException;
import javax.xml.stream.XMLStreamException;
import kodo.jdbc.conf.descriptor.PersistenceConfigurationBean;
import kodo.jdbc.conf.descriptor.PersistenceUnitConfigurationBean;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.PersistenceUtils;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.PersistenceDescriptorLoader;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.descriptor.PersistenceBean;
import weblogic.j2ee.descriptor.PersistenceUnitBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.kodo.monitoring.KodoPersistenceUnitParent;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public abstract class AbstractPersistenceUnitRegistry
implements PersistenceUnitRegistry {
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugKodoWeblogic");
    protected Map persistenceUnits = new HashMap();
    protected ApplicationContextInternal appCtx;
    private final Map descriptorMap = new HashMap();
    private final boolean isDebug = Boolean.getBoolean("weblogic.deployment.PersistenceRegistry");
    private File[] rootFiles = null;
    private File[] canonicalizedRootFiles = null;
    private final GenericClassLoader scopeClassLoader;
    private final String scopeName;
    private final File configDir;
    private final DeploymentPlanBean planBean;

    public AbstractPersistenceUnitRegistry(GenericClassLoader genericClassLoader, String string, File file, DeploymentPlanBean deploymentPlanBean) {
        this(genericClassLoader, string, file, deploymentPlanBean, null);
    }

    public AbstractPersistenceUnitRegistry(GenericClassLoader genericClassLoader, String string, File file, DeploymentPlanBean deploymentPlanBean, ApplicationContextInternal applicationContextInternal) {
        this.appCtx = applicationContextInternal;
        this.scopeClassLoader = genericClassLoader;
        this.scopeName = string;
        this.configDir = file;
        this.planBean = deploymentPlanBean;
    }

    public void setParentRuntimeMBean(KodoPersistenceUnitParent kodoPersistenceUnitParent) throws EnvironmentException {
        Collection collection = this.persistenceUnits.values();
        for (PersistenceUnitInfoImpl persistenceUnitInfoImpl : collection) {
            persistenceUnitInfoImpl.setParentRuntimeMBean(kodoPersistenceUnitParent);
        }
    }

    public String getQualifiedName() {
        return this.getScopeName();
    }

    protected String getScopeName() {
        return this.scopeName;
    }

    public void loadPersistenceDescriptors(boolean bl) throws EnvironmentException, IllegalAccessException, InstantiationException, ClassNotFoundException, NamingException, IOException, XMLStreamException {
        Map map = this.loadPersistenceDescriptor("META-INF/persistence.xml", bl);
        Map map2 = this.loadPersistenceDescriptor("META-INF/persistence-configuration.xml", bl);
        if (bl) {
            this.storeDescriptors(map, map2);
        }
    }

    private File[] getRootFiles(boolean bl) throws IOException {
        if (bl) {
            if (this.canonicalizedRootFiles == null) {
                this.canonicalizedRootFiles = PersistenceUtils.getApplicationRoots(this.scopeClassLoader, this.scopeName, bl);
            }
            return this.canonicalizedRootFiles;
        }
        if (this.rootFiles == null) {
            this.rootFiles = PersistenceUtils.getApplicationRoots(this.scopeClassLoader, this.scopeName, bl);
        }
        return this.rootFiles;
    }

    private Map loadPersistenceDescriptor(String string, boolean bl) throws EnvironmentException {
        Enumeration enumeration;
        Map map = null;
        try {
            enumeration = this.scopeClassLoader.getResources(string);
        }
        catch (IOException iOException) {
            if (this.isDebug) {
                this.debug("Unable to find " + string);
            }
            return map;
        }
        HashSet<URI> hashSet = new HashSet<URI>();
        while (enumeration.hasMoreElements()) {
            DescriptorBean descriptorBean;
            URL uRL = (URL)enumeration.nextElement();
            URI uRI = null;
            URI uRI2 = null;
            try {
                uRI2 = PersistenceDescriptorLoader.getResourceURI(uRL);
                if (hashSet.contains(uRI2)) continue;
                hashSet.add(uRI2);
                descriptorBean = this.getRootFiles(true);
                uRI = PersistenceDescriptorLoader.getRelativeURI((File[])descriptorBean, uRI2);
            }
            catch (IOException iOException) {
                throw new EnvironmentException("Error scanning module " + this.getScopeName() + " for persistence descriptors: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
            if (!uRI.equals(uRI2)) {
                Object object;
                descriptorBean = null;
                try {
                    object = new PersistenceDescriptorLoader(uRL, this.configDir, this.planBean, this.scopeName, uRI.toString());
                    descriptorBean = ((PersistenceDescriptorLoader)object).loadDescriptorBean();
                }
                catch (Exception exception) {
                    throw new EnvironmentException("Error loading the persistence descriptor " + uRI + " from the module " + this.getScopeName() + ".  See the following stack trace for nested errors: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
                if (descriptorBean == null) continue;
                this.descriptorMap.put(uRI.toString(), descriptorBean.getDescriptor());
                if (!bl) continue;
                try {
                    object = this.toRootURL(uRL);
                    URL uRL2 = this.toJarParentURL((URL)object);
                    map = this.processDescriptor(descriptorBean, (URL)object, uRL2, map);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!this.isDebug) continue;
                    this.debug("Unable to process resourceURL " + uRL, malformedURLException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!this.isDebug) continue;
                    this.debug("Unable to process resourceURL " + uRL, uRISyntaxException);
                }
                continue;
            }
            if (!this.isDebug) continue;
            this.debug("Unable to find relative root for " + uRI2);
        }
        return map;
    }

    public void loadPersistenceDescriptor(VirtualJarFile virtualJarFile, boolean bl, File file) throws EnvironmentException {
        DescriptorBean descriptorBean = this.loadPersistenceDescriptor(virtualJarFile, "META-INF/persistence.xml");
        DescriptorBean descriptorBean2 = this.loadPersistenceDescriptor(virtualJarFile, "META-INF/persistence-configuration.xml");
        if (bl) {
            URL uRL = null;
            URL uRL2 = null;
            try {
                uRL = file.toURL();
                uRL2 = file.getAbsoluteFile().getParentFile().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new EnvironmentException("Error computing URL: " + malformedURLException);
            }
            Map map = null;
            Map map2 = null;
            if (descriptorBean != null) {
                map = this.processDescriptor(descriptorBean, uRL, uRL2, null);
            }
            if (descriptorBean2 != null) {
                map2 = this.processDescriptor(descriptorBean2, uRL, uRL2, null);
            }
            this.storeDescriptors(map, map2);
        }
    }

    private DescriptorBean loadPersistenceDescriptor(VirtualJarFile virtualJarFile, String string) throws EnvironmentException {
        try {
            PersistenceDescriptorLoader persistenceDescriptorLoader = new PersistenceDescriptorLoader(virtualJarFile, this.configDir, this.planBean, this.scopeName, string);
            DescriptorBean descriptorBean = persistenceDescriptorLoader.loadDescriptorBean();
            if (descriptorBean != null) {
                this.descriptorMap.put(string, descriptorBean.getDescriptor());
            }
            return descriptorBean;
        }
        catch (Exception exception) {
            throw new EnvironmentException("Error loading the persistence descriptor " + string + " from the module " + this.getScopeName() + ".  See the following stack trace for nested errors: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
    }

    private Map processDescriptor(DescriptorBean descriptorBean, URL uRL, URL uRL2, Map hashMap) throws EnvironmentException {
        if (hashMap == null) {
            hashMap = new HashMap<String, BeanInfo>();
        }
        if (descriptorBean instanceof PersistenceBean) {
            PersistenceBean persistenceBean = (PersistenceBean)descriptorBean;
            PersistenceUnitBean[] persistenceUnitBeanArray = persistenceBean.getPersistenceUnits();
            for (int i = 0; i < persistenceUnitBeanArray.length; ++i) {
                String string = persistenceUnitBeanArray[i].getName();
                this.assertNoDuplicate(hashMap, string, uRL);
                BeanInfo beanInfo = new BeanInfo(persistenceUnitBeanArray[i], uRL, uRL2, descriptorBean);
                hashMap.put(string, beanInfo);
            }
        } else {
            PersistenceConfigurationBean persistenceConfigurationBean = (PersistenceConfigurationBean)descriptorBean;
            PersistenceUnitConfigurationBean[] persistenceUnitConfigurationBeanArray = persistenceConfigurationBean.getPersistenceUnitConfigurations();
            for (int i = 0; i < persistenceUnitConfigurationBeanArray.length; ++i) {
                String string = persistenceUnitConfigurationBeanArray[i].getName();
                this.assertNoDuplicate(hashMap, string, uRL);
                BeanInfo beanInfo = new BeanInfo(persistenceUnitConfigurationBeanArray[i], uRL, uRL2, descriptorBean);
                hashMap.put(string, beanInfo);
            }
        }
        return hashMap;
    }

    private void assertNoDuplicate(Map map, String string, URL uRL) throws EnvironmentException {
        BeanInfo beanInfo = (BeanInfo)map.get(string);
        if (beanInfo != null) {
            throw new EnvironmentException("duplicate persistence units with name " + string + " in scope " + this.scopeName + ". First PU location: " + beanInfo.rootUrl + ". Second PU location: " + uRL);
        }
    }

    protected void storeDescriptors(Map map, Map map2) throws EnvironmentException {
        if (map == null) {
            return;
        }
        for (BeanInfo beanInfo : map.values()) {
            PersistenceUnitBean persistenceUnitBean = (PersistenceUnitBean)beanInfo.bean;
            String string = ((PersistenceBean)beanInfo.rootBean).getOriginalVersion();
            BeanInfo beanInfo2 = map2 == null ? null : (BeanInfo)map2.get(persistenceUnitBean.getName());
            PersistenceUnitConfigurationBean persistenceUnitConfigurationBean = beanInfo2 == null ? null : (PersistenceUnitConfigurationBean)beanInfo2.bean;
            try {
                this.putPersistenceUnit(new PersistenceUnitInfoImpl(persistenceUnitBean, persistenceUnitConfigurationBean, this.scopeClassLoader, this.getQualifiedName(), beanInfo.rootUrl, beanInfo.jarParentUrl, string, this.appCtx));
            }
            catch (EnvironmentException environmentException) {
                EnvironmentException environmentException2 = new EnvironmentException("Error processing persistence unit " + persistenceUnitBean.getName() + " of module " + this.scopeName + ": " + environmentException.getMessage());
                environmentException2.setStackTrace(environmentException.getStackTrace());
                throw environmentException2;
            }
        }
    }

    void putPersistenceUnit(PersistenceUnitInfoImpl persistenceUnitInfoImpl) throws EnvironmentException {
        String string = persistenceUnitInfoImpl.getPersistenceUnitName();
        PersistenceUnitInfoImpl persistenceUnitInfoImpl2 = this.persistenceUnits.put(string, persistenceUnitInfoImpl);
        if (persistenceUnitInfoImpl2 != null) {
            throw new EnvironmentException("duplicate persistence units with name " + string + " in scope " + this.scopeName + ". First PU location: " + persistenceUnitInfoImpl2.getPersistenceUnitRootUrl() + ". Second PU location: " + persistenceUnitInfoImpl.getPersistenceUnitRootUrl());
        }
    }

    public void close() {
        Iterator iterator = this.persistenceUnits.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((PersistenceUnitInfoImpl)iterator.next()).close();
            }
            catch (PersistenceException persistenceException) {
                persistenceException.printStackTrace();
            }
        }
    }

    public Collection getPersistenceUnitNames() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.persistenceUnits.keySet());
        return hashSet;
    }

    public Iterator getDescriptorURIs() {
        return this.descriptorMap.keySet().iterator();
    }

    public Descriptor getDescriptor(String string) {
        return (Descriptor)this.descriptorMap.get(string);
    }

    protected URL toRootURL(URL uRL) throws MalformedURLException, URISyntaxException {
        if ("file".equals(uRL.getProtocol())) {
            return new URL(uRL, "..");
        }
        if ("jar".equals(uRL.getProtocol()) || "zip".equals(uRL.getProtocol())) {
            String string = uRL.toString();
            string = "zip".equals(uRL.getProtocol()) ? (string.startsWith("zip:/") ? string.replaceFirst("^zip:", "file:") : string.replaceFirst("^zip:", "file:/")) : string.replaceFirst("^jar:", "");
            string = string.substring(0, string.indexOf("!/"));
            URL uRL2 = new URL(string);
            return uRL2;
        }
        throw new IllegalArgumentException("Unsupported URL format: " + uRL);
    }

    private URL toJarParentURL(URL uRL) throws MalformedURLException {
        return new URL(uRL, ".");
    }

    private void debug(String string) {
        this.debug(string, null);
    }

    private void debug(String string, Exception exception) {
        System.out.println("AbstractPersistenceUnitRegistry: " + string);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    private static class BeanInfo {
        public final Object bean;
        public final URL rootUrl;
        public final URL jarParentUrl;
        public final DescriptorBean rootBean;

        public BeanInfo(Object object, URL uRL, URL uRL2, DescriptorBean descriptorBean) {
            this.bean = object;
            this.rootUrl = uRL;
            this.jarParentUrl = uRL2;
            this.rootBean = descriptorBean;
        }
    }
}

