/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import commonj.timers.TimerManager;
import commonj.work.WorkManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.management.MBeanServer;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.deployment.EjbInfo;
import weblogic.deployment.EntityManagerFactoryProxyImpl;
import weblogic.deployment.EntityManagerInvocationHandlerFactory;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.JMSConnFactoryOpaqueReferenceImpl;
import weblogic.deployment.MailSessionOpaqueReferenceImpl;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.deployment.PersistenceUnitRegistryProvider;
import weblogic.deployment.ServiceRefProcessor;
import weblogic.deployment.ServiceRefProcessorException;
import weblogic.deployment.ServiceRefProcessorFactory;
import weblogic.deployment.TransactionalPersistenceManagerProxyImpl;
import weblogic.ejb20.portable.HandleDelegateImpl;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.J2EEUtils;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.j2ee.descriptor.PersistenceContextRefBean;
import weblogic.j2ee.descriptor.PersistenceUnitRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.wl.MessageDestinationDescriptorBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.logging.Loggable;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassLoaderUtils;
import weblogic.utils.reflect.ReflectUtils;
import weblogic.work.j2ee.J2EEWorkManager;
import weblogic.workarea.WorkContextHelper;

public abstract class BaseEnvironmentBuilder {
    private static final HandleDelegateImpl handleDelegate = new HandleDelegateImpl();
    protected static final boolean DEBUG = System.getProperty("weblogic.compenv.debug") != null;
    protected static final boolean VERBOSE = System.getProperty("weblogic.compenv.verbose") != null;
    public static final String BEA_CTX = "bea";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String MODULE_NAME_BINDING = "bea/ModuleName";
    public static final String USER_TX_BINDING = "javax/transaction/UserTransaction";
    public static final String LOCAL_USER_TX_BINDING = "comp/UserTransaction";
    public static final String TM_BINDING = "javax/transaction/TransactionManager";
    public static final String LOCAL_TM_BINDING = "comp/TransactionSynchronizationRegistry";
    protected static final String LOCAL_ORB_BINDING = "comp/ORB";
    protected static final String HANDLE_DELEGATE_BINDING = "HandleDelegate";
    protected final Context rootCtx;
    protected Context envCtx;
    protected Context resCtx;
    protected final String applicationName;
    protected final String moduleName;
    protected final String componentName;
    private Set serviceRefHelpers = new HashSet();

    public BaseEnvironmentBuilder(Context context, String string, String string2, String string3) throws NamingException {
        Context context2;
        this.rootCtx = context;
        this.applicationName = string;
        this.moduleName = string2;
        this.componentName = string3;
        context.createSubcontext(BEA_CTX);
        context.bind(MODULE_NAME_BINDING, (Object)string2);
        Context context3 = context.createSubcontext("comp");
        this.envCtx = context3.createSubcontext("env");
        this.resCtx = this.envCtx.createSubcontext("wls-connector-resref");
        this.addUserTransaction();
        this.addTransactionManager();
        this.addORB();
        WorkContextHelper.bind((Context)context3);
        this.addDefaultJ2EEWorkManager();
        MBeanServer mBeanServer = ManagementService.getRuntimeMBeanServer(kernelId);
        if (mBeanServer != null) {
            context2 = this.envCtx.createSubcontext("jmx");
            context2.bind("runtime", (Object)mBeanServer);
        }
        if ((mBeanServer = ManagementService.getDomainRuntimeMBeanServer(kernelId)) != null) {
            context2 = this.envCtx.createSubcontext("jmx");
            context2.bind("domainRuntime", (Object)mBeanServer);
        }
        DisconnectMonitorListImpl.bindToJNDI((Context)context3);
        context3.bind(HANDLE_DELEGATE_BINDING, (Object)handleDelegate);
    }

    public BaseEnvironmentBuilder(Context context, String string, String string2) throws NamingException {
        this(context, string, string2, string2);
    }

    public Context getContext() {
        return this.rootCtx;
    }

    public Context getEnvCtx() {
        return this.envCtx;
    }

    protected LinkRef createLinkRef(String string) {
        return new LinkRef(this.transformJNDIName(string));
    }

    protected abstract String transformJNDIName(String var1);

    public void addEnvironmentEntries(Collection collection) throws NamingException, EnvironmentException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.bindEnvEntry(iterator.next());
        }
    }

    public void removeEnvironmentEntries(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.unbindEnvEntry(iterator.next());
        }
    }

    protected abstract void bindEnvEntry(Object var1) throws NamingException, EnvironmentException;

    protected abstract Map createJMSPoolProperties(String var1, AuthenticatedSubject var2) throws NamingException;

    protected void bindResRef(String string, boolean bl, boolean bl2, String string2, String string3, int n) throws NamingException {
        if ("javax.mail.Session".equals(string) && !bl) {
            MailSessionOpaqueReferenceImpl mailSessionOpaqueReferenceImpl = new MailSessionOpaqueReferenceImpl(string2, this.applicationName);
            this.envCtx.bind(string3, (Object)mailSessionOpaqueReferenceImpl);
        } else if ("javax.jms.ConnectionFactory".equals(string) && !bl) {
            String string4 = this.applicationName + "-" + this.componentName + "-" + string2;
            JMSConnFactoryOpaqueReferenceImpl jMSConnFactoryOpaqueReferenceImpl = new JMSConnFactoryOpaqueReferenceImpl(string4, n, bl2, this.createJMSPoolProperties(string2, null));
            this.envCtx.bind(string3, (Object)jMSConnFactoryOpaqueReferenceImpl);
        } else {
            this.envCtx.bind(string3, (Object)new LinkRef(string2));
        }
    }

    protected abstract void unbindEnvEntry(Object var1);

    protected Object findObject(String string) {
        try {
            return this.findObject(string, new InitialContext());
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)namingException);
        }
    }

    protected Object findObject(String string, Context context) {
        Object object = null;
        try {
            if (string.indexOf(":") > 0 && string.indexOf("java:") == -1) {
                return null;
            }
            object = context.lookup(string);
        }
        catch (NamingException namingException) {
            return null;
        }
        return object;
    }

    protected Object findObjectOrCreateLinkRef(String string) {
        Object object = this.findObject(string);
        if (object == null) {
            object = this.createLinkRef(string);
        }
        return object;
    }

    protected boolean lookUpDataSrc(String string) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess.getDomain().lookupJDBCConnectionPool(string) != null) {
            return true;
        }
        if (runtimeAccess.getDomain().lookupJDBCDataSource(string) != null) {
            return true;
        }
        if (runtimeAccess.getDomain().lookupJDBCMultiPool(string) != null) {
            return true;
        }
        return runtimeAccess.getDomain().lookupJDBCTxDataSource(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lookUpGlobalJNDI(String string) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Object object = initialContext.lookup(string);
            if (object != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NamingException namingException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (initialContext != null) {
                    initialContext.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void addUserTransaction() throws NamingException {
        Object object = this.findObjectOrCreateLinkRef(USER_TX_BINDING);
        this.rootCtx.bind(LOCAL_USER_TX_BINDING, object);
        if (DEBUG) {
            System.out.println("Bound javax/transaction/UserTransaction to " + this.rootCtx.getNameInNamespace() + ":" + LOCAL_USER_TX_BINDING);
        }
    }

    private void addTransactionManager() throws NamingException {
        Object object = this.findObjectOrCreateLinkRef(TM_BINDING);
        this.rootCtx.bind(LOCAL_TM_BINDING, object);
        if (DEBUG) {
            System.out.println("Bound javax/transaction/TransactionManager to " + this.rootCtx.getNameInNamespace() + ":" + LOCAL_TM_BINDING);
        }
    }

    private void removeTransactionManager() {
        block2: {
            try {
                this.rootCtx.unbind(LOCAL_TM_BINDING);
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    private void addDefaultJ2EEWorkManager() throws NamingException {
        WorkManager workManager = J2EEWorkManager.getDefault(this.applicationName);
        if (workManager == null) {
            return;
        }
        this.envCtx.bind("wm/default", (Object)workManager);
    }

    private void addORB() throws NamingException {
        this.rootCtx.bind(LOCAL_ORB_BINDING, (Object)new Reference("org.omg.CORBA.ORB", "weblogic.deployment.ORBObjectFactory", null));
    }

    protected void autowireEJBRef(String string, String string2, String string3) throws NamingException, EnvironmentException {
        Context context = null;
        try {
            context = (Context)this.rootCtx.lookup("app/ejb");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        String string4 = string2;
        if (string4 == null) {
            string4 = string3;
        }
        String string5 = null;
        if (context != null) {
            string5 = this.findejbinfo(context, string, string4, string5);
        }
        if (string5 == null) {
            Loggable loggable = J2EELogger.logFailedToAutoLinkEjbRefNoMatchesLoggable((String)string, (String)this.moduleName, (String)this.applicationName, (String)string4);
            throw new EnvironmentException(loggable.getMessage());
        }
        this.envCtx.bind(string, (Object)new LinkRef("java:app/ejb/" + string5));
    }

    private String findejbinfo(Context context, String string, String string2, String string3) throws NamingException, EnvironmentException {
        NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            Object object = binding.getObject();
            if (!(object instanceof Context)) continue;
            EjbInfo ejbInfo = null;
            try {
                ejbInfo = (EjbInfo)((Context)object).lookup("ejb-info");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ejbInfo != null && ejbInfo.implementsInterface(string2)) {
                if (string3 == null) {
                    string3 = binding.getName() + "/" + string2;
                } else {
                    Loggable loggable = J2EELogger.logFailedToAutoLinkEjbRefMultipleInterfacesLoggable((String)string, (String)this.moduleName, (String)this.applicationName, (String)string2);
                    throw new EnvironmentException(loggable.getMessage());
                }
            }
            if (ejbInfo != null) continue;
            string3 = this.findejbinfo((Context)object, string, string2, string3);
        }
        return string3;
    }

    protected void addEJBLinkRef(String string, String string2, String string3, String string4, String string5, boolean bl) throws NamingException, EnvironmentException {
        Object object;
        Context context = null;
        try {
            context = (Context)this.rootCtx.lookup("app/ejb");
        }
        catch (NamingException namingException) {
            Loggable loggable = J2EELogger.logNoEJBDeploymentsFoundForLinkRefLoggable((String)this.applicationName, (String)this.componentName);
            throw new EnvironmentException(loggable.getMessage());
        }
        String string6 = J2EEUtils.getAppScopedLinkPath(string2, string5, context);
        if (string6 == null) {
            Loggable loggable = J2EELogger.logUnableToResolveEJBLinkLoggable((String)string2, (String)string, (String)string5);
            throw new EnvironmentException(loggable.getMessage());
        }
        EjbInfo ejbInfo = null;
        try {
            ejbInfo = (EjbInfo)new InitialContext().lookup("java:app/ejb/" + string6 + "/ejb-info");
        }
        catch (NamingException namingException) {
            Loggable loggable = J2EELogger.logUnableToResolveEJBLinkLoggable((String)string2, (String)string, (String)string5);
            throw new EnvironmentException(loggable.getMessage());
        }
        String string7 = null;
        if (string3 != null) {
            string7 = string3;
            if (bl && ejbInfo.getLocalHomeName() != null) {
                string7 = ejbInfo.getLocalHomeName();
            }
            if (!bl && ejbInfo.getHomeName() != null) {
                string7 = ejbInfo.getHomeName();
            }
        } else if (string4 != null) {
            string7 = string4;
        } else {
            object = ejbInfo.getImplementedInterfaceNames();
            if (((String[])object).length == 1) {
                string7 = object[0];
            } else if (((String[])object).length == 2) {
                if (ejbInfo.getHomeName() != null && ejbInfo.getLocalHomeName() != null) {
                    string7 = bl ? ejbInfo.getLocalHomeName() : ejbInfo.getHomeName();
                }
            } else {
                Loggable loggable = J2EELogger.logFailedToCreateEjbRefMultipleInterfacesLoggable((String)string, (String)this.moduleName, (String)this.applicationName);
                throw new EnvironmentException(loggable.getMessage());
            }
        }
        if (!ejbInfo.implementsInterface(string7)) {
            object = J2EELogger.logEJBRefTargetDoesNotImplementInterfaceLoggable((String)string, (String)this.moduleName, (String)this.applicationName, (String)string7);
            throw new EnvironmentException(object.getMessage());
        }
        if (DEBUG) {
            Debug.say((String)("binding-java:app/ejb/" + string6 + "/" + string7 + " to " + string));
        }
        this.envCtx.bind(string, (Object)new LinkRef("java:app/ejb/" + string6 + "/" + string7));
        if (string3 != null) {
            object = this.envCtx.lookup(string);
            if (bl && !ClassLoaderUtils.visibleToClassLoader((Object)object)) {
                Loggable loggable = J2EELogger.logEjbLocalRefNotVisibleLoggable((String)this.applicationName, (String)this.componentName, (String)string6);
                throw new EnvironmentException(loggable.getMessage());
            }
        }
    }

    public void addServiceReferences(Collection collection, Collection collection2, ServletContext servletContext, String string) throws NamingException, EnvironmentException {
        HashMap<String, ServiceReferenceDescriptionBean> hashMap = new HashMap<String, ServiceReferenceDescriptionBean>();
        if (collection2 != null) {
            for (ServiceReferenceDescriptionBean serviceReferenceDescriptionBean : collection2) {
                hashMap.put(serviceReferenceDescriptionBean.getServiceRefName(), serviceReferenceDescriptionBean);
            }
        }
        for (ServiceReferenceDescriptionBean serviceReferenceDescriptionBean : collection) {
            ServiceReferenceDescriptionBean serviceReferenceDescriptionBean2 = (ServiceReferenceDescriptionBean)hashMap.get(serviceReferenceDescriptionBean.getServiceRefName());
            try {
                ServiceRefProcessor serviceRefProcessor = ServiceRefProcessorFactory.getInstance().getProcessor((ServiceRefBean)serviceReferenceDescriptionBean, serviceReferenceDescriptionBean2, servletContext);
                serviceRefProcessor.bindServiceRef(this.rootCtx, this.envCtx, string);
                this.serviceRefHelpers.add(serviceRefProcessor);
            }
            catch (ServiceRefProcessorException serviceRefProcessorException) {
                throw new EnvironmentException(serviceRefProcessorException.getMessage(), serviceRefProcessorException);
            }
        }
    }

    public void removeUserTransaction() {
        block2: {
            try {
                this.rootCtx.unbind(LOCAL_USER_TX_BINDING);
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    public void removeDefaultJ2EEWorkManager() {
        block2: {
            try {
                this.envCtx.unbind("wm/default");
                this.envCtx.destroySubcontext("wm");
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    public void removeORB() {
        block2: {
            try {
                this.rootCtx.unbind(LOCAL_ORB_BINDING);
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    public void removeHandleDelegate() {
        block2: {
            try {
                Context context = (Context)this.rootCtx.lookup("comp");
                context.unbind(HANDLE_DELEGATE_BINDING);
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    public void removeServiceReferences(Collection collection) {
        for (ServiceRefProcessor serviceRefProcessor : this.serviceRefHelpers) {
            try {
                serviceRefProcessor.unbindServiceRef(this.envCtx);
            }
            catch (NamingException namingException) {
                if (!DEBUG) continue;
                namingException.printStackTrace();
            }
        }
        this.serviceRefHelpers.clear();
    }

    public void removeStandardEntries() {
        block6: {
            this.removeUserTransaction();
            this.removeORB();
            this.removeHandleDelegate();
            this.removeDefaultJ2EEWorkManager();
            this.removeTransactionManager();
            try {
                this.destroyContextsRecursively((Context)this.envCtx.lookup("wls-connector-resref"), this.envCtx, "wls-connector-resref");
                Context context = (Context)this.envCtx.lookup("jmx");
                if (context != null) {
                    block5: {
                        context.unbind("runtime");
                        try {
                            context.unbind("domainRuntime");
                        }
                        catch (NamingException namingException) {
                            if (!DEBUG) break block5;
                            namingException.printStackTrace();
                        }
                    }
                    this.envCtx.destroySubcontext("jmx");
                }
                Context context2 = (Context)this.rootCtx.lookup("comp");
                this.destroyContextsRecursively(this.envCtx, context2, "env");
                WorkContextHelper.unbind((Context)context2);
                DisconnectMonitorListImpl.unbindFromJNDI((Context)context2);
                this.destroyContextsRecursively(context2, this.rootCtx, "comp");
                this.rootCtx.unbind(MODULE_NAME_BINDING);
                this.rootCtx.destroySubcontext(BEA_CTX);
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block6;
                namingException.printStackTrace();
            }
        }
    }

    private void destroyContextsRecursively(Context context, Context context2, String string) {
        block7: {
            if (context == null) {
                return;
            }
            if (DEBUG) {
                J2EELogger.logDebug((String)("Cleanup the intermediateContexts for :" + context));
            }
            try {
                NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
                while (namingEnumeration.hasMoreElements()) {
                    Object object = namingEnumeration.next();
                    Binding binding = object;
                    String string2 = binding.getName();
                    object = binding.getObject();
                    if (DEBUG) {
                        J2EELogger.logDebug((String)("Removing " + object));
                    }
                    if (object instanceof Context) {
                        Context context3 = (Context)object;
                        this.destroyContextsRecursively(context3, context, string2);
                        continue;
                    }
                    J2EELogger.logDebug((String)("Warning : Binding" + string2 + " still exists for Context :" + context + ". Unbinding it."));
                    context.unbind(string2);
                }
                context2.destroySubcontext(string);
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Naming exception while removing  intermediate contexts for " + context));
                if (!DEBUG) break block7;
                namingException.printStackTrace();
            }
        }
    }

    public void addMessageDestinationReferences(Collection collection, String string) throws NamingException, EnvironmentException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (MessageDestinationRefBean messageDestinationRefBean : collection) {
            Context context = (Context)this.rootCtx.lookup("app/messageDestination");
            String string2 = messageDestinationRefBean.getMessageDestinationLink() == null ? messageDestinationRefBean.getMessageDestinationRefName() : messageDestinationRefBean.getMessageDestinationLink();
            String string3 = J2EEUtils.getAppScopedLinkPath(string2, string, context);
            String string4 = messageDestinationRefBean.getMappedName();
            if (string3 == null && string4 == null) {
                string4 = string2;
            }
            MessageDestinationDescriptorBean messageDestinationDescriptorBean = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            if (string3 != null) {
                string3 = J2EEUtils.normalizeJNDIName(string3);
                try {
                    messageDestinationDescriptorBean = (MessageDestinationDescriptorBean)context.lookup(string3);
                    string6 = messageDestinationDescriptorBean.getInitialContextFactory();
                    string7 = messageDestinationDescriptorBean.getProviderUrl();
                    string5 = messageDestinationDescriptorBean.getDestinationJNDIName();
                    string5 = BaseEnvironmentBuilder.transformJNDIName(string5, this.applicationName);
                }
                catch (NamingException namingException) {
                    Loggable loggable = J2EELogger.logUnableToResolveMessageDestinationLinkLoggable((String)messageDestinationRefBean.getMessageDestinationLink(), (String)messageDestinationRefBean.getMessageDestinationRefName(), (String)string);
                    throw new EnvironmentException(loggable.getMessage());
                }
            } else {
                string6 = "weblogic.jndi.WLInitialContextFactory";
                string5 = string4;
            }
            MessageDestinationReference messageDestinationReference = new MessageDestinationReference(string5, string6, string7, messageDestinationRefBean.getMessageDestinationType(), "weblogic.deployment.BaseEnvironmentBuilder.MessageDestinationObjectFactory");
            this.envCtx.bind(messageDestinationRefBean.getMessageDestinationRefName(), (Object)messageDestinationReference);
        }
    }

    public void removeMessageDestinationReferences(Collection collection) {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (MessageDestinationRefBean messageDestinationRefBean : collection) {
            try {
                this.envCtx.unbind(messageDestinationRefBean.getMessageDestinationRefName());
            }
            catch (NamingException namingException) {
                if (!DEBUG) continue;
                namingException.printStackTrace();
            }
        }
    }

    public static String transformJNDIName(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("${APPNAME}") != -1) {
            return StringUtils.replaceGlobal((String)string, (String)"${APPNAME}", (String)string2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTimerManagerRef(String string) {
        TimerManager timerManager = null;
        try {
            timerManager = (TimerManager)this.envCtx.lookup(string);
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            J2EELogger.logDebug((String)("Cannot unbind " + string));
            if (DEBUG) {
                namingException.printStackTrace();
            }
        }
        finally {
            if (timerManager != null) {
                timerManager.stop();
            }
        }
    }

    protected void addTimerManager(String string) throws NamingException, EnvironmentException {
        if (string == null || string.length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(this.applicationName);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.applicationName != null) {
            stringBuffer.append(this.applicationName);
        }
        if (this.moduleName != null) {
            stringBuffer.append("@" + this.moduleName);
        }
        if (this.componentName != null) {
            stringBuffer.append("@" + this.componentName);
        }
        stringBuffer.append("@" + string);
        this.envCtx.bind(string, (Object)TimerManagerFactory.getTimerManagerFactory().getCommonjTimerManager(stringBuffer.toString(), applicationContextInternal.getWorkManagerCollection().getDefault()));
    }

    public void addPersistenceContextRefs(PersistenceContextRefBean[] persistenceContextRefBeanArray, ClassLoader classLoader, PersistenceUnitRegistryProvider persistenceUnitRegistryProvider) throws EnvironmentException, NamingException {
        for (int i = 0; persistenceContextRefBeanArray != null && i < persistenceContextRefBeanArray.length; ++i) {
            Object object = this.createPersistenceContextProxy(persistenceContextRefBeanArray[i], classLoader, persistenceUnitRegistryProvider);
            this.envCtx.bind(persistenceContextRefBeanArray[i].getPersistenceContextRefName(), object);
        }
    }

    public void removePersistenceContextRefs(PersistenceContextRefBean[] persistenceContextRefBeanArray) {
        for (int i = 0; persistenceContextRefBeanArray != null && i < persistenceContextRefBeanArray.length; ++i) {
            try {
                this.envCtx.unbind(persistenceContextRefBeanArray[i].getPersistenceContextRefName());
                continue;
            }
            catch (NamingException namingException) {
                if (System.getProperty("weblogic.compenv.debug") == null) continue;
                namingException.printStackTrace();
            }
        }
    }

    public void addPersistenceUnitRefs(PersistenceUnitRefBean[] persistenceUnitRefBeanArray, ClassLoader classLoader, PersistenceUnitRegistryProvider persistenceUnitRegistryProvider) throws EnvironmentException, NamingException {
        for (int i = 0; persistenceUnitRefBeanArray != null && i < persistenceUnitRefBeanArray.length; ++i) {
            Object object = this.getPersistenceContextFactory(persistenceUnitRefBeanArray[i], persistenceUnitRegistryProvider, classLoader);
            this.envCtx.bind(persistenceUnitRefBeanArray[i].getPersistenceUnitRefName(), object);
        }
    }

    public void removePersistenceUnitRefs(PersistenceUnitRefBean[] persistenceUnitRefBeanArray) {
        for (int i = 0; persistenceUnitRefBeanArray != null && i < persistenceUnitRefBeanArray.length; ++i) {
            try {
                this.envCtx.unbind(persistenceUnitRefBeanArray[i].getPersistenceUnitRefName());
                continue;
            }
            catch (NamingException namingException) {
                if (System.getProperty("weblogic.compenv.debug") == null) continue;
                namingException.printStackTrace();
            }
        }
    }

    private Class getInjectionType(Class clazz, String string) throws EnvironmentException {
        Class clazz2 = this.getInjectionTypeForField(clazz, string);
        if (clazz2 == null) {
            clazz2 = this.getInjectionTypeForMethod(clazz, string);
        }
        if (clazz2 == null) {
            throw new EnvironmentException("Unable to find injection target named: " + string + " on class: " + clazz);
        }
        return clazz2;
    }

    private Class getInjectionTypeForField(Class clazz, String string) {
        try {
            return clazz.getDeclaredField(string).getType();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private Class getInjectionTypeForMethod(Class clazz, String string) {
        char c = string.charAt(0);
        String string2 = ("" + c).toUpperCase(Locale.US) + string.substring(1);
        string2 = "set" + string2;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            if (!methodArray[i].getName().equals(string2) || (classArray = methodArray[i].getParameterTypes()).length != 1) continue;
            return classArray[0];
        }
        return null;
    }

    private Object createPersistenceContextProxy(PersistenceContextRefBean persistenceContextRefBean, ClassLoader classLoader, PersistenceUnitRegistryProvider persistenceUnitRegistryProvider) throws EnvironmentException {
        List list = this.computeInterfaces(persistenceContextRefBean.getInjectionTargets(), classLoader);
        PersistenceUnitRegistry persistenceUnitRegistry = persistenceUnitRegistryProvider.getPersistenceUnitRegistry();
        String string = this.getPersistenceUnitName(persistenceContextRefBean.getPersistenceUnitName(), persistenceUnitRegistry, persistenceContextRefBean.getInjectionTargets());
        persistenceContextRefBean.setPersistenceUnitName(string);
        InvocationHandler invocationHandler = persistenceContextRefBean.getPersistenceContextType().equals("Transaction") ? (this.isJDOPersistenceContext(persistenceContextRefBean, persistenceContextRefBean.getInjectionTargets(), list, classLoader) ? new TransactionalPersistenceManagerProxyImpl(this.applicationName, this.moduleName, string, persistenceUnitRegistry) : EntityManagerInvocationHandlerFactory.createTransactionalEntityManagerInvocationHandler(this.applicationName, this.moduleName, string, persistenceUnitRegistry)) : EntityManagerInvocationHandlerFactory.createExtendedEntityManagerInvocationHandler(this.applicationName, this.moduleName, string, persistenceUnitRegistry);
        return Proxy.newProxyInstance(classLoader, list.toArray(new Class[list.size()]), invocationHandler);
    }

    private List computeInterfaces(InjectionTargetBean[] injectionTargetBeanArray, ClassLoader classLoader) throws EnvironmentException {
        ArrayList<Class<Object>> arrayList = new ArrayList<Class<Object>>();
        if (injectionTargetBeanArray.length == 0) {
            arrayList.add(EntityManager.class);
        } else {
            for (int i = 0; i < injectionTargetBeanArray.length; ++i) {
                try {
                    Class<?> clazz = classLoader.loadClass(injectionTargetBeanArray[i].getInjectionTargetClass());
                    Class clazz2 = this.getInjectionType(clazz, injectionTargetBeanArray[i].getInjectionTargetName());
                    if (clazz2.isInterface()) {
                        arrayList.add(clazz2);
                    }
                    Enumeration enumeration = ReflectUtils.allInterfaces((Class)clazz2);
                    while (enumeration.hasMoreElements()) {
                        arrayList.add((Class<Object>)enumeration.nextElement());
                    }
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new EnvironmentException("Error loading class: ", classNotFoundException);
                }
            }
        }
        return arrayList;
    }

    private boolean isJDOPersistenceContext(PersistenceContextRefBean persistenceContextRefBean, InjectionTargetBean[] injectionTargetBeanArray, Collection collection, ClassLoader classLoader) throws EnvironmentException {
        if (collection == null) {
            collection = this.computeInterfaces(injectionTargetBeanArray, classLoader);
        }
        boolean bl = collection.contains(EntityManager.class);
        boolean bl2 = collection.contains(PersistenceManager.class);
        if (bl && bl2) {
            throw new EnvironmentException("Persistence context " + persistenceContextRefBean + " has injection target(s) that implement both " + EntityManager.class.getName() + " and " + PersistenceManager.class.getName() + ". This is illegal.");
        }
        if (!bl && !bl2) {
            throw new EnvironmentException("Persistence context " + persistenceContextRefBean + " has injection target(s) that implement neither  " + EntityManager.class.getName() + " nor " + PersistenceManager.class.getName() + ". This is illegal.");
        }
        return bl2;
    }

    private boolean isJDOPersistenceContextFactory(PersistenceUnitRefBean persistenceUnitRefBean, InjectionTargetBean[] injectionTargetBeanArray, Collection collection, ClassLoader classLoader) throws EnvironmentException {
        if (collection == null) {
            if (injectionTargetBeanArray.length == 0) {
                return false;
            }
            collection = this.computeInterfaces(injectionTargetBeanArray, classLoader);
        }
        boolean bl = collection.contains(EntityManagerFactory.class);
        boolean bl2 = collection.contains(PersistenceManagerFactory.class);
        if (bl && bl2) {
            throw new EnvironmentException("Persistence unit " + persistenceUnitRefBean + " has injection target(s) that implement both " + EntityManagerFactory.class.getName() + " and " + PersistenceManagerFactory.class.getName() + ". This is illegal.");
        }
        if (!bl && !bl2) {
            throw new EnvironmentException("Persistence unit " + persistenceUnitRefBean + " has injection target(s) that implement neither  " + EntityManagerFactory.class.getName() + " nor " + PersistenceManagerFactory.class.getName() + ". This is illegal.");
        }
        return bl2;
    }

    private Object getPersistenceContextFactory(PersistenceUnitRefBean persistenceUnitRefBean, PersistenceUnitRegistryProvider persistenceUnitRegistryProvider, ClassLoader classLoader) throws EnvironmentException {
        PersistenceUnitRegistry persistenceUnitRegistry = persistenceUnitRegistryProvider.getPersistenceUnitRegistry();
        String string = this.getPersistenceUnitName(persistenceUnitRefBean.getPersistenceUnitName(), persistenceUnitRegistry, persistenceUnitRefBean.getInjectionTargets());
        PersistenceUnitInfoImpl persistenceUnitInfoImpl = persistenceUnitRegistry.getPersistenceUnit(string);
        EntityManagerFactory entityManagerFactory = persistenceUnitInfoImpl.getEntityManagerFactory();
        EntityManagerFactoryProxyImpl entityManagerFactoryProxyImpl = (EntityManagerFactoryProxyImpl)Proxy.getInvocationHandler(entityManagerFactory);
        entityManagerFactoryProxyImpl.setAppName(this.applicationName);
        entityManagerFactoryProxyImpl.setModuleName(this.moduleName);
        if (this.isJDOPersistenceContextFactory(persistenceUnitRefBean, persistenceUnitRefBean.getInjectionTargets(), null, classLoader)) {
            return TransactionalPersistenceManagerProxyImpl.toPersistenceManagerFactory(entityManagerFactory);
        }
        return entityManagerFactory;
    }

    private String getPersistenceUnitName(String string, PersistenceUnitRegistry persistenceUnitRegistry, InjectionTargetBean[] injectionTargetBeanArray) throws EnvironmentException {
        if (string != null && !"".equals(string)) {
            return string;
        }
        Collection collection = persistenceUnitRegistry.getPersistenceUnitNames();
        if (collection.size() == 1) {
            return (String)collection.iterator().next();
        }
        if (injectionTargetBeanArray != null && injectionTargetBeanArray.length == 1) {
            return injectionTargetBeanArray[0].getInjectionTargetName();
        }
        if (injectionTargetBeanArray == null || injectionTargetBeanArray.length == 0) {
            throw new EnvironmentException("PersistenceContext refs defined without any injection targets must explicitly name a persistence unit.");
        }
        throw new EnvironmentException("PersistenceContext refs defined with multiple injection targets must explicitly name a persistence unit.");
    }

    public static final class MessageDestinationObjectFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
            MessageDestinationReference messageDestinationReference = (MessageDestinationReference)object;
            String string = messageDestinationReference.getDestinationJNDIName();
            String string2 = messageDestinationReference.getInitialContextFactory();
            String string3 = messageDestinationReference.getProviderURL();
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("java.naming.factory.initial", string2);
            if (null != string3) {
                hashtable2.put("java.naming.provider.url", string3);
            }
            InitialContext initialContext = new InitialContext(hashtable2);
            return initialContext.lookup(string);
        }
    }

    public static final class MessageDestinationReference
    extends Reference {
        private String destinationJNDIName;
        private String initialContextFactory;
        private String providerURL;

        public MessageDestinationReference(String string, String string2, String string3, String string4, String string5) {
            super(string4, string5, null);
            this.destinationJNDIName = string;
            this.initialContextFactory = string2;
            this.providerURL = string3;
        }

        public String getDestinationJNDIName() {
            return this.destinationJNDIName;
        }

        public String getInitialContextFactory() {
            return this.initialContextFactory;
        }

        public String getProviderURL() {
            return this.providerURL;
        }

        public String getFactoryClassName() {
            return MessageDestinationObjectFactory.class.getName();
        }
    }
}

