/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.persistence.TransactionRequiredException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import weblogic.deployment.InterceptingInvocationHandler;
import weblogic.deployment.InvocationHandlerInterceptor;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.internal.InterpositionTier;
import weblogic.transaction.internal.ServerTransactionManagerImpl;

abstract class BasePersistenceContextProxyImpl
implements InterceptingInvocationHandler {
    private final String appName;
    private final String moduleName;
    private final String persistenceUnitName;
    private final String unqualifiedPersistenceUnitName;
    private InvocationHandlerInterceptor iceptor;
    protected final PersistenceUnitInfoImpl persistenceUnit;
    protected Method transactionAccessMethod;
    protected Method closeMethod;
    protected Method delegateMethod;
    protected Set transactionalMethods = Collections.EMPTY_SET;
    protected final TransactionSynchronizationRegistry txRegistry;
    protected final TransactionHelper txHelper;

    public BasePersistenceContextProxyImpl(String string, String string2, String string3, PersistenceUnitRegistry persistenceUnitRegistry) {
        this.persistenceUnit = persistenceUnitRegistry.getPersistenceUnit(string3);
        this.unqualifiedPersistenceUnitName = string3;
        this.persistenceUnitName = this.persistenceUnit.getPersistenceUnitId();
        this.appName = string;
        this.moduleName = string2;
        this.txHelper = TransactionHelper.getTransactionHelper();
        this.txRegistry = (TransactionSynchronizationRegistry)this.txHelper.getTransactionManager();
    }

    public void setInterceptor(InvocationHandlerInterceptor invocationHandlerInterceptor) {
        this.iceptor = invocationHandlerInterceptor;
    }

    public void setTransactionAccessMethod(Method method) {
        this.transactionAccessMethod = method;
    }

    public void setCloseMethod(Method method) {
        this.closeMethod = method;
    }

    public void setTransactionalMethods(Set set) {
        this.transactionalMethods = set;
    }

    public void setDelegateMethod(Method method) {
        this.delegateMethod = method;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getUnitName() {
        return this.persistenceUnitName;
    }

    public String getUnqualifiedUnitName() {
        return this.unqualifiedPersistenceUnitName;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.iceptor != null) {
            this.iceptor.preInvoke(method, objectArray);
        }
        Transaction transaction = this.txHelper.getTransaction();
        Object object2 = this.invoke(object, method, objectArray, transaction);
        if (this.iceptor != null) {
            return this.iceptor.postInvoke(method, objectArray, object2);
        }
        return object2;
    }

    protected Object invoke(Object object, Method method, Object[] objectArray, Transaction transaction) throws Throwable {
        this.validateInvocation(method, transaction);
        Object object2 = this.getPersistenceContext(transaction);
        this.checkTransactionStatus(object2, transaction);
        try {
            Object object3 = method.invoke(object2, objectArray);
            Object var8_8 = null;
            if (transaction == null && !method.equals(this.delegateMethod)) {
                this.close(object2);
            }
            return object3;
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                throw invocationTargetException.getCause();
            }
            catch (Throwable throwable) {
                block5: {
                    Object var8_9 = null;
                    if (transaction != null || method.equals(this.delegateMethod)) break block5;
                    this.close(object2);
                }
                throw throwable;
            }
        }
    }

    protected void checkTransactionStatus(Object object, Transaction transaction) {
    }

    protected void validateInvocation(Method method, Transaction transaction) {
        if (method.equals(this.transactionAccessMethod)) {
            throw new IllegalStateException("The method " + method + " cannot be invoked in the context of a JTA " + this.getPersistenceContextStyleName() + ".");
        }
        if (method.equals(this.closeMethod)) {
            throw new IllegalStateException("The method " + method + " cannot be invoked on a container-managed EntityManager" + this.getPersistenceContextStyleName() + ".");
        }
        if (transaction == null && this.transactionalMethods.contains(method)) {
            throw new TransactionRequiredException("The method " + method + " must be called in the context of a transaction.");
        }
    }

    protected abstract String getPersistenceContextStyleName();

    protected Object getPersistenceContext(Transaction transaction) {
        Object object;
        if (transaction != null && (object = this.txRegistry.getResource((Object)this.persistenceUnitName)) != null) {
            return object;
        }
        object = this.newPersistenceContext(this.persistenceUnit);
        if (transaction != null) {
            this.txRegistry.putResource((Object)this.persistenceUnitName, object);
            ((ServerTransactionManagerImpl)this.txRegistry).registerInterposedSynchronization((Synchronization)new PersistenceContextCloser(object), InterpositionTier.WLS_INTERNAL_SYNCHRONIZATION);
        }
        return object;
    }

    protected abstract Object newPersistenceContext(PersistenceUnitInfoImpl var1);

    protected abstract void close(Object var1);

    private final class PersistenceContextCloser
    implements Synchronization {
        private final Object pc;

        private PersistenceContextCloser(Object object) {
            this.pc = object;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            BasePersistenceContextProxyImpl.this.close(this.pc);
        }
    }
}

