/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import kodo.jdbc.conf.descriptor.JDBCConfigurationBeanParser;
import kodo.jdbc.conf.descriptor.PersistenceUnitConfigurationBean;
import kodo.persistence.PersistenceProviderImpl;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryProvider;
import weblogic.deployment.DynamicProxyUtils;
import weblogic.deployment.EntityManagerFactoryProxyImpl;
import weblogic.deployment.EnvironmentException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.PersistencePropertyBean;
import weblogic.j2ee.descriptor.PersistenceUnitBean;
import weblogic.kodo.WebLogicLogFactory;
import weblogic.kodo.monitoring.KodoPersistenceUnitParent;
import weblogic.kodo.monitoring.KodoPersistenceUnitRuntimeMBeanFactory;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JPAMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.KodoPersistenceUnitRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassPreProcessor;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

abstract class BasePersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String[] CONVERT = new String[]{"TransactionMode", "ConnectionFactory", "ConnectionFactoryName", "ConnectionFactoryMode", "ConnectionFactory2", "ConnectionFactory2Name", "ClassResolver"};
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugKodoWeblogic");
    protected final PersistenceUnitBean dd;
    private final PersistenceUnitConfigurationBean configDD;
    private final GenericClassLoader cl;
    private final String persistenceArchiveId;
    private final String persistenceUnitId;
    private final URL rootUrl;
    private final URL jarParentUrl;
    private final List jarFileUrls = new ArrayList();
    private ApplicationContextInternal appCtx;
    private EntityManagerFactory wrappedEMF;
    private EntityManagerFactory unwrappedEMF;
    private Properties properties = new Properties();
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private String providerClassName;
    private String originalVersion;
    private KodoPersistenceUnitParent parentMBean;
    private KodoPersistenceUnitRuntimeMBean runtimeMBean;

    BasePersistenceUnitInfoImpl(PersistenceUnitBean persistenceUnitBean, PersistenceUnitConfigurationBean persistenceUnitConfigurationBean, GenericClassLoader genericClassLoader, String string, URL uRL, URL uRL2, String string2) throws EnvironmentException {
        this(persistenceUnitBean, persistenceUnitConfigurationBean, genericClassLoader, string, uRL, uRL2, string2, null);
    }

    BasePersistenceUnitInfoImpl(PersistenceUnitBean persistenceUnitBean, PersistenceUnitConfigurationBean persistenceUnitConfigurationBean, GenericClassLoader genericClassLoader, String string, URL uRL, URL uRL2, String string2, ApplicationContextInternal applicationContextInternal) throws EnvironmentException {
        this.dd = persistenceUnitBean;
        this.configDD = persistenceUnitConfigurationBean;
        this.cl = genericClassLoader;
        this.persistenceArchiveId = string;
        this.persistenceUnitId = string + "#" + persistenceUnitBean.getName();
        this.rootUrl = uRL;
        this.jarParentUrl = uRL2;
        this.originalVersion = string2;
        this.appCtx = applicationContextInternal;
        this.createJarFileUrls();
        this.createProperties();
        this.lookUpDataSources();
        this.initializeEntityManagerFactory();
    }

    private void registerWithParentMBean() throws EnvironmentException {
        if (this.parentMBean != null) {
            block6: {
                try {
                    this.runtimeMBean = KodoPersistenceUnitRuntimeMBeanFactory.getInstance().createKodoPersistenceUnitRuntimeMBean(this.getPersistenceUnitName(), (RuntimeMBean)this.parentMBean, this.unwrappedEMF);
                }
                catch (RuntimeException runtimeException) {
                    DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJpaRuntime");
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Problem creating KodoPersistenceUnitRuntimeMBean", (Throwable)runtimeException);
                    }
                }
                catch (ManagementException managementException) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("Problem creating KodoPersistenceUnitRuntimeMBean", (Throwable)managementException);
                }
            }
            if (this.runtimeMBean != null) {
                this.parentMBean.addKodoPersistenceUnit(this.runtimeMBean);
            }
        }
    }

    public void setParentRuntimeMBean(KodoPersistenceUnitParent kodoPersistenceUnitParent) throws EnvironmentException {
        if (this.parentMBean != null) {
            return;
        }
        this.parentMBean = kodoPersistenceUnitParent;
        this.registerWithParentMBean();
    }

    private void lookUpDataSources() {
        if (this.dd.getJtaDataSource() != null && !"".equals(this.dd.getJtaDataSource())) {
            this.jtaDataSource = this.lookUpDataSource(this.dd.getJtaDataSource());
        }
        if (this.dd.getNonJtaDataSource() != null && !"".equals(this.dd.getNonJtaDataSource())) {
            this.nonJtaDataSource = this.lookUpDataSource(this.dd.getNonJtaDataSource());
        }
    }

    private DataSource lookUpDataSource(String string) {
        try {
            InitialContext initialContext = new InitialContext();
            return (DataSource)initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    private void createJarFileUrls() throws EnvironmentException {
        if (this.dd.getJarFiles().length > 0 && "jar".equals(this.jarParentUrl.getProtocol())) {
            throw new IllegalStateException("jar-file references are only supported inside META-INF/classes and exploded-format deployments.  Unsupported reference found while parsing persistence unit '" + this.persistenceUnitId + "'.");
        }
        for (int i = 0; i < this.dd.getJarFiles().length; ++i) {
            URL uRL;
            String string = this.jarParentUrl.toString() + this.dd.getJarFiles()[i];
            try {
                uRL = new URL(string);
                uRL.openConnection().connect();
                this.jarFileUrls.add(uRL);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                EnvironmentException environmentException = new EnvironmentException("Error processing PersistenceUnit " + this.getPersistenceUnitName() + ": " + malformedURLException);
                environmentException.setStackTrace(malformedURLException.getStackTrace());
                throw environmentException;
            }
            catch (IOException iOException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("jar-file is not found at " + string);
                }
                if (this.appCtx == null || (uRL = this.getJarFileUrlFromLibraryModule(this.dd.getJarFiles()[i])) == null) continue;
                this.jarFileUrls.add(uRL);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createProperties() {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating properties:" + this.rootUrl + ":" + this.dd + ":" + this.configDD);
        }
        if (this.configDD != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Parsing persistence-configuration.xml properties...");
            }
            Object object2 = null;
            Properties properties = new JDBCConfigurationBeanParser().load(this.configDD);
            block2: for (String string : properties.keySet()) {
                for (int i = 0; i < CONVERT.length; ++i) {
                    if (string.endsWith(CONVERT[i])) {
                        String string2 = "openjpa" + string.substring("kodo".length());
                        continue block2;
                    }
                    this.properties.setProperty(string, properties.getProperty(string));
                }
            }
        }
        if (logger.isDebugEnabled()) {
            for (Map.Entry entry : this.properties.entrySet()) {
                logger.debug("Configuration property:" + entry.getKey() + "," + entry.getValue());
            }
            logger.debug("Done parsing -configuration.");
        }
        if (this.dd.getProperties() != null) {
            PersistencePropertyBean[] persistencePropertyBeanArray = this.dd.getProperties().getProperties();
            for (int i = 0; persistencePropertyBeanArray != null && i < persistencePropertyBeanArray.length; ++i) {
                this.properties.setProperty(persistencePropertyBeanArray[i].getName(), persistencePropertyBeanArray[i].getValue());
            }
        }
        if (logger.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                logger.debug("Found persistence property:" + entry.getKey() + "," + entry.getValue());
            }
            logger.debug("Done parsing persistence properties.");
        }
        if (this.isKodoPersistenceUnit()) {
            Object object;
            void var1_14;
            if (this.properties.containsKey("kodo.Id")) {
                String string = "kodo.Id";
            } else {
                String string = "openjpa.Id";
            }
            if (this.properties.containsKey(var1_14)) {
                J2EELogger.logPersistenceUnitIdPropertySpecified((String)this.getPersistenceUnitId(), (String)var1_14);
            }
            this.properties.setProperty((String)var1_14, this.getPersistenceUnitId());
            boolean bl = false;
            try {
                object = Class.forName(org.apache.openjpa.persistence.PersistenceProviderImpl.class.getName(), true, this.getClassLoader());
                bl = object != org.apache.openjpa.persistence.PersistenceProviderImpl.class;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (bl) {
                J2EELogger.logOpenJPAPersistenceUnitUsesApplicationJars((String)this.getPersistenceUnitId());
            } else {
                object = this.properties.containsKey("kodo.Log") ? "kodo.Log" : "openjpa.Log";
                if (this.properties.containsKey(object)) {
                    J2EELogger.logPersistenceUnitLogConfigurationSpecified((String)this.getPersistenceUnitId(), (String)object);
                }
                this.properties.setProperty((String)object, WebLogicLogFactory.class.getName());
            }
        }
    }

    protected PersistenceProvider getPersistenceProvider() throws EnvironmentException {
        try {
            return (PersistenceProvider)Class.forName(this.getPersistenceProviderClassName(), true, (ClassLoader)this.cl).newInstance();
        }
        catch (Exception exception) {
            EnvironmentException environmentException = new EnvironmentException("Error instantiating the Persistence Provider class " + this.getPersistenceProviderClassName() + " of the PersistenceUnit " + this.getPersistenceUnitName() + ": " + exception);
            environmentException.initCause(exception);
            throw environmentException;
        }
    }

    private void initializeEntityManagerFactory() throws EnvironmentException {
        this.initializeEntityManagerFactory(false);
    }

    private void initializeEntityManagerFactory(boolean bl) throws EnvironmentException {
        if (this.unwrappedEMF == null) {
            this.unwrappedEMF = this.getPersistenceProvider().createContainerEntityManagerFactory((PersistenceUnitInfo)this, this.getPersistenceProviderProperties(bl));
            if (this.unwrappedEMF == null) {
                throw new EnvironmentException("could not find deployed EMF for persistence unit named " + this.getPersistenceUnitName() + ". Available EMFs in the current context: " + this);
            }
            Class[] classArray = DynamicProxyUtils.getAllInterfaces(this.unwrappedEMF.getClass(), EntityManagerFactory.class);
            EntityManagerFactoryProxyImpl entityManagerFactoryProxyImpl = new EntityManagerFactoryProxyImpl(this.unwrappedEMF, this.getPersistenceUnitName());
            this.wrappedEMF = (EntityManagerFactory)Proxy.newProxyInstance((ClassLoader)this.cl, classArray, (InvocationHandler)entityManagerFactoryProxyImpl);
        }
    }

    private Map getPersistenceProviderProperties(boolean bl) {
        String string;
        String string2;
        if (this.isKodoPersistenceUnit() || this.isHibernatePersistenceUnit() && !bl) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("eclipselink.target-server", "WebLogic_10");
        if (this.appCtx != null) {
            hashMap.put("weblogic.application-id", this.appCtx.getApplicationId());
        }
        if (!this.isProviderLoadedFromApplication() && (string2 = this.properties.getProperty("eclipselink.logging.logger")) == null && ((string = this.dd.getProvider()) == null || string.contains("org.eclipse.persistence"))) {
            hashMap.put("eclipselink.logging.logger", "weblogic.eclipselink.WeblogicEclipseLinkLog");
        }
        if (this.dd.getJtaDataSource() != null && !"".equals(this.dd.getJtaDataSource()) && this.jtaDataSource == null && this.properties.getProperty("javax.persistence.jtaDataSource") == null) {
            hashMap.put("javax.persistence.jtaDataSource", this.dd.getJtaDataSource());
        }
        if (this.dd.getNonJtaDataSource() != null && !"".equals(this.dd.getNonJtaDataSource()) && this.nonJtaDataSource == null && this.properties.getProperty("javax.persistence.nonJtaDataSource") == null) {
            hashMap.put("javax.persistence.nonJtaDataSource", this.dd.getNonJtaDataSource());
        }
        return hashMap;
    }

    public String getPersistenceUnitName() {
        return this.dd.getName();
    }

    private boolean isProviderLoadedFromApplication() {
        GenericClassLoader genericClassLoader;
        Annotation annotation;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getPersistenceProviderClassName(), true, (ClassLoader)this.cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader instanceof GenericClassLoader && (annotation = (genericClassLoader = (GenericClassLoader)classLoader).getAnnotation()).getApplicationName() != null;
    }

    public String getPersistenceProviderClassName() {
        if (this.providerClassName == null) {
            String string = this.dd.getProvider();
            if (string == null || string.trim().length() == 0) {
                string = "org.apache.openjpa.persistence.PersistenceProviderImpl";
                if (ManagementService.isRuntimeAccessInitialized()) {
                    DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
                    JPAMBean jPAMBean = domainMBean.getJPA();
                    string = jPAMBean.getDefaultJPAProvider();
                }
                J2EELogger.logUsingDefaultPersistenceProvider((String)this.getPersistenceUnitId(), (String)string);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("The persistence unit " + this.getPersistenceUnitId() + " will use the following PersistenceProvider class: " + string);
            }
            this.providerClassName = string;
        }
        return this.providerClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.valueOf((String)this.dd.getTransactionType());
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public List getMappingFileNames() {
        return Arrays.asList(this.dd.getMappingFiles());
    }

    public List getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.rootUrl;
    }

    public List getManagedClassNames() {
        return Arrays.asList(this.dd.getClasses());
    }

    public boolean excludeUnlistedClasses() {
        return this.dd.getExcludeUnlistedClasses();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        this.cl.addInstanceClassPreProcessor((ClassPreProcessor)new ClassPreProcessorImpl(classTransformer));
    }

    public ClassLoader getNewTempClassLoader() {
        return new GenericClassLoader(this.cl.getClassFinder(), this.cl.getParent());
    }

    public String getDescription() {
        return this.dd.getDescription();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.wrappedEMF == null) {
            throw new IllegalStateException("EMF has not been initialized yet!");
        }
        return this.wrappedEMF;
    }

    public EntityManagerFactory getUnwrappedEntityManagerFactory() {
        if (this.unwrappedEMF == null) {
            throw new IllegalStateException("EMF has not been initialized yet!");
        }
        return this.unwrappedEMF;
    }

    public String getPersistenceUnitId() {
        return this.persistenceUnitId;
    }

    public void close() {
        if (this.unwrappedEMF != null) {
            this.unwrappedEMF.close();
            this.unwrappedEMF = null;
            this.wrappedEMF = null;
            this.providerClassName = null;
        }
        this.appCtx = null;
    }

    private boolean isKodoPersistenceUnit() {
        String string = this.getPersistenceProviderClassName();
        return string == null || "".equals(string.trim()) || string.equals(org.apache.openjpa.persistence.PersistenceProviderImpl.class.getName()) || string.equals(PersistenceProviderImpl.class.getName());
    }

    private boolean isHibernatePersistenceUnit() {
        return this.getPersistenceProviderClassName().contains("hibernate");
    }

    public PersistenceUnitConfigurationBean getConfigDD() {
        return this.configDD;
    }

    public PersistenceUnitBean getDD() {
        return this.dd;
    }

    private DataSource lookUpAppScopedDataSource(Context context, String string) throws EnvironmentException {
        try {
            InitialContext initialContext = new InitialContext();
            return (DataSource)initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            try {
                Context context2 = (Context)context.lookup("jdbc");
                if (string.startsWith("java:/app/jdbc/")) {
                    string = string.substring("java:/app/jdbc/".length());
                }
                return (DataSource)context2.lookup(string);
            }
            catch (NamingException namingException2) {
                return null;
            }
        }
    }

    public void activate(Context context) throws EnvironmentException {
        boolean bl = false;
        if (this.dd.getJtaDataSource() != null && this.jtaDataSource == null) {
            this.jtaDataSource = this.lookUpAppScopedDataSource(context, this.dd.getJtaDataSource());
            bl = true;
        }
        boolean bl2 = false;
        if (this.dd.getNonJtaDataSource() != null && this.nonJtaDataSource == null) {
            this.nonJtaDataSource = this.lookUpAppScopedDataSource(context, this.dd.getNonJtaDataSource());
            bl2 = true;
        }
        if (!bl && !bl2) {
            return;
        }
        if (this.isHibernatePersistenceUnit()) {
            this.close();
            this.initializeEntityManagerFactory(true);
        }
        if (this.unwrappedEMF != null && this.unwrappedEMF instanceof OpenJPAEntityManagerFactorySPI) {
            OpenJPAConfiguration openJPAConfiguration = ((OpenJPAEntityManagerFactorySPI)this.unwrappedEMF).getConfiguration();
            if (openJPAConfiguration == null) {
                return;
            }
            if (bl) {
                openJPAConfiguration.setConnectionFactory((Object)this.jtaDataSource);
                openJPAConfiguration.setConnectionFactoryMode("managed");
            }
            if (bl2) {
                if (!bl) {
                    openJPAConfiguration.setConnectionFactory((Object)this.nonJtaDataSource);
                } else {
                    openJPAConfiguration.setConnectionFactory2((Object)this.nonJtaDataSource);
                }
            }
        }
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.originalVersion;
    }

    private URL getJarFileUrlFromLibraryModule(String string) {
        if (this.appCtx == null) {
            return null;
        }
        String[] stringArray = this.persistenceArchiveId.split("#");
        LibraryProvider libraryProvider = this.appCtx.getLibraryProvider(stringArray[stringArray.length - 1]);
        if (libraryProvider != null) {
            Library[] libraryArray = libraryProvider.getReferencedLibraries();
            for (int i = 0; i < libraryArray.length; ++i) {
                Library library = libraryArray[i];
                try {
                    VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)library.getLocation());
                    Iterator iterator = virtualJarFile.entries();
                    while (iterator.hasNext()) {
                        ZipEntry zipEntry = (ZipEntry)iterator.next();
                        if (zipEntry.getName().indexOf(string) <= -1) continue;
                        URL uRL = virtualJarFile.getResource(zipEntry.getName());
                        if (logger.isDebugEnabled()) {
                            logger.debug("jar-file is found in library at " + uRL.toString());
                        }
                        return uRL;
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private class ClassPreProcessorImpl
    implements ClassPreProcessor {
        private ClassTransformer transformer;

        private ClassPreProcessorImpl(ClassTransformer classTransformer) {
            this.transformer = classTransformer;
        }

        public void initialize(Hashtable hashtable) {
        }

        public byte[] preProcess(String string, byte[] byArray) {
            ProtectionDomain protectionDomain = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)BasePersistenceUnitInfoImpl.this.cl);
                byte[] byArray2 = this.transformer.transform((ClassLoader)BasePersistenceUnitInfoImpl.this.cl, string, null, protectionDomain, byArray);
                byte[] byArray3 = byArray2 == null ? byArray : byArray2;
                Object var8_8 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                return byArray3;
            }
            catch (Exception exception) {
                try {
                    if ("java.lang.instrument.IllegalClassFormatException".equals(exception.getClass().getName())) {
                        throw new RuntimeException(exception);
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException(exception);
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    Thread.currentThread().setContextClassLoader(classLoader);
                    throw throwable;
                }
            }
        }
    }
}

