/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.net.MalformedURLException;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.EarUtils;
import weblogic.deployment.AbstractPersistenceUnitRegistry;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.utils.classloaders.GenericClassLoader;

public class EarPersistenceUnitRegistry
extends AbstractPersistenceUnitRegistry {
    private Map persistenceUnitDescriptors;
    private Map persistenceConfigDescriptors;

    public EarPersistenceUnitRegistry(GenericClassLoader genericClassLoader, ApplicationContextInternal applicationContextInternal) throws EnvironmentException, MalformedURLException {
        super(genericClassLoader, applicationContextInternal.getApplicationId(), EarUtils.getConfigDir(applicationContextInternal), applicationContextInternal.findDeploymentPlan(), applicationContextInternal);
        try {
            this.loadPersistenceDescriptors(true);
        }
        catch (EnvironmentException environmentException) {
            throw environmentException;
        }
        catch (Exception exception) {
            throw new EnvironmentException(exception);
        }
    }

    public void initialize() throws EnvironmentException {
        super.storeDescriptors(this.persistenceUnitDescriptors, this.persistenceConfigDescriptors);
    }

    protected void storeDescriptors(Map map, Map map2) {
        this.persistenceUnitDescriptors = map;
        this.persistenceConfigDescriptors = map2;
    }

    public PersistenceUnitInfoImpl getPersistenceUnit(String string) throws IllegalArgumentException {
        if (string.startsWith("../")) {
            int n = string.indexOf("#");
            if (n < 0) {
                return null;
            }
            string = string.substring(n + 1);
        }
        return (PersistenceUnitInfoImpl)this.persistenceUnits.get(string);
    }
}

